/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.AsyncDeductSelectService;
import kd.imc.rim.common.invoice.deduction.DeductInvoiceOperateService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.impl.AisinoDeductService;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;

public class AisinoAsyncDeductSelectService
extends AsyncDeductSelectService {
    private static Log LOGGER = LogFactory.getLog(AisinoAsyncDeductSelectService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void querySelectResult(DynamicObject selectLog) {
        block30: {
            String batchNo = selectLog.getString("batch_no");
            LOGGER.info("\u5f00\u59cb\u67e5\u8be2\u5f02\u6b65\u52fe\u9009\u7ed3\u679c:{}", (Object)batchNo);
            String taxPeriod = DateUtils.format(selectLog.getDate("tax_period"), "yyyyMM");
            Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(selectLog.get("org"));
            AisinoDeductService deductService = new AisinoDeductService(orgId);
            JSONObject param = new JSONObject();
            param.put("batchNo", (Object)batchNo);
            String taxNo = selectLog.getString("tax_no");
            param.put("taxNo", (Object)taxNo);
            String key = "rim.aisinoasyncdeduct-" + batchNo;
            try (DLock lock = DLock.create((String)key);){
                if (!lock.tryLock()) break block30;
                try {
                    JSONObject queryResult = ((DeductService)deductService).gxInvoicesQuery(param);
                    if (queryResult != null && ResultContant.isSuccess(queryResult).booleanValue()) {
                        JSONObject data = queryResult.getJSONObject("data");
                        if (data == null) {
                            LOGGER.info("\u6ca1\u6709\u8fd4\u56dedata\u6570\u636e:{}-{}", (Object)taxNo, (Object)batchNo);
                            selectLog.set("description", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u8fd4\u56dedata\u6570\u636e", (String)"AisinoAsyncDeductSelectService_0", (String)"imc-rim-common", (Object[])new Object[0]));
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                            return;
                        }
                        JSONArray successArray = data.getJSONArray("success");
                        JSONArray failArray = data.getJSONArray("fail");
                        JSONArray handlingArray = data.getJSONArray("handling");
                        selectLog.set("success_num", (Object)successArray.size());
                        selectLog.set("fail_num", (Object)failArray.size());
                        selectLog.set("update_time", (Object)new Date());
                        if (CollectionUtils.isEmpty((Collection)handlingArray)) {
                            selectLog.set("handle_status", (Object)"1");
                        }
                        if (!CollectionUtils.isEmpty((Collection)successArray) || !CollectionUtils.isEmpty((Collection)failArray)) {
                            Map<String, DynamicObject> selectAccountMap = this.getSelectAccount(batchNo);
                            ArrayList<DynamicObject> updateAccountList = new ArrayList<DynamicObject>(8);
                            JSONArray updateSelectInvoiceArray = new JSONArray();
                            JSONObject success = null;
                            JSONObject example = null;
                            String deductionPurpose = "";
                            if (!CollectionUtils.isEmpty((Collection)successArray)) {
                                for (int i = 0; i < successArray.size(); ++i) {
                                    success = successArray.getJSONObject(i);
                                    String mapKey = CommonUtils.getInvoiceCodeNoGroup(success.getString("invoiceCode"), success.getString("invoiceNo"));
                                    DynamicObject updateAccount = selectAccountMap.get(mapKey);
                                    if (updateAccount == null) continue;
                                    deductionPurpose = updateAccount.getString("deduction_purpose");
                                    updateAccount.set("handle_status", (Object)"1");
                                    updateAccount.set("select_result", (Object)success.getString("selectResult"));
                                    updateAccount.set("description", (Object)this.getSelectMsg(success));
                                    updateAccount.set("update_time", (Object)new Date());
                                    updateAccount.set("select_time", (Object)success.getDate("selectDate"));
                                    updateAccount.set("effective_tax_amount", (Object)success.getBigDecimal("effectiveTaxAmount"));
                                    updateAccount.set("invoice_date", (Object)success.getDate("invoiceDate"));
                                    updateAccount.set("tax_period", (Object)selectLog.getDate("tax_period"));
                                    updateAccountList.add(updateAccount);
                                    if (!StringUtils.isNotEmpty((CharSequence)updateAccount.getString("serial_no"))) continue;
                                    example = new JSONObject();
                                    example.put("serial_no", (Object)updateAccount.getString("serial_no"));
                                    example.put("invoice_type", (Object)DynamicObjectUtil.getDynamicObjectLongValue(updateAccount.get("invoice_type")));
                                    example.put("deduction_purpose", (Object)success.getString("deductionPurpose"));
                                    example.put("effective_tax_amount", (Object)success.getBigDecimal("effectiveTaxAmount"));
                                    example.put("tax_period", (Object)taxPeriod);
                                    example.put("authenticate_flag", (Object)success.getString("authenticateFlag"));
                                    example.put("select_time", (Object)success.getString("selectDate"));
                                    example.put("not_deductible_type", (Object)success.getString("notDeductibleType"));
                                    updateSelectInvoiceArray.add((Object)example);
                                }
                                DeductInvoiceOperateService deductInvoiceOperateService = new DeductInvoiceOperateService();
                                deductInvoiceOperateService.updateBatchSelectedInvoice(updateSelectInvoiceArray, deductionPurpose, taxNo);
                            }
                            HashMap<String, String> serialNoStatusMap = new HashMap<String, String>(8);
                            if (!CollectionUtils.isEmpty((Collection)failArray)) {
                                for (int i = 0; i < failArray.size(); ++i) {
                                    success = failArray.getJSONObject(i);
                                    String mapKey = CommonUtils.getInvoiceCodeNoGroup(success.getString("invoiceCode"), success.getString("invoiceNo"));
                                    DynamicObject updateAccount = selectAccountMap.get(mapKey);
                                    if (updateAccount == null) continue;
                                    updateAccount.set("handle_status", (Object)"1");
                                    updateAccount.set("select_result", (Object)success.getString("selectResult"));
                                    updateAccount.set("description", (Object)this.getSelectMsg(success));
                                    updateAccount.set("invoice_date", (Object)success.getDate("invoiceDate"));
                                    updateAccount.set("update_time", (Object)new Date());
                                    updateAccountList.add(updateAccount);
                                    if (!StringUtils.isNotEmpty((CharSequence)updateAccount.getString("serial_no"))) continue;
                                    String preAuthenticateFlag = updateAccount.getString("pre_authenticate_flag");
                                    if (StringUtils.isEmpty((CharSequence)preAuthenticateFlag)) {
                                        preAuthenticateFlag = "1".equals(updateAccount.getString("select_status")) ? "0" : "1";
                                    }
                                    serialNoStatusMap.put(updateAccount.getString("serial_no"), preAuthenticateFlag);
                                }
                            }
                            this.save(selectLog, updateAccountList, serialNoStatusMap);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("\u822a\u4fe1\u5f02\u6b65\u67e5\u8be2\u52fe\u9009\u7ed3\u679c\u5931\u8d25:" + batchNo, (Throwable)e);
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }
}

