/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.DeductSelectService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.impl.AisinoAsyncDeductSelectService;
import kd.imc.rim.common.invoice.deduction.impl.AisinoDeductService;
import kd.imc.rim.common.utils.UUID;

public class AisinoDeductSelectService
extends DeductSelectService {
    private static Log LOGGER = LogFactory.getLog(AisinoDeductSelectService.class);
    private static final int DEFAULT_SIZE = 500;

    public AisinoDeductSelectService() {
        int size = InvoiceDownloadConstant.getPageSizeFromConfig(500, "aisino_select_size");
        if (size > 500 || size <= 0) {
            size = 500;
        }
        this.selectSize = size;
    }

    @Override
    public DeductService getDeductServiceImpl(Long orgId) {
        return new AisinoDeductService(orgId);
    }

    @Override
    public Map<String, Object> selectedResult(DeductService service, JSONObject paramJson) {
        HashMap result = Maps.newHashMap();
        int successNum = 0;
        int failNum = 0;
        String taxNo = paramJson.getString("taxNo");
        String batchNo = UUID.getBatchNoByTaxNo(taxNo);
        paramJson.put("batchNo", (Object)batchNo);
        JSONArray invoices = paramJson.getJSONArray("invoices");
        HashMap<String, String> serialNoStatusMap = new HashMap<String, String>(8);
        for (int i = 0; i < invoices.size(); ++i) {
            serialNoStatusMap.put(invoices.getJSONObject(i).getString("serialNo"), "5");
        }
        int size = invoices.size();
        StringBuilder message = new StringBuilder();
        JSONObject gxInvoicesRtn = service.gxInvoices(paramJson);
        LOGGER.info("\u822a\u4fe1\u52fe\u9009\u8fd4\u56de\u7ed3\u679c:{}", (Object)gxInvoicesRtn);
        if (ResultContant.isSuccess(gxInvoicesRtn).booleanValue()) {
            successNum = size;
            this.insertSelectAccount(paramJson, ErrorType.STATUS_HANDLING.getCode(), batchNo, "2", "3");
            this.updateInvoiceSelecting(serialNoStatusMap);
        } else {
            failNum = size;
            this.setFailMessage(paramJson, String.format(ResManager.loadKDString((String)"\u52fe\u9009\u5931\u8d25:%s", (String)"AisinoDeductSelectService_0", (String)"imc-rim-common", (Object[])new Object[0]), gxInvoicesRtn.getString("description")), message);
        }
        result.put("errcode", gxInvoicesRtn.getString("errcode"));
        result.put("successNum", successNum);
        result.put("failNum", failNum);
        result.put("message", message.toString());
        result.put("sync", "0");
        result.put("batchNo", batchNo);
        return result;
    }

    @Override
    public void queryAsyncSelectResult(List<String> batchNoList) {
        if (!CollectionUtils.isEmpty(batchNoList)) {
            AisinoAsyncDeductSelectService asyncDeductSelectService = new AisinoAsyncDeductSelectService();
            asyncDeductSelectService.queryAsyncSelectResultByBatchNo(batchNoList);
        }
    }
}

