/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.HolytaxInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductStatisticsService;
import kd.imc.rim.common.utils.AisinoConvertUtil;
import kd.imc.rim.common.utils.AisinoService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.lang3.tuple.Pair;

public class AisinoDeductService
extends DeductService {
    private static Log LOGGER = LogFactory.getLog(AisinoDeductService.class);
    private static final String SELECT_FILED = "invoice_code,invoice_no,invoice_date,invoice_amount,effective_tax_amount,total_tax_amount,saler_name,buyer_tax_no,buyer_name,invoice_type,invoice_status,manage_status,deduction_purpose,tax_period,authenticate_time,authenticate_flag,select_time,not_deductible_type";

    public AisinoDeductService(Long orgId) {
        this.orgId = orgId;
    }

    @Override
    public JSONObject queryTaxperiod(String taxNo) {
        try {
            String ssq;
            JSONObject data;
            AisinoService service = AisinoService.newInstance();
            JSONObject param = new JSONObject();
            JSONObject resultJson = service.postAppJson("jx.rz.info.timeQuery", this.orgId, taxNo, (Map<String, Object>)param);
            LOGGER.info("\u540c\u6b65\u83b7\u53d6\u7a0e\u671f\u7ed3\u679c\u8fd4\u56de:{}-{}", (Object)taxNo, (Object)resultJson);
            if (ResultContant.isSuccess(resultJson).booleanValue() && (data = resultJson.getJSONObject("data")) != null && StringUtils.isNotEmpty((CharSequence)(ssq = data.getString("dqssq")))) {
                String ssqs = ssq + ";" + data.getString("gxkssj") + ";" + data.getString("ssqjssj");
                data.put("taxPeriod", (Object)ssq);
                data.put("skssq", (Object)ssqs);
            }
            return resultJson;
        }
        catch (Exception e) {
            LOGGER.error("\u540c\u6b65\u83b7\u53d6\u7a0e\u671f\u5931\u8d25:" + taxNo, (Throwable)e);
            return null;
        }
    }

    @Override
    public JSONObject queryInvoices(JSONObject bodyJson) {
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        JSONObject searchOpt = bodyJson.getJSONObject("searchOpt");
        if (searchOpt == null) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        if ("03".equals(bodyJson.getString("synctype"))) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u822a\u4fe1\u63a5\u53e3\u4e0d\u652f\u6301\u6309\u62b5\u6263\u7a0e\u671f\u67e5\u8be2", (String)"AisinoDeductService_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String batchNo = UUID.getBatchNoByTaxNo(taxNo);
        String asyncFlag = bodyJson.getString("asyncFlag");
        if ("1".equals(asyncFlag)) {
            JSONObject resultJson = ResultContant.createSuccessJSONObject();
            return DeductionUtils.setBatchNo2Result(resultJson, asyncFlag, batchNo);
        }
        JSONObject paramJson = new JSONObject();
        String invoiceType = searchOpt.getString("invoiceType");
        String invoiceNo = searchOpt.getString("invoiceNo");
        String invoiceCode = searchOpt.getString("invoiceCode");
        int pageNum = 1;
        String fplx = "00";
        if (StringUtils.isNotEmpty((CharSequence)invoiceType) && !"-1".equals(invoiceType)) {
            fplx = HolytaxInvoiceTypeEnum.getHolytaxTypeByAwsType(invoiceType);
        }
        if (HolytaxInvoiceTypeEnum.HGJKS.getCode().equals(fplx) && StringUtils.isNotEmpty((CharSequence)invoiceNo)) {
            paramJson.put("jkshm", (Object)invoiceNo);
        }
        if (!HolytaxInvoiceTypeEnum.HGJKS.getCode().equals(fplx)) {
            if (StringUtils.isNotEmpty((CharSequence)invoiceCode)) {
                paramJson.put("fpdm", (Object)invoiceCode);
            }
            if (StringUtils.isNotEmpty((CharSequence)invoiceCode)) {
                paramJson.put("fphm", (Object)invoiceNo);
            }
        }
        paramJson.put("batchNo", (Object)batchNo);
        paramJson.put("fplx", (Object)fplx);
        paramJson.put("gxzt", searchOpt.get((Object)"deductFlag"));
        paramJson.put("rzzt", (Object)"-1");
        paramJson.put("taxNo", (Object)taxNo);
        paramJson.put("kprqq", searchOpt.get((Object)"startTime"));
        paramJson.put("kprqz", searchOpt.get((Object)"endTime"));
        paramJson.put("pageNum", (Object)pageNum);
        LOGGER.info("\u822a\u4fe1\u53d1\u7968\u4e0b\u8f7d\u53c2\u6570:{}", (Object)paramJson);
        AisinoService service = AisinoService.newInstance();
        JSONObject resultJson = service.postAppJson("jx.rz.invoices.mainQuery.new", this.orgId, taxNo, (Map<String, Object>)paramJson);
        if (resultJson == null) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u83b7\u53d6\u53d1\u7968\u5931\u8d25", (String)"AisinoDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONObject data = null;
        JSONArray invoices = new JSONArray();
        if (ResultContant.isSuccess(resultJson).booleanValue() && (data = resultJson.getJSONObject("data")) != null) {
            this.invoiceConvert(invoices, data);
            int totalPages = data.getInteger("totalPages");
            this.downSurplusInvoice(service, taxNo, invoices, paramJson, totalPages);
        }
        resultJson.put("data", (Object)invoices);
        LOGGER.info("\u822a\u4fe1\u53d1\u7968\u4e0b\u8f7d\u7ed3\u679c\u8fd4\u56de:{}-{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    private void downSurplusInvoice(AisinoService service, String taxNo, JSONArray invoices, JSONObject paramJson, int page) {
        if (page <= 1) {
            return;
        }
        JSONObject result = null;
        for (int currentPage = 2; currentPage <= page; ++currentPage) {
            JSONObject data;
            paramJson.put("pageNum", (Object)currentPage);
            result = service.postAppJson("jx.rz.invoices.mainQuery.new", this.orgId, taxNo, (Map<String, Object>)paramJson);
            if (!ResultContant.isSuccess(result).booleanValue() || ObjectUtils.isEmpty((Object)(data = result.getJSONObject("data")))) continue;
            this.invoiceConvert(invoices, data);
        }
    }

    private void invoiceConvert(JSONArray invoices, JSONObject data) {
        JSONArray invoiceList = data.getJSONArray("invoicesData");
        if (!CollectionUtils.isEmpty((Collection)invoiceList)) {
            JSONObject invoice = null;
            for (int i = 0; i < invoiceList.size(); ++i) {
                invoice = AisinoConvertUtil.convertInvoiceMainInfo(invoiceList.getJSONObject(i));
                invoices.add((Object)invoice);
            }
        }
    }

    @Override
    public JSONObject getStatisticTable(JSONObject bodyJson) {
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        AisinoService service = AisinoService.newInstance();
        JSONObject resultJson = service.postAppJson("jx.rz.info.stateQuery", this.orgId, taxNo, (Map<String, Object>)bodyJson);
        LOGGER.info("\u822a\u4fe1\u67e5\u8be2\u7edf\u8ba1\u8868\u8fd4\u56de:{}-{}", (Object)taxNo, (Object)resultJson);
        if (resultJson == null) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u83b7\u53d6\u7edf\u8ba1\u8868\u5931\u8d25", (String)"AisinoDeductService_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (ResultContant.isSuccess(resultJson).booleanValue()) {
            JSONObject data = resultJson.getJSONObject("data");
            String errcode = "0000";
            String description = ResManager.loadKDString((String)"\u7edf\u8ba1\u6210\u529f", (String)"AisinoDeductService_3", (String)"imc-rim-common", (Object[])new Object[0]);
            if (data != null) {
                JSONObject standardData = new JSONObject();
                String taxPeriod = data.getString("dqssq");
                standardData.put("taxPeriod", (Object)taxPeriod);
                standardData.put("tjInfo", (Object)data.getString("tjjg"));
                standardData.put("applyTime", (Object)data.getString("sqtjsj"));
                standardData.put("createTjbbStatus", (Object)data.getString("tjwcsj"));
                String createTjbbStatus = "";
                String updateTime = "";
                boolean isAllowQxTj = true;
                boolean isAllowQrtj = false;
                boolean isAllowGxInvoice = true;
                boolean allowChangeSsqBySeason = false;
                String tjbz = data.getString("tjbz");
                String qmbz = data.getString("qmbz");
                String sqtjsj = data.getString("sqtjsj");
                String tjwcsj = data.getString("tjwcsj");
                String qrqmsj = data.getString("qrqmsj");
                String failReason = data.getString("failReason");
                if ("00".equals(tjbz)) {
                    createTjbbStatus = "01";
                    isAllowQxTj = false;
                } else if ("01".equals(tjbz)) {
                    createTjbbStatus = "21";
                    isAllowQrtj = false;
                    isAllowGxInvoice = false;
                    isAllowQxTj = false;
                    updateTime = sqtjsj;
                } else if ("04".equals(tjbz)) {
                    updateTime = tjwcsj;
                    if ("00".equals(qmbz)) {
                        createTjbbStatus = "02";
                        isAllowQrtj = true;
                        isAllowGxInvoice = false;
                    } else if ("02".equals(qmbz)) {
                        createTjbbStatus = "03";
                        isAllowQrtj = false;
                        isAllowGxInvoice = false;
                    } else if ("01".equals(qmbz)) {
                        createTjbbStatus = "05";
                        isAllowQrtj = false;
                        isAllowGxInvoice = false;
                        updateTime = qrqmsj;
                    } else if ("99".equals(qmbz)) {
                        errcode = "0299";
                        description = ResManager.loadKDString((String)"\u83b7\u53d6\u786e\u8ba4\u7edf\u8ba1\u8868\u6807\u8bc6\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5", (String)"AisinoDeductService_4", (String)"imc-rim-common", (Object[])new Object[0]);
                    }
                } else if ("05".equals(failReason)) {
                    createTjbbStatus = "22";
                    isAllowQxTj = false;
                    isAllowQrtj = false;
                } else if ("99".equals(tjbz)) {
                    errcode = "0299";
                    description = ResManager.loadKDString((String)"\u83b7\u53d6\u7edf\u8ba1\u8868\u6807\u8bc6\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5", (String)"AisinoDeductService_5", (String)"imc-rim-common", (Object[])new Object[0]);
                }
                standardData.put("allowChangeSsqBySeason", (Object)allowChangeSsqBySeason);
                standardData.put("createTjbbStatus", (Object)createTjbbStatus);
                standardData.put("isAllowQxTj", (Object)isAllowQxTj);
                standardData.put("isAllowQrtj", (Object)isAllowQrtj);
                standardData.put("isAllowGxInvoice", (Object)isAllowGxInvoice);
                standardData.put("updateTime", (Object)updateTime);
                resultJson.put("errcode", (Object)errcode);
                resultJson.put("description", (Object)description);
                resultJson.put("data", (Object)standardData);
            }
        }
        return resultJson;
    }

    @Override
    public JSONObject queryStatisticTable(JSONObject param) {
        if (StringUtils.isEmpty((CharSequence)param.getString("batchNo"))) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"AisinoDeductService_6", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String taxNo = param.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        AisinoService service = AisinoService.newInstance();
        JSONObject resultJson = service.postAppJson("jx.rz.cert.statQuery", this.orgId, taxNo, (Map<String, Object>)param);
        LOGGER.info("\u822a\u4fe1\u67e5\u8be2\u7edf\u8ba1\u8868\u8fd4\u56de:{}-{}", (Object)taxNo, (Object)resultJson);
        if (resultJson == null) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u83b7\u53d6\u7edf\u8ba1\u8868\u5931\u8d25", (String)"AisinoDeductService_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (ResultContant.isSuccess(resultJson).booleanValue()) {
            JSONObject data = resultJson.getJSONObject("data");
            String errcode = "0000";
            String description = ResManager.loadKDString((String)"\u7edf\u8ba1\u6210\u529f", (String)"AisinoDeductService_3", (String)"imc-rim-common", (Object[])new Object[0]);
            if (data != null) {
                JSONObject standardData = new JSONObject();
                String taxPeriod = data.getString("ssq");
                standardData.put("taxPeriod", (Object)taxPeriod);
                standardData.put("tjInfo", (Object)data.getString("tjjg"));
                standardData.put("applyTime", (Object)data.getString("tjsj"));
                standardData.put("createTjbbStatus", (Object)data.getString("tjsj"));
                String createTjbbStatus = "";
                String updateTime = "";
                boolean isAllowQxTj = true;
                boolean isAllowQrtj = false;
                boolean isAllowGxInvoice = true;
                boolean isFinish = false;
                boolean allowChangeSsqBySeason = false;
                String tjzt = data.getString("tjzt");
                String sqtjsj = data.getString("tjsj");
                String failReason = data.getString("failReason");
                if ("0".equals(tjzt)) {
                    createTjbbStatus = "01";
                    isAllowQxTj = false;
                } else if ("1".equals(tjzt)) {
                    String curTaxPeriod = DateUtils.format(new Date(), "yyyyMM");
                    if (taxPeriod.equals(curTaxPeriod)) {
                        createTjbbStatus = "03";
                        isAllowQrtj = false;
                        isAllowGxInvoice = false;
                    } else {
                        createTjbbStatus = "02";
                        isAllowQrtj = true;
                        isAllowGxInvoice = false;
                    }
                    updateTime = sqtjsj;
                }
                if ("01".equals(failReason)) {
                    isFinish = true;
                } else if ("05".equals(failReason)) {
                    createTjbbStatus = "22";
                    isAllowQxTj = false;
                    isAllowQrtj = false;
                } else if ("00".equals(failReason)) {
                    createTjbbStatus = "21";
                    isAllowQrtj = false;
                    isAllowGxInvoice = false;
                    isAllowQxTj = false;
                    updateTime = sqtjsj;
                } else if ("02".equals(failReason)) {
                    errcode = "0202";
                    description = ResManager.loadKDString((String)"\u8be5\u4f01\u4e1a\u5f53\u671f\u5df2\u7edf\u8ba1\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u64cd\u4f5c", (String)"AisinoDeductService_7", (String)"imc-rim-common", (Object[])new Object[0]);
                } else if ("03".equals(failReason)) {
                    errcode = "0203";
                    description = ResManager.loadKDString((String)"\u8f6c\u767b\u8bb0\u7eb3\u7a0e\u4eba\u4e0d\u80fd\u7edf\u8ba1", (String)"AisinoDeductService_8", (String)"imc-rim-common", (Object[])new Object[0]);
                } else if ("04".equals(failReason)) {
                    errcode = "0204";
                    description = ResManager.loadKDString((String)"\u4f01\u4e1a\u672a\u7edf\u8ba1\uff0c\u64a4\u9500\u7edf\u8ba1\u65e0\u6548", (String)"AisinoDeductService_9", (String)"imc-rim-common", (Object[])new Object[0]);
                } else if ("06".equals(failReason)) {
                    errcode = "0206";
                    description = ResManager.loadKDString((String)"\u63d0\u4ea4\u8ba4\u8bc1\u6240\u5c5e\u671f\u4e0e\u5f53\u524d\u5c5e\u671f\u4e0d\u7b26", (String)"AisinoDeductService_10", (String)"imc-rim-common", (Object[])new Object[0]);
                } else if ("99".equals(failReason)) {
                    errcode = "0299";
                    description = ResManager.loadKDString((String)"\u5176\u4ed6\u5f02\u5e38", (String)"AisinoDeductService_11", (String)"imc-rim-common", (Object[])new Object[0]);
                }
                standardData.put("createTjbbStatus", (Object)createTjbbStatus);
                standardData.put("isFinish", (Object)isFinish);
                standardData.put("allowChangeSsqBySeason", (Object)allowChangeSsqBySeason);
                standardData.put("isAllowQxTj", (Object)isAllowQxTj);
                standardData.put("isAllowQrtj", (Object)isAllowQrtj);
                standardData.put("isAllowGxInvoice", (Object)isAllowGxInvoice);
                standardData.put("updateTime", (Object)updateTime);
                resultJson.put("errcode", (Object)errcode);
                resultJson.put("description", (Object)description);
                resultJson.put("data", (Object)standardData);
            }
        }
        return resultJson;
    }

    @Override
    public JSONObject createStatisticTable(JSONObject bodyJson) {
        if (ObjectUtils.isEmpty((Object)bodyJson)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        AisinoService service = AisinoService.newInstance();
        String taxperiod = this.syncGetTaxperiod(taxNo);
        if (StringUtils.isEmpty((CharSequence)taxperiod)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u7a0e\u671f\u5931\u8d25", (String)"AisinoDeductService_12", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u822a\u4fe1\u7533\u8bf7\u7edf\u8ba1\u8868\u53c2\u6570:{}", (Object)bodyJson);
        JSONObject param = new JSONObject();
        String batchNo = UUID.getBatchNoByTaxNo(taxNo);
        param.put("batchNo", (Object)batchNo);
        param.put("tjssq", (Object)taxperiod);
        String tjbz = Optional.ofNullable(bodyJson.getString("tjbz")).filter(StringUtils::isNotEmpty).orElse("1");
        param.put("tjbz", (Object)tjbz);
        String asyncFlag = bodyJson.getString("asyncFlag");
        JSONObject resultJson = service.postAppJson("jx.rz.cert.statRequest", this.orgId, taxNo, (Map<String, Object>)param);
        LOGGER.info("\u822a\u4fe1\u7533\u8bf7\u7edf\u8ba1\u8868\u8fd4\u56de:{}-{}", (Object)taxNo, (Object)resultJson);
        if (resultJson == null) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u751f\u6210/\u53d6\u6d88\u7edf\u8ba1\u8868\u5931\u8d25,\u8bf7\u91cd\u65b0\u67e5\u8be2\u7edf\u8ba1\u8868", (String)"AisinoDeductService_13", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return DeductionUtils.setBatchNo2Result(resultJson, asyncFlag, batchNo);
    }

    @Override
    public JSONObject cancelStatisticTable(JSONObject bodyJson) {
        bodyJson.put("tjbz", (Object)"0");
        return this.createStatisticTable(bodyJson);
    }

    @Override
    public JSONObject confirmStatisticTable(JSONObject bodyJson) {
        if (ObjectUtils.isEmpty((Object)bodyJson)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        AisinoService service = AisinoService.newInstance();
        String taxperiod = this.syncGetTaxperiod(taxNo);
        if (StringUtils.isEmpty((CharSequence)taxperiod)) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u7a0e\u671f\u5931\u8d25", (String)"AisinoDeductService_12", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u822a\u4fe1\u786e\u8ba4\u7edf\u8ba1\u8868\u53c2\u6570:{}", (Object)bodyJson);
        JSONObject param = new JSONObject();
        String batchNo = UUID.getBatchNoByTaxNo(taxNo);
        param.put("batchNo", (Object)batchNo);
        param.put("rzssq", (Object)taxperiod);
        param.put("qrbz", (Object)"1");
        String asyncFlag = bodyJson.getString("asyncFlag");
        param.put("qrmm", (Object)Optional.ofNullable(bodyJson.getString("confirmSecret")).orElseGet(() -> bodyJson.getString("password")));
        JSONObject resultJson = service.postAppJson("jx.rz.cert.certRequest", this.orgId, taxNo, (Map<String, Object>)param);
        LOGGER.info("\u822a\u4fe1\u786e\u8ba4\u7edf\u8ba1\u8868\u8fd4\u56de:{}-{}", (Object)taxNo, (Object)resultJson);
        if (resultJson == null) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u786e\u8ba4\u7edf\u8ba1\u8868\u5931\u8d25", (String)"AisinoDeductService_14", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return DeductionUtils.setBatchNo2Result(resultJson, asyncFlag, batchNo);
    }

    @Override
    public JSONObject queryConfirmStatisticTable(JSONObject bodyJson) {
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        if (StringUtils.isEmpty((CharSequence)bodyJson.getString("batchNo"))) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u67e5\u8be2\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"AisinoDeductService_15", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        AisinoService service = AisinoService.newInstance();
        JSONObject resultJson = service.postAppJson("jx.rz.cert.certQuery", this.orgId, taxNo, (Map<String, Object>)bodyJson);
        LOGGER.info("\u822a\u4fe1\u67e5\u8be2\u786e\u8ba4\u7edf\u8ba1\u8868\u8fd4\u56de:{}-{}", (Object)taxNo, (Object)resultJson);
        if (resultJson == null) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u67e5\u8be2\u786e\u8ba4\u7edf\u8ba1\u8868\u5931\u8d25,\u8bf7\u91cd\u65b0\u67e5\u8be2\u7edf\u8ba1\u8868", (String)"AisinoDeductService_16", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (ResultContant.isSuccess(resultJson).booleanValue()) {
            JSONObject data = resultJson.getJSONObject("data");
            String failReason = data.getString("failReason");
            String errcode = "0000";
            String description = ResManager.loadKDString((String)"\u8ba4\u8bc1\u6210\u529f", (String)"AisinoDeductService_17", (String)"imc-rim-common", (Object[])new Object[0]);
            boolean isFinish = false;
            String createTjbbStatus = "";
            if ("01".equals(failReason) || "02".equals(failReason)) {
                createTjbbStatus = "05";
                isFinish = true;
            } else if ("00".equals(failReason)) {
                createTjbbStatus = "24";
            } else if ("03".equals(failReason)) {
                errcode = "0203";
                description = ResManager.loadKDString((String)"\u8f6c\u767b\u8bb0\u7eb3\u7a0e\u4eba\u4e0d\u80fd\u7edf\u8ba1", (String)"AisinoDeductService_8", (String)"imc-rim-common", (Object[])new Object[0]);
            } else if ("04".equals(failReason)) {
                errcode = "0204";
                description = ResManager.loadKDString((String)"\u4f01\u4e1a\u672a\u8ba4\u8bc1\uff0c\u64a4\u9500\u8ba4\u8bc1\u65e0\u6548", (String)"AisinoDeductService_18", (String)"imc-rim-common", (Object[])new Object[0]);
            } else if ("05".equals(failReason)) {
                errcode = "0205";
                description = ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8bb0\u5f55", (String)"AisinoDeductService_19", (String)"imc-rim-common", (Object[])new Object[0]);
            } else if ("06".equals(failReason)) {
                errcode = "0206";
                description = ResManager.loadKDString((String)"\u63d0\u4ea4\u8ba4\u8bc1\u6240\u5c5e\u671f\u4e0e\u5f53\u524d\u5c5e\u671f\u4e0d\u7b26", (String)"AisinoDeductService_10", (String)"imc-rim-common", (Object[])new Object[0]);
            } else if ("07".equals(failReason)) {
                errcode = "0207";
                description = ResManager.loadKDString((String)"\u5f53\u671f\u672a\u5230\u7533\u62a5\u671f\uff0c\u4e0d\u80fd\u8ba4\u8bc1", (String)"AisinoDeductService_20", (String)"imc-rim-common", (Object[])new Object[0]);
            } else if ("08".equals(failReason)) {
                errcode = "0208";
                description = ResManager.loadKDString((String)"\u786e\u8ba4\u7b7e\u540d\u5bc6\u7801\u9519\u8bef", (String)"AisinoDeductService_21", (String)"imc-rim-common", (Object[])new Object[0]);
            } else if ("09".equals(failReason)) {
                errcode = "0209";
                description = ResManager.loadKDString((String)"\u7efc\u5408\u670d\u52a1\u5e73\u53f0\u672a\u8bbe\u7f6e\u786e\u8ba4\u5bc6\u7801", (String)"AisinoDeductService_22", (String)"imc-rim-common", (Object[])new Object[0]);
            } else if ("99".equals(failReason)) {
                errcode = "0299";
                description = ResManager.loadKDString((String)"\u5176\u4ed6\u5f02\u5e38", (String)"AisinoDeductService_11", (String)"imc-rim-common", (Object[])new Object[0]);
            }
            JSONObject rtnData = new JSONObject();
            rtnData.put("createTjbbStatus", (Object)createTjbbStatus);
            rtnData.put("isFinish", (Object)isFinish);
            resultJson.put("errcode", (Object)errcode);
            resultJson.put("description", (Object)description);
            resultJson.put("data", (Object)rtnData);
        }
        return resultJson;
    }

    @Override
    public JSONObject gxInvoices(JSONObject bodyJson) {
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String taxPeriod = this.syncGetTaxperiod(taxNo);
        if (StringUtils.isEmpty((CharSequence)taxPeriod)) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u52fe\u9009\u5931\u8d25:\u83b7\u53d6\u5f53\u524d\u7a0e\u671f\u5931\u8d25", (String)"AisinoDeductService_23", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        bodyJson.put("taxPeriod", (Object)taxPeriod);
        JSONArray invoices = bodyJson.getJSONArray("invoices");
        if (CollectionUtils.isEmpty((Collection)invoices)) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"AisinoDeductService_24", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONObject aisinoParam = new JSONObject();
        aisinoParam.put("batchNo", (Object)bodyJson.getString("batchNo"));
        aisinoParam.put("taxNo", (Object)taxNo);
        String rzlx = "1";
        String billType = bodyJson.getString("billType");
        if ("1".equals(billType)) {
            rzlx = "3";
        } else if ("2".equals(billType)) {
            return ResultContant.createJSONObject(ErrorType.DKDJ_NONSUPPORT);
        }
        aisinoParam.put("rzlx", (Object)rzlx);
        Pair<String, String> deductionPurposeMap = DeductionConstant.getDeductionPurpose(bodyJson.getString("deductibleMode"));
        JSONArray data = new JSONArray();
        JSONObject newInvoice = null;
        for (int i = 0; i < invoices.size(); ++i) {
            JSONObject invoice = invoices.getJSONObject(i);
            newInvoice = new JSONObject();
            if ("3".equals(rzlx)) {
                newInvoice.put("jkshm", invoice.get((Object)"invoiceNo"));
            } else {
                newInvoice.put("fpdm", invoice.get((Object)"invoiceCode"));
                newInvoice.put("fphm", invoice.get((Object)"invoiceNo"));
            }
            newInvoice.put("kprq", invoice.get((Object)"invoiceDate"));
            String fplx = HolytaxInvoiceTypeEnum.getHolytaxType(invoice.getLong("invoiceTypeLong"));
            if (HolytaxInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(fplx)) {
                fplx = HolytaxInvoiceTypeEnum.SPECIAL_ELECTRON.getCode();
            }
            newInvoice.put("fplx", (Object)fplx);
            newInvoice.put("yxse", (Object)BigDecimalUtil.format(invoice.getBigDecimal("effectiveTaxAmount")));
            newInvoice.put("gxzt", deductionPurposeMap.getLeft());
            String yt = (String)deductionPurposeMap.getRight();
            newInvoice.put("yt", (Object)yt);
            if ("2".equals(yt)) {
                newInvoice.put("bdkyy", (Object)invoice.getString("notDeductibleType"));
            }
            newInvoice.put("se", (Object)BigDecimalUtil.format(invoice.getBigDecimal("totalTaxAmount")));
            newInvoice.put("sqskssq", (Object)taxPeriod);
            data.add((Object)newInvoice);
        }
        aisinoParam.put("contentRows", (Object)data.size());
        aisinoParam.put("data", (Object)data);
        AisinoService service = AisinoService.newInstance();
        JSONObject resultJson = service.postAppJson("jx.rz.select.request", this.orgId, taxNo, (Map<String, Object>)aisinoParam);
        LOGGER.info("\u822a\u4fe1\u52fe\u9009\u53d1\u7968\u7533\u8bf7\u7ed3\u679c\u8fd4\u56de:{}-{}", (Object)taxNo, (Object)resultJson);
        if (resultJson == null) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u52fe\u9009\u53d1\u7968\u5931\u8d25", (String)"AisinoDeductService_25", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return resultJson;
    }

    @Override
    public JSONObject gxInvoicesQuery(JSONObject bodyJson) {
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        AisinoService service = AisinoService.newInstance();
        JSONObject resultJson = service.postAppJson("jx.rz.select.query", this.orgId, taxNo, (Map<String, Object>)bodyJson);
        LOGGER.info("\u822a\u4fe1\u52fe\u9009\u53d1\u7968\u67e5\u8be2\u7ed3\u679c\u8fd4\u56de:{}-{}", (Object)taxNo, (Object)resultJson);
        if (resultJson == null) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u67e5\u8be2\u52fe\u9009\u53d1\u7968\u7ed3\u679c\u5931\u8d25", (String)"AisinoDeductService_26", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (ResultContant.isSuccess(resultJson).booleanValue()) {
            JSONObject data = resultJson.getJSONObject("data");
            JSONArray invoicesData = data.getJSONArray("invoicesData");
            JSONArray success = new JSONArray();
            JSONArray fail = new JSONArray();
            JSONArray handling = new JSONArray();
            for (int i = 0; i < invoicesData.size(); ++i) {
                JSONObject invoice = invoicesData.getJSONObject(i);
                JSONObject invoiceParam = new JSONObject();
                if (StringUtils.isNotEmpty((CharSequence)invoice.getString("jkshm"))) {
                    invoiceParam.put("invoiceCode", (Object)"");
                    invoiceParam.put("invoiceNo", invoice.get((Object)"jkshm"));
                } else {
                    invoiceParam.put("invoiceCode", invoice.get((Object)"fpdm"));
                    invoiceParam.put("invoiceNo", invoice.get((Object)"fphm"));
                }
                invoiceParam.put("invoiceDate", invoice.get((Object)"kprq"));
                invoiceParam.put("effectiveTaxAmount", invoice.get((Object)"yxse"));
                invoiceParam.put("selectDate", invoice.get((Object)"wcsj"));
                invoiceParam.put("deductionPurpose", invoice.get((Object)"yt"));
                invoiceParam.put("authenticateFlag", invoice.get((Object)"gxzt"));
                invoiceParam.put("notDeductibleType", invoice.get((Object)"bdkyy"));
                String selectResult = "";
                String failReason = invoice.getString("failReason");
                if ("01".equals(failReason) || "11".equals(failReason)) {
                    selectResult = "1";
                } else if ("02".equals(failReason)) {
                    selectResult = "2";
                } else if ("03".equals(failReason)) {
                    selectResult = "3";
                } else if ("04".equals(failReason)) {
                    selectResult = "4";
                } else if ("05".equals(failReason)) {
                    selectResult = "5";
                } else if ("06".equals(failReason)) {
                    selectResult = "10";
                } else if ("07".equals(failReason)) {
                    selectResult = "21";
                } else if ("08".equals(failReason)) {
                    selectResult = "18";
                } else if ("09".equals(failReason)) {
                    selectResult = "20";
                } else if ("10".equals(failReason)) {
                    selectResult = "35";
                } else if ("12".equals(failReason)) {
                    selectResult = "31";
                } else if ("13".equals(failReason)) {
                    selectResult = "8";
                } else if ("99".equals(failReason)) {
                    selectResult = "34";
                }
                invoiceParam.put("selectResult", (Object)selectResult);
                if ("1".equals(selectResult)) {
                    success.add((Object)invoiceParam);
                    continue;
                }
                if ("35".equals(selectResult)) {
                    handling.add((Object)invoiceParam);
                    continue;
                }
                fail.add((Object)invoiceParam);
            }
            data.clear();
            data.put("success", (Object)success);
            data.put("fail", (Object)fail);
            data.put("handling", (Object)handling);
        }
        return resultJson;
    }

    @Override
    public JSONObject queryHistoryStatistics(String taxNo, String taxPeriod) {
        return DeductStatisticsService.queryTaxPeriodInvoices(taxNo, taxPeriod);
    }

    @Override
    public JSONObject queryHistoryStatistics(String taxNo, String taxPeriod, boolean queryStatistics) {
        return this.queryHistoryStatistics(taxNo, taxPeriod);
    }

    @Override
    public JSONObject getDrawbackStatisticTable(JSONObject paramJson) {
        return ResultContant.createJSONObject("0200", ResManager.loadKDString((String)"\u822a\u4fe1\u63a5\u53e3\u6682\u65f6\u4e0d\u652f\u6301\u9000\u7a0e\u7edf\u8ba1\u529f\u80fd", (String)"AisinoDeductService_27", (String)"imc-rim-common", (Object[])new Object[0]));
    }

    @Override
    public JSONObject drawbackStatisticConfirm(JSONObject paramJson) {
        return ResultContant.createJSONObject("0200", ResManager.loadKDString((String)"\u822a\u4fe1\u63a5\u53e3\u6682\u65f6\u4e0d\u652f\u6301\u9000\u7a0e\u7edf\u8ba1\u529f\u80fd", (String)"AisinoDeductService_27", (String)"imc-rim-common", (Object[])new Object[0]));
    }

    @Override
    public JSONObject downFullInvoice(JSONObject paramJson) {
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5f53\u524d\u4f01\u4e1a\u7a0e\u53f7\u8f6f\u8bc1\u4e66\u914d\u7f6e\u662f\u5426\u6b63\u786e", (String)"AisinoDeductService_28", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        AisinoService service = AisinoService.newInstance();
        JSONObject resultJson = service.postAppJson("jx.rz.invoicesQuery", this.orgId, taxNo, (Map<String, Object>)paramJson);
        LOGGER.info("\u822a\u4fe1\u5168\u91cf\u53d1\u7968\u4e0b\u8f7d\u7ed3\u679c\u8fd4\u56de:{}-{}", (Object)taxNo, (Object)resultJson);
        if (resultJson == null) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u83b7\u53d6\u5168\u91cf\u53d1\u7968\u5931\u8d25", (String)"AisinoDeductService_29", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return resultJson;
    }

    @Override
    public JSONObject queryInvoiceStatus(JSONObject paramJson) {
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5f53\u524d\u4f01\u4e1a\u7a0e\u53f7\u8f6f\u8bc1\u4e66\u914d\u7f6e\u662f\u5426\u6b63\u786e", (String)"AisinoDeductService_28", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        AisinoService service = AisinoService.newInstance();
        JSONObject resultJson = service.postAppJson("jx.rz.invoicesStateQuery", this.orgId, taxNo, (Map<String, Object>)paramJson);
        LOGGER.info("\u822a\u4fe1\u8868\u5934\u53d1\u7968\u4e0b\u8f7d\u7ed3\u679c\u8fd4\u56de:{}-{}", (Object)taxNo, (Object)resultJson);
        if (resultJson == null) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u83b7\u53d6\u5168\u91cf\u53d1\u7968\u5931\u8d25", (String)"AisinoDeductService_29", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return resultJson;
    }
}

