/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.AsyncDeductQueryService;
import kd.imc.rim.common.invoice.deduction.DeductStatisticsService;
import kd.imc.rim.common.invoice.download.InvoiceDownHelper;
import kd.imc.rim.common.invoice.download.impl.InvoiceTableDownServiceImpl;
import kd.imc.rim.common.utils.ListUtils;

public class AsyncInvoiceDownQueryServiceImpl
extends AsyncDeductQueryService {
    private static Log LOGGER = LogFactory.getLog(AsyncInvoiceDownQueryServiceImpl.class);
    private static final Set<String> ALLOW_DOWN_STATUS = new HashSet<String>(4){
        private static final long serialVersionUID = -2012333430055776732L;
        {
            this.add("1");
            this.add("3");
            this.add("9");
        }
    };
    private static final String LOCK_KEY = "rim.AsyncInvoiceDownQueryServiceImpl-";

    @Override
    public JSONObject queryAsyncResult(JSONObject param) {
        this.checkParam(param);
        this.checkPageNo(param);
        this.checkPageSize(param);
        String taxNo = param.getString("taxNo");
        String taskNo = param.getString("taskNo");
        String lockKey = LOCK_KEY + taxNo + taskNo;
        try (DLock lock = DLock.create((String)lockKey, (String)ResManager.loadKDString((String)"\u5f02\u6b65\u6570\u636e\u67e5\u8be2", (String)"AsyncInvoiceDownQueryServiceImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));){
            if (lock.tryLock()) {
                JSONObject jSONObject = this.getDownResult(param, taxNo, taskNo);
                return jSONObject;
            }
            LOGGER.info("{}\u4efb\u52a1\u53f7\u8bf7\u6c42\u9891\u7e41", (Object)taskNo);
            JSONObject jSONObject = this.getHandlingResult(ResManager.loadKDString((String)"\u4efb\u52a1\u53f7\u8bf7\u6c42\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"AsyncInvoiceDownQueryServiceImpl_1", (String)"imc-rim-common", (Object[])new Object[0]));
            return jSONObject;
        }
    }

    private JSONObject getDownResult(JSONObject param, String taxNo, String taskNo) {
        QFilter qFilter = new QFilter("batch_no", "=", (Object)taskNo).and("tax_no", "=", (Object)taxNo).and("sync_type", "=", (Object)"1");
        List primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"rim_down_log", (QFilter[])qFilter.toArray(), null, (int)10);
        if (ObjectUtils.isEmpty((Object)primaryKeys)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u4efb\u52a1\uff0c\u8bf7\u786e\u8ba4\u8bf7\u6c42\u7a0e\u53f7\u6216\u4efb\u52a1\u53f7\u662f\u5426\u6b63\u786e", (String)"AsyncInvoiceDownQueryServiceImpl_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        DynamicObject downLog = BusinessDataServiceHelper.loadSingle(primaryKeys.get(0), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_down_log"));
        String govStatus = downLog.getString("gov_status");
        if ("5".equals(govStatus)) {
            String description = downLog.getString("description");
            String errcode = downLog.getString("download_errcode");
            if (StringUtils.isEmpty((CharSequence)errcode) || errcode.length() < 4) {
                errcode = "5001";
            }
            return ResultContant.createJSONObject(errcode, StringUtils.isEmpty((CharSequence)description) ? ResManager.loadKDString((String)"\u8868\u5934\u4e0b\u8f7d\u5931\u8d25", (String)"AsyncInvoiceDownQueryServiceImpl_3", (String)"imc-rim-common", (Object[])new Object[0]) : description);
        }
        if (ALLOW_DOWN_STATUS.contains(govStatus)) {
            boolean getSaveInvoice;
            boolean bl = getSaveInvoice = "1".equals(param.getString("saveFlag")) && "3".equals(govStatus);
            if (getSaveInvoice) {
                ThreadPools.executeOnceIncludeRequestContext((String)"AsyncInvoiceDownQueryServiceImpl.invoiceDeal", () -> {
                    String lockKey2 = LOCK_KEY + downLog.get("id");
                    try (DLock lock2 = DLock.create((String)lockKey2, (String)"AsyncInvoiceDownQueryServiceImpl.lock");){
                        if (lock2.tryLock()) {
                            this.dealInvoice(downLog);
                        } else {
                            LOGGER.info("\u5f53\u524d\u6279\u6b21\u6b63\u5728\u5904\u7406\u4e2d[{}]", downLog.get("batch_no"));
                        }
                    }
                });
                return this.getHandlingResult(downLog.getString("description"));
            }
            return this.getSuccessData(taskNo, param.getIntValue("pageNo"), param.getIntValue("pageSize"), govStatus);
        }
        return this.getHandleData(downLog);
    }

    private JSONObject getHandleData(DynamicObject downLog) {
        ThreadPools.executeOnceIncludeRequestContext((String)"AsyncInvoiceDownQueryServiceImpl.invoiceDown", () -> {
            String lockKey = LOCK_KEY + downLog.get("id");
            try (DLock lock = DLock.create((String)lockKey, (String)"AsyncInvoiceDownQueryServiceImpl.table.lock");){
                if (lock.tryLock()) {
                    new InvoiceTableDownServiceImpl(false).invoiceDown(downLog, RequestContext.get());
                    if ("3".equals(downLog.getString("gov_status"))) {
                        this.dealInvoice(downLog);
                    }
                } else {
                    LOGGER.info("\u5f53\u524d\u6279\u6b21\u6b63\u5728\u5904\u7406\u4e2d[{}]", downLog.get("batch_no"));
                }
            }
        });
        return this.getHandlingResult(downLog.getString("description"));
    }

    private void dealInvoice(DynamicObject downLog) {
        HashSet<String> succBatchNos = new HashSet<String>(1);
        succBatchNos.add(downLog.getString("batch_no"));
        InvoiceDownHelper.dealInvoice(succBatchNos);
        InvoiceDownHelper.updateSuccessStatus(new DynamicObject[]{downLog});
    }

    private JSONObject getSuccessData(String batchNo, int pageNo, int pageSize, String govStatus) {
        JSONArray invoicesData = new JSONArray();
        JSONObject data = new JSONObject();
        data.put("totalPage", (Object)0);
        data.put("totalElement", (Object)0);
        data.put("pageNo", (Object)pageNo);
        data.put("pageSize", (Object)pageSize);
        if ("9".equals(govStatus)) {
            data.put("invoicesData", (Object)invoicesData);
            return ResultContant.createSuccessJSONObject(data);
        }
        QFilter qFilter = new QFilter("batch_no", "=", (Object)batchNo).and("data_type_tb", "=", (Object)"1");
        DynamicObjectCollection serialNoColl = QueryServiceHelper.query((String)"rim_down_account", (String)"serial_no,fpy_serial_no", (QFilter[])qFilter.toArray());
        if (!CollectionUtils.isEmpty((Collection)serialNoColl)) {
            data.put("totalElement", (Object)serialNoColl.size());
            List lists = ListUtils.splitList(serialNoColl, pageSize);
            Optional.ofNullable(lists).ifPresent(s -> data.put("totalPage", (Object)lists.size()));
            if (!CollectionUtils.isEmpty(lists) && pageNo <= lists.size()) {
                JSONArray invoices;
                JSONObject queryObject;
                List dynamicObjectList = lists.get(pageNo - 1);
                ArrayList<String> fpySerialNos = new ArrayList<String>(8);
                ArrayList<String> notSaveSerialNos = new ArrayList<String>(8);
                for (DynamicObject dynamicObject : dynamicObjectList) {
                    if (StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("fpy_serial_no"))) {
                        fpySerialNos.add(dynamicObject.getString("fpy_serial_no"));
                        continue;
                    }
                    notSaveSerialNos.add(dynamicObject.getString("serial_no"));
                }
                if (!CollectionUtils.isEmpty(fpySerialNos) && ResultContant.isSuccess(queryObject = DeductStatisticsService.queryTableInvoices(fpySerialNos)).booleanValue() && !CollectionUtils.isEmpty((Collection)(invoices = queryObject.getJSONArray("data")))) {
                    invoicesData.addAll((Collection)invoices);
                }
                if (!CollectionUtils.isEmpty(notSaveSerialNos)) {
                    QFilter serialNoFilter = new QFilter("serial_no", "in", notSaveSerialNos);
                    DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_down_input", (String)"invoice_json_tag", (QFilter[])serialNoFilter.toArray());
                    for (DynamicObject downInput : collection) {
                        JSONObject invoiceJson = JSONObject.parseObject((String)downInput.getString("invoice_json_tag"));
                        invoicesData.add((Object)invoiceJson);
                    }
                }
            }
        }
        data.put("invoicesData", (Object)invoicesData);
        return ResultContant.createSuccessJSONObject(data);
    }

    @Override
    public JSONObject getResult(DynamicObject selectLog) {
        return null;
    }
}

