/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.RimRetryPostUtil;
import kd.imc.rim.common.utils.UUID;

public class HolytaxDeductService
extends DeductService {
    private static Log LOGGER = LogFactory.getLog(HolytaxDeductService.class);
    private static final Set<String> COLLECT_ERRCODE = new HashSet<String>(8);

    public HolytaxDeductService(Long orgId) {
        this.orgId = orgId;
        COLLECT_ERRCODE.addAll(DeductionUtils.getHolyRetryErrcodes());
    }

    @Override
    public JSONObject queryTaxperiod(String taxNo) {
        try {
            AwsFpyService service = AwsFpyService.newInstance();
            JSONObject param = new JSONObject();
            DeductionConstant.setUnittestFlag((Map<String, Object>)param);
            param.put("taxNo", (Object)taxNo);
            LOGGER.info("\u540c\u6b65\u83b7\u53d6\u7a0e\u671f\u53c2\u6570:{}", (Object)param);
            JSONObject resultJson = service.postAppJson("fpdk_getTaxPeriod", this.orgId, (Map<String, Object>)param);
            LOGGER.info("\u540c\u6b65\u83b7\u53d6\u7a0e\u671f\u7ed3\u679c\u8fd4\u56de:{}-{}", (Object)taxNo, (Object)resultJson);
            return resultJson;
        }
        catch (Exception e) {
            LOGGER.error("\u540c\u6b65\u83b7\u53d6\u7a0e\u671f\u5931\u8d25:" + taxNo, (Throwable)e);
            return null;
        }
    }

    @Override
    public JSONObject queryInvoices(JSONObject bodyJson) {
        boolean isPage;
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String requestId = DeductionConstant.getRequestId(bodyJson);
        bodyJson.put("requestId", (Object)requestId);
        DeductionConstant.setUnittestFlag((Map<String, Object>)bodyJson);
        String synctype = bodyJson.getString("synctype");
        Integer pageNoParam = CommonUtils.getJsonValue((Map<String, Object>)bodyJson, Integer.class, "dataIndex", "pageNo");
        int pageNo = Optional.ofNullable(pageNoParam).orElse(1);
        LOGGER.info("\u4e0b\u8f7d\u53d1\u7968\u53c2\u6570:{}", (Object)bodyJson);
        String asyncFlag = bodyJson.getString("asyncFlag");
        String batchNo = UUID.getBatchNoByTaxNo(taxNo);
        if ("1".equals(asyncFlag)) {
            JSONObject resultJson = ResultContant.createSuccessJSONObject();
            return DeductionUtils.setBatchNo2Result(resultJson, asyncFlag, batchNo);
        }
        String configPage = RimConfigUtils.getConfig("rim_deduction", "hl_is_page");
        boolean bl = isPage = "1".equals(configPage) && ("03".equals(synctype) || "04".equals(synctype));
        if (isPage) {
            int pageSize = InvoiceDownloadConstant.getPageSizeFromConfig(1000, "hl_query_page_size");
            bodyJson.put("pageNo", (Object)pageNo);
            bodyJson.put("pageSize", (Object)pageSize);
        }
        int retryTime = InvoiceDownloadConstant.getPageSizeFromConfig(5, "query_invoices_retry_times");
        int sleepTime = InvoiceDownloadConstant.getPageSizeFromConfig(1000, "query_invoices_sleep_times");
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject resultJson = RimRetryPostUtil.retryPost(service, "fpdk_queryInvoices", this.orgId, bodyJson, COLLECT_ERRCODE, retryTime, sleepTime);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u83b7\u53d6\u53d1\u7968\u5931\u8d25", (String)"HolytaxDeductService_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONArray data = resultJson.getJSONArray("data");
        if (data == null) {
            data = new JSONArray();
        }
        if (ResultContant.isSuccess(resultJson).booleanValue() && isPage) {
            resultJson.put("nextDataIndex", (Object)(pageNo + 1));
            while (!"1".equals(bodyJson.getString("notQueryPage"))) {
                bodyJson.put("pageNo", (Object)(++pageNo));
                bodyJson.put("requestId", (Object)UUID.randomUUID());
                resultJson = RimRetryPostUtil.retryPost(service, "fpdk_queryInvoices", this.orgId, bodyJson, COLLECT_ERRCODE, retryTime, sleepTime);
                if (ResultContant.isSuccess(resultJson).booleanValue()) {
                    JSONArray invoiceArray = resultJson.getJSONArray("data");
                    data.addAll((Collection)invoiceArray);
                    String continueFlag = resultJson.getString("continueFlag");
                    if ("true".equals(continueFlag)) continue;
                    break;
                }
                if (resultJson != null) break;
                resultJson = ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u83b7\u53d6\u53d1\u7968\u5931\u8d25", (String)"HolytaxDeductService_0", (String)"imc-rim-common", (Object[])new Object[0]));
                break;
            }
        }
        resultJson.put("data", (Object)data);
        LOGGER.info("\u4e0b\u8f7d\u53d1\u7968\u8fd4\u56de\u7ed3\u679c:{}-[{}]{},\u4e0b\u8f7d\u6570\u91cf:{}", new Object[]{taxNo, resultJson.get((Object)"errcode"), resultJson.get((Object)"description"), CollectionUtils.isEmpty((Collection)data) ? 0 : data.size()});
        return resultJson;
    }

    @Override
    public JSONObject getStatisticTable(JSONObject bodyJson) {
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String requestId = DeductionConstant.getRequestId(bodyJson);
        bodyJson.put("requestId", (Object)requestId);
        DeductionConstant.setUnittestFlag((Map<String, Object>)bodyJson);
        LOGGER.info("\u67e5\u8be2\u7edf\u8ba1\u8868\u53c2\u6570:{}", (Object)bodyJson);
        AwsFpyService service = AwsFpyService.newInstance();
        int retryTime = InvoiceDownloadConstant.getPageSizeFromConfig(5, "get_statistic_retry_times");
        int sleepTime = InvoiceDownloadConstant.getPageSizeFromConfig(1000, "get_statistic_sleep_times");
        JSONObject resultJson = RimRetryPostUtil.retryPost(service, "fpdk_getStatisticTable", this.orgId, bodyJson, COLLECT_ERRCODE, retryTime, sleepTime);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u83b7\u53d6\u7edf\u8ba1\u8868\u5931\u8d25", (String)"HolytaxDeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONObject data = resultJson.getJSONObject("data");
        if (data != null) {
            data.put("tjInfoArr", data.get((Object)"tjxx"));
        }
        LOGGER.info("\u67e5\u8be2\u7edf\u8ba1\u8868\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    @Override
    public JSONObject createStatisticTable(JSONObject bodyJson) {
        int sleepTime;
        int retryTime;
        if (ObjectUtils.isEmpty((Object)bodyJson)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String requestId = DeductionConstant.getRequestId(bodyJson);
        bodyJson.put("requestId", (Object)requestId);
        DeductionConstant.setUnittestFlag((Map<String, Object>)bodyJson);
        LOGGER.info("\u751f\u6210\u7edf\u8ba1\u8868\u53c2\u6570:{}", (Object)bodyJson);
        String batchNo = UUID.getBatchNoByTaxNo(taxNo);
        String asyncFlag = bodyJson.getString("asyncFlag");
        if ("1".equals(asyncFlag)) {
            JSONObject resultJson = ResultContant.createSuccessJSONObject();
            return DeductionUtils.setBatchNo2Result(resultJson, asyncFlag, batchNo);
        }
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject resultJson = RimRetryPostUtil.retryPost(service, "fpdk_createStatisticTable", this.orgId, bodyJson, COLLECT_ERRCODE, retryTime = InvoiceDownloadConstant.getPageSizeFromConfig(5, "create_statistic_retry_times"), sleepTime = InvoiceDownloadConstant.getPageSizeFromConfig(1000, "create_statistic_sleep_times"));
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u751f\u6210\u7edf\u8ba1\u8868\u5931\u8d25,\u8bf7\u91cd\u65b0\u67e5\u8be2\u7edf\u8ba1\u8868", (String)"HolytaxDeductService_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONObject data = resultJson.getJSONObject("data");
        if (data != null) {
            data.put("tjInfoArr", data.get((Object)"tjxx"));
        }
        LOGGER.info("\u751f\u6210\u7edf\u8ba1\u8868\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        return DeductionUtils.setBatchNo2Result(resultJson, asyncFlag, batchNo);
    }

    @Override
    public JSONObject cancelStatisticTable(JSONObject bodyJson) {
        int sleepTime;
        int retryTime;
        if (ObjectUtils.isEmpty((Object)bodyJson)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String taxNo = bodyJson.getString("taxNo");
        JSONObject resultJson = ResultContant.createSuccessJSONObject();
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String requestId = DeductionConstant.getRequestId(bodyJson);
        bodyJson.put("requestId", (Object)requestId);
        DeductionConstant.setUnittestFlag((Map<String, Object>)bodyJson);
        LOGGER.info("\u53d6\u6d88\u7edf\u8ba1\u8868\u53c2\u6570:{}", (Object)bodyJson);
        String batchNo = UUID.getBatchNoByTaxNo(taxNo);
        String asyncFlag = bodyJson.getString("asyncFlag");
        if ("1".equals(asyncFlag)) {
            return DeductionUtils.setBatchNo2Result(resultJson, asyncFlag, batchNo);
        }
        AwsFpyService service = AwsFpyService.newInstance();
        resultJson = RimRetryPostUtil.retryPost(service, "fpdk_cancelStatisticTable", this.orgId, bodyJson, COLLECT_ERRCODE, retryTime = InvoiceDownloadConstant.getPageSizeFromConfig(5, "cancel_statistic_retry_times"), sleepTime = InvoiceDownloadConstant.getPageSizeFromConfig(1000, "cancel_statistic_sleep_times"));
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u64a4\u9500\u7edf\u8ba1\u8868\u5931\u8d25", (String)"HolytaxDeductService_3", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u64a4\u9500\u7edf\u8ba1\u8868\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        return DeductionUtils.setBatchNo2Result(resultJson, asyncFlag, batchNo);
    }

    @Override
    public JSONObject confirmStatisticTable(JSONObject paramJson) {
        int sleepTime;
        int retryTime;
        JSONObject resultJson = ResultContant.createSuccessJSONObject();
        if (ObjectUtils.isEmpty((Object)paramJson)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        if (StringUtils.isBlank((CharSequence)paramJson.getString("password"))) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u786e\u8ba4\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"HolytaxDeductService_13", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String requestId = DeductionConstant.getRequestId(paramJson);
        paramJson.put("requestId", (Object)requestId);
        DeductionConstant.setUnittestFlag((Map<String, Object>)paramJson);
        LOGGER.info("\u786e\u8ba4\u7b7e\u540d\u53c2\u6570:{}", (Object)paramJson);
        String batchNo = UUID.getBatchNoByTaxNo(taxNo);
        String asyncFlag = paramJson.getString("asyncFlag");
        if ("1".equals(asyncFlag)) {
            return DeductionUtils.setBatchNo2Result(resultJson, asyncFlag, batchNo);
        }
        AwsFpyService service = AwsFpyService.newInstance();
        resultJson = RimRetryPostUtil.retryPost(service, "fpdk_confirmStatisticTable", this.orgId, paramJson, COLLECT_ERRCODE, retryTime = InvoiceDownloadConstant.getPageSizeFromConfig(5, "confirm_retry_times"), sleepTime = InvoiceDownloadConstant.getPageSizeFromConfig(1000, "confirm_sleep_times"));
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u786e\u8ba4\u7edf\u8ba1\u8868\u5931\u8d25", (String)"HolytaxDeductService_4", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u7edf\u8ba1\u8868\u786e\u8ba4\u7b7e\u540d\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        return DeductionUtils.setBatchNo2Result(resultJson, asyncFlag, batchNo);
    }

    @Override
    public JSONObject gxInvoices(JSONObject bodyJson) {
        if (null == bodyJson) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"HolytaxDeductService_5", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String taxNo = bodyJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        JSONArray invoices = bodyJson.getJSONArray("invoices");
        if (CollectionUtils.isEmpty((Collection)invoices)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570invoices\u4e0d\u80fd\u4e3a\u7a7a", (String)"HolytaxDeductService_6", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if ("2".equals(bodyJson.getString("billType"))) {
            return ResultContant.createJSONObject(ErrorType.DKDJ_NONSUPPORT);
        }
        String requestId = DeductionConstant.getRequestId(bodyJson);
        bodyJson.put("requestId", (Object)requestId);
        DeductionConstant.setUnittestFlag((Map<String, Object>)bodyJson);
        LOGGER.info("\u52fe\u9009\u53d1\u7968\u8bf7\u6c42\u53c2\u6570:{}", (Object)bodyJson);
        String asyncFlag = bodyJson.getString("asyncFlag");
        if ("1".equals(asyncFlag)) {
            return ResultContant.createSuccessJSONObject();
        }
        int retryTime = InvoiceDownloadConstant.getPageSizeFromConfig(10, "gx_invoices_retry_times");
        int sleepTime = InvoiceDownloadConstant.getPageSizeFromConfig(3000, "gx_invoices_sleep_times");
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject param = new JSONObject();
        param.putAll((Map)bodyJson);
        String deductibleMode = param.getString("deductibleMode");
        if ("2".equals(deductibleMode)) {
            param.put("deductibleStep", (Object)"1");
        } else if ("-2".equals(deductibleMode)) {
            param.put("deductibleMode", (Object)"2");
            param.put("deductibleStep", (Object)"-1");
        }
        JSONObject resultJson = RimRetryPostUtil.retryPost(service, "fpdk_selectInvoices", this.orgId, param, COLLECT_ERRCODE, retryTime, sleepTime);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u52fe\u9009\u53d1\u7968\u5931\u8d25", (String)"HolytaxDeductService_7", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u52fe\u9009\u53d1\u7968\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    @Override
    public JSONObject queryHistoryStatistics(String taxNo, String taxPeriod) {
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        JSONObject bodyJson = new JSONObject();
        bodyJson.put("taxNo", (Object)taxNo);
        bodyJson.put("synccondition", (Object)taxPeriod);
        bodyJson.put("currentOrgId", (Object)0);
        bodyJson.put("jksbz", (Object)1);
        bodyJson.put("synctype", (Object)"03");
        JSONObject searchOpt = new JSONObject();
        searchOpt.put("invoiceType", (Object)"");
        searchOpt.put("startTime", (Object)"");
        searchOpt.put("endTime", (Object)"");
        searchOpt.put("invoiceNo", (Object)"");
        searchOpt.put("invoiceCode", (Object)"");
        bodyJson.put("searchOpt", (Object)searchOpt);
        return this.queryInvoices(bodyJson);
    }

    @Override
    public JSONObject queryHistoryStatistics(String taxNo, String taxPeriod, boolean queryStatistics) {
        return this.queryHistoryStatistics(taxNo, taxPeriod);
    }

    @Override
    public JSONObject applyFullInvoice(JSONObject paramJson) {
        if (CollectionUtils.isEmpty((Map)paramJson)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"HolytaxDeductService_5", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String taxNo = (String)paramJson.get((Object)"taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5f53\u524d\u4f01\u4e1a\u7a0e\u53f7\u8f6f\u8bc1\u4e66\u914d\u7f6e\u662f\u5426\u6b63\u786e", (String)"HolytaxDeductService_8", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        DeductionConstant.setUnittestFlag((Map<String, Object>)paramJson);
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject resultJson = service.postAppJson("fpdk_downloadInvoicesApply", this.orgId, (Map<String, Object>)paramJson);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u8fdb\u9500\u9879\u7533\u8bf7\u5931\u8d25", (String)"HolytaxDeductService_9", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u8fdb\u9500\u9879\u7533\u8bf7\u7ed3\u679c:{},{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    @Override
    public JSONObject downFullInvoice(JSONObject paramJson) {
        if (CollectionUtils.isEmpty((Map)paramJson)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"HolytaxDeductService_5", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String taxNo = (String)paramJson.get((Object)"taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject("0201", ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5f53\u524d\u4f01\u4e1a\u7a0e\u53f7\u8f6f\u8bc1\u4e66\u914d\u7f6e\u662f\u5426\u6b63\u786e", (String)"HolytaxDeductService_8", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        DeductionConstant.setUnittestFlag((Map<String, Object>)paramJson);
        String requestId = DeductionConstant.getRequestId(paramJson);
        paramJson.put("requestId", (Object)requestId);
        AwsFpyService service = AwsFpyService.newInstance();
        int retryTime = InvoiceDownloadConstant.getPageSizeFromConfig(3, "full_invoices_retry_times");
        int sleepTime = InvoiceDownloadConstant.getPageSizeFromConfig(2000, "full_invoices_sleep_times");
        JSONObject resultJson = RimRetryPostUtil.retryPost(service, "fpdk_downloadInvoicesQuery", this.orgId, paramJson, COLLECT_ERRCODE, retryTime, sleepTime);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u8fdb\u9500\u9879\u4e0b\u8f7d\u5931\u8d25", (String)"HolytaxDeductService_10", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return resultJson;
    }

    @Override
    public JSONObject getDrawbackStatisticTable(JSONObject paramJson) {
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String requestId = DeductionConstant.getRequestId(paramJson);
        paramJson.put("requestId", (Object)requestId);
        DeductionConstant.setUnittestFlag((Map<String, Object>)paramJson);
        LOGGER.info("\u67e5\u8be2\u9000\u7a0e\u7edf\u8ba1\u8868\u53c2\u6570:{}", (Object)paramJson);
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject resultJson = service.postEncryptAppJson("fpdk_drawbackStatisticQuery", this.orgId, (Map<String, Object>)paramJson);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u67e5\u8be2\u9000\u7a0e\u7edf\u8ba1\u8868\u5931\u8d25", (String)"HolytaxDeductService_11", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u67e5\u8be2\u9000\u7a0e\u7edf\u8ba1\u8868\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }

    @Override
    public JSONObject drawbackStatisticConfirm(JSONObject paramJson) {
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL);
        }
        String requestId = DeductionConstant.getRequestId(paramJson);
        paramJson.put("requestId", (Object)requestId);
        DeductionConstant.setUnittestFlag((Map<String, Object>)paramJson);
        LOGGER.info("\u786e\u8ba4\u9000\u7a0e\u7edf\u8ba1\u8868\u53c2\u6570:{}", (Object)paramJson);
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject resultJson = service.postEncryptAppJson("fpdk_drawbackConfirmStatistic", this.orgId, (Map<String, Object>)paramJson);
        if (null == resultJson) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u786e\u8ba4\u9000\u7a0e\u7edf\u8ba1\u8868\u786e\u8ba4\u9000\u7a0e\u7edf\u8ba1\u8868\u5931\u8d25", (String)"HolytaxDeductService_12", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u786e\u8ba4\u9000\u7a0e\u7edf\u8ba1\u8868\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)resultJson);
        return resultJson;
    }
}

