/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.AsyncDeductSelectService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.invoice.deduction.impl.LqDeductService;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.TenantUtils;
import org.apache.commons.lang3.tuple.Pair;

public class LqAsyncDeductSelectService
extends AsyncDeductSelectService {
    private static Log LOGGER = LogFactory.getLog(LqAsyncDeductSelectService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void querySelectResult(DynamicObject selectLog) {
        JSONArray failArray;
        ArrayList<DynamicObject> updateAccountList;
        Map<String, DynamicObject> selectAccountMap;
        String billType;
        block44: {
            String deductionPurpose;
            JSONObject example;
            JSONObject success;
            JSONArray updateSelectInvoiceArray;
            JSONArray successArray;
            String taxNo;
            String taxPeriod;
            block45: {
                String batchNo = selectLog.getString("batch_no");
                LOGGER.info("\u5f00\u59cb\u67e5\u8be2\u5f02\u6b65\u52fe\u9009\u7ed3\u679c-\u4e50\u4f01:{}", (Object)batchNo);
                taxPeriod = "";
                if (selectLog.getDate("tax_period") != null) {
                    taxPeriod = DateUtils.format(selectLog.getDate("tax_period"), "yyyyMM");
                }
                Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(selectLog.get("org"));
                JSONObject param = new JSONObject();
                param.put("batchNo", (Object)batchNo);
                taxNo = selectLog.getString("tax_no");
                param.put("taxNo", (Object)taxNo);
                billType = selectLog.getString("bill_type");
                param.put("billType", (Object)billType);
                String deductibleMode = selectLog.getString("operate_type");
                param.put("deductibleMode", (Object)deductibleMode);
                String key = "rim.lqasyncdeduct-" + batchNo;
                try (DLock lock = DLock.create((String)key, (String)"LqAsyncDeductSelectService.lock");){
                    if (!lock.tryLock()) return;
                    try {
                        JSONObject queryResult = this.doSelect(orgId, param);
                        selectLog.set("update_time", (Object)new Date());
                        selectAccountMap = this.getSelectAccount(batchNo, billType);
                        if (CollectionUtils.isEmpty(selectAccountMap)) {
                            LOGGER.info("\u6ca1\u6709\u67e5\u8be2\u5230\u52fe\u9009\u53f0\u8d26\u6570\u636e:{}-{}", (Object)taxNo, (Object)batchNo);
                            selectLog.set("handle_status", (Object)"2");
                            selectLog.set("description", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u52fe\u9009\u53f0\u8d26\u6570\u636e", (String)"LqAsyncDeductSelectService_0", (String)"imc-rim-common", (Object[])new Object[0]));
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                            return;
                        }
                        updateAccountList = new ArrayList<DynamicObject>(8);
                        if (queryResult != null && ResultContant.isSuccess(queryResult).booleanValue()) {
                            JSONObject data = queryResult.getJSONObject("data");
                            if (data == null) {
                                LOGGER.info("\u6ca1\u6709\u8fd4\u56dedata\u6570\u636e:{}-{}", (Object)taxNo, (Object)batchNo);
                                selectLog.set("description", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u8fd4\u56dedata\u6570\u636e", (String)"LqAsyncDeductSelectService_1", (String)"imc-rim-common", (Object[])new Object[0]));
                                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                                return;
                            }
                            successArray = data.getJSONArray("success");
                            failArray = data.getJSONArray("fail");
                            JSONArray handlingArray = data.getJSONArray("handling");
                            selectLog.set("success_num", (Object)successArray.size());
                            selectLog.set("fail_num", (Object)(selectLog.getInt("total_num") - successArray.size() - handlingArray.size()));
                            if (CollectionUtils.isEmpty((Collection)handlingArray)) {
                                selectLog.set("handle_status", (Object)"1");
                            }
                            if (CollectionUtils.isEmpty((Collection)successArray)) {
                                if (CollectionUtils.isEmpty((Collection)failArray)) return;
                            }
                            updateSelectInvoiceArray = new JSONArray();
                            success = null;
                            example = null;
                            deductionPurpose = "";
                            if (CollectionUtils.isEmpty((Collection)successArray)) break block44;
                            break block45;
                        }
                        if (queryResult != null && CommonUtils.isMatchErrcodes(queryResult, ErrorType.STATUS_HANDLING.getCode(), ErrorType.STATUS_TIMEOUT.getCode(), ErrorType.LQ_SERVICE_ERROR.getCode(), ErrorType.LQ_SERVICE_ERROR_6099.getCode())) {
                            Date createTime = selectLog.getDate("create_time");
                            if (this.checkHandleTimeOut(queryResult, createTime)) {
                                queryResult = ResultContant.createJSONObject(ErrorType.HANDLE_TIMEOUT);
                                this.saveAllFailResult(selectLog, billType, queryResult, selectAccountMap, updateAccountList);
                                return;
                            }
                            selectLog.set("description", (Object)queryResult.getString("description"));
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                            return;
                        }
                        if (queryResult == null) return;
                        this.saveAllFailResult(selectLog, billType, queryResult, selectAccountMap, updateAccountList);
                        return;
                    }
                    catch (Exception e) {
                        LOGGER.error("\u4e50\u4f01\u5f02\u6b65\u67e5\u8be2\u52fe\u9009\u7ed3\u679c\u5931\u8d25:" + batchNo, (Throwable)e);
                        return;
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            for (int i = 0; i < successArray.size(); ++i) {
                String skssq;
                BigDecimal effectiveTaxAmount;
                success = successArray.getJSONObject(i);
                String invoiceCode = StringUtils.trimToEmpty((String)success.getString("invoiceCode"));
                String mapKey = this.getBillNo(invoiceCode, success.getString("invoiceNo"), billType, success.getDate("invoiceDate"));
                DynamicObject updateAccount = selectAccountMap.get(mapKey);
                if (updateAccount == null && (updateAccount = this.getAccountByElectronicNo(selectAccountMap, success.getString("invoiceNo"))) == null) continue;
                deductionPurpose = updateAccount.getString("deduction_purpose");
                Pair<String, String> deductionPurposeMap = DeductionConstant.getDeductionPurpose(deductionPurpose);
                updateAccount.set("handle_status", (Object)"1");
                updateAccount.set("select_result", (Object)success.getString("selectResult"));
                updateAccount.set("description", (Object)this.getSelectMsg(success));
                updateAccount.set("update_time", (Object)new Date());
                updateAccount.set("select_time", (Object)success.getDate("selectDate"));
                updateAccountList.add(updateAccount);
                if (!StringUtils.isNotEmpty((CharSequence)updateAccount.getString("serial_no"))) continue;
                example = new JSONObject();
                example.put("serial_no", (Object)updateAccount.getString("serial_no"));
                example.put("invoice_type", (Object)DynamicObjectUtil.getDynamicObjectLongValue(updateAccount.get("invoice_type")));
                if (StringUtils.isNotEmpty((CharSequence)success.getString("deductionPurpose"))) {
                    example.put("deduction_purpose", (Object)success.getString("deductionPurpose"));
                } else {
                    example.put("deduction_purpose", deductionPurposeMap.getRight());
                }
                if (("1".equals(billType) || "2".equals(billType)) && (effectiveTaxAmount = updateAccount.getBigDecimal("total_tax_amount")) != null && effectiveTaxAmount.compareTo(BigDecimal.ZERO) > 0) {
                    example.put("effective_tax_amount", (Object)effectiveTaxAmount);
                }
                if (StringUtils.isNotEmpty((CharSequence)(skssq = success.getString("taxPeriod")))) {
                    example.put("tax_period", (Object)skssq);
                } else {
                    example.put("tax_period", (Object)taxPeriod);
                }
                if (StringUtils.isEmpty((CharSequence)success.getString("selectDate"))) {
                    example.remove((Object)"tax_period");
                }
                example.put("authenticate_flag", deductionPurposeMap.getLeft());
                example.put("select_time", (Object)success.getString("selectDate"));
                example.put("cancel_select_type", (Object)updateAccount.getString("select_opera_type"));
                example.put("not_deductible_type", (Object)updateAccount.getString("not_deductible_type"));
                this.setUpdateInvoiceData(example, updateAccount, success, deductionPurpose);
                updateSelectInvoiceArray.add((Object)example);
            }
            this.updateInvoiceData(taxNo, updateSelectInvoiceArray, deductionPurpose);
        }
        Map<String, String> serialNoStatusMap = this.getStatusMap(failArray, selectAccountMap, updateAccountList, "", billType);
        selectLog.set("description", null);
        this.save(serialNoStatusMap, selectLog, updateAccountList);
    }

    private boolean checkHandleTimeOut(JSONObject queryResult, Date createTime) {
        if (queryResult == null || !ErrorType.STATUS_HANDLING.getCode().equals(queryResult.getString("errcode"))) {
            return false;
        }
        int maxDays = InvoiceDownloadConstant.getPageSizeFromConfig(10, "leqi_async_handle_days");
        Date date = DateUtils.addDay(createTime, maxDays);
        return new Date().compareTo(date) > 0;
    }

    private void saveAllFailResult(DynamicObject selectLog, String billType, JSONObject queryResult, Map<String, DynamicObject> selectAccountMap, List<DynamicObject> updateAccountList) {
        Map<String, String> serialNoStatusMap = this.getStatusMap(null, selectAccountMap, updateAccountList, queryResult.getString("description"), billType);
        selectLog.set("success_num", (Object)0);
        selectLog.set("fail_num", (Object)selectAccountMap.size());
        selectLog.set("description", (Object)queryResult.getString("description"));
        selectLog.set("handle_status", (Object)"2");
        this.save(serialNoStatusMap, selectLog, updateAccountList);
    }

    public void save(Map<String, String> serialNoStatusMap, DynamicObject selectLog, List<DynamicObject> updateAccountList) {
        try (TXHandle h = TX.required();){
            try {
                this.recoverMainInvoiceStatus(serialNoStatusMap);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                SaveServiceHelper.save((DynamicObject[])updateAccountList.toArray(new DynamicObject[updateAccountList.size()]));
            }
            catch (Throwable e) {
                LOGGER.error("\u52fe\u9009\u65e5\u5fd7/\u53f0\u8d26\u5931\u8d25", e);
                h.markRollback();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void queryRecordedCommitResult(DynamicObject selectLog) {
        JSONArray failArray;
        JSONArray successArray;
        ArrayList<DynamicObject> updateAccountList;
        Map<String, DynamicObject> selectAccountMap;
        String billType;
        block40: {
            String deductionPurpose;
            JSONObject success;
            ArrayList<JSONObject> updateInvoiceList;
            String dktype;
            block41: {
                Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(selectLog.get("org"));
                String batchNo = selectLog.getString("batch_no");
                String taxNo = selectLog.getString("tax_no");
                billType = selectLog.getString("bill_type");
                String operateType = selectLog.getString("operate_type");
                String key = "rim.lq-recorded-commit-" + batchNo;
                dktype = DeductionConstant.getDkType(taxNo);
                DeductService deductService = DeductServiceFactory.newInstanceForRecordedHandle(dktype);
                if (deductService == null) {
                    LOGGER.info("\u8be5\u7ec4\u7ec7\u7684\u6536\u7968\u901a\u9053\u4e0d\u652f\u6301\u5165\u8d26\u63d0\u4ea4\u7ed3\u679c\u67e5\u8be2, \u7a0e\u53f7\uff1a{}", (Object)taxNo);
                    return;
                }
                try (DLock lock = DLock.create((String)key, (String)"lq-recorded-query");){
                    if (!lock.tryLock()) return;
                    try {
                        Map<String, Object> selectLogMap = DynamicObjectUtil.dynamicObject2Map(selectLog);
                        selectAccountMap = this.getSelectAccount(batchNo, billType);
                        if (CollectionUtils.isEmpty(selectAccountMap)) {
                            LOGGER.info("\u4e50\u4f01-\u6ca1\u6709\u67e5\u8be2\u5230\u52fe\u9009\u53f0\u8d26\u6570\u636e:{}-{}", (Object)taxNo, (Object)batchNo);
                            selectLog.set("description", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u52fe\u9009\u53f0\u8d26\u6570\u636e", (String)"LqAsyncDeductSelectService_0", (String)"imc-rim-common", (Object[])new Object[0]));
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                            return;
                        }
                        JSONObject param = new JSONObject();
                        param.put("batchNo", (Object)batchNo);
                        param.put("taxNo", (Object)taxNo);
                        param.put("billType", (Object)billType);
                        param.put("operateType", (Object)operateType);
                        JSONObject queryResult = deductService.queryRecordedCommitResult(param);
                        updateAccountList = new ArrayList<DynamicObject>(8);
                        updateInvoiceList = new ArrayList<JSONObject>(8);
                        LOGGER.info("\u4e50\u4f01-\u8fd4\u56de\u7ed3\u679c:{}-{}", (Object)taxNo, (Object)queryResult);
                        if (queryResult != null && ResultContant.isSuccess(queryResult).booleanValue()) {
                            JSONObject data = queryResult.getJSONObject("data");
                            if (data == null) {
                                LOGGER.info("\u4e50\u4f01-\u6ca1\u6709\u8fd4\u56dedata\u6570\u636e:{}-{}", (Object)taxNo, (Object)batchNo);
                                selectLog.set("description", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u8fd4\u56dedata\u6570\u636e", (String)"LqAsyncDeductSelectService_1", (String)"imc-rim-common", (Object[])new Object[0]));
                                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                                return;
                            }
                            successArray = data.getJSONArray("success");
                            failArray = data.getJSONArray("fail");
                            selectLog.set("success_num", (Object)(!CollectionUtils.isEmpty((Collection)successArray) ? successArray.size() : 0));
                            selectLog.set("fail_num", !CollectionUtils.isEmpty((Collection)failArray) ? Integer.valueOf(failArray.size()) : "0");
                            if (CollectionUtils.isEmpty((Collection)successArray)) {
                                if (CollectionUtils.isEmpty((Collection)failArray)) return;
                            }
                            JSONArray updateSelectInvoiceArray = new JSONArray();
                            success = null;
                            deductionPurpose = "";
                            if (CollectionUtils.isEmpty((Collection)successArray)) break block40;
                            LOGGER.info("\u4e50\u4f01-\u7a0e\u5c40\u5165\u8d26\uff0c\u5b58\u5728\u6210\u529f\u6570\u636e\uff0csize: {}", (Object)successArray.size());
                            break block41;
                        }
                        if (queryResult != null && CommonUtils.isMatchErrcodes(queryResult, ErrorType.STATUS_HANDLING.getCode(), ErrorType.STATUS_TIMEOUT.getCode(), ErrorType.LQ_SERVICE_ERROR.getCode(), ErrorType.LQ_SERVICE_ERROR_6099.getCode())) {
                            Date createTime = selectLog.getDate("create_time");
                            if (this.checkHandleTimeOut(queryResult, createTime)) {
                                queryResult = ResultContant.createJSONObject(ErrorType.HANDLE_TIMEOUT);
                                this.saveAllFailRecorded(selectLog, billType, selectAccountMap, queryResult, updateAccountList);
                                return;
                            }
                            selectLog.set("description", (Object)queryResult.getString("description"));
                            selectLog.set("update_time", (Object)new Date());
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                            return;
                        }
                        if (queryResult == null) return;
                        this.saveAllFailRecorded(selectLog, billType, selectAccountMap, queryResult, updateAccountList);
                        return;
                    }
                    catch (Exception e) {
                        LOGGER.error("\u67e5\u8be2\u53d1\u7968\u5165\u8d26\u63d0\u4ea4\u7ed3\u679c,\u7ed3\u679c\u5931\u8d25:" + batchNo, (Throwable)e);
                        return;
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            for (int i = 0; i < successArray.size(); ++i) {
                String mapKey;
                DynamicObject updateAccount;
                success = successArray.getJSONObject(i);
                String invoiceCode = success.getString("invoiceCode");
                if (invoiceCode == null) {
                    invoiceCode = "";
                }
                if ((updateAccount = selectAccountMap.get(mapKey = this.getBillNo(invoiceCode.trim(), success.getString("invoiceNo"), billType, success.getDate("invoiceDate")))) == null && (updateAccount = this.getAccountByElectronicNo(selectAccountMap, success.getString("invoiceNo"))) == null) continue;
                deductionPurpose = updateAccount.getString("deduction_purpose");
                updateAccount.set("handle_status", (Object)"1");
                updateAccount.set("select_result", (Object)"1");
                updateAccount.set("description", (Object)success.getString("description"));
                updateAccount.set("update_time", (Object)new Date());
                updateAccountList.add(updateAccount);
                if (!StringUtils.isNotEmpty((CharSequence)updateAccount.getString("serial_no"))) continue;
                JSONObject example = new JSONObject();
                example.put("dktype", (Object)dktype);
                example.put("serial_no", (Object)updateAccount.getString("serial_no"));
                example.put("select_time", (Object)updateAccount.getDate("select_time"));
                example.put("tax_recorded_status", (Object)deductionPurpose);
                if (org.apache.commons.lang.StringUtils.isNotBlank((String)success.getString("lqTaxRecordedTime"))) {
                    example.put("lqTaxRecordedTime", (Object)success.getString("lqTaxRecordedTime"));
                }
                updateInvoiceList.add(example);
            }
            this.updateSuccessRecordedInfo(updateInvoiceList);
        }
        Map<String, String> failRecordedAccount = null;
        if (!CollectionUtils.isEmpty((Collection)failArray)) {
            LOGGER.info("\u4e50\u4f01-\u7a0e\u5c40\u5165\u8d26\uff0c\u5b58\u5728\u5931\u8d25\u6570\u636e\uff0csize: {}", (Object)failArray.size());
            failRecordedAccount = this.getFailRecordedAccount(failArray, selectAccountMap, updateAccountList, "", billType);
        }
        selectLog.set("description", null);
        selectLog.set("update_time", (Object)new Date());
        selectLog.set("handle_status", (Object)(!CollectionUtils.isEmpty((Collection)successArray) ? "1" : "2"));
        LOGGER.info("handle_status {}", (Object)selectLog.getString("handle_status"));
        this.saveAccountRecorded(failRecordedAccount, selectLog, updateAccountList);
    }

    private void saveAllFailRecorded(DynamicObject selectLog, String billType, Map<String, DynamicObject> selectAccountMap, JSONObject queryResult, List<DynamicObject> updateAccountList) {
        Map<String, String> failRecordedAccount = this.getFailRecordedAccount(null, selectAccountMap, updateAccountList, queryResult.getString("description"), billType);
        selectLog.set("success_num", (Object)0);
        selectLog.set("fail_num", (Object)selectAccountMap.size());
        selectLog.set("description", (Object)queryResult.getString("description"));
        selectLog.set("handle_status", (Object)"2");
        selectLog.set("update_time", (Object)new Date());
        this.saveAccountRecorded(failRecordedAccount, selectLog, updateAccountList);
    }

    public Map<String, String> getStatusMap(JSONArray failArray, Map<String, DynamicObject> selectAccountMap, List<DynamicObject> updateAccountList, String description, String billType) {
        HashMap serialNoStatusMap;
        block3: {
            block2: {
                serialNoStatusMap = Maps.newHashMap();
                if (CollectionUtils.isEmpty((Collection)failArray)) break block2;
                for (int i = 0; i < failArray.size(); ++i) {
                    JSONObject fail = failArray.getJSONObject(i);
                    String mapKey = this.getBillNo(fail.getString("invoiceCode"), fail.getString("invoiceNo"), billType, fail.getDate("invoiceDate"));
                    DynamicObject updateAccount = selectAccountMap.get(mapKey);
                    if (updateAccount == null && (updateAccount = this.getAccountByElectronicNo(selectAccountMap, fail.getString("invoiceNo"))) == null) continue;
                    updateAccount.set("handle_status", (Object)"1");
                    updateAccount.set("select_result", (Object)fail.getString("selectResult"));
                    updateAccount.set("description", (Object)this.getSelectMsg(fail));
                    updateAccount.set("update_time", (Object)new Date());
                    updateAccountList.add(updateAccount);
                    this.setFailInvoiceStatus(serialNoStatusMap, updateAccount);
                }
                break block3;
            }
            if (!updateAccountList.isEmpty()) break block3;
            for (Map.Entry<String, DynamicObject> entry : selectAccountMap.entrySet()) {
                DynamicObject failAccount = entry.getValue();
                failAccount.set("handle_status", (Object)"1");
                failAccount.set("select_result", (Object)"31");
                failAccount.set("description", (Object)description);
                failAccount.set("update_time", (Object)new Date());
                updateAccountList.add(failAccount);
                this.setFailInvoiceStatus(serialNoStatusMap, failAccount);
            }
        }
        return serialNoStatusMap;
    }

    @Override
    protected JSONObject doSelect(Long orgId, JSONObject param) {
        if (TenantUtils.isSmallScaleTaxpayer(param.getString("taxNo"))) {
            return ResultContant.createJSONObject(ErrorType.SMALL_SCALE_TAXPAYER_DEDUCT);
        }
        LqDeductService deductService = new LqDeductService(orgId);
        return ((DeductService)deductService).gxInvoicesQuery(param);
    }
}

