/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.AsyncDeductHelper;
import kd.imc.rim.common.invoice.deduction.AsyncDeductSelectService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.invoice.deduction.impl.NewEtaxDeductService;
import kd.imc.rim.common.invoice.deduction.impl.NewHolytaxAsyncDeductSelectService;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.ListUtils;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.ViewUtil;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;

public class NewEtaxAsyncDeductSelectService
extends AsyncDeductSelectService {
    private static Log LOGGER = LogFactory.getLog(NewEtaxAsyncDeductSelectService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void querySelectResult(DynamicObject selectLog) {
        JSONArray failArray;
        ArrayList<DynamicObject> updateAccountList;
        Map<String, DynamicObject> selectAccountMap;
        String billType;
        block40: {
            String deductionPurpose;
            JSONObject example;
            JSONObject success;
            JSONArray updateSelectInvoiceArray;
            JSONArray successArray;
            String taxPeriodResult;
            String taxNo;
            String taxPeriod;
            block41: {
                String batchNo = selectLog.getString("batch_no");
                LOGGER.info("\u5f00\u59cb\u67e5\u8be2\u5f02\u6b65\u52fe\u9009\u7ed3\u679c-rpa:{}", (Object)batchNo);
                taxPeriod = "";
                if (selectLog.getDate("tax_period") != null) {
                    taxPeriod = DateUtils.format(selectLog.getDate("tax_period"), "yyyyMM");
                }
                Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(selectLog.get("org"));
                JSONObject param = new JSONObject();
                param.put("batchNo", (Object)batchNo);
                taxNo = selectLog.getString("tax_no");
                param.put("taxNo", (Object)taxNo);
                if (StringUtils.isNotBlank((CharSequence)taxNo) && StringUtils.isNotBlank((CharSequence)batchNo) && batchNo.startsWith(taxNo)) {
                    NewHolytaxAsyncDeductSelectService holytaxAsyncDeductSelectService = new NewHolytaxAsyncDeductSelectService();
                    holytaxAsyncDeductSelectService.querySelectResult(selectLog);
                    return;
                }
                billType = selectLog.getString("bill_type");
                param.put("billType", (Object)billType);
                String key = "rim.rpaasyncdeduct-" + batchNo;
                Set<String> etaxAsynErrcodes = DeductionUtils.getEtaxHeadAsynRetryErrcodes("etax_deduct_asyn_retrycode");
                try (DLock lock = DLock.create((String)key, (String)"rpaasyncdeduct.lock");){
                    if (!lock.tryLock()) return;
                    try {
                        selectLog.set("update_time", (Object)new Date());
                        selectAccountMap = this.getSelectAccount(batchNo, billType);
                        if (CollectionUtils.isEmpty(selectAccountMap)) {
                            LOGGER.info("\u6ca1\u6709\u67e5\u8be2\u5230\u52fe\u9009\u53f0\u8d26\u6570\u636e:{}-{}", (Object)taxNo, (Object)batchNo);
                            selectLog.set("handle_status", (Object)"2");
                            selectLog.set("description", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u52fe\u9009\u53f0\u8d26\u6570\u636e", (String)"LqAsyncDeductSelectService_0", (String)"imc-rim-common", (Object[])new Object[0]));
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                            return;
                        }
                        JSONObject queryResult = this.doSelect(orgId, param);
                        updateAccountList = new ArrayList<DynamicObject>(8);
                        if (queryResult != null && queryResult.get((Object)"data") != null) {
                            JSONObject data = queryResult.getJSONObject("data");
                            if (data == null) {
                                LOGGER.info("\u6ca1\u6709\u8fd4\u56dedata\u6570\u636e:{}-{}", (Object)taxNo, (Object)batchNo);
                                selectLog.set("description", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u8fd4\u56dedata\u6570\u636e", (String)"LqAsyncDeductSelectService_1", (String)"imc-rim-common", (Object[])new Object[0]));
                                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                                return;
                            }
                            taxPeriodResult = data.getString("taxPeriod");
                            successArray = data.getJSONArray("success");
                            failArray = data.getJSONArray("fail");
                            selectLog.set("success_num", (Object)(!CollectionUtils.isEmpty((Collection)successArray) ? successArray.size() : 0));
                            selectLog.set("fail_num", (Object)(!CollectionUtils.isEmpty((Collection)failArray) ? failArray.size() : 0));
                            if (CollectionUtils.isEmpty((Collection)successArray) && CollectionUtils.isEmpty((Collection)failArray)) {
                                this.dealDataSelectFail(selectLog, billType, selectAccountMap, queryResult, updateAccountList);
                                return;
                            }
                            selectLog.set("handle_status", (Object)"1");
                            updateSelectInvoiceArray = new JSONArray();
                            success = null;
                            example = null;
                            deductionPurpose = "";
                            if (CollectionUtils.isEmpty((Collection)successArray)) break block40;
                            break block41;
                        }
                        if (queryResult != null && etaxAsynErrcodes.contains(queryResult.getString("errcode"))) {
                            String description = this.subDescription(queryResult.getString("description"));
                            selectLog.set("description", (Object)description);
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                            return;
                        }
                        if (queryResult == null) return;
                        this.dealDataSelectFail(selectLog, billType, selectAccountMap, queryResult, updateAccountList);
                        return;
                    }
                    catch (Exception e) {
                        LOGGER.error("rpa\u5f02\u6b65\u67e5\u8be2\u52fe\u9009\u7ed3\u679c\u5931\u8d25:" + batchNo, (Throwable)e);
                        return;
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            for (int i = 0; i < successArray.size(); ++i) {
                BigDecimal effectiveTaxAmount;
                String mapKey;
                DynamicObject updateAccount;
                success = successArray.getJSONObject(i);
                String invoiceCode = success.getString("invoiceCode");
                if (invoiceCode == null) {
                    invoiceCode = "";
                }
                if ((updateAccount = selectAccountMap.get(mapKey = this.getBillNo(invoiceCode.trim(), success.getString("invoiceNo"), billType, success.getDate("invoiceDate")))) == null && (updateAccount = this.getAccountByElectronicNo(selectAccountMap, success.getString("invoiceNo"))) == null) continue;
                deductionPurpose = updateAccount.getString("deduction_purpose");
                Pair<String, String> deductionPurposeMap = DeductionConstant.getDeductionPurpose(deductionPurpose);
                updateAccount.set("handle_status", (Object)"1");
                updateAccount.set("select_result", (Object)success.getString("selectResult"));
                updateAccount.set("description", (Object)this.getSelectMsg(success));
                updateAccount.set("update_time", (Object)new Date());
                if (StringUtils.isNotBlank((CharSequence)success.getString("taxPeriod"))) {
                    updateAccount.set("tax_period", (Object)DateUtils.stringToDate(success.getString("taxPeriod"), "yyyyMM"));
                }
                updateAccount.set("select_time", (Object)success.getDate("selectDate"));
                updateAccountList.add(updateAccount);
                if (!StringUtils.isNotEmpty((CharSequence)updateAccount.getString("serial_no"))) continue;
                example = new JSONObject();
                example.put("serial_no", (Object)updateAccount.getString("serial_no"));
                example.put("invoice_type", (Object)DynamicObjectUtil.getDynamicObjectLongValue(updateAccount.get("invoice_type")));
                if (StringUtils.isNotEmpty((CharSequence)success.getString("deductionPurpose"))) {
                    example.put("deduction_purpose", (Object)success.getString("deductionPurpose"));
                } else {
                    example.put("deduction_purpose", deductionPurposeMap.getRight());
                }
                if (("1".equals(billType) || "2".equals(billType)) && (effectiveTaxAmount = updateAccount.getBigDecimal("total_tax_amount")) != null && effectiveTaxAmount.compareTo(BigDecimal.ZERO) > 0) {
                    example.put("effective_tax_amount", (Object)effectiveTaxAmount);
                }
                if (StringUtils.isNotBlank((CharSequence)success.getString("taxPeriod"))) {
                    example.put("tax_period", (Object)success.getString("taxPeriod"));
                } else {
                    example.put("tax_period", (Object)(StringUtils.isNotBlank((CharSequence)taxPeriodResult) ? taxPeriodResult : taxPeriod));
                }
                example.put("authenticate_flag", deductionPurposeMap.getLeft());
                example.put("select_time", (Object)success.getString("selectDate"));
                example.put("operate_time", (Object)success.getString("operateTime"));
                example.put("cancel_select_type", (Object)updateAccount.getString("select_opera_type"));
                example.put("not_deductible_type", (Object)updateAccount.getString("not_deductible_type"));
                this.setUpdateInvoiceData(example, updateAccount, success, deductionPurpose);
                updateSelectInvoiceArray.add((Object)example);
            }
            this.updateInvoiceData(taxNo, updateSelectInvoiceArray, deductionPurpose);
        }
        Map<String, String> serialNoStatusMap = this.getFailStatusMap(failArray, selectAccountMap, updateAccountList, "", billType);
        selectLog.set("description", null);
        this.updateMainSaveLog(serialNoStatusMap, selectLog, updateAccountList, selectLog.getString("select_opera_type"));
    }

    private void dealDataSelectFail(DynamicObject selectLog, String billType, Map<String, DynamicObject> selectAccountMap, JSONObject queryResult, List<DynamicObject> updateAccountList) {
        String description = this.subDescription(queryResult.getString("description"));
        Map<String, String> serialNoStatusMap = this.getFailStatusMap(null, selectAccountMap, updateAccountList, description, billType);
        selectLog.set("success_num", (Object)0);
        selectLog.set("fail_num", (Object)selectAccountMap.size());
        selectLog.set("description", (Object)description);
        selectLog.set("update_time", (Object)new Date());
        selectLog.set("handle_status", (Object)"2");
        this.updateMainSaveLog(serialNoStatusMap, selectLog, updateAccountList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void queryRecordedCommitResult(DynamicObject selectLog) {
        JSONArray failArray;
        JSONArray successArray;
        ArrayList<JSONObject> updateInvoiceList;
        ArrayList<DynamicObject> updateAccountList;
        Map<String, DynamicObject> selectAccountMap;
        String dktype;
        String billType;
        block35: {
            String deductionPurpose;
            JSONObject success;
            block36: {
                Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(selectLog.get("org"));
                String batchNo = selectLog.getString("batch_no");
                String taxNo = selectLog.getString("tax_no");
                billType = selectLog.getString("bill_type");
                String operateType = selectLog.getString("operate_type");
                String key = "rim.etax-recorded-commit-" + batchNo;
                dktype = DeductionConstant.getDkType(taxNo);
                DeductService deductService = DeductServiceFactory.newInstanceForRecordedHandle(dktype);
                if (deductService == null) {
                    LOGGER.info("\u8be5\u7ec4\u7ec7\u7684\u6536\u7968\u901a\u9053\u4e0d\u652f\u6301\u5165\u8d26\u63d0\u4ea4\u7ed3\u679c\u67e5\u8be2, \u7a0e\u53f7\uff1a{}", (Object)taxNo);
                    return;
                }
                Set<String> etaxAsynErrcodes = DeductionUtils.getEtaxHeadAsynRetryErrcodes("etax_recorded_asyn_retrycode");
                try (DLock lock = DLock.create((String)key, (String)"queryRecordedCommitResult.lock");){
                    if (!lock.tryLock()) return;
                    try {
                        selectAccountMap = this.getSelectAccount(batchNo, billType);
                        if (CollectionUtils.isEmpty(selectAccountMap)) {
                            LOGGER.info("rpa-\u6ca1\u6709\u67e5\u8be2\u5230\u52fe\u9009\u53f0\u8d26\u6570\u636e:{}-{}", (Object)taxNo, (Object)batchNo);
                            selectLog.set("description", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u52fe\u9009\u53f0\u8d26\u6570\u636e", (String)"LqAsyncDeductSelectService_0", (String)"imc-rim-common", (Object[])new Object[0]));
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                            return;
                        }
                        JSONObject param = new JSONObject();
                        param.put("batchNo", (Object)batchNo);
                        param.put("taxNo", (Object)taxNo);
                        param.put("billType", (Object)billType);
                        param.put("operateType", (Object)operateType);
                        JSONObject queryResult = deductService.queryRecordedCommitResult(param);
                        updateAccountList = new ArrayList<DynamicObject>(8);
                        updateInvoiceList = new ArrayList<JSONObject>(8);
                        if (queryResult != null && ResultContant.isSuccess(queryResult).booleanValue()) {
                            JSONObject data = queryResult.getJSONObject("data");
                            if (data == null) {
                                LOGGER.info("rpa-\u6ca1\u6709\u8fd4\u56dedata\u6570\u636e:{}-{}", (Object)taxNo, (Object)batchNo);
                                selectLog.set("description", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u8fd4\u56dedata\u6570\u636e", (String)"LqAsyncDeductSelectService_1", (String)"imc-rim-common", (Object[])new Object[0]));
                                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                                return;
                            }
                            successArray = data.getJSONArray("success");
                            failArray = data.getJSONArray("fail");
                            selectLog.set("success_num", (Object)(!CollectionUtils.isEmpty((Collection)successArray) ? successArray.size() : 0));
                            selectLog.set("fail_num", !CollectionUtils.isEmpty((Collection)failArray) ? Integer.valueOf(failArray.size()) : "0");
                            if (CollectionUtils.isEmpty((Collection)successArray) && CollectionUtils.isEmpty((Collection)failArray)) {
                                this.dealDateRecordFail(selectLog, billType, selectAccountMap, queryResult, updateAccountList);
                                return;
                            }
                            JSONArray updateSelectInvoiceArray = new JSONArray();
                            success = null;
                            deductionPurpose = "";
                            if (CollectionUtils.isEmpty((Collection)successArray)) break block35;
                            LOGGER.info("rpa-\u7a0e\u5c40\u5165\u8d26\uff0c\u5b58\u5728\u6210\u529f\u6570\u636e\uff0csize: {}", (Object)successArray.size());
                            break block36;
                        }
                        if (queryResult != null && etaxAsynErrcodes.contains(queryResult.getString("errcode"))) {
                            String description = this.subDescription(queryResult.getString("description"));
                            selectLog.set("description", (Object)description);
                            selectLog.set("update_time", (Object)new Date());
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                            return;
                        }
                        if (queryResult == null) return;
                        this.dealDateRecordFail(selectLog, billType, selectAccountMap, queryResult, updateAccountList);
                        return;
                    }
                    catch (Exception e) {
                        LOGGER.error("\u67e5\u8be2\u53d1\u7968\u5165\u8d26\u63d0\u4ea4\u7ed3\u679c,\u7ed3\u679c\u5931\u8d25:" + batchNo, (Throwable)e);
                        return;
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            for (int i = 0; i < successArray.size(); ++i) {
                String mapKey;
                DynamicObject updateAccount;
                success = successArray.getJSONObject(i);
                String invoiceCode = success.getString("invoiceCode");
                if (invoiceCode == null) {
                    invoiceCode = "";
                }
                if ((updateAccount = selectAccountMap.get(mapKey = this.getBillNo(invoiceCode.trim(), success.getString("invoiceNo"), billType, success.getDate("invoiceDate")))) == null && (updateAccount = this.getAccountByElectronicNo(selectAccountMap, success.getString("invoiceNo"))) == null) continue;
                deductionPurpose = updateAccount.getString("deduction_purpose");
                updateAccount.set("handle_status", (Object)"1");
                updateAccount.set("select_result", (Object)"1");
                updateAccount.set("description", (Object)this.subDescription(success.getString("description")));
                updateAccount.set("update_time", (Object)new Date());
                updateAccountList.add(updateAccount);
                String mxuuid = success.getString("mxuuid");
                String rzuuid = success.getString("rzuuid");
                if (!StringUtils.isNotEmpty((CharSequence)updateAccount.getString("serial_no"))) continue;
                JSONObject example = new JSONObject();
                example.put("dktype", (Object)dktype);
                example.put("serial_no", (Object)updateAccount.getString("serial_no"));
                example.put("select_time", (Object)updateAccount.getDate("select_time"));
                example.put("tax_recorded_status", (Object)deductionPurpose);
                example.put("mxuuid", (Object)mxuuid);
                example.put("rzuuid", (Object)rzuuid);
                updateInvoiceList.add(example);
            }
        }
        Map<String, String> failRecordedAccount = null;
        if (!CollectionUtils.isEmpty((Collection)failArray)) {
            JSONArray newFailArr = this.dealFailData(failArray, selectAccountMap, updateAccountList, updateInvoiceList, billType, dktype);
            LOGGER.info("rpa-\u7a0e\u5c40\u5165\u8d26\uff0c\u5b58\u5728\u5931\u8d25\u6570\u636e\uff0csize: {}", (Object)newFailArr.size());
            if (!CollectionUtils.isEmpty((Collection)newFailArr)) {
                failRecordedAccount = this.getFailRecordedAccount(newFailArr, selectAccountMap, updateAccountList, "", billType);
            }
        }
        this.updateSuccessRecordedInfo(updateInvoiceList);
        selectLog.set("description", null);
        selectLog.set("update_time", (Object)new Date());
        selectLog.set("handle_status", (Object)(!CollectionUtils.isEmpty((Collection)successArray) ? "1" : "2"));
        LOGGER.info("handle_status {}", (Object)selectLog.getString("handle_status"));
        this.saveAccountRecorded(failRecordedAccount, selectLog, updateAccountList, selectLog.getString("select_opera_type"));
    }

    private JSONArray dealFailData(JSONArray failArray, Map<String, DynamicObject> selectAccountMap, List<DynamicObject> updateAccountList, List<JSONObject> updateInvoiceList, String billType, String dktype) {
        JSONArray newFailArr = new JSONArray();
        if (!CollectionUtils.isEmpty((Collection)failArray)) {
            LOGGER.info("rpa-\u7a0e\u5c40\u5165\u8d26\uff0c\u5b58\u5728\u7a0e\u5c40\u5df2\u5165\u8d26\u6570\u636e\uff0csize: {}", (Object)failArray.size());
            for (int i = 0; i < failArray.size(); ++i) {
                JSONObject fail = failArray.getJSONObject(i);
                if (fail == null) continue;
                String entryResult = fail.getString("entryResult");
                if (StringUtils.equals((CharSequence)"1", (CharSequence)entryResult) || StringUtils.equals((CharSequence)"32", (CharSequence)entryResult)) {
                    String mapKey;
                    DynamicObject updateAccount;
                    String invoiceCode = fail.getString("invoiceCode");
                    if (invoiceCode == null) {
                        invoiceCode = "";
                    }
                    if ((updateAccount = selectAccountMap.get(mapKey = this.getBillNo(invoiceCode.trim(), fail.getString("invoiceNo"), billType, fail.getDate("invoiceDate")))) == null && (updateAccount = this.getAccountByElectronicNo(selectAccountMap, fail.getString("invoiceNo"))) == null) continue;
                    updateAccount.set("handle_status", (Object)"1");
                    updateAccount.set("select_result", (Object)"44");
                    updateAccount.set("description", (Object)this.subDescription(fail.getString("description")));
                    updateAccount.set("update_time", (Object)new Date());
                    updateAccountList.add(updateAccount);
                    String mxuuid = fail.getString("mxuuid");
                    String rzuuid = fail.getString("rzuuid");
                    if (!StringUtils.isNotEmpty((CharSequence)updateAccount.getString("serial_no"))) continue;
                    JSONObject example = new JSONObject();
                    example.put("dktype", (Object)dktype);
                    example.put("serial_no", (Object)updateAccount.getString("serial_no"));
                    if (StringUtils.isNotBlank((CharSequence)fail.getString("entryMarkDate"))) {
                        try {
                            example.put("select_time", (Object)DateUtils.stringToDate(fail.getString("entryMarkDate"), "yyyy-MM-dd"));
                        }
                        catch (Exception e) {
                            LOGGER.info("\u65e5\u671f\u683c\u5f0f\u6709\u8bef\uff0c{}-{}", (Object)mapKey, (Object)fail.getString("entryMarkDate"));
                        }
                    }
                    example.put("tax_recorded_status", (Object)fail.getString("entryMarkStatus"));
                    example.put("mxuuid", (Object)mxuuid);
                    example.put("rzuuid", (Object)rzuuid);
                    updateInvoiceList.add(example);
                    continue;
                }
                newFailArr.add((Object)fail);
            }
        }
        return newFailArr;
    }

    private void dealDateRecordFail(DynamicObject selectLog, String billType, Map<String, DynamicObject> selectAccountMap, JSONObject queryResult, List<DynamicObject> updateAccountList) {
        String description = this.subDescription(queryResult.getString("description"));
        Map<String, String> failRecordedAccount = this.getFailRecordedAccount(null, selectAccountMap, updateAccountList, description, billType);
        selectLog.set("success_num", (Object)0);
        selectLog.set("fail_num", (Object)selectAccountMap.size());
        selectLog.set("description", (Object)description);
        selectLog.set("handle_status", (Object)"2");
        selectLog.set("update_time", (Object)new Date());
        this.saveAccountRecorded(failRecordedAccount, selectLog, updateAccountList);
    }

    private void getFailSelectAccount(JSONArray failArray, Map<String, DynamicObject> selectAccountMap, List<DynamicObject> updateAccountList, String description, String billType) {
        block3: {
            block2: {
                if (CollectionUtils.isEmpty((Collection)failArray)) break block2;
                for (int i = 0; i < failArray.size(); ++i) {
                    JSONObject fail = failArray.getJSONObject(i);
                    String mapKey = this.getBillNo(fail.getString("invoiceCode"), fail.getString("invoiceNo"), billType, fail.getDate("invoiceDate"));
                    DynamicObject updateAccount = selectAccountMap.get(mapKey);
                    if (updateAccount == null && (updateAccount = this.getAccountByElectronicNo(selectAccountMap, fail.getString("invoiceNo"))) == null) continue;
                    updateAccount.set("handle_status", (Object)"1");
                    updateAccount.set("description", (Object)this.subDescription(fail.getString("description")));
                    updateAccount.set("update_time", (Object)new Date());
                    updateAccountList.add(updateAccount);
                }
                break block3;
            }
            if (!updateAccountList.isEmpty()) break block3;
            for (Map.Entry<String, DynamicObject> entry : selectAccountMap.entrySet()) {
                DynamicObject failAccount = entry.getValue();
                failAccount.set("handle_status", (Object)"1");
                failAccount.set("description", (Object)this.subDescription(description));
                failAccount.set("update_time", (Object)new Date());
                updateAccountList.add(failAccount);
            }
        }
    }

    private void save(List<JSONObject> updateInvoiceList, DynamicObject selectLog, List<DynamicObject> updateAccountList) {
        try (TXHandle h = TX.required();){
            try {
                if (null != updateInvoiceList && updateInvoiceList.size() > 0) {
                    Map<String, JSONObject> serialNoMap = updateInvoiceList.stream().collect(Collectors.toMap(t -> t.getString("serial_no"), t -> t, (k1, k2) -> k1));
                    QFilter invoiceFilter = new QFilter("serial_no", "in", serialNoMap.keySet());
                    DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"rim_invoice", (String)MetadataUtil.getFields("rim_invoice"), (QFilter[])new QFilter[]{invoiceFilter});
                    HashMap invoiceDynamicObjectMap = new HashMap(8);
                    if (dynamicObjects != null && dynamicObjects.length > 0) {
                        for (DynamicObject dynamicObject : dynamicObjects) {
                            ArrayList<DynamicObject> dynamicObjects1;
                            QFilter serialNOFilter;
                            JSONObject jsonObject = serialNoMap.get(dynamicObject.getString("serial_no"));
                            String taxRecordedStatus = jsonObject.getString("tax_recorded_status");
                            dynamicObject.set("tax_recorded_status", (Object)taxRecordedStatus);
                            if ("06".equals(taxRecordedStatus)) {
                                dynamicObject.set("tax_recorded_purpose", (Object)"");
                                dynamicObject.set("tax_recorded_time", null);
                            }
                            Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(dynamicObject.get("invoice_type"));
                            String serialNo = dynamicObject.getString("serial_no");
                            String entityId = InputInvoiceTypeEnum.getEntity(invoiceType);
                            DynamicObject idObject = QueryServiceHelper.queryOne((String)entityId, (String)"id", (QFilter[])new QFilter[]{serialNOFilter = new QFilter("serial_no", "=", (Object)serialNo)});
                            if (idObject == null) {
                                LOGGER.info(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\uff1a%1$s\uff0c\u5bf9\u5e94\u7684\u4e1a\u52a1\u5b50\u8868\u4e0d\u5b58\u5728\u6570\u636e", (String)"TaxRecordedEditPlugin_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), dynamicObject.getString("invoice_no")));
                                continue;
                            }
                            DynamicObject invoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)entityId);
                            invoiceDynamicObject.set("tax_recorded_status", (Object)taxRecordedStatus);
                            if ("06".equals(taxRecordedStatus)) {
                                invoiceDynamicObject.set("tax_recorded_purpose", (Object)"");
                                invoiceDynamicObject.set("tax_recorded_time", null);
                            }
                            String recordedMxUuid = invoiceDynamicObject.getString("recorded_mxuuid");
                            String recordedRzUuid = invoiceDynamicObject.getString("recorded_rzuuid");
                            if (StringUtils.isBlank((CharSequence)recordedMxUuid) || StringUtils.isBlank((CharSequence)recordedRzUuid)) {
                                invoiceDynamicObject.set("recorded_mxuuid", (Object)jsonObject.getString("mxuuid"));
                                invoiceDynamicObject.set("recorded_rzuuid", (Object)jsonObject.getString("rzuuid"));
                            }
                            if (invoiceDynamicObjectMap.containsKey(invoiceType)) {
                                dynamicObjects1 = (ArrayList<DynamicObject>)invoiceDynamicObjectMap.get(invoiceType);
                                dynamicObjects1.add(invoiceDynamicObject);
                                continue;
                            }
                            dynamicObjects1 = new ArrayList<DynamicObject>(1);
                            dynamicObjects1.add(invoiceDynamicObject);
                            invoiceDynamicObjectMap.put(invoiceType, dynamicObjects1);
                        }
                        for (List dynamicObjectList : invoiceDynamicObjectMap.values()) {
                            SaveServiceHelper.save((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]));
                        }
                        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                SaveServiceHelper.save((DynamicObject[])updateAccountList.toArray(new DynamicObject[updateAccountList.size()]));
            }
            catch (Throwable e) {
                LOGGER.error("\u52fe\u9009\u65e5\u5fd7/\u53f0\u8d26\u5931\u8d25", e);
                h.markRollback();
                throw e;
            }
        }
    }

    @Override
    protected JSONObject doSelect(Long orgId, JSONObject param) {
        if (TenantUtils.isSmallScaleTaxpayer(param.getString("taxNo"))) {
            return ResultContant.createJSONObject(ErrorType.SMALL_SCALE_TAXPAYER_DEDUCT);
        }
        NewEtaxDeductService deductService = new NewEtaxDeductService(orgId);
        return ((DeductService)deductService).gxInvoicesQuery(param);
    }

    public void discardTask(Map<String, List<String>> param, AbstractFormPlugin plugin, String operateType, Map<String, String> failMap) {
        QFilter filter;
        DynamicObjectCollection initCollection;
        if (param == null) {
            LOGGER.info("\u4f5c\u5e9f\u4efb\u52a1-\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        NewEtaxDeductService deductService = new NewEtaxDeductService(0L);
        Collection<List<String>> values = param.values();
        HashMap<String, String> successBatchNoMap = new HashMap<String, String>(values.size());
        if (MapUtils.isEmpty(failMap)) {
            failMap = new HashMap<String, String>(values.size());
        }
        StringBuilder message = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : param.entrySet()) {
            String taxNo = entry.getKey();
            JSONObject requestParam = new JSONObject();
            requestParam.put("taxNo", (Object)taxNo);
            List<String> batchNoList = entry.getValue();
            if (batchNoList.size() > deductService.maxSizeRecorded) {
                List<List<String>> lists = ListUtils.splitList(batchNoList, deductService.maxSizeRecorded);
                for (List<String> list : lists) {
                    JSONObject paramSplit = new JSONObject();
                    paramSplit.put("taxNo", (Object)taxNo);
                    paramSplit.put("batchNos", list);
                    JSONObject result = deductService.discardTasks(paramSplit);
                    this.delaResult(successBatchNoMap, failMap, list, result);
                }
                continue;
            }
            requestParam.put("batchNos", batchNoList);
            JSONObject result = deductService.discardTasks(requestParam);
            this.delaResult(successBatchNoMap, failMap, batchNoList, result);
        }
        if (!MapUtils.isEmpty(successBatchNoMap)) {
            if ("1".equals(operateType)) {
                this.dealDataSelect(successBatchNoMap);
            }
            if ("2".equals(operateType)) {
                this.dealDataDown(successBatchNoMap);
            }
        }
        HashMap<String, String> newFailMap = new HashMap<String, String>(values.size());
        if ("2".equals(operateType) && MapUtils.isNotEmpty(failMap) && !CollectionUtils.isEmpty((Collection)(initCollection = QueryServiceHelper.query((String)"rim_down_log", (String)"id,taskno,batch_no", (QFilter[])new QFilter[]{filter = new QFilter("taskno", "in", failMap.keySet())})))) {
            Map<String, String> map = initCollection.stream().collect(Collectors.toMap(t -> t.getString("taskno"), t -> t.getString("batch_no"), (k1, k2) -> k1));
            for (Map.Entry<String, String> entry : failMap.entrySet()) {
                String taskNo = entry.getKey();
                if (!map.containsKey(taskNo)) continue;
                newFailMap.put(map.get(taskNo), entry.getValue());
            }
        }
        this.showTipMessage(successBatchNoMap.size(), MapUtils.isNotEmpty(newFailMap) ? newFailMap : failMap, plugin);
    }

    private void dealDataDown(Map<String, String> successBatchNoMap) {
        QFilter batchNoFilter = new QFilter("taskno", "in", successBatchNoMap.keySet());
        QFilter govStatusFilter = new QFilter("gov_status", "=", (Object)"6");
        DynamicObject[] downLogList = BusinessDataServiceHelper.load((String)"rim_down_log", (String)"gov_status, total_num, success_num, description, batch_no, taskno", (QFilter[])new QFilter[]{batchNoFilter, govStatusFilter});
        String description = ResManager.loadKDString((String)"\u4efb\u52a1\u4f5c\u5e9f\u6210\u529f", (String)"NewEtaxAsyncDeductSelectService_1", (String)"imc-rim-common", (Object[])new Object[0]);
        Date now = new Date();
        for (DynamicObject dynamicObject : downLogList) {
            dynamicObject.set("gov_status", (Object)"5");
            String taskno = dynamicObject.getString("taskno");
            String descriptionReturn = successBatchNoMap.get(taskno);
            if (StringUtils.isNotBlank((CharSequence)descriptionReturn)) {
                description = descriptionReturn;
            }
            dynamicObject.set("description", (Object)description);
            dynamicObject.set("total_num", (Object)0);
            dynamicObject.set("success_num", (Object)0);
        }
        SaveServiceHelper.save((DynamicObject[])downLogList);
    }

    private void dealDataSelect(Map<String, String> successBatchNoMap) {
        if (MapUtils.isEmpty(successBatchNoMap)) {
            return;
        }
        QFilter batchNoFilter = new QFilter("batch_no", "in", successBatchNoMap.keySet());
        Object[] logsArr = AsyncDeductSelectService.getSelectLogObjects(new QFilter[]{batchNoFilter});
        if (!ObjectUtils.isEmpty((Object[])logsArr)) {
            long start = System.currentTimeMillis();
            Map<String, List<DynamicObject>> map = Arrays.stream(logsArr).collect(Collectors.groupingBy(t -> t.getString("select_type")));
            for (Map.Entry<String, List<DynamicObject>> enty : map.entrySet()) {
                String key = enty.getKey();
                List<DynamicObject> logs = enty.getValue();
                AsyncDeductHelper.abandonTask(logs, key, successBatchNoMap);
            }
            LOGGER.info("\u5e9f\u5f03\u4efb\u52a1--\u6570\u636e\u5e93\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        }
    }

    private void showTipMessage(int successSize, Map<String, String> failMap, AbstractFormPlugin plugin) {
        if (MapUtils.isEmpty(failMap)) {
            plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u4f5c\u5e9f\u6210\u529f", (String)"SelectLogListPlugin_22", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            plugin.getView().invokeOperation("refresh");
        } else {
            int failSize = failMap.size();
            int totalSize = successSize + failSize;
            StringBuilder message = new StringBuilder();
            for (Map.Entry<String, String> entry : failMap.entrySet()) {
                String batchNo = entry.getKey();
                String description = entry.getValue();
                String tip = String.format(ResManager.loadKDString((String)"\u6279\u6b21\u53f7\uff1a%1$s\uff0c\u5931\u8d25\u539f\u56e0\uff1a%2$s", (String)"SelectLogListPlugin_20", (String)"imc-rim-formplugin", (Object[])new Object[0]), batchNo, description);
                message.append(tip);
                message.append(ViewUtil.LINE_SEPARATOR);
            }
            String allFail = ResManager.loadKDString((String)"\u4efb\u52a1\u4f5c\u5e9f\u5931\u8d25\uff0c", (String)"SelectLogListPlugin_21", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            String partSuccess = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u4f5c\u5e9f\u90e8\u5206\u6210\u529f\uff0c", (String)"SelectLogListPlugin_25", (String)"imc-rim-formplugin", (Object[])new Object[0]), new Object[0]);
            boolean partSuccessFlag = successSize > 0;
            String title = partSuccessFlag ? partSuccess : allFail;
            ViewUtil.showMessage(plugin, title, message.toString(), successSize, failSize);
            if (partSuccessFlag) {
                plugin.getView().invokeOperation("refresh");
            }
        }
    }

    private void delaResult(Map<String, String> successBatchNoMap, Map<String, String> failMap, List<String> list, JSONObject result) {
        String description = result.getString("description");
        if (ResultContant.isSuccess(result).booleanValue()) {
            JSONArray data = result.getJSONArray("data");
            for (int i = 0; i < data.size(); ++i) {
                JSONObject jsonObject = data.getJSONObject(i);
                String batchNo = jsonObject.getString("batchNo");
                String descriptionNew = jsonObject.getString("description");
                String status = jsonObject.getString("status");
                if ("02".equals(status) || "04".equals(status) || "05".equals(status)) {
                    if (!StringUtils.isNotBlank((CharSequence)batchNo)) continue;
                    successBatchNoMap.put(batchNo, this.subDescription(descriptionNew));
                    continue;
                }
                failMap.put(batchNo, this.convert(status));
            }
        } else {
            for (String batchNo : list) {
                failMap.put(batchNo, this.subDescription(description));
            }
        }
    }

    private String convert(String status) {
        if (StringUtils.isBlank((CharSequence)status)) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u652f\u6301\u5e9f\u5f03\u64cd\u4f5c", (String)"SelectLogListPlugin_18", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        if ("00".equals(status)) {
            return ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u7ecf\u5904\u7406\u5b8c\u6210\uff0c\u4e0d\u80fd\u5e9f\u5f03", (String)"SelectLogListPlugin_13", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        if ("01".equals(status)) {
            return ResManager.loadKDString((String)"\u4efb\u52a1\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u4e0d\u80fd\u5e9f\u5f03", (String)"SelectLogListPlugin_14", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u652f\u6301\u5e9f\u5f03\u64cd\u4f5c", (String)"SelectLogListPlugin_18", (String)"imc-rim-formplugin", (Object[])new Object[0]);
    }

    public void handleRecordedAbandon(List<DynamicObject> logs, Map<String, String> successBatchNoMap) {
        String description = ResManager.loadKDString((String)"\u4efb\u52a1\u4f5c\u5e9f\u6210\u529f", (String)"NewEtaxAsyncDeductSelectService_1", (String)"imc-rim-common", (Object[])new Object[0]);
        for (DynamicObject selectLog : logs) {
            String billType = selectLog.getString("bill_type");
            String batchNo = selectLog.getString("batch_no");
            Map<String, DynamicObject> selectAccountMap = this.getSelectAccount(batchNo, billType);
            ArrayList<DynamicObject> updateAccountList = new ArrayList<DynamicObject>(8);
            String descriptionReturn = successBatchNoMap.get(batchNo);
            if (StringUtils.isNotBlank((CharSequence)descriptionReturn)) {
                description = descriptionReturn;
            }
            Map<String, String> failRecordedAccount = this.getRecordAccountDiscardTask(selectAccountMap, updateAccountList, description);
            selectLog.set("success_num", (Object)0);
            selectLog.set("fail_num", (Object)selectAccountMap.size());
            selectLog.set("description", (Object)description);
            selectLog.set("handle_status", (Object)"2");
            selectLog.set("update_time", (Object)new Date());
            this.saveAccountRecorded(failRecordedAccount, selectLog, updateAccountList);
        }
    }

    public void handleSelectAgricAbandon(List<DynamicObject> logs, Map<String, String> successBatchNoMap) {
        String description = ResManager.loadKDString((String)"\u4efb\u52a1\u4f5c\u5e9f\u6210\u529f", (String)"NewEtaxAsyncDeductSelectService_1", (String)"imc-rim-common", (Object[])new Object[0]);
        for (DynamicObject selectLog : logs) {
            String billType = selectLog.getString("bill_type");
            String batchNo = selectLog.getString("batch_no");
            ArrayList<DynamicObject> updateAccountList = new ArrayList<DynamicObject>(8);
            Map<String, DynamicObject> selectAccountMap = this.getSelectAccount(batchNo, billType);
            String descriptionReturn = successBatchNoMap.get(batchNo);
            if (StringUtils.isNotBlank((CharSequence)descriptionReturn)) {
                description = descriptionReturn;
            }
            Map<String, String> serialNoStatusMap = this.getSelectAccountDiscardTask(selectAccountMap, updateAccountList, description);
            selectLog.set("success_num", (Object)0);
            selectLog.set("fail_num", (Object)selectAccountMap.size());
            selectLog.set("description", (Object)description);
            selectLog.set("handle_status", (Object)"2");
            this.updateMainSaveLog(serialNoStatusMap, selectLog, updateAccountList);
        }
    }
}

