/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.invoice.deduction.DeductSelectService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.impl.NewEtaxAsyncDeductSelectService;
import kd.imc.rim.common.invoice.deduction.impl.NewEtaxDeductService;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.ViewUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class NewEtaxDeductSelectService
extends DeductSelectService {
    private static Log LOGGER = LogFactory.getLog(NewEtaxDeductSelectService.class);
    private static final int DEFAULT_SIZE = 500;
    private static Set<String> INVOICE_FILEDS = Sets.newHashSet((Object[])new String[]{"invoiceType", "invoiceDate", "invoiceAmount", "effectiveTaxAmount", "totalTaxAmount"});
    private static Set<String> CUSTOM_FILEDS = Sets.newHashSet((Object[])new String[]{"customDeclarationNo", "invoiceDate", "effectiveTaxAmount", "totalTaxAmount"});
    private static Set<String> WITHHOLDING_FILEDS = Sets.newHashSet((Object[])new String[]{"voucherNo", "invoiceDate", "invoiceAmount", "effectiveTaxAmount", "totalTaxAmount", "withholdingAgentIDNum", "buyerTaxNo"});
    private static Set<String> NOT_DEDUCTIBLE_TYPE = Sets.newHashSet((Object[])new String[]{"1", "2", "3", "4", "5"});

    public NewEtaxDeductSelectService() {
        int size = InvoiceDownloadConstant.getPageSizeFromConfig(500, "newtax_select_size");
        if (size <= 0) {
            size = 500;
        }
        this.selectSize = size;
    }

    @Override
    public DeductService getDeductServiceImpl(Long orgId) {
        return new NewEtaxDeductService(orgId);
    }

    @Override
    public Map<String, Object> selectedResult(DeductService service, JSONObject paramJson) {
        JSONObject jsonObject;
        int i;
        String taxNo = paramJson.getString("taxNo");
        String rpaSelectSyn = paramJson.getString("rpa_select_syn");
        if (StringUtils.isBlank((CharSequence)rpaSelectSyn)) {
            rpaSelectSyn = NewEtaxDeductSelectService.isSyncDown(taxNo) ? "1" : "0";
            paramJson.put("rpa_select_syn", (Object)rpaSelectSyn);
        }
        LOGGER.info("rpa\u540c\u6b65\u5f02\u6b65\u52fe\u9009\u6807\u8bc6--rpa_select_syn\uff0c {}", (Object)rpaSelectSyn);
        if ("1".equals(rpaSelectSyn)) {
            return super.selectedResult(service, paramJson);
        }
        HashMap<String, Object> result = new HashMap<String, Object>(1);
        int successNum = 0;
        int failNum = 0;
        StringBuilder message = new StringBuilder();
        result.put("successNum", successNum);
        result.put("failNum", failNum);
        result.put("sync", "0");
        String billType = paramJson.getString("billType");
        if (StringUtils.isBlank((Object)paramJson)) {
            failNum = !CollectionUtils.isEmpty((Collection)paramJson.getJSONArray("invoices")) ? paramJson.getJSONArray("invoices").size() : 0;
            message.append(ErrorType.PARAM_NULL.getName()).append(ViewUtil.LINE_SEPARATOR);
            result.put("errcode", ErrorType.PARAM_NULL.getCode());
            result.put("message", message.toString());
            return result;
        }
        JSONArray invoices = paramJson.getJSONArray("invoices");
        if (CollectionUtils.isEmpty((Collection)invoices)) {
            message.append(ErrorType.PARAM_ERROR.getName()).append(ViewUtil.LINE_SEPARATOR);
            result.put("errcode", ErrorType.PARAM_ERROR.getCode());
            result.put("message", message.toString());
            return result;
        }
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            failNum = !CollectionUtils.isEmpty((Collection)paramJson.getJSONArray("invoices")) ? paramJson.getJSONArray("invoices").size() : 0;
            message.append(ErrorType.TAX_NO_NULL.getName()).append(ViewUtil.LINE_SEPARATOR);
            result.put("errcode", ErrorType.TAX_NO_NULL.getCode());
            result.put("message", message.toString());
            result.put("failNum", failNum);
            return result;
        }
        String deductibleMode = paramJson.getString("deductibleMode");
        ArrayList<JSONObject> invoiceOriginList = new ArrayList<JSONObject>(1);
        if ("1".equals(billType)) {
            for (i = 0; i < invoices.size(); ++i) {
                jsonObject = invoices.getJSONObject(i);
                String customDeclarationNo = jsonObject.getString("customDeclarationNo");
                if (NewEtaxDeductSelectService.checkHaveNullRpa(CUSTOM_FILEDS, jsonObject)) {
                    message.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968%1$s \u52fe\u9009\u6240\u9700\u5b57\u6bb5\u4e0d\u5b8c\u6574\uff0c\u8bf7\u524d\u5f80\u201c\u53d1\u7968\u5f52\u96c6\u7ba1\u7406-\u8fdb\u9879\u53d1\u7968\u5173\u952e\u8981\u7d20\u540c\u6b65\u201d\u624b\u5de5\u4e0b\u8f7d\u540e\u91cd\u8bd5\u3002", (String)"NewEtaxDeductSelectService_1", (String)"imc-rim-common", (Object[])new Object[0]), customDeclarationNo)).append(ViewUtil.LINE_SEPARATOR);
                    ++failNum;
                    continue;
                }
                if (!this.checkNotDeductReason(deductibleMode, jsonObject, message, failNum, customDeclarationNo)) continue;
                invoiceOriginList.add(jsonObject);
            }
        } else if ("2".equals(billType)) {
            for (i = 0; i < invoices.size(); ++i) {
                jsonObject = invoices.getJSONObject(i);
                String voucherNo = jsonObject.getString("voucherNo");
                Pair<String, String> deductionPurposePair = DeductionConstant.getDeductionPurpose(deductibleMode);
                String deductionPurpose = (String)deductionPurposePair.getRight();
                if ("3".equals(deductionPurpose)) {
                    message.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968%1$s \u4ee3\u6263\u4ee3\u7f34\u5b8c\u7a0e\u51ed\u8bc1\u4e0d\u652f\u6301\u9000\u7a0e\u52fe\u9009", (String)"NewEtaxDeductSelectService_5", (String)"imc-rim-common", (Object[])new Object[0]), voucherNo)).append(ViewUtil.LINE_SEPARATOR);
                    ++failNum;
                    continue;
                }
                if (NewEtaxDeductSelectService.checkHaveNullRpa(WITHHOLDING_FILEDS, jsonObject)) {
                    message.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968%1$s \u52fe\u9009\u6240\u9700\u5b57\u6bb5\u4e0d\u5b8c\u6574\uff0c\u8bf7\u524d\u5f80\u201c\u53d1\u7968\u5f52\u96c6\u7ba1\u7406-\u8fdb\u9879\u53d1\u7968\u5173\u952e\u8981\u7d20\u540c\u6b65\u201d\u624b\u5de5\u4e0b\u8f7d\u540e\u91cd\u8bd5\u3002", (String)"NewEtaxDeductSelectService_1", (String)"imc-rim-common", (Object[])new Object[0]), voucherNo)).append(ViewUtil.LINE_SEPARATOR);
                    ++failNum;
                    continue;
                }
                if (!this.checkNotDeductReason(deductibleMode, jsonObject, message, failNum, voucherNo)) continue;
                invoiceOriginList.add(jsonObject);
            }
        } else {
            for (i = 0; i < invoices.size(); ++i) {
                jsonObject = invoices.getJSONObject(i);
                String invoiceCode = jsonObject.getString("invoiceCode");
                String invoiceNo = jsonObject.getString("invoiceNo");
                if (NewEtaxDeductSelectService.checkHaveNullRpa(INVOICE_FILEDS, jsonObject)) {
                    message.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968%1$s \u52fe\u9009\u6240\u9700\u5b57\u6bb5\u4e0d\u5b8c\u6574\uff0c\u8bf7\u524d\u5f80\u201c\u53d1\u7968\u5f52\u96c6\u7ba1\u7406-\u8fdb\u9879\u53d1\u7968\u5173\u952e\u8981\u7d20\u540c\u6b65\u201d\u624b\u5de5\u4e0b\u8f7d\u540e\u91cd\u8bd5\u3002", (String)"NewEtaxDeductSelectService_1", (String)"imc-rim-common", (Object[])new Object[0]), CommonUtils.getInvoiceCodeNoGroup(invoiceCode, invoiceNo))).append(ViewUtil.LINE_SEPARATOR);
                    ++failNum;
                    continue;
                }
                if (!this.checkNotDeductReason(deductibleMode, jsonObject, message, failNum, CommonUtils.getInvoiceCodeNoGroup(invoiceCode, invoiceNo))) continue;
                invoiceOriginList.add(jsonObject);
            }
        }
        if (CollectionUtils.isEmpty(invoiceOriginList)) {
            result.put("errcode", ErrorType.PARAM_ERROR.getCode());
            result.put("message", message.toString());
            result.put("failNum", failNum);
            return result;
        }
        paramJson.put("invoices", invoiceOriginList);
        paramJson.put("asyncFlag", (Object)"1");
        JSONObject gxInvoicesRtn = service.gxInvoicesAsyn(paramJson);
        if (ErrorType.SUCCESS.getCode().equals(gxInvoicesRtn.get((Object)"errcode"))) {
            HashMap<String, String> serialNoStatusMap = new HashMap<String, String>(8);
            for (int i2 = 0; i2 < invoiceOriginList.size(); ++i2) {
                serialNoStatusMap.put(((JSONObject)invoiceOriginList.get(i2)).getString("serialNo"), "5");
            }
            JSONObject data = gxInvoicesRtn.getJSONObject("data");
            result.put("batchNo", data.getString("batchNo"));
            successNum = invoiceOriginList.size();
            CommonUtils.copyData(paramJson, gxInvoicesRtn, "account");
            this.insertSelectAccount(paramJson, ErrorType.STATUS_HANDLING.getCode(), data.getString("batchNo"), "2", "3");
            this.updateInvoiceSelecting(serialNoStatusMap);
        } else {
            failNum = invoiceOriginList.size();
            this.setFailMessage(paramJson, String.format(ResManager.loadKDString((String)"\u52fe\u9009\u5931\u8d25:%s", (String)"LqDeductSelectService_0", (String)"imc-rim-common", (Object[])new Object[0]), gxInvoicesRtn.getString("description")), message);
        }
        result.put("errcode", gxInvoicesRtn.getString("errcode"));
        result.put("message", message.toString());
        result.put("failNum", failNum);
        result.put("successNum", successNum);
        return result;
    }

    @Override
    public void queryAsyncSelectResult(List<String> batchNoList) {
        if (!CollectionUtils.isEmpty(batchNoList)) {
            NewEtaxAsyncDeductSelectService asyncDeductSelectService = new NewEtaxAsyncDeductSelectService();
            asyncDeductSelectService.queryAsyncSelectResultByBatchNo(batchNoList);
        }
    }

    private boolean checkNotDeductReason(String deductibleMode, JSONObject jsonObject, StringBuilder message, int failNum, String invoiceNo) {
        if ("4".equals(deductibleMode) || "-4".equals(deductibleMode)) {
            String notDeductibleType = jsonObject.getString("notDeductibleType");
            if (StringUtils.isBlank((CharSequence)notDeductibleType)) {
                message.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968%1$s \u4e0d\u62b5\u6263\u52fe\u9009\uff0c\u4e0d\u62b5\u6263\u539f\u56e0\u4e0d\u53ef\u4e3a\u7a7a", (String)"NewEtaxDeductSelectService_2", (String)"imc-rim-common", (Object[])new Object[0]), invoiceNo)).append(ViewUtil.LINE_SEPARATOR);
                ++failNum;
                return false;
            }
            if (!NOT_DEDUCTIBLE_TYPE.contains(notDeductibleType)) {
                message.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968%1$s \u4e0d\u62b5\u6263\u52fe\u9009\uff0c\u4e0d\u62b5\u6263\u539f\u56e0\u5b57\u6bb5\u7684\u503c\u4e0d\u6b63\u786e", (String)"NewEtaxDeductSelectService_3", (String)"imc-rim-common", (Object[])new Object[0]), invoiceNo)).append(ViewUtil.LINE_SEPARATOR);
                ++failNum;
                return false;
            }
        }
        return true;
    }

    private static boolean checkHaveNullRpa(Set<String> fields, JSONObject data) {
        for (String field : fields) {
            Object value = data.get((Object)field);
            if (Objects.isNull(value)) {
                return true;
            }
            if (!(value instanceof String) || !org.apache.commons.lang.StringUtils.isBlank((String)((String)value))) continue;
            return true;
        }
        return false;
    }
}

