/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.ReadyDeductSelectSerive;
import kd.imc.rim.common.invoice.recognition.RecognitionCheckParentTask;
import kd.imc.rim.common.service.RecognitionCheckService;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DateUtils;

public class RecognitionReadySelectTask
implements Callable<JSONObject> {
    private static Log logger = LogFactory.getLog(RecognitionReadySelectTask.class);
    private RequestContext rc;
    private String url;
    private String name;
    private String pageId;
    private Long orgId;
    private Long taxOrgId;
    private Date taxPeriod;
    public static final String waiting = "waiting";
    public static final String success = "success";
    public static final String fail = "fail";

    public RecognitionReadySelectTask(RequestContext requestContext, String url, String name, String pageId, Long orgId, Long taxOrgId, Date taxPeriod) {
        RecognitionCheckParentTask.saveCacheFile(pageId, url, waiting);
        this.rc = requestContext;
        this.url = url;
        this.name = name;
        this.pageId = pageId;
        this.orgId = orgId;
        this.taxOrgId = taxOrgId;
        this.taxPeriod = taxPeriod;
    }

    @Override
    public JSONObject call() {
        RequestContext.copyAndSet((RequestContext)this.rc);
        if (StringUtils.isEmpty((CharSequence)this.url)) {
            return null;
        }
        JSONArray resultArray = new JSONArray();
        JSONObject result = new JSONObject();
        JSONObject businessParam = new JSONObject();
        businessParam.put("resource", (Object)ResManager.loadKDString((String)"\u626b\u63cf\u4eea\u9884\u52fe\u9009", (String)"RecognitionReadySelectTask_0", (String)"imc-rim-common", (Object[])new Object[0]));
        businessParam.put("org_id", (Object)this.orgId);
        businessParam.put("tax_org", (Object)this.taxOrgId);
        ReadyDeductSelectSerive readyDeductSelectSerive = new ReadyDeductSelectSerive();
        JSONObject invoiceResult = RecognitionCheckService.getInstance().recognitionCheckInvoice(this.url, this.name, null, businessParam);
        logger.info("\u626b\u63cf\u4eea\u9884\u52fe\u9009\u8bc6\u522b\u7684\u53d1\u7968\u4fe1\u606f\uff1a " + invoiceResult);
        if (ResultContant.isSuccess(invoiceResult).booleanValue()) {
            JSONArray invoiceArray = invoiceResult.getJSONArray("data");
            if (invoiceArray != null) {
                CacheHelper.put(this.pageId + "refresh", "1", 90);
                try {
                    for (int i = 0; i < invoiceArray.size(); ++i) {
                        JSONObject invoice = invoiceArray.getJSONObject(i);
                        if (!StringUtils.isEmpty((CharSequence)invoice.getString("errcode")) && !"0000".equals(invoice.getString("errcode"))) {
                            result.put("errcode", (Object)"0011");
                            result.put("desc", (Object)invoice.getString("description"));
                            result.put("org_id", (Object)this.orgId);
                            result.put("taxorg_id", (Object)this.taxOrgId);
                            result.put("tax_period", (Object)DateUtils.format(this.taxPeriod, "yyyy-MM"));
                            result.put("invoice_info", (Object)invoice);
                            resultArray.add((Object)result);
                            continue;
                        }
                        result = readyDeductSelectSerive.selectInvoiceArray(invoice, this.orgId, this.taxOrgId, this.taxPeriod);
                        result.put("org_id", (Object)this.orgId);
                        result.put("taxorg_id", (Object)this.taxOrgId);
                        result.put("tax_period", (Object)DateUtils.format(this.taxPeriod, "yyyy-MM"));
                        result.put("invoice_info", (Object)invoice);
                        resultArray.add((Object)result);
                    }
                    RecognitionCheckParentTask.saveCacheFileResult(this.url, resultArray);
                    logger.info("\u626b\u63cf\u4eea\u9884\u52fe\u9009\u7f13\u5b58\u4fe1\u606f_pageId:" + this.pageId + " url:" + this.url);
                    RecognitionCheckParentTask.saveCacheFile(this.pageId, this.url, success);
                }
                catch (Exception e) {
                    logger.error("\u626b\u63cf\u4eea\u9884\u52fe\u9009\u5f02\u5e38\uff1a" + this.pageId, (Throwable)e);
                    JSONObject errorResult = new JSONObject();
                    errorResult.put("errcode", (Object)"0010");
                    errorResult.put("desc", (Object)ResManager.loadKDString((String)"\u7a0b\u5e8f\u5f02\u5e38", (String)"RecognitionReadySelectTask_1", (String)"imc-rim-common", (Object[])new Object[0]));
                    errorResult.put("org_id", (Object)this.orgId);
                    errorResult.put("taxorg_id", (Object)this.taxOrgId);
                    errorResult.put("tax_period", (Object)DateUtils.format(this.taxPeriod, "yyyy-MM"));
                    resultArray.add((Object)errorResult);
                    RecognitionCheckParentTask.saveCacheFileResult(this.url, resultArray);
                    RecognitionCheckParentTask.saveCacheFile(this.pageId, this.url, fail);
                }
            } else {
                JSONObject errorResult = new JSONObject();
                errorResult.put("errcode", (Object)"0010");
                errorResult.put("desc", (Object)ResManager.loadKDString((String)"\u8be5\u53d1\u7968\u8bc6\u522b\u5931\u8d25", (String)"RecognitionReadySelectTask_2", (String)"imc-rim-common", (Object[])new Object[0]));
                errorResult.put("org_id", (Object)this.orgId);
                errorResult.put("taxorg_id", (Object)this.taxOrgId);
                errorResult.put("tax_period", (Object)DateUtils.format(this.taxPeriod, "yyyy-MM"));
                resultArray.add((Object)errorResult);
                RecognitionCheckParentTask.saveCacheFileResult(this.url, resultArray);
                RecognitionCheckParentTask.saveCacheFile(this.pageId, this.url, fail);
            }
        } else {
            JSONObject errorResult = new JSONObject();
            errorResult.put("errcode", (Object)"0010");
            errorResult.put("desc", (Object)ResManager.loadKDString((String)"\u8be5\u53d1\u7968\u8bc6\u522b\u5931\u8d25", (String)"RecognitionReadySelectTask_2", (String)"imc-rim-common", (Object[])new Object[0]));
            errorResult.put("org_id", (Object)this.orgId);
            errorResult.put("taxorg_id", (Object)this.taxOrgId);
            errorResult.put("tax_period", (Object)DateUtils.format(this.taxPeriod, "yyyy-MM"));
            resultArray.add((Object)errorResult);
            RecognitionCheckParentTask.saveCacheFileResult(this.url, resultArray);
            RecognitionCheckParentTask.saveCacheFile(this.pageId, this.url, fail);
        }
        return result;
    }
}

