/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.invoice.download.InvoiceDownHelper;
import kd.imc.rim.common.utils.DeductionUtils;

public class InvoiceDownServiceTask
implements Callable<String> {
    private static Log LOGGER = LogFactory.getLog(InvoiceDownServiceTask.class);
    private RequestContext rc;
    private List<DynamicObject> downLogs;
    private int downMaxNum;

    public InvoiceDownServiceTask(RequestContext rc, List<DynamicObject> downLogs, int downMaxNum) {
        this.rc = rc;
        this.downLogs = downLogs;
        this.downMaxNum = downMaxNum;
    }

    @Override
    public String call() throws Exception {
        RequestContext.copyAndSet((RequestContext)this.rc);
        if (CollectionUtils.isEmpty(this.downLogs)) {
            return "";
        }
        int index = 0;
        int errorNum = 0;
        for (DynamicObject dynamicObject : this.downLogs) {
            String govStatus = dynamicObject.getString("gov_status");
            if (!"2".equals(govStatus) && !"6".equals(govStatus)) continue;
            JSONObject result = InvoiceDownHelper.downInvoice(dynamicObject, this.rc);
            String errcode = result != null ? result.getString("errcode") + result.getString("description") : "9999";
            LOGGER.info("\u4e0b\u8f7d\u8fd4\u56de\u6570\u636e{}-index:{}-{}-{}", new Object[]{dynamicObject.getString("tax_no"), ++index + 1, dynamicObject.getString("batch_no"), errcode});
            if (DeductionUtils.isNotConfig(result)) {
                ++errorNum;
            }
            if (errorNum < this.downMaxNum) continue;
            if (result != null) {
                List<DynamicObject> downLogsNew = this.downLogs.subList(index, this.downLogs.size());
                InvoiceDownHelper.updateDescription(downLogsNew, result.getString("description"));
            }
            return dynamicObject.getString("tax_no");
        }
        return "";
    }
}

