/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.impl.NewEtaxDeductService;
import kd.imc.rim.common.invoice.download.InvoiceDownHelper;
import kd.imc.rim.common.invoice.download.impl.InOutputInvoiceDownServiceImpl;
import kd.imc.rim.common.utils.AllEleAuthUtil;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.ListUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.common.utils.ViewUtil;

public class RpaFileDownApplyService {
    public Map<String, JSONArray> replenishApplyData(String taxNo, List<String> invoiceNoList, Long invoiceTypeParam) {
        HashMap<String, JSONArray> applyFiles = new HashMap<String, JSONArray>(8);
        if (CollectionUtils.isEmpty(invoiceNoList)) {
            return applyFiles;
        }
        QFilter invoiceNoFilter = new QFilter("invoice_no", "in", invoiceNoList);
        QFilter invoiceTypeFilter = null;
        if (invoiceTypeParam > 0L) {
            invoiceTypeFilter = new QFilter("invoice_type", "=", (Object)invoiceTypeParam);
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice", (String)"id,invoice_code,invoice_no,invoice_date,buyer_tax_no,invoice_type,serial_no,buyer_name,saler_tax_no,saler_name,total_amount", (QFilter[])new QFilter[]{invoiceNoFilter, invoiceTypeFilter});
        Object[] serialNos = collection.stream().map(s -> s.getString("serial_no")).toArray();
        Set<String> downloadedTaxFileNos = InvoiceDownHelper.getDownloadedTaxFileNos(serialNos);
        String taxCity = AllEleAuthUtil.getTaxCity(taxNo);
        for (DynamicObject invoice : collection) {
            String dkType;
            Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(invoice.get("invoice_type"));
            String invoiceCode = invoice.getString("invoice_code");
            String invoiceNo = invoice.getString("invoice_no");
            String buyerTaxNo = invoice.getString("buyer_tax_no");
            String serialNo = invoice.getString("serial_no");
            Date invoiceDate = invoice.getDate("invoice_date");
            String buyerName = invoice.getString("buyer_name");
            String salerTaxNo = invoice.getString("saler_tax_no");
            String salerName = invoice.getString("saler_name");
            String totalAmount = DynamicObjectUtil.fieldToString(invoice.get("total_amount"));
            String codeGroup = CommonUtils.getInvoiceCodeNoGroup(invoiceCode, invoiceNo);
            if (downloadedTaxFileNos.contains(serialNo)) {
                String msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u5df2\u7ecf\u4e0b\u8f7d\u4e86\u7a0e\u5c40\u6587\u4ef6\uff0c\u8bf7\u52ff\u91cd\u590d\u7533\u8bf7\u3002", (String)"DownTaxFileOperateService_7", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                continue;
            }
            if (!InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType) && !InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType) && !InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType) && !InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoiceType) || invoiceDate == null || DateUtils.isTimeZero(invoiceDate) || StringUtils.isEmpty((CharSequence)buyerTaxNo) || !"4".equals(dkType = DeductionConstant.getDkType(buyerTaxNo))) continue;
            JSONArray invoices = applyFiles.getOrDefault(buyerTaxNo, new JSONArray());
            JSONObject json = new JSONObject();
            json.put("invoiceNo", (Object)invoiceNo);
            json.put("invoiceType", (Object)InputInvoiceTypeEnum.getAwsType(invoiceType));
            HashSet<Integer> fileTypeSet = new HashSet<Integer>(1);
            fileTypeSet.add(-1);
            json.put("fileTypes", fileTypeSet);
            json.put("invoiceDate", (Object)DateUtils.format(invoiceDate, "yyyy-MM-dd HH:mm:ss"));
            json.put("buyerTaxNo", (Object)buyerTaxNo);
            json.put("buyerName", (Object)buyerName);
            json.put("salerTaxNo", (Object)salerTaxNo);
            json.put("salerName", (Object)salerName);
            json.put("totalAmount", (Object)totalAmount);
            json.put("cityCode", (Object)taxCity);
            invoices.add((Object)json);
            applyFiles.put(buyerTaxNo, invoices);
        }
        return applyFiles;
    }

    public JSONObject applyTaxFile(Map<String, JSONArray> applyFiles, Date minInvoiceDate, Date maxInvoiceDate, int reapplyTimes) {
        if (ObjectUtils.isEmpty(applyFiles)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        JSONObject result = new JSONObject();
        result.put("errcode", (Object)"0000");
        String lqTaxNoStr = ImcConfigUtil.getValue("rim_deduction", "leqi_taxno_down_ele_file");
        int successNum = 0;
        int maxApplySize = InvoiceDownloadConstant.getPageSizeFromConfig(1000, "rpa_max_size_down_ele_file");
        for (Map.Entry<String, JSONArray> entry : applyFiles.entrySet()) {
            String taxNo = entry.getKey();
            Long orgId = TenantUtils.getOrgByNumberOrTaxNo(null, taxNo);
            NewEtaxDeductService deductService = new NewEtaxDeductService(orgId);
            String dkType = DeductionConstant.getDkType(taxNo);
            boolean isLqTaxno = "5".equals(dkType) || StringUtils.isNotBlank((CharSequence)lqTaxNoStr) && lqTaxNoStr.contains(taxNo);
            JSONArray allInvoices = entry.getValue();
            Map<String, List<JSONObject>> listMap = allInvoices.toJavaList(JSONObject.class).stream().filter(s -> StringUtils.isNotEmpty((CharSequence)s.getString("invoiceType"))).collect(Collectors.groupingBy(s -> s.getString("invoiceType")));
            for (Map.Entry<String, List<JSONObject>> listEntry : listMap.entrySet()) {
                String msg;
                String invoiceType = listEntry.getKey();
                List<JSONObject> invoices = listEntry.getValue();
                JSONObject param = new JSONObject();
                param.put("dataType", (Object)"1");
                param.put("snapshotMark", (Object)true);
                param.put("taxNo", (Object)taxNo);
                if (isLqTaxno) {
                    param.put("lqFlag", (Object)"1");
                }
                if (invoices.size() > maxApplySize) {
                    List<List<JSONObject>> lists = ListUtils.splitList(invoices, maxApplySize);
                    for (List<JSONObject> list : lists) {
                        JSONObject paramSplit = new JSONObject();
                        paramSplit.putAll((Map)param);
                        paramSplit.put("invoices", list);
                        JSONObject resultReturn = ((DeductService)deductService).applyInvoiceFile(paramSplit);
                        paramSplit.put("minInvoiceDate", (Object)minInvoiceDate);
                        paramSplit.put("maxInvoiceDate", (Object)maxInvoiceDate);
                        paramSplit.put("invoiceType", (Object)invoiceType);
                        paramSplit.put("orgId", (Object)orgId);
                        paramSplit.put("reapplyTimes", (Object)reapplyTimes);
                        if (ResultContant.isSuccess(resultReturn).booleanValue()) {
                            successNum += list.size();
                            this.dealData(resultReturn, paramSplit);
                            continue;
                        }
                        if (null == resultReturn) continue;
                        String totalMsg = result.getString("description");
                        String msg2 = resultReturn.getString("description");
                        if (!StringUtils.isNotBlank((CharSequence)msg2)) continue;
                        StringBuilder resultMessage = new StringBuilder();
                        totalMsg = StringUtils.isNotBlank((CharSequence)totalMsg) ? totalMsg + msg2 : msg2;
                        resultMessage.append(taxNo).append("\uff1a").append(totalMsg).append(ViewUtil.LINE_SEPARATOR);
                        result.put("description", (Object)resultMessage.toString());
                    }
                    continue;
                }
                param.put("invoices", invoices);
                JSONObject resultReturn = ((DeductService)deductService).applyInvoiceFile(param);
                param.put("minInvoiceDate", (Object)minInvoiceDate);
                param.put("maxInvoiceDate", (Object)maxInvoiceDate);
                param.put("invoiceType", (Object)invoiceType);
                param.put("orgId", (Object)orgId);
                param.put("reapplyTimes", (Object)reapplyTimes);
                if (ResultContant.isSuccess(resultReturn).booleanValue()) {
                    successNum += invoices.size();
                    this.dealData(resultReturn, param);
                    continue;
                }
                if (null == resultReturn || !StringUtils.isNotBlank((CharSequence)(msg = resultReturn.getString("description")))) continue;
                result.put("description", (Object)msg);
            }
        }
        result.put("successNum", (Object)successNum);
        if (successNum == 0) {
            result.put("errcode", (Object)ErrorType.PARAM_ERROR.getCode());
        }
        return result;
    }

    private JSONObject dealData(JSONObject result, JSONObject param) {
        JSONObject data;
        String taskNo;
        if (null == result) {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u7533\u8bf7\u5931\u8d25", (String)"NewEtaxDeductService_22", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String taxNo = param.getString("taxNo");
        String invoiceType = param.getString("invoiceType");
        Long orgId = param.getLong("orgId");
        List invoices = (List)param.getObject("invoices", List.class);
        Date minInvoiceDate = param.getDate("minInvoiceDate");
        Date maxInvoiceDate = param.getDate("maxInvoiceDate");
        if (!ResultContant.isSuccess(result).booleanValue()) {
            return ResultContant.createJSONObject(result.getString("errcode"), String.format(ResManager.loadKDString((String)"\u7a0e\u53f7[%1$s]\u7533\u8bf7\u4e0b\u8f7d\u7a0e\u5c40\u6587\u4ef6\u5931\u8d25:%2$s", (String)"DownTaxFileOperateService_9", (String)"imc-rim-formplugin", (Object[])new Object[0]), taxNo, result.getString("description")));
        }
        if (ResultContant.isSuccess(result).booleanValue() && StringUtils.isNotEmpty((CharSequence)(taskNo = (data = result.getJSONObject("data")).getString("batchNo")))) {
            Long orgId2 = TenantUtils.getOrgByNumberOrTaxNo(null, taxNo);
            if (orgId2 <= 0L) {
                orgId2 = orgId;
            }
            InOutputInvoiceDownServiceImpl downService = new InOutputInvoiceDownServiceImpl();
            String applyBatchNo = UUID.getBatchNo("DOWN");
            DynamicObject fileLog = downService.getDownLogDynamicObject(applyBatchNo, taskNo, orgId2, taxNo, 0, "", InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceType));
            if (minInvoiceDate != null) {
                fileLog.set("invoice_startdate", (Object)minInvoiceDate);
            }
            if (maxInvoiceDate != null) {
                fileLog.set("invoice_enddate", (Object)maxInvoiceDate);
            }
            fileLog.set("aws_invoice_type", (Object)invoiceType);
            fileLog.set("gov_status", (Object)"6");
            fileLog.set("download_errcode", (Object)"0");
            fileLog.set("inout", (Object)"7");
            fileLog.set("apply_step", (Object)1);
            try {
                int reapplyTimes = param.getIntValue("reapplyTimes");
                if (reapplyTimes > 0) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("reapplyTimes", (Object)reapplyTimes);
                    fileLog.set("json_tag", (Object)jsonObject.toJSONString());
                }
            }
            catch (Exception reapplyTimes) {
                // empty catch block
            }
            String accountApp = result.getString("account");
            if (StringUtils.isNotBlank((CharSequence)accountApp)) {
                fileLog.set("account", (Object)accountApp);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fileLog});
            ArrayList<DynamicObject> syncAccountList = new ArrayList<DynamicObject>(invoices.size());
            for (JSONObject invoice : invoices) {
                DynamicObject account = downService.getAccountDynamicObject(invoice, applyBatchNo, "", "7", null, orgId2);
                syncAccountList.add(account);
            }
            SaveServiceHelper.save((DynamicObject[])syncAccountList.toArray(new DynamicObject[0]));
        }
        return result;
    }
}

