/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.excel;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.constant.HolytaxInvoiceTypeEnum;
import kd.imc.rim.common.invoice.download.excel.HolytaxResolverConstant;
import kd.imc.rim.common.invoice.download.excel.InputOutputInvoiceResolver;

public class HolytaxInputOutputInvoiceResolver
implements InputOutputInvoiceResolver {
    private static final Log LOGGER = LogFactory.getLog(HolytaxInputOutputInvoiceResolver.class);

    @Override
    public String invoiceCell2Name(String invoiceCellName, String type) {
        Map<String, String> resolver = HolytaxResolverConstant.getInvoiceResolver(type);
        if (resolver == null) {
            LOGGER.info("invoiceCell2Name {} {}", (Object)invoiceCellName, (Object)type);
            throw new KDException(new ErrorCode("2001", ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b\u6709\u8bef", (String)"HolytaxInputOutputInvoiceResolver_0", (String)"imc-rim-common", (Object[])new Object[0])), new Object[0]);
        }
        invoiceCellName = this.trim(invoiceCellName);
        return resolver.getOrDefault(invoiceCellName, invoiceCellName);
    }

    @Override
    public String itemCell2Name(String itemcellName, String type) {
        Map<String, String> resolver = HolytaxResolverConstant.getInvoiceResolverItem(type);
        if (resolver == null) {
            LOGGER.info("itemCell2Name {} {}", (Object)itemcellName, (Object)type);
            throw new KDException(new ErrorCode("2001", ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b\u6709\u8bef", (String)"HolytaxInputOutputInvoiceResolver_0", (String)"imc-rim-common", (Object[])new Object[0])), new Object[0]);
        }
        itemcellName = this.trim(itemcellName);
        return resolver.getOrDefault(itemcellName, itemcellName);
    }

    @Override
    public String itemField() {
        return "mxs";
    }

    @Override
    public String typeField() {
        return "fplx";
    }

    @Override
    public String titleCell2Type(String titleCellName) {
        String type = HolytaxResolverConstant.getInvoiceTypeByName(this.trim(titleCellName));
        if (StringUtils.isEmpty((CharSequence)type)) {
            LOGGER.info("titleCell2Type {} ", (Object)titleCellName);
            throw new KDException(new ErrorCode("2001", ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u53d1\u7968\u7c7b\u578b", (String)"HolytaxInputOutputInvoiceResolver_1", (String)"imc-rim-common", (Object[])new Object[0])), new Object[0]);
        }
        return type;
    }

    private String trim(String str) {
        return StringUtils.trimToEmpty((String)str);
    }

    @Override
    public String getSheetRowKey(Map rMap) {
        return "" + rMap.get("fpdm") + "-" + rMap.get("fphm") + rMap.get("jkshm");
    }

    @Override
    public void lastDeal(Map<String, JSONObject> invoiceMap) {
        for (JSONObject invoice : invoiceMap.values()) {
            if (!StringUtils.equals((CharSequence)HolytaxInvoiceTypeEnum.ORDINARY_ROLL.getCode(), (CharSequence)invoice.getString("fplx"))) continue;
            BigDecimal jshj = new BigDecimal("0.00");
            JSONArray items = invoice.getJSONArray("mxs");
            if (!CollectionUtils.isEmpty((Collection)items)) {
                for (int i = 0; i < items.size(); ++i) {
                    JSONObject item = items.getJSONObject(i);
                    jshj = jshj.add(item.getBigDecimal("je"));
                }
            }
            invoice.put("jshj", (Object)jshj);
            invoice.put("hjje", (Object)jshj);
        }
    }
}

