/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.excel;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.constant.HolytaxInvoiceTypeEnum;
import kd.imc.rim.common.utils.BigDecimalUtil;
import org.apache.commons.lang3.StringUtils;

public class TaxInvoiceConvertUtil {
    private static Log logger = LogFactory.getLog(TaxInvoiceConvertUtil.class);

    public static String getInvoiceStateByCN(String state) {
        if (BigDecimalUtil.isNumber(state)) {
            return state;
        }
        if ("\u6b63\u5e38".equals(state)) {
            return "0";
        }
        if ("\u4f5c\u5e9f".equals(state)) {
            return "2";
        }
        if ("\u7ea2\u51b2".equals(state)) {
            return "3";
        }
        if ("\u5931\u63a7".equals(state)) {
            return "1";
        }
        if ("\u5f02\u5e38".equals(state)) {
            return "4";
        }
        if ("\u975e\u6b63\u5e38".equals(state)) {
            return "5";
        }
        if ("\u7ea2\u5b57\u53d1\u7968\u5f85\u786e\u8ba4".equals(state)) {
            return "6";
        }
        if ("\u90e8\u5206\u7ea2\u51b2".equals(state)) {
            return "7";
        }
        if ("\u5168\u989d\u7ea2\u51b2".equals(state)) {
            return "8";
        }
        return "0";
    }

    public static String getInvoiceState(String state) {
        if ("0".equals(state) || "\u6b63\u5e38".equals(state)) {
            return "0";
        }
        if ("1".equals(state) || "\u4f5c\u5e9f".equals(state)) {
            return "2";
        }
        if ("2".equals(state) || "\u7ea2\u51b2".equals(state)) {
            return "3";
        }
        if ("3".equals(state) || "\u5931\u63a7".equals(state)) {
            return "1";
        }
        if ("4".equals(state) || "\u5f02\u5e38".equals(state)) {
            return "4";
        }
        if ("-1".equals(state) || "\u975e\u6b63\u5e38".equals(state)) {
            return "5";
        }
        if ("80".equals(state) || "\u7ea2\u5b57\u53d1\u7968\u5f85\u786e\u8ba4".equals(state)) {
            return "6";
        }
        if ("7".equals(state) || "\u90e8\u5206\u7ea2\u51b2".equals(state)) {
            return "7";
        }
        if ("8".equals(state) || "\u5168\u989d\u7ea2\u51b2".equals(state)) {
            return "8";
        }
        return "0";
    }

    public static JSONObject getOriginDmHm(String remark) {
        JSONObject result = new JSONObject();
        String originalInvoiceCode = "";
        String originalInvoiceNo = "";
        remark = remark.replaceAll("[\r\n\t,\uff0c\uff1a: ]", "");
        String rgex = "\u53d1\u7968\u4ee3\u7801(.*?)\u53f7\u7801";
        Pattern pattern = Pattern.compile(rgex);
        Matcher m = pattern.matcher(remark);
        if (m.find()) {
            remark = remark.substring(remark.indexOf("\u53d1\u7968\u4ee3\u7801"));
        }
        int fpdmIndex = remark.indexOf("\u4ee3\u7801");
        int fphmIndex = remark.indexOf("\u53f7\u7801");
        int remarkLength = remark.length();
        if (fpdmIndex != -1 && fphmIndex != -1) {
            if (fpdmIndex > fphmIndex) {
                originalInvoiceCode = remark.substring(fpdmIndex + 2, remarkLength).replaceAll("[^0-9]", "");
                originalInvoiceNo = remark.substring(fphmIndex + 2, fpdmIndex).replaceAll("[^0-9]", "");
            } else {
                originalInvoiceCode = remark.substring(fpdmIndex + 2, fphmIndex).replaceAll("[^0-9]", "");
                originalInvoiceNo = remark.substring(fphmIndex + 2, remarkLength).replaceAll("[^0-9]", "");
            }
            if (originalInvoiceCode.length() > 12) {
                originalInvoiceCode = originalInvoiceCode.substring(0, 12);
            }
            if (originalInvoiceNo.length() > 8) {
                originalInvoiceNo = originalInvoiceNo.substring(0, 8);
            }
            result.put("originalInvoiceCode", (Object)originalInvoiceCode);
            result.put("originalInvoiceNo", (Object)originalInvoiceNo);
            return result;
        }
        return null;
    }

    public static JSONObject getJxxAddedTaxData(JSONObject curInvoice) {
        JSONArray invoiceItems;
        JSONObject result = new JSONObject();
        String invoiceType = curInvoice.getString("fplx");
        String fpdm = curInvoice.getString("fpdm");
        String fphm = curInvoice.getString("fphm");
        invoiceType = HolytaxInvoiceTypeEnum.getAwsTypeByHolytaxType(invoiceType);
        String xmfc = curInvoice.getString("xfmc");
        String remark = curInvoice.getString("bz");
        String jshj = curInvoice.getString("jshj");
        String hjje = curInvoice.getString("hjje");
        if (StringUtils.isEmpty((CharSequence)fpdm) && StringUtils.isNotEmpty((CharSequence)fphm) && fphm.length() == 20) {
            if ("1".equals(invoiceType)) {
                invoiceType = "26";
            } else if ("2".equals(invoiceType)) {
                invoiceType = "27";
            }
        }
        result.put("invoiceType", (Object)invoiceType);
        result.put("invoiceCode", (Object)fpdm);
        result.put("invoiceNo", (Object)fphm);
        result.put("invoiceDate", (Object)curInvoice.getString("kprq"));
        result.put("invoiceStatus", (Object)TaxInvoiceConvertUtil.getInvoiceState(curInvoice.getString("fpzt")));
        result.put("salerTaxNo", (Object)curInvoice.getString("xfsh"));
        result.put("salerName", (Object)xmfc);
        result.put("buyerTaxNo", (Object)curInvoice.getString("gfsh"));
        result.put("buyerName", (Object)curInvoice.getString("gfmc"));
        result.put("invoiceAmount", (Object)hjje);
        result.put("totalTaxAmount", (Object)curInvoice.getString("hjse"));
        if (StringUtils.isEmpty((CharSequence)jshj) && "5".equals(invoiceType)) {
            result.put("totalAmount", (Object)hjje);
        } else {
            result.put("totalAmount", (Object)jshj);
        }
        result.put("checkCode", (Object)curInvoice.getString("jym"));
        result.put("salerAddressPhone", (Object)curInvoice.getString("xfdzdh"));
        result.put("salerAccount", (Object)curInvoice.getString("xfyhzh"));
        result.put("buyerAddressPhone", (Object)curInvoice.getString("gfdzdh"));
        result.put("buyerAccount", (Object)curInvoice.getString("gfyhzh"));
        result.put("cipherArea", (Object)curInvoice.getString("mmq"));
        result.put("remark", (Object)remark);
        result.put("machineNo", (Object)curInvoice.getString("jqbh"));
        result.put("jdhm", (Object)curInvoice.getString("jdhm"));
        result.put("drawer", (Object)curInvoice.getString("kpr"));
        result.put("payee", (Object)curInvoice.getString("skr"));
        result.put("reviewer", (Object)curInvoice.getString("fhr"));
        result.put("proxyMark", (Object)"0");
        result.put("type", (Object)"0");
        if (xmfc.indexOf("\u7a0e\u52a1\u5c40") != -1 && remark.indexOf("\u4ee3\u5f00") != -1) {
            result.put("proxyMark", (Object)"1");
        }
        if (jshj.indexOf(45) != -1) {
            result.put("type", (Object)"1");
            JSONObject originInfo = TaxInvoiceConvertUtil.getOriginDmHm(remark);
            if (null != originInfo) {
                result.put("originalInvoiceCode", (Object)originInfo.getString("originalInvoiceCode"));
                result.put("originalInvoiceNo", (Object)originInfo.getString("originalInvoiceNo"));
            }
        }
        if (CollectionUtils.isEmpty((Collection)(invoiceItems = curInvoice.getJSONArray("mxs")))) {
            invoiceItems = new JSONArray();
        }
        JSONArray itemsList = new JSONArray();
        for (int j = 0; j < invoiceItems.size(); ++j) {
            JSONObject subItem = new JSONObject();
            JSONObject curInvoiceItem = invoiceItems.getJSONObject(j);
            subItem.put("xh", curInvoiceItem.get((Object)"xh"));
            subItem.put("goodsCode", curInvoiceItem.get((Object)"ssflbm"));
            subItem.put("goodsName", curInvoiceItem.get((Object)"xmmc"));
            if (invoiceType.equals("15")) {
                String vehPlate = curInvoiceItem.getString("cph");
                String specModel = curInvoiceItem.getString("lx");
                String startDate = curInvoiceItem.getString("txrqq");
                String endDate = curInvoiceItem.getString("txrqz");
                if (StringUtils.isEmpty((CharSequence)vehPlate) && StringUtils.isEmpty((CharSequence)specModel) && StringUtils.isEmpty((CharSequence)startDate) && StringUtils.isEmpty((CharSequence)endDate)) {
                    subItem.put("vehPlate", curInvoiceItem.get((Object)"ggxh"));
                    subItem.put("specModel", curInvoiceItem.get((Object)"dw"));
                    subItem.put("startDate", curInvoiceItem.get((Object)"sl"));
                    subItem.put("endDate", curInvoiceItem.get((Object)"dj"));
                } else {
                    subItem.put("vehPlate", (Object)vehPlate);
                    subItem.put("specModel", (Object)specModel);
                    subItem.put("startDate", (Object)startDate);
                    subItem.put("endDate", (Object)endDate);
                }
            } else {
                String dw = curInvoiceItem.getString("dw");
                if (!StringUtils.isEmpty((CharSequence)dw)) {
                    dw = dw.replace(" ", "");
                }
                subItem.put("specModel", curInvoiceItem.get((Object)"ggxh"));
                subItem.put("unit", (Object)dw);
                subItem.put("num", curInvoiceItem.get((Object)"sl"));
                subItem.put("unitPrice", curInvoiceItem.get((Object)"dj"));
            }
            subItem.put("detailAmount", curInvoiceItem.get((Object)"je"));
            subItem.put("taxRate", curInvoiceItem.get((Object)"slv"));
            subItem.put("taxAmount", curInvoiceItem.get((Object)"se"));
            itemsList.add((Object)subItem);
        }
        for (int i = 0; i < itemsList.size(); ++i) {
            JSONObject item = itemsList.getJSONObject(i);
            if ("1".equals(result.getString("type"))) {
                item.put("discountType", (Object)0);
                continue;
            }
            if (itemsList.size() == 1) {
                item.put("discountType", (Object)0);
                continue;
            }
            if (i != itemsList.size() - 1) {
                if (StringUtils.isNotEmpty((CharSequence)item.getString("detailAmount")) && item.getBigDecimal("detailAmount").compareTo(BigDecimal.ZERO) < 0) {
                    item.put("discountType", (Object)1);
                    continue;
                }
                if (StringUtils.isNotEmpty((CharSequence)itemsList.getJSONObject(i + 1).getString("detailAmount")) && itemsList.getJSONObject(i + 1).getBigDecimal("detailAmount").compareTo(BigDecimal.ZERO) < 0) {
                    item.put("discountType", (Object)2);
                    continue;
                }
                item.put("discountType", (Object)0);
                continue;
            }
            if (StringUtils.isNotEmpty((CharSequence)item.getString("detailAmount")) && item.getBigDecimal("detailAmount").compareTo(BigDecimal.ZERO) < 0) {
                item.put("discountType", (Object)1);
                continue;
            }
            item.put("discountType", (Object)0);
        }
        result.put("items", (Object)itemsList);
        return result;
    }

    public static JSONObject getJxxVehicleData(JSONObject invoice) {
        JSONObject result = new JSONObject();
        String xmfc = invoice.getString("xfmc");
        String remark = invoice.getString("bz");
        String jshj = invoice.getString("jshj");
        if (StringUtils.isEmpty((CharSequence)remark)) {
            remark = "";
        }
        result.put("invoiceType", (Object)"12");
        result.put("invoiceCode", invoice.get((Object)"fpdm"));
        result.put("invoiceNo", invoice.get((Object)"fphm"));
        result.put("invoiceDate", invoice.get((Object)"kprq"));
        result.put("invoiceStatus", (Object)TaxInvoiceConvertUtil.getInvoiceState(invoice.getString("fpzt")));
        result.put("buyerName", invoice.get((Object)"gfmc"));
        result.put("buyerCardno", invoice.get((Object)"sfzhm"));
        result.put("buyerTaxNo", invoice.get((Object)"gfsh"));
        result.put("vehicleType", invoice.get((Object)"cllx"));
        result.put("brandModel", invoice.get((Object)"cpxh"));
        result.put("producingArea", invoice.get((Object)"cd"));
        result.put("certificateNum", invoice.get((Object)"hgzh"));
        result.put("importCertificate", invoice.get((Object)"jkzmsh"));
        result.put("commodityInspectionNum", invoice.get((Object)"sjdh"));
        result.put("engineNum", invoice.get((Object)"fdjhm"));
        result.put("vehicleIdentificationCode", invoice.get((Object)"clsbdh"));
        result.put("totalAmount", (Object)jshj);
        result.put("salerName", (Object)xmfc);
        result.put("salerPhone", invoice.get((Object)"dh"));
        result.put("salerTaxNo", invoice.get((Object)"xfsh"));
        result.put("salerAccount", invoice.get((Object)"zh"));
        result.put("salerAddress", invoice.get((Object)"dz"));
        result.put("salerBankName", invoice.get((Object)"khyh"));
        result.put("taxRate", invoice.get((Object)"slv"));
        result.put("totalTaxAmount", invoice.get((Object)"hjse"));
        result.put("taxAmount", invoice.get((Object)"hjse"));
        result.put("taxAuthorityName", invoice.get((Object)"zgswjg"));
        result.put("taxAuthorityCode", invoice.get((Object)"zgswjgdm"));
        result.put("invoiceAmount", invoice.get((Object)"hjje"));
        result.put("overTaxCode", invoice.get((Object)"wspzhm"));
        result.put("totalTon", invoice.get((Object)"dw"));
        result.put("limitePeople", invoice.get((Object)"xcrs"));
        result.put("proxyMark", (Object)"0");
        result.put("type", (Object)"0");
        if (xmfc.indexOf("\u7a0e\u52a1\u5c40") != -1 && remark.indexOf("\u4ee3\u5f00") != -1) {
            result.put("proxyMark", (Object)"1");
        }
        if (jshj.indexOf(45) != -1) {
            result.put("type", (Object)"1");
            JSONObject originInfo = TaxInvoiceConvertUtil.getOriginDmHm(remark);
            if (null != originInfo) {
                result.put("originalInvoiceCode", (Object)originInfo.getString("originalInvoiceCode"));
                result.put("originalInvoiceNo", (Object)originInfo.getString("originalInvoiceNo"));
            }
        }
        return result;
    }

    public static JSONObject getJxxEscData(JSONObject invoice) {
        JSONObject result = new JSONObject();
        String xmfc = invoice.getString("mfdw");
        String remark = invoice.getString("bz");
        String cjhj = invoice.getString("cjhj");
        result.put("invoiceType", (Object)"13");
        result.put("invoiceCode", invoice.get((Object)"fpdm"));
        result.put("invoiceNo", invoice.get((Object)"fphm"));
        result.put("invoiceDate", invoice.get((Object)"kprq"));
        result.put("invoiceStatus", (Object)TaxInvoiceConvertUtil.getInvoiceState(invoice.getString("fpzt")));
        result.put("buyerName", invoice.get((Object)"gfdw"));
        result.put("buyerIdNo", invoice.get((Object)"gfdwdm"));
        result.put("buyerAddress", invoice.get((Object)"gfdwdz"));
        result.put("buyerPhoneNumber", invoice.get((Object)"gfdwdh"));
        result.put("salerName", (Object)xmfc);
        result.put("salerIdNo", invoice.get((Object)"mfdwdm"));
        result.put("salerAddress", invoice.get((Object)"mfdwdz"));
        result.put("salerPhoneNumber", invoice.get((Object)"mfdwdh"));
        result.put("licensePlateNumber", invoice.get((Object)"cpzh"));
        result.put("registrationNumber", invoice.get((Object)"djzh"));
        result.put("vehicleType", invoice.get((Object)"cllx"));
        result.put("vehicleIdentificationNo", invoice.get((Object)"clsbdh"));
        result.put("bandModel", invoice.get((Object)"cpxh"));
        result.put("vehicleManagementName", invoice.get((Object)"zrdclglsmc"));
        result.put("totalAmount", (Object)cjhj);
        result.put("auctionName", invoice.get((Object)"jydw"));
        result.put("auctionAddress", invoice.get((Object)"jydwdz"));
        result.put("auctionTaxpayerId", invoice.get((Object)"jydwnsrsbh"));
        result.put("auctionBankAccout", invoice.get((Object)"jydwkhyhzh"));
        result.put("auctionPhoneNumber", invoice.get((Object)"jydwdh"));
        result.put("marketName", invoice.get((Object)"escsc"));
        result.put("marketTaxpayerId", invoice.get((Object)"escnsrsbh"));
        result.put("marketAddress", invoice.get((Object)"escdz"));
        result.put("marketBankAccout", invoice.get((Object)"esckhyhzh"));
        result.put("marketPhoneNumber", invoice.get((Object)"escdh"));
        result.put("remark", (Object)remark);
        result.put("drawer", invoice.get((Object)"kpr"));
        result.put("proxyMark", (Object)"0");
        result.put("type", (Object)"0");
        if (xmfc.indexOf("\u7a0e\u52a1\u5c40") != -1 && remark.indexOf("\u4ee3\u5f00") != -1) {
            result.put("proxyMark", (Object)"1");
        }
        if (cjhj.indexOf(45) != -1) {
            result.put("type", (Object)"1");
            JSONObject originInfo = TaxInvoiceConvertUtil.getOriginDmHm(remark);
            if (null != originInfo) {
                result.put("originalInvoiceCode", (Object)originInfo.getString("originalInvoiceCode"));
                result.put("originalInvoiceNo", (Object)originInfo.getString("originalInvoiceNo"));
            }
        }
        return result;
    }

    public static JSONObject getJxxJks(JSONObject invoice) {
        JSONObject result = new JSONObject();
        result.put("invoiceType", (Object)"21");
        result.put("customDeclarationNo", invoice.get((Object)"jkshm"));
        result.put("invoiceDate", invoice.get((Object)"tfrq"));
        result.put("deptName", invoice.get((Object)"jkdwmc1"));
        result.put("deptTaxNo", invoice.get((Object)"jkdwsh1"));
        result.put("secondDeptName", invoice.get((Object)"jkdwmc2"));
        result.put("secondDeptTaxNo", invoice.get((Object)"jkdwsh2"));
        result.put("portCode", invoice.get((Object)"jkkadm"));
        result.put("totalTaxAmount", invoice.get((Object)"skje"));
        result.put("getOffice", invoice.get((Object)"srjg"));
        result.put("applyDeptNo", invoice.get((Object)"sqdwbm"));
        result.put("declareNo", invoice.get((Object)"bgdbh"));
        result.put("modeTrade", invoice.get((Object)"myfs"));
        result.put("budgetAccountCode", invoice.get((Object)"yskmdm"));
        result.put("codeCollectionTreasury", invoice.get((Object)"skgkdm"));
        result.put("contractNo", invoice.get((Object)"hth"));
        result.put("transToolNo", invoice.get((Object)"ysgj"));
        result.put("payLimitDate", invoice.get((Object)"jkqx"));
        result.put("deliveryNo", invoice.get((Object)"tydh"));
        result.put("dataSource", invoice.get((Object)"sjly"));
        JSONArray invoiceItems = invoice.getJSONArray("mxs");
        if (CollectionUtils.isEmpty((Collection)invoiceItems)) {
            invoiceItems = new JSONArray();
        }
        JSONArray itemsList = new JSONArray();
        for (int j = 0; j < invoiceItems.size(); ++j) {
            JSONObject subItem = new JSONObject();
            JSONObject dataSubItem = invoiceItems.getJSONObject(j);
            subItem.put("orderNumber", (Object)dataSubItem.getString("xh"));
            subItem.put("taxNumberInformation", (Object)dataSubItem.getString("shxx"));
            subItem.put("goodsName", (Object)dataSubItem.getString("hwmc"));
            subItem.put("unitPrice", (Object)dataSubItem.getString("wsjg"));
            subItem.put("num", (Object)dataSubItem.getString("sl"));
            subItem.put("unit", (Object)dataSubItem.getString("dw"));
            subItem.put("taxRate", (Object)dataSubItem.getString("slv"));
            subItem.put("taxAmount", (Object)dataSubItem.getString("skje"));
            subItem.put("dataSource", (Object)dataSubItem.getString("sjly"));
            itemsList.add((Object)subItem);
        }
        result.put("items", (Object)itemsList);
        return result;
    }

    public static JSONArray getInputOutInvoiceData(JSONArray invoiceList, String type) {
        if (CollectionUtils.isEmpty((Collection)invoiceList)) {
            return null;
        }
        Set<String> allowTypes = HolytaxInvoiceTypeEnum.getAllHolytaxTypes();
        if (allowTypes.contains(type)) {
            JSONArray resultList = new JSONArray();
            for (int i = 0; i < invoiceList.size(); ++i) {
                JSONObject invoice = invoiceList.getJSONObject(i);
                JSONObject invoiceResult = new JSONObject();
                invoiceResult = HolytaxInvoiceTypeEnum.HGJKS.getCode().equals(type) ? TaxInvoiceConvertUtil.getJxxJks(invoice) : (HolytaxInvoiceTypeEnum.MOTOR_INVOICE.getCode().equals(type) ? TaxInvoiceConvertUtil.getJxxVehicleData(invoice) : (HolytaxInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(type) ? TaxInvoiceConvertUtil.getJxxEscData(invoice) : TaxInvoiceConvertUtil.getJxxAddedTaxData(invoice)));
                invoiceResult.replaceAll((k, v) -> v == null ? "" : v);
                resultList.add((Object)invoiceResult);
            }
            return resultList;
        }
        return null;
    }
}

