/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.excel;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.HolytaxInvoiceTypeEnum;
import kd.imc.rim.common.invoice.download.InvoiceDealService;
import kd.imc.rim.common.invoice.download.excel.DownExcelUtils;
import kd.imc.rim.common.invoice.download.excel.HolytaxResolverConstant;
import kd.imc.rim.common.invoice.download.excel.TaxInvoiceConvertUtil;
import kd.imc.rim.common.invoice.download.impl.InOutputInvoiceDownServiceImpl;
import kd.imc.rim.common.invoice.download.impl.InputInvoiceDealService;
import kd.imc.rim.common.invoice.download.impl.OutputInvoiceDealService;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.InvoiceCheckUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.common.utils.ViewUtil;
import org.apache.commons.compress.utils.Sets;

public class UnzipAndAnalysisExcelService {
    private static final Log LOGGER = LogFactory.getLog(UnzipAndAnalysisExcelService.class);

    public static JSONObject analysisExcel(Object[] urls, DynamicObjectCollection userorgs) {
        JSONObject result = new JSONObject();
        StringBuilder message = new StringBuilder();
        int total = urls.length;
        int success = 0;
        int successNum = 0;
        HashSet batchNos = Sets.newHashSet((Object[])new String[0]);
        for (Object url : urls) {
            String urlStr = url.toString();
            String fileName = urlStr.substring(urlStr.lastIndexOf(47) + 1);
            LOGGER.info("\u89e3\u6790\u7a0e\u5c40Excel:{}", (Object)fileName);
            try {
                Map<String, String> fileNameInfo = UnzipAndAnalysisExcelService.analyzeFileName(fileName);
                String invoiceType = "";
                String taxNoFile = "";
                String inout = "";
                if (!CollectionUtils.isEmpty(fileNameInfo)) {
                    inout = fileNameInfo.get("inout");
                    taxNoFile = fileNameInfo.get("taxNo");
                    invoiceType = fileNameInfo.get("invoiceType");
                }
                String taxNo = "";
                Long orgId = 0L;
                for (DynamicObject userorg : userorgs) {
                    String tax = userorg.getString("taxpayer_tax_no");
                    if (!StringUtils.equals((CharSequence)taxNoFile, (CharSequence)tax)) continue;
                    taxNo = tax;
                    orgId = DynamicObjectUtil.getDynamicObjectLongValue(userorg.get("taxpayer_org"));
                    break;
                }
                if (StringUtils.isEmpty((CharSequence)taxNo)) {
                    message.append(String.format(ResManager.loadKDString((String)"\u6587\u4ef6:%s \u53d1\u7968\u6570\u636e\u7a0e\u53f7\u4e0e\u9009\u62e9\u7684\u914d\u7f6e\u7a0e\u53f7\u4e0d\u5339\u914d\u3002", (String)"UnzipAndAnalysisExcelService_0", (String)"imc-rim-common", (Object[])new Object[0]), fileName)).append(ViewUtil.LINE_SEPARATOR);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)invoiceType) || StringUtils.equals((CharSequence)"-1", (CharSequence)invoiceType)) {
                    message.append(String.format(ResManager.loadKDString((String)"\u6587\u4ef6:%s \u53d1\u7968\u7c7b\u578b\u9519\u8bef\u3002", (String)"UnzipAndAnalysisExcelService_1", (String)"imc-rim-common", (Object[])new Object[0]), fileName, taxNo)).append(ViewUtil.LINE_SEPARATOR);
                    continue;
                }
                Map<String, JSONObject> map = DownExcelUtils.analyzeExcel(urlStr, fileName);
                if (CollectionUtils.isEmpty(map)) {
                    message.append(String.format(ResManager.loadKDString((String)"\u6587\u4ef6:%s \u6570\u636e\u4e3a\u7a7a\u3002", (String)"UnzipAndAnalysisExcelService_2", (String)"imc-rim-common", (Object[])new Object[0]), fileName)).append(ViewUtil.LINE_SEPARATOR);
                    continue;
                }
                JSONArray originArray = new JSONArray();
                originArray.addAll(map.values());
                JSONArray inputOutInvoiceData = TaxInvoiceConvertUtil.getInputOutInvoiceData(originArray, invoiceType);
                if (CollectionUtils.isEmpty((Collection)inputOutInvoiceData)) {
                    message.append(String.format(ResManager.loadKDString((String)"\u6587\u4ef6:%s \u6570\u636e\u4e3a\u7a7a\u3002", (String)"UnzipAndAnalysisExcelService_2", (String)"imc-rim-common", (Object[])new Object[0]), fileName)).append(ViewUtil.LINE_SEPARATOR);
                    continue;
                }
                Iterator iterator = inputOutInvoiceData.iterator();
                while (iterator.hasNext()) {
                    JSONObject invoice = JSONObject.parseObject((String)JSONObject.toJSONString(iterator.next()));
                    invoice.put("checkStatus", (Object)"4");
                    ApiResult apiResult = InvoiceCheckUtils.checkMust(invoice, false);
                    if (apiResult == null) continue;
                    message.append(String.format(ResManager.loadKDString((String)"\u6587\u4ef6:%1$s \u53d1\u7968:%2$s %3$s\u3002", (String)"UnzipAndAnalysisExcelService_3", (String)"imc-rim-common", (Object[])new Object[0]), fileName, CommonUtils.getInvoiceCodeNoGroup(invoice.getString("invoiceCode"), invoice.getString("invoiceNo")), apiResult.getMessage())).append(ViewUtil.LINE_SEPARATOR);
                    iterator.remove();
                }
                if (!CollectionUtils.isEmpty((Collection)inputOutInvoiceData)) {
                    int invoiceNum = inputOutInvoiceData.size();
                    successNum += invoiceNum;
                    String batchNo = UUID.getBatchNo("DOWN");
                    DynamicObject inDownLog = BusinessDataServiceHelper.newDynamicObject((String)"rim_down_log");
                    inDownLog.set("gov_status", (Object)"8");
                    inDownLog.set("inout", (Object)inout);
                    inDownLog.set("total_num", (Object)invoiceNum);
                    inDownLog.set("sync_type", (Object)"5");
                    inDownLog.set("invoice_type", (Object)HolytaxInvoiceTypeEnum.getInvoiceTypeByHolytaxType(invoiceType));
                    inDownLog.set("org", (Object)orgId);
                    inDownLog.set("tax_no", (Object)taxNo);
                    inDownLog.set("batch_no", (Object)batchNo);
                    UnzipAndAnalysisExcelService.saveInvoiceToDownLog(batchNo, orgId, inout, inputOutInvoiceData);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{inDownLog});
                    batchNos.add(batchNo);
                    ++success;
                    continue;
                }
                message.append(String.format(ResManager.loadKDString((String)"\u6587\u4ef6:%1$s \u6ca1\u6709\u5b8c\u6574\u53d1\u7968\u6570\u636e\u3002", (String)"UnzipAndAnalysisExcelService_4", (String)"imc-rim-common", (Object[])new Object[0]), fileName)).append(ViewUtil.LINE_SEPARATOR);
            }
            catch (Exception e) {
                LOGGER.info(fileName + "\u89e3\u6790\u5931\u8d25", (Object)e);
                message.append(String.format(ResManager.loadKDString((String)"\u6587\u4ef6:%1$s \u89e3\u6790\u5931\u8d25:%2$s\u3002", (String)"UnzipAndAnalysisExcelService_5", (String)"imc-rim-common", (Object[])new Object[0]), fileName, e.getMessage())).append(ViewUtil.LINE_SEPARATOR);
            }
        }
        result.put("total", (Object)total);
        result.put("success", (Object)success);
        result.put("successNum", (Object)successNum);
        result.put("message", (Object)message.toString());
        result.put("batchNos", (Object)String.join((CharSequence)",", batchNos));
        UnzipAndAnalysisExcelService.asyncDealTmpInvoice(batchNos);
        return result;
    }

    private static void saveInvoiceToDownLog(String batchNo, Long orgId, String inout, JSONArray inputOutInvoiceData) {
        if (!CollectionUtils.isEmpty((Collection)inputOutInvoiceData)) {
            InOutputInvoiceDownServiceImpl invoiceDownService = new InOutputInvoiceDownServiceImpl();
            String dataType = "1".equals(inout) ? "2" : "3";
            invoiceDownService.insertSyncInputOutDataAccount(inputOutInvoiceData, batchNo, "1", dataType, orgId, inout);
        }
    }

    private static void asyncDealTmpInvoice(Set<String> batchNos) {
        if (!CollectionUtils.isEmpty(batchNos)) {
            ThreadPools.executeOnceIncludeRequestContext((String)"UnzipAndAnalysisExcelService.asyncDealTmpInvoice", () -> {
                for (String batchNo : batchNos) {
                    UnzipAndAnalysisExcelService.dealTmpInvoice(batchNo);
                }
            });
        }
    }

    private static void dealTmpInvoice(String batchNo) {
        QFilter infilter;
        QFilter filter = new QFilter("batch_no", "=", (Object)batchNo);
        DynamicObjectCollection accountCollection = QueryServiceHelper.query((String)"rim_down_account", (String)"id,status,serial_no,data_type_tb", (QFilter[])new QFilter[]{filter});
        if (CollectionUtils.isEmpty((Collection)accountCollection)) {
            return;
        }
        String dataType = ((DynamicObject)accountCollection.get(0)).getString("data_type_tb");
        Object[] serialNoList = accountCollection.stream().map(s -> s.get("serial_no")).toArray();
        QFilter serialNoFilter = new QFilter("serial_no", "in", (Object)serialNoList);
        DynamicObjectCollection inputCollection = QueryServiceHelper.query((String)"rim_down_input", (String)"id", (QFilter[])new QFilter[]{serialNoFilter, infilter = new QFilter("inout", "=", (Object)dataType)});
        if (CollectionUtils.isEmpty((Collection)inputCollection)) {
            return;
        }
        List<Object> idList = inputCollection.stream().map(s -> s.get("id")).collect(Collectors.toList());
        InvoiceDealService dealService = null;
        dealService = "1".equals(dataType) ? new InputInvoiceDealService(RequestContext.get(), idList) : new OutputInvoiceDealService(RequestContext.get(), idList);
        dealService.deal(RequestContext.get(), idList);
    }

    private static Map<String, String> analyzeFileName(String fileName) {
        HashMap result = Maps.newHashMap();
        if (StringUtils.isNotEmpty((CharSequence)fileName)) {
            if (fileName.contains("\u8fdb\u9879")) {
                result.put("inout", "1");
            } else {
                result.put("inout", "2");
            }
            String[] split = fileName.split("-");
            result.put("taxNo", split[0]);
            result.put("invoiceType", HolytaxResolverConstant.getInvoiceTypeByName(fileName));
        }
        return result;
    }
}

