/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.impl.AisinoDeductService;
import kd.imc.rim.common.invoice.download.InvoiceDownService;
import kd.imc.rim.common.utils.AisinoConvertUtil;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.LockUtils;
import kd.imc.rim.common.utils.UUID;

public class AisinoHeaderInvoiceDownServiceImpl
extends InvoiceDownService {
    private static Log LOGGER = LogFactory.getLog(AisinoHeaderInvoiceDownServiceImpl.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JSONObject invoiceDown(DynamicObject downInit, RequestContext requestContext, Long orgId, String taxNo) {
        LOGGER.info("\u5f00\u59cb\u4e0b\u8f7d\u589e\u91cf\u53d1\u7968{}", (Object)taxNo);
        Date beginDate = downInit.getDate("begin");
        if (orgId == 0L) {
            orgId = requestContext.getOrgId();
        }
        if (this.checkOffFlag("3", taxNo)) {
            return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u5df2\u914d\u7f6e\u5173\u95ed,\u8bf7\u91cd\u65b0\u914d\u7f6e", (String)"AisinoHeaderInvoiceDownServiceImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONObject param = new JSONObject();
        param.put("taxNo", (Object)taxNo);
        String batchNo = this.getDownBatchNo();
        String taskNo = UUID.getBatchNoByTaxNo(taxNo);
        int pageNum = 1;
        String status = "1";
        Date endDate = new Date();
        int days = InvoiceDownloadConstant.getPageSizeFromConfig(3, "aisino_header_days");
        Date startDate = DateUtils.addDay(endDate, -days);
        startDate = DateUtils.getDayStart(startDate);
        param.put("batchNo", (Object)taskNo);
        param.put("fplx", (Object)"00");
        param.put("startDate", (Object)DateUtils.format(startDate, "yyyy-MM-dd HH:mm:ss"));
        param.put("endDate", (Object)DateUtils.format(endDate, "yyyy-MM-dd HH:mm:ss"));
        param.put("pageNum", (Object)pageNum);
        param.put("status", (Object)status);
        String key = "rim.aisinoHeadercollectinvoicedata-" + taxNo;
        JSONObject resultJson = ResultContant.createSuccessJSONObject();
        try (DLock lock = LockUtils.createDLockByMd5(key, "AisinoHeaderInvoiceDownServiceImpl.lock");){
            if (!lock.tryLock()) return resultJson;
            resultJson = this.downLoadInvoices(param, orgId);
            if (null == resultJson) return resultJson;
            if (ResultContant.isSuccess(resultJson) == false) return resultJson;
            JSONObject data = resultJson.getJSONObject("data");
            if (ObjectUtils.isEmpty((Object)data)) {
                LOGGER.info("{}-data\u8fd4\u56de\u4e3a\u7a7a", (Object)taxNo);
                JSONObject jSONObject = ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u8868\u5934\u6570\u636edata\u4e3a\u7a7a", (String)"AisinoHeaderInvoiceDownServiceImpl_1", (String)"imc-rim-common", (Object[])new Object[0]));
                return jSONObject;
            }
            int totalPages = data.getInteger("totalPages");
            JSONArray invoicesData = data.getJSONArray("invoicesData");
            if (CollectionUtils.isEmpty((Collection)invoicesData)) return resultJson;
            JSONArray tollInvoices = new JSONArray();
            DynamicObject syncLog = this.getDownLogDynamicObject(batchNo, taskNo, orgId, taxNo, 0, "1");
            this.insertHeaderSyncLog(syncLog, taxNo, data, tollInvoices, beginDate);
            this.downSurplusInvoice(syncLog, param, totalPages, orgId, tollInvoices, beginDate);
            if (CollectionUtils.isEmpty((Collection)tollInvoices)) return resultJson;
            batchNo = this.getDownBatchNo();
            DynamicObject syncLoToll = this.getDownLogDynamicObject(batchNo, taskNo, orgId, taxNo, 0, "1");
            this.saveAccount(syncLoToll, tollInvoices, beginDate);
            return resultJson;
        }
        catch (Exception e) {
            LOGGER.error("\u4e0b\u8f7d\u8868\u5934\u6570\u636e\u5931\u8d25" + taxNo, (Throwable)e);
            return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u8868\u5934\u6570\u636e\u5931\u8d25", (String)"AisinoHeaderInvoiceDownServiceImpl_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
    }

    private void downSurplusInvoice(DynamicObject syncLog, JSONObject paramJson, int page, Long orgId, JSONArray tollInvoices, Date beginDate) {
        if (page <= 1) {
            return;
        }
        JSONObject result = null;
        for (int currentPage = 2; currentPage <= page; ++currentPage) {
            paramJson.put("pageNum", (Object)currentPage);
            result = this.downLoadInvoices(paramJson, orgId);
            if (null == result || !ResultContant.isSuccess(result).booleanValue()) continue;
            JSONObject data = result.getJSONObject("data");
            if (ObjectUtils.isEmpty((Object)data)) {
                LOGGER.info("{}-data\u8fd4\u56de\u4e3a\u7a7a", (Object)syncLog.getString("tax_no"));
                return;
            }
            this.insertHeaderSyncLog(syncLog, syncLog.getString("tax_no"), data, tollInvoices, beginDate);
        }
    }

    private void insertHeaderSyncLog(DynamicObject syncLog, String taxNo, JSONObject dataJson, JSONArray tollInvoices, Date beginDate) {
        if (ObjectUtils.isEmpty((Object)dataJson)) {
            return;
        }
        JSONArray dataArray = dataJson.getJSONArray("invoicesData");
        if (CollectionUtils.isEmpty((Collection)dataArray)) {
            return;
        }
        LOGGER.info("\u8868\u5934\u4e0b\u8f7d\u5165\u540c\u6b65\u53f0\u8d26\u65e5\u5fd7\u8868:{},\u53d1\u7968\u6570\u91cf:{}", (Object)taxNo, (Object)dataArray.size());
        JSONObject newInvoice = null;
        JSONArray newDataArray = new JSONArray();
        for (int i = 0; i < dataArray.size(); ++i) {
            JSONObject invoice = dataArray.getJSONObject(i);
            newInvoice = AisinoConvertUtil.convertInvoiceMainInfo(invoice);
            String invoiceType = newInvoice.getString("invoiceType");
            if ("15".equals(invoiceType)) {
                tollInvoices.add((Object)newInvoice);
                continue;
            }
            newDataArray.add((Object)newInvoice);
        }
        if (CollectionUtils.isEmpty((Collection)newDataArray)) {
            return;
        }
        this.saveAccount(syncLog, newDataArray, beginDate);
    }

    private void saveAccount(DynamicObject syncLog, JSONArray dataArray, Date beginDate) {
        int totalNum = syncLog.getInt("total_num");
        this.insertHeaderSyncAccount(syncLog, beginDate, dataArray);
        syncLog.set("total_num", (Object)(totalNum += dataArray.size()));
        syncLog.set("modifytime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{syncLog});
    }

    @Override
    public JSONObject downLoadInvoices(JSONObject bodyParam, Long orgId) {
        AisinoDeductService deductService = new AisinoDeductService(orgId);
        return ((DeductService)deductService).queryInvoiceStatus(bodyParam);
    }
}

