/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.HolytaxInvoiceTypeEnum;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.impl.AisinoDeductService;
import kd.imc.rim.common.invoice.download.InvoiceDownService;
import kd.imc.rim.common.invoice.model.ConvertFieldUtil;
import kd.imc.rim.common.utils.AisinoConvertUtil;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.LockUtils;

public class AisinoInOutInvoiceDownServiceImpl
extends InvoiceDownService {
    private static Log LOGGER = LogFactory.getLog(AisinoInOutInvoiceDownServiceImpl.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JSONObject invoiceDown(DynamicObject downLog, RequestContext requestContext, Long orgId, String taxNo) {
        LOGGER.info("\u5f00\u59cb\u4e0b\u8f7d\u8fdb\u9500\u9879\u53d1\u7968{}-{}", (Object)taxNo, downLog.get("batch_no"));
        String taskNo = downLog.getString("taskno");
        Long invoice_type = DynamicObjectUtil.getDynamicObjectLongValue(downLog.get("invoice_type"));
        if (orgId == 0L) {
            orgId = requestContext.getOrgId();
        }
        if (this.checkOffFlag("3", taxNo)) {
            return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u5df2\u914d\u7f6e\u5173\u95ed,\u8bf7\u91cd\u65b0\u914d\u7f6e", (String)"AisinoInOutInvoiceDownServiceImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        int pageNum = 1;
        String status = "1";
        Date startDate = downLog.getDate("invoice_startdate");
        Date endDate = downLog.getDate("invoice_enddate");
        startDate = DateUtils.getDayStart(startDate);
        endDate = DateUtils.getDayEndTime(endDate);
        JSONObject param = new JSONObject();
        param.put("taxNo", (Object)taxNo);
        param.put("batchNo", (Object)taskNo);
        param.put("fplx", (Object)HolytaxInvoiceTypeEnum.getHolytaxType(invoice_type));
        param.put("pageNum", (Object)pageNum);
        param.put("status", (Object)status);
        param.put("startDate", (Object)DateUtils.format(startDate, "yyyy-MM-dd HH:mm:ss"));
        param.put("endDate", (Object)DateUtils.format(endDate, "yyyy-MM-dd HH:mm:ss"));
        String key = "rim.aisinoinoutCollectinvoicedata-" + downLog.get("id");
        JSONObject resultJson = ResultContant.createSuccessJSONObject();
        try (DLock lock = LockUtils.createDLockByMd5(key, "AisinoInOutInvoiceDownServiceImpl.lock");){
            if (lock.tryLock()) {
                resultJson = this.downLoadInvoices(param, orgId);
                String inout = downLog.getString("inout");
                if (null != resultJson && ResultContant.isSuccess(resultJson).booleanValue()) {
                    downLog.set("total_num", (Object)0);
                    JSONObject data = resultJson.getJSONObject("data");
                    if (ObjectUtils.isEmpty((Object)data)) {
                        resultJson = ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u5168\u91cf\u6570\u636edata\u4e3a\u7a7a", (String)"AisinoInOutInvoiceDownServiceImpl_1", (String)"imc-rim-common", (Object[])new Object[0]));
                        this.setDescription(downLog, resultJson);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
                        JSONObject jSONObject = resultJson;
                        return jSONObject;
                    }
                    int totalPages = data.getInteger("totalPages");
                    downLog.set("gov_status", (Object)"8");
                    downLog.set("download_errcode", (Object)"3");
                    if (CollectionUtils.isEmpty((Collection)data.getJSONArray("invoicesData"))) {
                        downLog.set("gov_status", (Object)"9");
                        downLog.set("download_errcode", (Object)"4");
                    }
                    this.insertInputOutDataSyncLog(downLog, data, inout);
                    this.downSurplusInvoice(downLog, param, totalPages, orgId, inout);
                    downLog.set("modifytime", (Object)new Date());
                    this.setDescription(downLog, "");
                } else {
                    downLog.set("download_errcode", (Object)"5");
                    this.setDescription(downLog, resultJson);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
                return resultJson;
            }
            resultJson = ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u8be5\u6279\u6b21\u6b63\u5728\u5728\u4e0b\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AisinoInOutInvoiceDownServiceImpl_2", (String)"imc-rim-common", (Object[])new Object[0]));
            return resultJson;
        }
        catch (Exception e) {
            LOGGER.error("\u4e0b\u8f7d\u5168\u91cf\u53d1\u7968\u5931\u8d25" + taxNo, (Throwable)e);
            this.setDescription(downLog, e.getMessage());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
            return ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u5168\u91cf\u53d1\u7968\u5931\u8d25", (String)"AisinoInOutInvoiceDownServiceImpl_3", (String)"imc-rim-common", (Object[])new Object[0]));
        }
    }

    private void downSurplusInvoice(DynamicObject downLog, JSONObject paramJson, int page, Long orgId, String inout) {
        if (page <= 1) {
            return;
        }
        JSONObject result = null;
        for (int currentPage = 2; currentPage <= page; ++currentPage) {
            paramJson.put("pageNum", (Object)currentPage);
            result = this.downLoadInvoices(paramJson, orgId);
            if (null == result || !ResultContant.isSuccess(result).booleanValue()) continue;
            JSONObject data = result.getJSONObject("data");
            if (ObjectUtils.isEmpty((Object)data)) {
                LOGGER.info("{}-data\u8fd4\u56de\u4e3a\u7a7a", (Object)downLog.getString("tax_no"));
                return;
            }
            this.insertInputOutDataSyncLog(downLog, data, inout);
        }
    }

    @Override
    public void insertInputOutDataSyncLog(DynamicObject downLog, JSONObject dataJson, String downDataType) {
        if (ObjectUtils.isEmpty((Object)dataJson)) {
            return;
        }
        JSONArray fullDataArray = dataJson.getJSONArray("invoicesData");
        String batchNo = downLog.getString("batch_no");
        Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(downLog.get("org"));
        int totalNum = downLog.getInt("total_num");
        if (!CollectionUtils.isEmpty((Collection)fullDataArray)) {
            totalNum += fullDataArray.size();
            fullDataArray = this.convertInvoiceList(fullDataArray);
            this.insertSyncInputOutDataAccount(fullDataArray, batchNo, "5", "3", orgId, downDataType);
        }
        downLog.set("total_num", (Object)totalNum);
    }

    private JSONArray convertInvoiceList(JSONArray aisinoInvoiceList) {
        JSONArray invoiceList = new JSONArray();
        JSONObject aisinoInvoice = null;
        for (int i = 0; i < aisinoInvoiceList.size(); ++i) {
            aisinoInvoice = aisinoInvoiceList.getJSONObject(i);
            invoiceList.add((Object)this.convertInvoice(aisinoInvoice));
        }
        return invoiceList;
    }

    private JSONObject convertInvoice(JSONObject aisinoInvoice) {
        LOGGER.info("\u822a\u4fe1\u4e0b\u8f7d\u53d1\u7968\u4fe1\u606f\uff1a" + aisinoInvoice);
        String holytaxInvoiceType = aisinoInvoice.getString("fplxs");
        Long invoiceType = HolytaxInvoiceTypeEnum.getInvoiceTypeByHolytaxType(holytaxInvoiceType);
        invoiceType = AisinoConvertUtil.getAlleleInvoiceType(aisinoInvoice.getString("invoiceNo"), invoiceType);
        aisinoInvoice.put("invoiceType", (Object)invoiceType);
        if (InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoiceType)) {
            aisinoInvoice.put("invoiceCode", (Object)"");
        }
        if (StringUtils.isNotEmpty((CharSequence)aisinoInvoice.getString("jkshm"))) {
            aisinoInvoice.put("invoiceNo", (Object)aisinoInvoice.getString("jkshm"));
        }
        aisinoInvoice.put("deductionPurpose", (Object)AisinoConvertUtil.deductionPurposeConvert(aisinoInvoice.getString("rzlx")));
        String checkFlag = aisinoInvoice.getString("gxzt");
        String checkAuthenticateFlag = aisinoInvoice.getString("rzzt");
        String authenticateFlag = "0";
        if ("1".equals(checkAuthenticateFlag)) {
            authenticateFlag = "2";
        } else if ("1".equals(checkFlag)) {
            authenticateFlag = "1";
        }
        aisinoInvoice.put("checkFlag", (Object)checkFlag);
        aisinoInvoice.put("checkAuthenticateFlag", (Object)checkAuthenticateFlag);
        aisinoInvoice.put("authenticateFlag", (Object)authenticateFlag);
        if (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) {
            aisinoInvoice.put("deductionPurpose", (Object)aisinoInvoice.getString("yt"));
        }
        String cancellationMark = aisinoInvoice.getString("cancellationMark");
        aisinoInvoice.put("invoiceStatus", (Object)"0");
        if ("Y".equals(cancellationMark)) {
            aisinoInvoice.put("invoiceStatus", (Object)"2");
        } else if ("3".equals(cancellationMark)) {
            aisinoInvoice.put("invoiceStatus", (Object)"3");
        } else if ("7".equals(cancellationMark) || "8".equals(cancellationMark)) {
            aisinoInvoice.put("invoiceStatus", (Object)cancellationMark);
        }
        BigDecimal totalAmount = aisinoInvoice.getBigDecimal("totalAmount");
        aisinoInvoice.put("type", (Object)"0");
        if (totalAmount != null && totalAmount.compareTo(BigDecimal.ZERO) < 0) {
            aisinoInvoice.put("type", (Object)"1");
        }
        String itemsKey = "detailList";
        aisinoInvoice.put("gxsj", (Object)DateUtils.getStandardDate(aisinoInvoice.getString("gxsj")));
        aisinoInvoice.put("rzrq", (Object)DateUtils.getStandardDate(aisinoInvoice.getString("rzrq")));
        Object entity = ConvertFieldUtil.convertCheckEntityByInvoiceType(invoiceType, aisinoInvoice, itemsKey);
        JSONObject invoice = JSONObject.parseObject((String)JSONObject.toJSONString((Object)entity));
        invoice.put("invoiceType", (Object)InputInvoiceTypeEnum.getAwsType(invoice.getLong("invoiceType")));
        invoice.put("notDeductibleType", (Object)aisinoInvoice.getString("bdkyy"));
        String invoiceDate = "";
        String selectAuthenticateTime = "";
        String selectTime = "";
        if (invoice.getDate("invoiceDate") != null) {
            invoiceDate = DateUtils.format(invoice.getDate("invoiceDate"));
        }
        if (invoice.getDate("selectTime") != null) {
            selectTime = DateUtils.format(invoice.getDate("selectTime"));
        }
        if (invoice.getDate("authenticateTime") != null) {
            selectAuthenticateTime = DateUtils.format(invoice.getDate("authenticateTime"));
        }
        invoice.put("checkFlag", (Object)checkFlag);
        invoice.put("checkAuthenticateFlag", (Object)checkAuthenticateFlag);
        invoice.put("authenticateFlag", (Object)authenticateFlag);
        invoice.put("invoiceDate", (Object)invoiceDate);
        invoice.put("selectTime", (Object)selectTime);
        invoice.put("selectAuthenticateTime", (Object)selectAuthenticateTime);
        return invoice;
    }

    @Override
    public JSONObject downLoadInvoices(JSONObject bodyParam, Long orgId) {
        AisinoDeductService deductService = new AisinoDeductService(orgId);
        return ((DeductService)deductService).downFullInvoice(bodyParam);
    }
}

