/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.impl.HolytaxDeductService;
import kd.imc.rim.common.invoice.download.InputOutInvoiceApplyService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.DateUtils;

public class HolytaxInputOutInvoiceApplyServiceImpl
extends InputOutInvoiceApplyService {
    private static final Log LOGGER = LogFactory.getLog(HolytaxInputOutInvoiceApplyServiceImpl.class);

    @Override
    public JSONObject applyInputOutDownInvoice(Long logId, DynamicObject initDynamicObject, String invoiceType, String dataType, Long orgId, String taxNo, Date begin, Date end) {
        boolean isEndApply;
        JSONObject requestMap = new JSONObject();
        requestMap.put("taxNo", (Object)taxNo);
        requestMap.put("fplxs", (Object)invoiceType);
        requestMap.put("sjlxs", (Object)dataType);
        requestMap.put("kprqq", (Object)DateUtils.format(begin));
        requestMap.put("kprqz", (Object)DateUtils.format(end));
        HolytaxDeductService deductService = new HolytaxDeductService(orgId);
        JSONObject resultJson = null;
        try {
            resultJson = ((DeductService)deductService).applyFullInvoice(requestMap);
        }
        catch (MsgException e1) {
            resultJson = ResultContant.createJSONObject(e1.getErrorCode(), e1.getErrorMsg());
            LOGGER.info("\u8fdb\u9500\u9879\u7533\u8bf7\u5931\u8d25:{},{}", (Object)taxNo, (Object)resultJson);
        }
        catch (Exception e2) {
            resultJson = ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u8fdb\u9500\u9879\u7533\u8bf7\u5931\u8d25", (String)"HolytaxInputOutInvoiceApplyServiceImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
            LOGGER.error("\u8fdb\u9500\u9879\u7533\u8bf7\u5931\u8d25:" + taxNo, (Throwable)e2);
        }
        if (resultJson == null) {
            return null;
        }
        String description = resultJson.getString("description");
        boolean bl = isEndApply = ResultContant.isSuccess(resultJson) == false && (StringUtils.contains((CharSequence)description, (CharSequence)"\u5168\u7535\u8bd5\u70b9\u4f01\u4e1a") || StringUtils.contains((CharSequence)description, (CharSequence)"\u8bc1\u4e66\u72b6\u6001\u6807\u8bb0\u6709\u8bef") || StringUtils.contains((CharSequence)description, (CharSequence)"\u672a\u914d\u7f6e\u8f6f\u8bc1\u4e66"));
        if (isEndApply) {
            throw new MsgException(resultJson.getString("errcode"), description);
        }
        this.dealResult(resultJson, initDynamicObject, logId, orgId, taxNo, invoiceType, null);
        return resultJson;
    }

    @Override
    public boolean checkDownCustom(String inout, String invoiceType, String taxNo) {
        if ("87".equals(invoiceType) || InputInvoiceTypeEnum.WITHHOLDING.getAwsType().equals(invoiceType) || "88".equals(invoiceType)) {
            return false;
        }
        if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getAwsType().equals(invoiceType) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getAwsType().equals(invoiceType) || InputInvoiceTypeEnum.USEDCAR_ELE_INVOICE.getAwsType().equals(invoiceType)) {
            return false;
        }
        return super.checkDownCustom(inout, invoiceType, taxNo);
    }
}

