/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.helper.RecognitionCheckHelper;
import kd.imc.rim.common.invoice.checknew.model.CheckParam;
import kd.imc.rim.common.invoice.checknew.model.CheckResult;
import kd.imc.rim.common.invoice.deduction.DeductionDownService;
import kd.imc.rim.common.invoice.download.InvoiceDealService;
import kd.imc.rim.common.invoice.download.impl.InOutputInvoiceDownServiceImpl;
import kd.imc.rim.common.invoice.model.ConvertFieldUtil;
import kd.imc.rim.common.invoice.recognitionnew.task.FileSaveTask;
import kd.imc.rim.common.invoice.save.InvoiceSaveResult;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.service.InvoiceLog;
import kd.imc.rim.common.service.SimplyCheckService;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.FileUploadUtils;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.InvoiceCheckUtils;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.LockUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.SysParamUtil;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.extract.ZipExtractUtil;
import kd.imc.rim.file.utils.BigDecimalUtil;
import org.apache.commons.lang3.tuple.Pair;

public class InputInvoiceDealService
extends InvoiceDealService
implements Callable<Boolean> {
    private RequestContext rc;
    private Object id;
    private static final Log LOGGER = LogFactory.getLog(InputInvoiceDealService.class);
    private static final String[] AIR_TRAIN_ELE_COVER_FIELDS = new String[]{"invoiceNo", "invoiceDate", "salerName", "salerTaxNo", "invoiceAmount", "totalAmount", "invoiceStatus", "deductionPurpose", "effectiveTaxAmount", "invoiceRiskLevel", "authenticateFlag", "selectTime", "checkAuthenticateFlag", "selectAuthenticateTime", "taxPeriod", "buyerTaxNo", "manageStatus", "notDeductibleType"};

    public InputInvoiceDealService(RequestContext rc, Object id) {
        this.rc = rc;
        this.id = id;
    }

    @Override
    public void dealSingle(RequestContext requestContext, DynamicObject data) {
        Integer handleNum;
        Integer n = handleNum = Integer.valueOf(data.getInt("handle_num"));
        Integer n2 = handleNum = Integer.valueOf(handleNum + 1);
        data.set("handle_num", (Object)handleNum);
        String serialNo = data.getString("serial_no");
        String key = "rim.dealinputinvoice-" + serialNo;
        int maxHandleNum = 3;
        try (DLock lock = LockUtils.createDLockByMd5(key, ResManager.loadKDString((String)"\u5904\u7406\u8fdb\u9879\u53d1\u7968", (String)"InputInvoiceDealService_0", (String)"imc-rim-common", (Object[])new Object[0]));){
            if (lock.tryLock()) {
                String dataType = data.getString("data_type");
                String invoiceJsonStr = data.getString("invoice_json_tag");
                Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(data.get("invoice_type"));
                JSONObject invoiceJson = JSONObject.parseObject((String)invoiceJsonStr);
                invoiceJson.put("invoiceType", (Object)invoiceType);
                String buyerTaxNo = CommonUtils.getJsonValue((Map<String, Object>)invoiceJson, String.class, "buyerTaxNo", "purchaserUnifiedSocialCreditCode", "deptTaxNo");
                Long configOrg = this.getOrgIdByTaxNo(buyerTaxNo);
                invoiceJson.put("taxNo", (Object)buyerTaxNo);
                DeductionUtils.setTaxDownCollectInfo(invoiceJson);
                InvoiceSaveService service = InvoiceSaveService.newInstance(invoiceType.toString());
                Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(data.get("org"));
                if (configOrg != null && configOrg > 0L) {
                    orgId = configOrg;
                } else if (orgId <= 0L) {
                    orgId = requestContext.getOrgId();
                }
                invoiceJson.put("org_id", (Object)orgId);
                invoiceJson.put("rim_user", (Object)requestContext.getUserId());
                Long mainInvoiceType = 0L;
                if ("3".equals(dataType) || "2".equals(dataType)) {
                    if ("2".equals(dataType)) {
                        invoiceJson.put("allowDeduction", (Object)"0");
                    }
                    this.handleCompleteInvoice(data, dataType, invoiceType, invoiceJson, service);
                } else if ("1".equals(dataType)) {
                    this.handleHeaderInvoice(requestContext, data, invoiceType, orgId, invoiceJson, service);
                } else if ("4".equals(dataType)) {
                    mainInvoiceType = this.handleInvoiceFile(data, invoiceType, invoiceJson, service);
                    maxHandleNum = 100;
                } else if ("9".equals(dataType)) {
                    this.handleAgricInvoice(data, invoiceType, invoiceJson, service);
                } else {
                    data.set("sync_status", (Object)"0");
                }
                data.set("modifytime", (Object)new Date());
                if (!"1".equals(data.getString("sync_status")) && handleNum > maxHandleNum) {
                    data.set("sync_status", (Object)"0");
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
                String syncStatus = data.getString("sync_status");
                if ((InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) && !"4".equals(dataType)) {
                    syncStatus = "1";
                }
                this.updateDownAccount(syncStatus, serialNo, data.getString("fpy_serial_no"), data.getString("inout"), invoiceType, mainInvoiceType);
            }
        }
        catch (Throwable e) {
            data.set("modifytime", (Object)new Date());
            if (!"1".equals(data.getString("sync_status")) && handleNum > 3) {
                data.set("sync_status", (Object)"0");
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
            LOGGER.error("InputInvoiceDownDealTask-error:" + serialNo, e);
        }
    }

    private void handleAgricInvoice(DynamicObject data, Long invoiceType, JSONObject invoiceJson, InvoiceSaveService service) {
        String serialNo;
        block17: {
            invoiceJson.put("downResource", (Object)"agricDown");
            String invoiceCode = invoiceJson.getString("invoiceCode");
            String invoiceNo = invoiceJson.getString("invoiceNo");
            QFilter invoiceTypeFilter = new QFilter("invoice_type", "=", (Object)invoiceType);
            String tenantNo = TenantUtils.getTenantNo();
            QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
            QFilter invoiceCodeFilter = new QFilter("invoice_code", "=", (Object)kd.imc.rim.common.utils.StringUtils.trimToEmpty((String)invoiceCode));
            QFilter invoiceNoFilter = new QFilter("invoice_no", "=", (Object)invoiceNo);
            DynamicObject serialObject = BusinessDataServiceHelper.loadSingle((String)"rim_invoice", (String)"id,serial_no", (QFilter[])new QFilter[]{invoiceCodeFilter, invoiceNoFilter, invoiceTypeFilter, tenantFilter});
            serialNo = "";
            if (serialObject != null) {
                serialNo = serialObject.getString("serial_no");
                DynamicObject mainDynamicObject = BusinessDataServiceHelper.loadSingle((Object)serialObject.get("id"), (String)"rim_invoice");
                service.setDownAgricData(invoiceType, mainDynamicObject, invoiceJson);
                String invoiceStatus = invoiceJson.getString("invoiceStatus");
                mainDynamicObject.set("invoice_status", (Object)invoiceStatus);
                String etaxInvoiceNo = invoiceJson.getString("etaxInvoiceNo");
                if (kd.imc.rim.common.utils.StringUtils.isNotEmpty((CharSequence)etaxInvoiceNo)) {
                    mainDynamicObject.set("electronic_no", (Object)etaxInvoiceNo);
                }
                service.setSourceAndRiskLevel(invoiceJson, mainDynamicObject);
                service.setMainInvoiceInfo(mainDynamicObject);
                try (TXHandle h = TX.required();){
                    try {
                        String entity = InputInvoiceTypeEnum.getEntity(invoiceType);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainDynamicObject});
                        QFilter serialFilter = new QFilter("serial_no", "=", (Object)serialNo);
                        DynamicObject idObject = QueryServiceHelper.queryOne((String)entity, (String)"id,serial_no", (QFilter[])new QFilter[]{tenantFilter, serialFilter});
                        if (idObject != null) {
                            DynamicObject invoiceBody = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)entity);
                            service.setDownAgricData(invoiceType, invoiceBody, invoiceJson);
                            invoiceBody.set("invoice_status", (Object)invoiceStatus);
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoiceBody});
                        }
                        InputInvoiceDealService.saveLog(invoiceJson, serialNo);
                        break block17;
                    }
                    catch (Throwable e) {
                        LOGGER.error("\u7a0e\u76d8\u4e0b\u8f7d\u66f4\u65b0\u53d1\u7968\u62a5\u9519", e);
                        h.markRollback();
                        throw e;
                    }
                }
            }
            InvoiceSaveResult saveResult = service.save(invoiceJson);
            serialNo = saveResult.getSerialNo();
            InputInvoiceDealService.saveLog(invoiceJson, serialNo);
        }
        data.set("sync_status", (Object)"1");
        data.set("fpy_serial_no", (Object)serialNo);
    }

    private static void saveLog(JSONObject invoice, String serialNo) {
        if (invoice == null) {
            return;
        }
        JSONObject logInfo = new JSONObject();
        logInfo.put("processingStatus", (Object)invoice.getString("processingStatus"));
        logInfo.put("farmProductType", (Object)invoice.getString("farmProductType"));
        logInfo.put("processType", (Object)invoice.getString("processType"));
        logInfo.put("selfProducedAmount", (Object)invoice.getString("selfProducedAmount"));
        logInfo.put("invoiceStatus", (Object)invoice.getString("invoiceStatus"));
        logInfo.put("traceId", (Object)RequestContext.get().getTraceId());
        InvoiceLog.insert("deduct_authenticate", serialNo, logInfo.toJSONString(), invoice.getLong("org_id"), CollectTypeEnum.PC_SHUIPAN.getName(), CollectTypeEnum.PC_SHUIPAN.getCode());
    }

    private long handleInvoiceFile(DynamicObject data, Long invoiceType, JSONObject invoiceJson, InvoiceSaveService service) {
        long orgId;
        String tenantNo;
        QFilter tenantFilter;
        QFilter invoiceNoFilter;
        DynamicObject serialObject;
        String invoiceCode = invoiceJson.getString("invoiceCode");
        String invoiceNo = invoiceJson.getString("invoiceNo");
        boolean maxHandleNumFlag = false;
        try {
            int handleNum = data.getInt("handle_num");
            int fileHandlNum = InvoiceDownloadConstant.getPageSizeFromConfig(3, "input__file_handl_num");
            maxHandleNumFlag = handleNum > fileHandlNum;
        }
        catch (Exception e) {
            LOGGER.info("\u83b7\u53d6\u6700\u5927\u5904\u7406\u914d\u7f6e\u9519\u8bef");
        }
        QFilter invoiceTypeFilter = null;
        QFilter invoiceCodeFilter = null;
        if (invoiceType != 0L) {
            invoiceTypeFilter = new QFilter("invoice_type", "=", (Object)invoiceType);
            invoiceCodeFilter = !InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType) && InputInvoiceTypeEnum.isEleInvoice(invoiceType) == false ? new QFilter("invoice_code", "=", (Object)invoiceCode) : new QFilter("invoice_code", "=", (Object)"");
        }
        if ((serialObject = BusinessDataServiceHelper.loadSingle((String)"rim_invoice", (String)"id,serial_no,original_state, org, invoice_type", (QFilter[])new QFilter[]{invoiceCodeFilter, invoiceNoFilter = new QFilter("invoice_no", "=", (Object)invoiceNo), invoiceTypeFilter, tenantFilter = new QFilter("tenant_no", "=", (Object)(tenantNo = TenantUtils.getTenantNo()))})) == null) {
            LOGGER.info("\u6570\u7535\u6587\u4ef6\u4e0b\u8f7d\uff0c\u53d1\u7968\u672a\u5165\u5e93\uff0c\u8df3\u8fc7\uff0c\u53d1\u7968\u53f7\u7801\uff1a{}", (Object)invoiceNo);
            return 0L;
        }
        long mainInvoiceType = DynamicObjectUtil.getDynamicObjectLongValue(serialObject.get("invoice_type"));
        String serialNo = serialObject.getString("serial_no");
        if (invoiceType <= 0L) {
            invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(serialObject.get("invoice_type"));
            service = InvoiceSaveService.newInstance(invoiceType.toString());
        }
        boolean electricFlag = InputInvoiceTypeEnum.isEleInvoice(invoiceType);
        String originalStateElectric = "0";
        if ("1".equals(serialObject.getString("original_state"))) {
            if (!electricFlag) {
                data.set("fpy_serial_no", (Object)serialNo);
                data.set("sync_status", (Object)"1");
                return mainInvoiceType;
            }
            originalStateElectric = "1";
        }
        QFilter serialFilter = new QFilter("serial_no", "=", (Object)serialNo);
        DynamicObject fileIdDynamicObject = QueryServiceHelper.queryOne((String)"rim_invoice_file", (String)"id", (QFilter[])new QFilter[]{tenantFilter, serialFilter});
        boolean genFlag = false;
        boolean over = false;
        if (fileIdDynamicObject == null) {
            fileIdDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice_file");
            fileIdDynamicObject.set("tenant_no", (Object)tenantNo);
            fileIdDynamicObject.set("serial_no", (Object)serialNo);
            fileIdDynamicObject.set("create_time", (Object)new Date());
            fileIdDynamicObject.set("original_filename", (Object)invoiceNo);
            over = true;
        } else {
            fileIdDynamicObject = BusinessDataServiceHelper.loadSingle((Object)fileIdDynamicObject.get("id"), (String)"rim_invoice_file");
            genFlag = "2".equals(fileIdDynamicObject.getString("original_state"));
            over = kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)fileIdDynamicObject.getString("ofd_url")) && kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)fileIdDynamicObject.getString("image_url")) && kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)fileIdDynamicObject.getString("snapshot_url")) && kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)fileIdDynamicObject.getString("xml_url")) && kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)fileIdDynamicObject.getString("pdf_url"));
        }
        fileIdDynamicObject.set("update_time", (Object)new Date());
        String ofdFile = invoiceJson.getString("ofdFile");
        String xmlFile = invoiceJson.getString("xmlFile");
        String pdfFile = invoiceJson.getString("pdfFile");
        String snapshotUrl = invoiceJson.getString("snapshotUrl");
        if (kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)snapshotUrl)) {
            snapshotUrl = invoiceJson.getString("snapshotFile");
        }
        String originalState = kd.imc.rim.common.utils.StringUtils.isNotEmpty((CharSequence)ofdFile) || kd.imc.rim.common.utils.StringUtils.isNotEmpty((CharSequence)pdfFile) || kd.imc.rim.common.utils.StringUtils.isNotEmpty((CharSequence)xmlFile) ? "1" : "0";
        String fileType = "2";
        if (kd.imc.rim.common.utils.StringUtils.isNotEmpty((CharSequence)xmlFile)) {
            Pair<String, byte[]> fileBytePair = FileUtils.downLoadFileToByte(xmlFile, serialNo + "_zip");
            if (fileBytePair == null || fileBytePair.getRight() == null) {
                if (maxHandleNumFlag) {
                    data.set("sync_status", (Object)"0");
                }
                return mainInvoiceType;
            }
            Map<String, String> zipFileMap = ZipExtractUtil.extractFileForXml((byte[])fileBytePair.getRight());
            if (CollectionUtils.isEmpty(zipFileMap)) {
                LOGGER.info("{}-zip\u4e3a\u7a7a", (Object)xmlFile);
                if (maxHandleNumFlag) {
                    data.set("sync_status", (Object)"0");
                }
                return mainInvoiceType;
            }
            String xmlUrl = "";
            String fileName = serialNo + "_xml" + '.' + "xml";
            for (Map.Entry<String, String> entry : zipFileMap.entrySet()) {
                String xmlStr = entry.getValue();
                if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)xmlStr)) continue;
                try (ByteArrayInputStream xbrlStream = new ByteArrayInputStream(xmlStr.getBytes("utf-8"));){
                    xmlUrl = FileUploadUtils.upload(FileUploadUtils.getInvoiceDir("invoice") + fileName, fileName, xbrlStream);
                    break;
                }
                catch (Exception e) {
                    LOGGER.error("\u5904\u7406xml\u6587\u4ef6\u8bc6\u522b:" + xmlFile, (Throwable)e);
                }
            }
            if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)xmlUrl)) {
                if (maxHandleNumFlag) {
                    data.set("sync_status", (Object)"0");
                }
                return mainInvoiceType;
            }
            if (electricFlag) {
                fileIdDynamicObject.set("tax_xml_url", (Object)xmlUrl);
                if ("0".equals(originalStateElectric) || over) {
                    this.setElecPersonFile(xmlUrl, fileIdDynamicObject, "xml_url", genFlag);
                }
            } else {
                fileIdDynamicObject.set("xml_url", (Object)xmlUrl);
            }
            fileType = "9";
        }
        if (kd.imc.rim.common.utils.StringUtils.isNotEmpty((CharSequence)pdfFile)) {
            if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)(pdfFile = FileUtils.downLoadAndUpload(pdfFile, serialNo + "_pdf")))) {
                if (maxHandleNumFlag) {
                    data.set("sync_status", (Object)"0");
                }
                return mainInvoiceType;
            }
            if (electricFlag) {
                fileIdDynamicObject.set("tax_pdf_url", (Object)pdfFile);
                if ("0".equals(originalStateElectric) || over) {
                    this.setElecPersonFile(pdfFile, fileIdDynamicObject, "pdf_url", genFlag);
                }
            } else {
                fileIdDynamicObject.set("pdf_url", (Object)pdfFile);
            }
            fileType = "1";
        }
        if (kd.imc.rim.common.utils.StringUtils.isNotEmpty((CharSequence)ofdFile)) {
            if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)(ofdFile = FileUtils.downLoadAndUpload(ofdFile, serialNo + "_ofd")))) {
                if (maxHandleNumFlag) {
                    data.set("sync_status", (Object)"0");
                }
                return mainInvoiceType;
            }
            if (electricFlag) {
                fileIdDynamicObject.set("tax_ofd_url", (Object)ofdFile);
                if ("0".equals(originalStateElectric) || over) {
                    this.setElecPersonFile(ofdFile, fileIdDynamicObject, "ofd_url", genFlag);
                }
            } else {
                fileIdDynamicObject.set("ofd_url", (Object)ofdFile);
            }
            fileType = "4";
        }
        if (kd.imc.rim.common.utils.StringUtils.isNotEmpty((CharSequence)snapshotUrl)) {
            if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)(snapshotUrl = FileUtils.downLoadAndUpload(snapshotUrl, serialNo + "_snap")))) {
                if (maxHandleNumFlag) {
                    data.set("sync_status", (Object)"0");
                }
                return mainInvoiceType;
            }
            if (electricFlag) {
                if ("0".equals(originalStateElectric)) {
                    this.setElecPersonFile(snapshotUrl, fileIdDynamicObject, "snapshot_url", genFlag);
                    this.setElecPersonFile(snapshotUrl, fileIdDynamicObject, "image_url", genFlag);
                }
            } else {
                fileIdDynamicObject.set("snapshot_url", (Object)snapshotUrl);
                fileIdDynamicObject.set("image_url", (Object)snapshotUrl);
            }
        } else if (genFlag) {
            fileIdDynamicObject.set("snapshot_url", (Object)"");
            fileIdDynamicObject.set("image_url", (Object)"");
        }
        fileIdDynamicObject.set("original_state", (Object)originalState);
        if ("1".equals(originalState) && "0".equals(originalStateElectric)) {
            fileIdDynamicObject.set("original_type", (Object)fileType);
        } else if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)fileIdDynamicObject.getString("original_type"))) {
            fileIdDynamicObject.set("original_type", (Object)fileType);
        }
        fileIdDynamicObject.set("rotation_angle", null);
        fileIdDynamicObject.set("region", null);
        fileIdDynamicObject.set("pixel", null);
        String needSign = "0";
        if ("0".equals(originalStateElectric) && electricFlag && (orgId = DynamicObjectUtil.getDynamicObjectLongValue(serialObject.get("org"))) > 0L) {
            needSign = SysParamUtil.getSysParamByOrgId(orgId, "tax_file_auto_sign") ? "1" : "0";
        }
        try (TXHandle h = TX.required();){
            try {
                FileSaveTask.setFileType(fileIdDynamicObject, "");
                String originalType = fileIdDynamicObject.getString("original_type");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fileIdDynamicObject});
                originalState = electricFlag ? needSign : originalState;
                DynamicObject mainDynamicObject = BusinessDataServiceHelper.loadSingle((Object)serialObject.get("id"), (String)"rim_invoice");
                mainDynamicObject.set("modifytime", (Object)new Date());
                if ("1".equals(originalState)) {
                    mainDynamicObject.set("original_state", (Object)originalState);
                    mainDynamicObject.set("original_time", (Object)new Date());
                    service.setMainInvoiceInfo(mainDynamicObject);
                }
                if ("4".equals(originalType)) {
                    InvoiceSaveService.setExtInfo(mainDynamicObject, InvoiceSaveConstant.EXT_FILETYPE_NOW, "ofd");
                } else if ("1".equals(originalType)) {
                    InvoiceSaveService.setExtInfo(mainDynamicObject, InvoiceSaveConstant.EXT_FILETYPE_NOW, "pdf");
                } else if ("9".equals(originalType)) {
                    InvoiceSaveService.setExtInfo(mainDynamicObject, InvoiceSaveConstant.EXT_FILETYPE_NOW, "xml");
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainDynamicObject});
                data.set("fpy_serial_no", (Object)serialNo);
                data.set("sync_status", (Object)"1");
            }
            catch (Throwable e) {
                LOGGER.error("\u4fdd\u5b58\u53d1\u7968\u6587\u4ef6\u62a5\u9519", e);
                h.markRollback();
                throw e;
            }
        }
        return mainInvoiceType;
    }

    private void setElecPersonFile(String filePath, DynamicObject fileIdDynamicObject, String propertyName, boolean genFlag) {
        if ((kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)fileIdDynamicObject.getString(propertyName)) || genFlag) && !kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)filePath)) {
            fileIdDynamicObject.set(propertyName, (Object)filePath);
        }
    }

    private void handleCompleteInvoice(DynamicObject data, String dataType, Long invoiceType, JSONObject invoiceJson, InvoiceSaveService service) {
        String serialNo;
        String checkStatus = invoiceJson.getString("checkStatus");
        if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)checkStatus)) {
            checkStatus = "1";
        }
        invoiceJson.put("checkStatus", (Object)checkStatus);
        DeductionUtils.deleteCheckCache(invoiceJson, invoiceType);
        if (InvoiceConvertUtils.isSaleListInvoiceType(invoiceType)) {
            RecognitionCheckHelper.markSaleListByCheckResult(invoiceJson);
        }
        if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType)) {
            this.convertAirEle(invoiceJson);
        }
        if (InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType)) {
            this.convertTrainEle(invoiceJson);
        }
        String remark = invoiceJson.getString("remark");
        BigDecimal totalAmount = BigDecimalUtil.transDecimal((Object)invoiceJson.get((Object)"totalAmount"));
        if (Arrays.asList(InputInvoiceTypeEnum.getRedInvoiceType()).contains(invoiceType) && totalAmount.compareTo(BigDecimal.ZERO) < 0) {
            String originalInvoiceCode = invoiceJson.getString("originalInvoiceCode");
            String originalInvoiceNo = invoiceJson.getString("originalInvoiceNo");
            if (kd.imc.rim.common.utils.StringUtils.isNotEmpty((CharSequence)remark)) {
                remark = remark.replaceAll("\uff1a", ":");
                if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)originalInvoiceNo)) {
                    originalInvoiceNo = InvoiceConvertUtils.extractRemarkInvoiceCodeAndNo(remark, "\u53f7\u7801");
                }
                if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)originalInvoiceCode) && kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)(originalInvoiceCode = InvoiceConvertUtils.extractRemarkInvoiceCodeAndNo(remark, "\u539f\u84dd\u7968\u4ee3\u7801")))) {
                    originalInvoiceCode = InvoiceConvertUtils.extractRemarkInvoiceCodeAndNo(remark, "\u53d1\u7968\u4ee3\u7801");
                }
                invoiceJson.put("originalInvoiceCode", (Object)originalInvoiceCode);
                invoiceJson.put("originalInvoiceNo", (Object)originalInvoiceNo);
            }
        }
        if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)(serialNo = DeductionDownService.handleTaxFullInvoice(service, invoiceJson)))) {
            service.notOverrideOrg(invoiceJson);
            invoiceJson.put("needUserRelation", (Object)"0");
            InvoiceSaveResult saveResult = service.save(invoiceJson);
            serialNo = saveResult.getSerialNo();
        }
        invoiceJson.put("serialNo", (Object)serialNo);
        String isSaleListInvoice = invoiceJson.getString("isSaleListInvoice");
        if ("1".equals(isSaleListInvoice)) {
            RecognitionCheckHelper recognitionCheckHelper = new RecognitionCheckHelper();
            recognitionCheckHelper.dealInvoiceAttachRelation(invoiceJson);
        }
        data.set("fpy_serial_no", (Object)serialNo);
        if ("3".equals(dataType)) {
            data.set("sync_status", (Object)"1");
        } else {
            data.set("sync_status", (Object)"0");
        }
    }

    private void convertTrainEle(JSONObject invoiceJson) {
        JSONArray specBusinessInfoArray;
        JSONObject jsonObject;
        if (invoiceJson == null) {
            return;
        }
        String invoiceNo = invoiceJson.getString("invoiceNo");
        JSONArray items = invoiceJson.getJSONArray("items");
        if (!CollectionUtils.isEmpty((Collection)items)) {
            for (int i = 0; i < items.size(); ++i) {
                jsonObject = items.getJSONObject(i);
                if (jsonObject == null) continue;
                String goodsName = jsonObject.getString("goodsName");
                String goodsCode = jsonObject.getString("goodsCode");
                String detailAmount = jsonObject.getString("detailAmount");
                String taxAmount = jsonObject.getString("taxAmount");
                String taxRate = jsonObject.getString("taxRate");
                if (!kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)goodsName) || !goodsName.contains("\u7968\u4ef7")) continue;
                invoiceJson.put("taxRate", (Object)taxRate);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(specBusinessInfoArray = invoiceJson.getJSONArray("specBusinessInfo"))) && (jsonObject = specBusinessInfoArray.getJSONObject(0)) != null) {
            String trainTimeStr = jsonObject.getString("date");
            String departureTime = jsonObject.getString("time");
            String passengerName = jsonObject.getString("passengerName");
            String startPlace = jsonObject.getString("startPlace");
            String endPlace = jsonObject.getString("endPlace");
            String idCardNo = jsonObject.getString("idCardNo");
            String trainNumber = jsonObject.getString("trainNumber");
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)trainTimeStr)) {
                try {
                    Date trainTime = DateUtils.stringToDate(trainTimeStr, "yyyy-MM-dd");
                    invoiceJson.put("trainTime", (Object)trainTime);
                }
                catch (Exception e) {
                    LOGGER.info("\u6570\u7535\u706b\u8f66\u7968\uff0c\u4e58\u673a\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\uff0c\u53d1\u7968\u53f7\u7801:{}, time {}", (Object)invoiceNo, (Object)trainTimeStr);
                }
            }
            invoiceJson.put("departureTime", (Object)departureTime);
            invoiceJson.put("passengerName", (Object)passengerName);
            invoiceJson.put("departureStation", (Object)startPlace);
            invoiceJson.put("destinationStation", (Object)endPlace);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)idCardNo)) {
                invoiceJson.put("customerIdentityNum", (Object)idCardNo);
                InvoiceCheckUtils.encodeIDNumber(invoiceJson, "customerIdentityNum", 8);
            }
            invoiceJson.put("trainNum", (Object)trainNumber);
        }
    }

    private void convertAirEle(JSONObject invoiceJson) {
        JSONArray airTransportDetailList;
        JSONObject jsonObject;
        if (invoiceJson == null) {
            return;
        }
        String invoiceNo = invoiceJson.getString("invoiceNo");
        JSONArray items = invoiceJson.getJSONArray("items");
        if (!CollectionUtils.isEmpty((Collection)items)) {
            for (int i = 0; i < items.size(); ++i) {
                jsonObject = items.getJSONObject(i);
                if (jsonObject == null) continue;
                String goodsName = jsonObject.getString("goodsName");
                String goodsCode = jsonObject.getString("goodsCode");
                String detailAmount = jsonObject.getString("detailAmount");
                String taxAmount = jsonObject.getString("taxAmount");
                String taxRate = jsonObject.getString("taxRate");
                if (!kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)goodsName)) continue;
                if (goodsName.contains("\u7968\u4ef7")) {
                    invoiceJson.put("taxRate", (Object)taxRate);
                    invoiceJson.put("ticketPrice", (Object)detailAmount);
                }
                if (goodsName.contains("\u71c3\u6cb9\u9644\u52a0\u8d39")) {
                    invoiceJson.put("fuelSurcharge", (Object)detailAmount);
                }
                if (!goodsName.contains("\u6c11\u822a\u53d1\u5c55\u57fa\u91d1")) continue;
                invoiceJson.put("airportConstructionFee", (Object)detailAmount);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(airTransportDetailList = invoiceJson.getJSONArray("airTransportDetailList"))) && (jsonObject = airTransportDetailList.getJSONObject(0)) != null) {
            String passengerName = jsonObject.getString("passengerName");
            String startPlace = jsonObject.getString("startPlace");
            String carrier = jsonObject.getString("carrier");
            String idCardNo = jsonObject.getString("idCardNo");
            String time = jsonObject.getString("time");
            String endPlace = jsonObject.getString("endPlace");
            String flightNumber = jsonObject.getString("flightNumber");
            ArrayList<JSONObject> newItems = new ArrayList<JSONObject>(1);
            JSONObject item = new JSONObject();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)time)) {
                try {
                    Date carrierDate = DateUtils.stringToDate(time, "yyyy-MM-dd HH:mm:ss");
                    item.put("carrierDate", (Object)carrierDate);
                    invoiceJson.put("carrierDate", (Object)carrierDate);
                }
                catch (Exception e) {
                    LOGGER.info("\u6570\u7535\u98de\u673a\u7968\uff0c\u4e58\u673a\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\uff0c\u53d1\u7968\u53f7\u7801:{}, time {}", (Object)invoiceNo, (Object)time);
                }
                if (time.length() > 16) {
                    String airTime = time.substring(11, 16);
                    item.put("airTime", (Object)airTime);
                    invoiceJson.put("airTime", (Object)airTime);
                }
            }
            invoiceJson.put("customerName", (Object)passengerName);
            item.put("placeOfDeparture", (Object)startPlace);
            invoiceJson.put("placeOfDeparture", (Object)startPlace);
            item.put("carrier", (Object)carrier);
            invoiceJson.put("carrier", (Object)carrier);
            item.put("destination", (Object)endPlace);
            invoiceJson.put("destination", (Object)endPlace);
            item.put("flightNum", (Object)flightNumber);
            invoiceJson.put("flightNum", (Object)flightNumber);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)idCardNo)) {
                invoiceJson.put("customerIdentityNum", (Object)idCardNo);
                InvoiceCheckUtils.encodeIDNumber(invoiceJson, "customerIdentityNum", 8);
            }
            newItems.add(item);
            invoiceJson.put("items", newItems);
        }
    }

    private void dealIDNumber(JSONObject invoice, String key, int enlength) {
        String idNumMiddle = invoice.getString("idNumMiddle");
        String customerIdNo = invoice.getString(key);
        String start = "";
        String end = "";
        if (StringUtils.isNotEmpty((CharSequence)customerIdNo)) {
            if (customerIdNo.length() == 18) {
                if (enlength == 4) {
                    start = customerIdNo.substring(0, 10);
                    end = customerIdNo.substring(14, 18);
                } else if (enlength == 8) {
                    start = customerIdNo.substring(0, 6);
                    end = customerIdNo.substring(14, 18);
                }
                if (StringUtils.isNotEmpty((CharSequence)idNumMiddle) && StringUtils.isNotEmpty((CharSequence)customerIdNo)) {
                    invoice.put(key, (Object)(start + idNumMiddle + end));
                }
            } else if (customerIdNo.length() >= 2) {
                start = customerIdNo.substring(0, customerIdNo.length() - 2);
                if (StringUtils.isNotEmpty((CharSequence)idNumMiddle) && StringUtils.isNotEmpty((CharSequence)customerIdNo)) {
                    invoice.put(key, (Object)(start + idNumMiddle));
                }
            } else {
                invoice.put(key, (Object)customerIdNo);
            }
        }
    }

    private void handleHeaderInvoice(RequestContext requestContext, DynamicObject data, Long invoiceType, Long orgId, JSONObject invoiceJson, InvoiceSaveService service) {
        invoiceJson.put("headerDownFlag", (Object)"1");
        Pair<Boolean, String> updatePair = DeductionDownService.isUpdateDownInvoice(service, invoiceType, invoiceJson);
        String downResource = invoiceJson.getString("downResource");
        if ("inputHeader".equals(downResource) || "inputInit".equals(downResource)) {
            if (((Boolean)updatePair.getLeft()).booleanValue()) {
                data.set("fpy_serial_no", updatePair.getRight());
            } else {
                invoiceJson.put("delete", (Object)"2");
                InvoiceSaveResult saveResult = service.save(invoiceJson);
                data.set("fpy_serial_no", (Object)saveResult.getSerialNo());
            }
            data.set("sync_status", (Object)"1");
            return;
        }
        if (((Boolean)updatePair.getLeft()).booleanValue()) {
            data.set("sync_status", (Object)"1");
            data.set("fpy_serial_no", updatePair.getRight());
        } else {
            this.checkInvoice(requestContext, data, invoiceType, orgId, invoiceJson, service);
        }
    }

    private void checkInvoice(RequestContext requestContext, DynamicObject data, Long invoiceType, Long orgId, JSONObject invoiceJson, InvoiceSaveService service) {
        Pair<Long, String> configPair;
        String cacheKey = "down_check_config_key" + orgId;
        String isCheck = CacheHelper.get(cacheKey);
        if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)isCheck) && kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)(isCheck = (String)(configPair = this.cacheConfig(null, orgId)).getRight()))) {
            String invoiceCheck = RimConfigUtils.getConfig("rim_deduction", "down_invoice_check");
            isCheck = Optional.ofNullable(invoiceCheck).filter(org.apache.commons.lang3.StringUtils::isNotEmpty).orElse("1");
            int hours = InvoiceDownloadConstant.getPageSizeFromConfig(15, "check_config_mins");
            CacheHelper.put(cacheKey, isCheck, hours * 60);
        }
        String isNotSave = RimConfigUtils.getConfig("rim_deduction", "not_down_uncheck_save");
        boolean isOrdinaryInvoice = invoiceType != null ? InputInvoiceTypeEnum.isOrdinaryInvoice(invoiceType) : false;
        boolean dateFlag = false;
        Date invoiceDates = invoiceJson.getDate("invoiceDate");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = sdf.parse("2025-07-28 00:00:00");
            if (invoiceDates.compareTo(date) >= 0) {
                dateFlag = true;
            }
        }
        catch (ParseException date) {
            // empty catch block
        }
        if (!(!"1".equals(isCheck) && !"2".equals(isCheck) || isOrdinaryInvoice || InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType) && dateFlag)) {
            String invoiceCode = invoiceJson.getString("invoiceCode");
            String invoiceNo = invoiceJson.getString("invoiceNo");
            if (InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType) || InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType)) {
                if (!"1".equals(isNotSave)) {
                    invoiceJson.put("checkStatus", (Object)"3");
                    InvoiceSaveResult saveTollResult = service.save(invoiceJson);
                    data.set("fpy_serial_no", (Object)saveTollResult.getSerialNo());
                }
                data.set("sync_status", (Object)"1");
            } else {
                Date invoiceDate = invoiceJson.getDate("invoiceDate");
                BigDecimal invoiceAmount = invoiceJson.getBigDecimal("invoiceAmount");
                if (InputInvoiceTypeEnum.needReplaceAmountType(invoiceType)) {
                    invoiceAmount = invoiceJson.getBigDecimal("totalAmount");
                }
                String checkCode = invoiceJson.getString("checkCode");
                CheckParam checkParam = new CheckParam(invoiceCode, invoiceNo, invoiceType, invoiceDate, invoiceAmount, checkCode, null);
                HashMap extMap = Maps.newHashMap();
                extMap.put("orgId", orgId);
                String taxNo = TenantUtils.getTaxNoByOrgId(orgId);
                extMap.put("taxNo", taxNo);
                extMap.put("eid", requestContext.getUserId());
                checkParam.setExtMap(extMap);
                CheckResult checkResult = SimplyCheckService.checkInvoice(checkParam, orgId, taxNo);
                if ("0000".equals(checkResult.getErrcode())) {
                    Object invoiceEntity = checkResult.getData();
                    String invoiceCheckStr = JSONObject.toJSONString((Object)invoiceEntity);
                    JSONObject invoiceData = JSON.parseObject((String)invoiceCheckStr);
                    String checkStatus = invoiceData.getString("checkStatus");
                    if (StringUtils.isEmpty((CharSequence)checkStatus)) {
                        invoiceData.put("checkStatus", (Object)"1");
                    }
                    ConvertFieldUtil.getStandardInvoice(invoiceData);
                    InOutputInvoiceDownServiceImpl downService = new InOutputInvoiceDownServiceImpl();
                    downService.updateNewDeductData(invoiceData, invoiceJson);
                    if ("1".equals(invoiceJson.getString("headerDownFlag")) && (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType))) {
                        if (kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)invoiceJson.getString("totalAmount")) && kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)invoiceJson.getString("invoiceAmount")) && kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)invoiceJson.getString("totalTaxAmount"))) {
                            try {
                                BigDecimal totalAmount = BigDecimalUtil.transDecimal((Object)invoiceJson.getString("invoiceAmount")).add(BigDecimalUtil.transDecimal((Object)invoiceJson.getString("totalTaxAmount")));
                                invoiceJson.put("totalAmount", (Object)String.valueOf(totalAmount));
                            }
                            catch (NumberFormatException e) {
                                LOGGER.info("\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38\uff0c{}", (Object)e);
                            }
                        }
                        CommonUtils.copyData(invoiceData, invoiceJson, AIR_TRAIN_ELE_COVER_FIELDS);
                        if (kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)invoiceJson.getString("salerName"))) {
                            invoiceData.put("salerName", (Object)invoiceJson.getString("salerName"));
                            invoiceData.put("sellerName", (Object)invoiceJson.getString("salerName"));
                        }
                    }
                    if (service != null) {
                        invoiceData.put("org_id", (Object)orgId);
                        invoiceData.put("taxNo", (Object)TenantUtils.getTaxNoByOrgId(orgId));
                        invoiceData.put("rim_user", (Object)requestContext.getUserId());
                        DeductionUtils.setTaxDownCollectInfo(invoiceData);
                        if ("1".equals(isCheck)) {
                            invoiceData.put("needUserRelation", (Object)"0");
                            InvoiceSaveResult saveResult = service.save(invoiceData);
                            invoiceData.put("serialNo", (Object)saveResult.getSerialNo());
                            String isSaleListInvoice = invoiceData.getString("isSaleListInvoice");
                            if ("1".equals(isSaleListInvoice)) {
                                RecognitionCheckHelper recognitionCheckHelper = new RecognitionCheckHelper();
                                recognitionCheckHelper.dealInvoiceAttachRelation(invoiceData);
                            }
                            data.set("fpy_serial_no", (Object)saveResult.getSerialNo());
                        }
                    }
                    data.set("sync_status", (Object)"1");
                } else if (!"1".equals(isNotSave)) {
                    invoiceJson.put("checkStatus", (Object)"2");
                    invoiceJson.put("needUserRelation", (Object)"0");
                    InvoiceSaveResult saveResult3 = service.save(invoiceJson);
                    data.set("fpy_serial_no", (Object)saveResult3.getSerialNo());
                }
                if ("2".equals(isCheck)) {
                    data.set("sync_status", (Object)"1");
                }
            }
        } else {
            if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType) && dateFlag) {
                LOGGER.info("2025\u5e747\u670828\u65e5\u4e4b\u540e\u7684\u8f93\u7535\u98de\u673a\u7968\uff0c\u7968\u5934\u4e0d\u67e5\u9a8c\uff0c\u76f4\u63a5\u4fdd\u5b58");
                invoiceJson.put("totalAmount", (Object)0);
                BigDecimal totalTaxInclAmount = kd.imc.rim.common.utils.BigDecimalUtil.transDecimal(invoiceJson.get((Object)"invoiceAmount")).add(kd.imc.rim.common.utils.BigDecimalUtil.transDecimal(invoiceJson.get((Object)"totalTaxAmount")));
                invoiceJson.put("totalTaxInclAmount", (Object)totalTaxInclAmount);
            }
            invoiceJson.put("checkStatus", (Object)"3");
            if (!"1".equals(isNotSave)) {
                if (InvoiceConvertUtils.isSaleListInvoiceType(invoiceType)) {
                    RecognitionCheckHelper.markSaleListByCheckResult(invoiceJson);
                }
                invoiceJson.put("needUserRelation", (Object)"0");
                InvoiceSaveResult saveResult2 = service.save(invoiceJson);
                invoiceJson.put("serialNo", (Object)saveResult2.getSerialNo());
                String isSaleListInvoice = invoiceJson.getString("isSaleListInvoice");
                if ("1".equals(isSaleListInvoice)) {
                    RecognitionCheckHelper recognitionCheckHelper = new RecognitionCheckHelper();
                    recognitionCheckHelper.dealInvoiceAttachRelation(invoiceJson);
                }
                data.set("fpy_serial_no", (Object)saveResult2.getSerialNo());
            }
            data.set("sync_status", (Object)"1");
        }
    }

    @Override
    public Boolean call() throws Exception {
        RequestContext.copyAndSet((RequestContext)this.rc);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"rim_down_input");
        DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)this.id, (DynamicObjectType)mainEntityType);
        this.dealSingle(this.rc, data);
        return Boolean.TRUE;
    }
}

