/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.download.InputOutInvoiceApplyService;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.LockUtils;
import kd.imc.rim.common.utils.LqConvertUtil;
import kd.imc.rim.common.utils.TenantUtils;

public class LqInputInvoiceInitApplyServiceImpl
extends InputOutInvoiceApplyService {
    private static final Log LOGGER = LogFactory.getLog(LqInputInvoiceInitApplyServiceImpl.class);
    private static final String[] INIT_INVOICE_TYPES = new String[]{"", InputInvoiceTypeEnum.HGJKS.getAwsType(), InputInvoiceTypeEnum.WITHHOLDING.getAwsType()};

    @Override
    public void divideObject(DynamicObject initDynamicObject, Long orgId, String taxNo, List<Map<String, Date>> initDateList) {
        if ("2".equals(initDynamicObject.getString("output_download")) && (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getAwsType().equals(initDynamicObject.getString("invoice_type")) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getAwsType().equals(initDynamicObject.getString("invoice_type")))) {
            LOGGER.info("\u4e50\u4f01\u8fdb\u9879\u672a\u52fe\u9009\u53d1\u7968\u521d\u59cb\u5316-\u9500\u9879\u4e0b\u8f7d\uff0c\u6682\u4e0d\u4e0b\u8f7d\u6570\u7535\u98de\u673a\u3001\u6570\u7535\u706b\u8f66\u53d1\u7968");
            return;
        }
        if (TenantUtils.isSmallScaleTaxpayer(taxNo)) {
            LOGGER.info("\u7a0e\u53f7:{}\u4e3a\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba,\u4e0d\u652f\u6301\u4e0b\u8f7d\u672a\u52fe\u9009\u53d1\u7968", (Object)taxNo);
            return;
        }
        String lockKey = "InvoiceDownInitApplyLock-" + taxNo;
        try (DLock lock = LockUtils.createDLockByMd5(lockKey, "InvoiceDownInitApplyLock");){
            if (lock.tryLock()) {
                LOGGER.info("\u5f00\u59cb\u7533\u8bf7\u672a\u52fe\u9009\u53d1\u7968\u521d\u59cb\u5316\u6570\u636e:{}", (Object)taxNo);
                Calendar cal = Calendar.getInstance();
                Date dateNow = new Date();
                cal.setTime(dateNow);
                int day = cal.get(5);
                int startDay = InvoiceDownloadConstant.getPageSizeFromConfig(2, "lq_init_apply_days");
                if (day < startDay) {
                    return;
                }
                for (String invoiceType : INIT_INVOICE_TYPES) {
                    this.applyCurrentData(initDynamicObject, invoiceType, "6", orgId, taxNo);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4e50\u4f01\u521d\u59cb\u5316\u7533\u5931\u8d25:" + taxNo, (Throwable)e);
        }
    }

    @Override
    public void applyCurrentData(DynamicObject initDynamicObject, String invoiceType, String dataType, Long orgId, String taxNo) {
        QFilter invoiceTypeFilter = new QFilter("invoice_type", "=", (Object)InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceType));
        QFilter dataTypeFilter = new QFilter("inout", "=", (Object)dataType);
        QFilter taxNoFilter = new QFilter("tax_no", "=", (Object)taxNo);
        Date endDate = new Date();
        int month = InvoiceDownloadConstant.getPageSizeFromConfig(2, "input_init_current");
        if (month < 0) {
            month = 2;
        }
        Date startDate = DateUtils.getFirstDateOfMonth(DateUtils.addMonth(endDate, -month));
        QFilter startFilter = new QFilter("invoice_enddate", ">=", (Object)DateUtils.getFirstDateOfMonth(endDate));
        QFilter endFilter = new QFilter("invoice_enddate", "<=", (Object)DateUtils.getLastDateOfMonth(endDate));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_down_log", (String)"id,taskno,invoice_type,gov_status,invoice_enddate,download_errcode,apply_date", (QFilter[])new QFilter[]{invoiceTypeFilter, dataTypeFilter, taxNoFilter, startFilter, endFilter}, (String)"invoice_enddate desc");
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            DynamicObject dynamicObject1 = (DynamicObject)collection.get(0);
            String govStatus = dynamicObject1.getString("gov_status");
            if ("7".equals(govStatus)) {
                this.applyInputOutDownInvoice(dynamicObject1.getLong("id"), null, invoiceType, dataType, orgId, taxNo, startDate, endDate);
            }
        } else {
            this.applyInputOutDownInvoice(null, null, invoiceType, dataType, orgId, taxNo, startDate, endDate);
        }
    }

    @Override
    public JSONObject applyInputOutDownInvoice(Long logId, DynamicObject initDynamicObject, String invoiceType, String dataType, Long orgId, String taxNo, Date begin, Date end) {
        JSONObject param = new JSONObject();
        param.put("api_type", (Object)"WGXSJCSHQDXZSQDKGX");
        param.put("nsrsbh", (Object)taxNo);
        param.put("ywlx", (Object)"01");
        param.put("pzzl", (Object)"01");
        if (InputInvoiceTypeEnum.HGJKS.getAwsType().equals(invoiceType)) {
            param.put("pzzl", (Object)"03");
        } else if (InputInvoiceTypeEnum.WITHHOLDING.getAwsType().equals(invoiceType)) {
            param.put("pzzl", (Object)"05");
            param.put("kjywrsbh", (Object)taxNo);
        }
        param.put("kpyf", (Object)DateUtils.format(begin, "yyyyMM"));
        JSONObject result = null;
        try {
            result = LqConvertUtil.invokeService(param, "DeductApiService");
        }
        catch (Exception e) {
            LOGGER.error("\u672a\u52fe\u9009\u521d\u59cb\u5316\u7533\u8bf7\u5931\u8d25" + taxNo, (Throwable)e);
            result = ResultContant.createJSONObject("0203", ResManager.loadKDString((String)"\u672a\u52fe\u9009\u521d\u59cb\u5316\u7533\u8bf7\u5931\u8d25", (String)"LqInputInvoiceInitApplyServiceImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        LOGGER.info("\u521d\u59cb\u5316\u7533\u8bf7\u8fd4\u56de{}-{}", (Object)taxNo, (Object)result);
        if (ResultContant.isSuccess(result).booleanValue()) {
            JSONObject data = result.getJSONObject("data");
            String pclsh = data.getString("pclsh");
            result = this.convertApplyResult(pclsh, dataType, invoiceType, begin, end);
            this.dealResult(result, initDynamicObject, logId, orgId, taxNo);
        }
        return result;
    }
}

