/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.download.InvoiceDownService;
import kd.imc.rim.common.invoice.download.RpaFileDownRetryTask;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.LockUtils;
import org.apache.commons.lang3.tuple.Pair;

public class NewEtaxDownServiceImpl
extends InvoiceDownService {
    private static Log LOGGER = LogFactory.getLog(NewEtaxDownServiceImpl.class);
    private static final int THREADPOOL_SIZE = 6;
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"RpaFileDownRetryTask", (int)6);

    public NewEtaxDownServiceImpl() {
        this.dkType = "4";
    }

    @Override
    public JSONObject invoiceDown(DynamicObject downLog, RequestContext requestContext, Long orgId, String taxNo) {
        JSONObject resultJson;
        block34: {
            LOGGER.info("\u5f00\u59cb\u4e0b\u8f7dRPA\u53d1\u7968\u6216\u8005\u6587\u4ef6{}-{}", (Object)taxNo, downLog.get("batch_no"));
            if (orgId == 0L) {
                orgId = requestContext.getOrgId();
            }
            if (this.checkOffFlag(this.dkType, taxNo)) {
                return ResultContant.createJSONObject(ErrorType.NEED_LOGIN.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u5df2\u914d\u7f6e\u5173\u95ed,\u8bf7\u91cd\u65b0\u914d\u7f6e", (String)"NewEtaxDownServiceImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            int applyStep = downLog.getInt("apply_step");
            JSONObject param = new JSONObject();
            param.put("taxNo", (Object)taxNo);
            param.put("batchNo", (Object)downLog.getString("taskno"));
            int pageSize = InvoiceDownloadConstant.getPageSizeFromConfig(500, "all_e_inout_down_pagesize");
            param.put("currentPage", (Object)1);
            if (applyStep > 0) {
                param.put("currentPage", (Object)applyStep);
            }
            param.put("pageSize", (Object)pageSize);
            String inout = downLog.getString("inout");
            resultJson = null;
            String preGovStatus = downLog.getString("gov_status");
            String key = this.getLockKey(downLog.get("id"));
            Date invoiceStartdate = downLog.getDate("invoice_startdate");
            Date invoiceEnddate = downLog.getDate("invoice_enddate");
            try (DLock lock = LockUtils.createDLockByMd5(key, "NewEtaxDownServiceImpl.Lock");){
                if (lock.tryLock()) {
                    try {
                        resultJson = this.downLoadInvoices(param, orgId);
                        if (resultJson != null && (ResultContant.isSuccess(resultJson).booleanValue() || "1651".equals(resultJson.getString("errcode")))) {
                            if (applyStep < 2) {
                                downLog.set("total_num", (Object)0);
                            }
                            int totalPage = resultJson.getIntValue("totalPage");
                            downLog.set("gov_status", (Object)"8");
                            downLog.set("download_errcode", (Object)"3");
                            JSONArray invoiceArray = resultJson.getJSONArray("data");
                            if (!CollectionUtils.isEmpty((Collection)invoiceArray)) {
                                if ("7".equals(inout) || "8".equals(inout)) {
                                    try {
                                        Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(downLog.get("invoice_type"));
                                        Pair<JSONArray, JSONArray> pair = this.dealData(invoiceArray, downLog);
                                        resultJson.put("data", pair.getLeft());
                                        JSONArray failArray = (JSONArray)pair.getRight();
                                        this.dealFailData(downLog, orgId, inout, invoiceType, failArray);
                                    }
                                    catch (Throwable e) {
                                        LOGGER.info("\u91cd\u65b0\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38", (Object)e);
                                    }
                                }
                                this.insertInputOutDataToTmp(downLog, resultJson, inout, 0, "7", "4");
                                boolean downSurplusInvoice = this.downSurplusInvoice(downLog, param, param.getIntValue("currentPage") + 1, totalPage, orgId, inout);
                                if (downSurplusInvoice) {
                                    downLog.set("apply_step", (Object)1);
                                    this.setDescription(downLog, (String)null);
                                } else {
                                    downLog.set("gov_status", (Object)"6");
                                }
                            } else {
                                downLog.set("gov_status", (Object)"9");
                                downLog.set("download_errcode", (Object)"4");
                                this.setDescription(downLog, (String)null);
                            }
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
                            break block34;
                        }
                        if (resultJson != null) {
                            Set<String> etaxAsynErrcodes = DeductionUtils.getEtaxHeadAsynRetryErrcodes("etax_file_asyn_retrycode");
                            if (resultJson != null && !etaxAsynErrcodes.contains(resultJson.getString("errcode"))) {
                                downLog.set("gov_status", (Object)"5");
                            }
                            this.setDescription(downLog, resultJson);
                            String dkType = DeductionConstant.getDkType(taxNo);
                            if (this.checkTaskStop(dkType, resultJson)) {
                                downLog.set("gov_status", (Object)"5");
                            }
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
                        }
                        break block34;
                    }
                    catch (Exception e) {
                        LOGGER.error(downLog.get("batch_no") + "\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
                        if (e instanceof MsgException) {
                            resultJson = ResultContant.createJSONObject(((MsgException)e).getErrorCode(), ((MsgException)e).getErrorMsg());
                        } else if (e instanceof KDException) {
                            KDException kdException = (KDException)e;
                            resultJson = ResultContant.createJSONObject(kdException.getErrorCode().getCode(), kdException.getErrorCode().getMessage());
                        } else {
                            resultJson = ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25", (String)"NewEtaxDownServiceImpl_1", (String)"imc-rim-common", (Object[])new Object[0]));
                        }
                        this.setDescription(downLog, e.getMessage());
                        downLog.set("gov_status", (Object)preGovStatus);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
                    }
                    break block34;
                }
                resultJson = ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u8be5\u6279\u6b21\u6b63\u5728\u5728\u4e0b\u8f7d\u4e2d,\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"NewEtaxDownServiceImpl_2", (String)"imc-rim-common", (Object[])new Object[0]));
            }
        }
        return resultJson;
    }

    private void dealFailData(DynamicObject downLog, Long orgId, String inout, Long invoiceType, JSONArray failArray) {
        if (!CollectionUtils.isEmpty((Collection)failArray)) {
            LOGGER.info("\u9500\u9879\u6587\u4ef6\u4e0b\u8f7d\uff0c\u63a8\u9001\u9519\u8bef\u6570\u636e\u7ed9\u5f00\u7968\uff0c{}", (Object)failArray.toString());
            if ("8".equals(inout)) {
                ThreadPools.executeOnceIncludeRequestContext((String)"NewEtaxDownServiceImpl-send-fail-message", () -> {
                    String taskno = downLog.getString("taskno");
                    HashSet<String> errMsg = new HashSet<String>(failArray.size());
                    for (int i = 0; i < failArray.size(); ++i) {
                        JSONObject fail = failArray.getJSONObject(i);
                        if (fail == null) continue;
                        errMsg.add(fail.getString("description"));
                    }
                    if (!CollectionUtils.isEmpty(errMsg)) {
                        JSONObject invokeParam = new JSONObject();
                        invokeParam.put("batchNo", (Object)taskno);
                        JSONArray failReasons = new JSONArray(errMsg.size());
                        for (String msg : errMsg) {
                            failReasons.add((Object)msg);
                        }
                        invokeParam.put("failReasons", (Object)failReasons);
                        LOGGER.info("\u9500\u9879\u6587\u4ef6\u4e0b\u8f7d\uff0c\u63a8\u9001\u9519\u8bef\u6570\u636e\u7ed9\u5f00\u7968-\u53c2\u6570{}", (Object)invokeParam);
                        LOGGER.info("\u9500\u9879\u6587\u4ef6\u4e0b\u8f7d\uff0c\u63a8\u9001\u9519\u8bef\u6570\u636e\u7ed9\u5f00\u7968-\u7ed3\u679c{}", (Object)this.sendErrMsg(invokeParam));
                    }
                });
            }
            if (invoiceType > 0L) {
                this.addInvoiceType(invoiceType, "4", failArray);
            }
            String batchNo = downLog.getString("batch_no");
            ArrayList<DynamicObject> syncAccountList = new ArrayList<DynamicObject>(8);
            for (int i = 0; i < failArray.size(); ++i) {
                JSONObject failInvoice = failArray.getJSONObject(i);
                DynamicObject account = this.getAccountDynamicObject(failInvoice, batchNo, "11", inout, null, orgId);
                syncAccountList.add(account);
            }
            if (!CollectionUtils.isEmpty(syncAccountList)) {
                SaveServiceHelper.save((DynamicObject[])syncAccountList.toArray(new DynamicObject[syncAccountList.size()]));
            }
        }
    }

    public JSONObject sendErrMsg(JSONObject param) {
        Object result = DispatchServiceHelper.invokeBizService((String)"imc", (String)"sim", (String)"InvoiceAddServiceImpl", (String)"updateRpaFailReason", (Object[])new Object[]{param});
        if (StringUtils.isBlank((Object)result)) {
            return null;
        }
        return JSONObject.parseObject((String)((String)result));
    }

    public boolean downSurplusInvoice(DynamicObject downLog, JSONObject param, int startPage, int totalPage, Long orgId, String inout) {
        if (totalPage <= 1) {
            return true;
        }
        Date invoiceStartdate = downLog.getDate("invoice_startdate");
        Date invoiceEnddate = downLog.getDate("invoice_enddate");
        JSONObject resultJson = null;
        for (int currentPage = startPage; currentPage <= totalPage; ++currentPage) {
            param.put("currentPage", (Object)currentPage);
            resultJson = this.downLoadInvoices(param, orgId);
            if (resultJson != null && ResultContant.isSuccess(resultJson).booleanValue()) {
                JSONArray invoiceArray = resultJson.getJSONArray("data");
                if ("7".equals(inout) || "8".equals(inout)) {
                    try {
                        Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(downLog.get("invoice_type"));
                        Pair<JSONArray, JSONArray> pair = this.dealData(invoiceArray, downLog);
                        resultJson.put("data", pair.getLeft());
                        this.dealFailData(downLog, orgId, inout, invoiceType, (JSONArray)pair.getRight());
                    }
                    catch (Exception e) {
                        LOGGER.info("\u91cd\u65b0\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38", (Object)e);
                    }
                }
            } else {
                downLog.set("apply_step", (Object)currentPage);
                this.setDescription(downLog, resultJson);
                return false;
            }
            int totalNum = downLog.getInt("total_num");
            this.insertInputOutDataToTmp(downLog, resultJson, inout, totalNum, "7", "4");
        }
        return true;
    }

    private Pair<JSONArray, JSONArray> dealData(JSONArray invoiceArray, DynamicObject downLog) {
        JSONArray successArray = new JSONArray();
        JSONArray failArray = new JSONArray();
        if (CollectionUtils.isEmpty((Collection)invoiceArray) || downLog == null) {
            return Pair.of((Object)successArray, (Object)failArray);
        }
        for (int i = 0; i < invoiceArray.size(); ++i) {
            JSONObject invoice = invoiceArray.getJSONObject(i);
            if (invoice == null) continue;
            invoice.put("batchNo", (Object)downLog.getString("taskno"));
            String status = invoice.getString("status");
            if ("1".equals(status)) {
                successArray.add((Object)invoice);
                continue;
            }
            failArray.add((Object)invoice);
        }
        String inout = downLog.getString("inout");
        if (!CollectionUtils.isEmpty((Collection)failArray) && "7".equals(inout)) {
            try {
                String json = downLog.getString("json_tag");
                int reapplyTimes = 0;
                int maxTimes = InvoiceDownloadConstant.getPageSizeFromConfig(3, "down_file_reapply_max_times");
                if (StringUtils.isNotEmpty((CharSequence)json)) {
                    try {
                        JSONObject jsonObject = JSONObject.parseObject((String)json);
                        reapplyTimes = jsonObject.getIntValue("reapplyTimes");
                    }
                    catch (Exception e) {
                        LOGGER.info("down-file\u89e3\u6790\u5f02\u5e38", (Object)e);
                    }
                }
                if (++reapplyTimes <= 3) {
                    String taxNo = downLog.getString("tax_no");
                    Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(downLog.get("invoice_type"));
                    Date invoiceStartdate = downLog.getDate("invoice_startdate");
                    Date invoiceEnddate = downLog.getDate("invoice_enddate");
                    this.applyDownFile(failArray, taxNo, invoiceType, invoiceStartdate, invoiceEnddate, reapplyTimes);
                }
            }
            catch (Exception e) {
                LOGGER.info("\u91cd\u65b0\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38", (Object)e);
            }
        }
        return Pair.of((Object)successArray, (Object)failArray);
    }

    private void applyDownFile(JSONArray invoiceArray, String taxNo, Long invoiceTypeParam, Date invoiceStartdate, Date invoiceEnddate, int reapplyTimes) {
        if (CollectionUtils.isEmpty((Collection)invoiceArray)) {
            return;
        }
        ArrayList<JSONObject> invoiceList = new ArrayList<JSONObject>();
        for (int i = 0; i < invoiceArray.size(); ++i) {
            if (invoiceArray.getJSONObject(i) == null) continue;
            invoiceList.add(invoiceArray.getJSONObject(i));
        }
        if (CollectionUtils.isEmpty(invoiceList)) {
            return;
        }
        List<String> invoiceNoList = invoiceList.stream().filter(t -> StringUtils.isNotBlank((CharSequence)t.getString("invoiceNo"))).map(t -> t.getString("invoiceNo")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(invoiceNoList)) {
            LOGGER.info("\u91cd\u65b0\u7533\u8bf7\u6587\u4ef6\u4e0b\u8f7d\uff0c\u53d1\u7968\u53f7\u7801\u4e3a\u7a7a\uff0c\u4e0d\u7533\u8bf7");
            return;
        }
        RpaFileDownRetryTask rpaFileDownRetryTask = new RpaFileDownRetryTask(RequestContext.get(), taxNo, invoiceNoList, invoiceTypeParam, invoiceStartdate, invoiceEnddate, reapplyTimes);
        threadPool.submit((Callable)rpaFileDownRetryTask);
    }
}

