/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.collector.InvoiceHeaderDownService;
import kd.imc.rim.common.invoice.download.impl.HeaderInvoiceDownServiceImpl;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.LockUtils;

public class NewEtaxHeaderInvoiceDownServiceImpl
extends HeaderInvoiceDownServiceImpl {
    private static Log logger = LogFactory.getLog(NewEtaxHeaderInvoiceDownServiceImpl.class);
    private static final String[] INVOICE_STATUS = new String[]{"2", "7", "8"};

    public NewEtaxHeaderInvoiceDownServiceImpl() {
        this.dkType = "4";
    }

    @Override
    public JSONObject invoiceDown(DynamicObject downInit, RequestContext requestContext, Long orgId, String taxNo) {
        logger.info("\u5f00\u59cb\u4e0b\u8f7drpa\u53d1\u7968\u72b6\u6001{}", (Object)taxNo);
        JSONObject resultJson = ResultContant.createSuccessJSONObject();
        String cacheKey = "newEleTax_header-" + taxNo;
        try (DLock lock = LockUtils.createDLockByMd5(cacheKey, "NewEtaxHeaderInvoiceDownServiceImpl.lock");){
            if (lock.tryLock()) {
                String multInvoiceStatus;
                int downDays;
                InvoiceHeaderDownService invoiceHeaderDownService = new InvoiceHeaderDownService(orgId);
                Date endTime = DateUtils.trunc(new Date());
                Date startTime = DateUtils.trunc(DateUtils.addDay(endTime, -(downDays = InvoiceDownloadConstant.getPageSizeFromConfig(365, "new_etax_header_days"))));
                if (this.notExist(taxNo, startTime, endTime, multInvoiceStatus = String.join((CharSequence)",", INVOICE_STATUS))) {
                    invoiceHeaderDownService.applyUnSelectTable(taxNo, "0", DateUtils.format(startTime), DateUtils.format(endTime), multInvoiceStatus);
                }
                int undownDays = InvoiceDownloadConstant.getPageSizeFromConfig(7, "new_etax_agric_days");
                startTime = DateUtils.trunc(DateUtils.addDay(endTime, -undownDays));
                this.downAgricInvoice(taxNo, orgId, startTime, endTime, "0");
                int downMons = InvoiceDownloadConstant.getPageSizeFromConfig(3, "new_etax_agriced_mons");
                startTime = DateUtils.trunc(DateUtils.addMonth(endTime, -downMons));
                this.downAgricInvoice(taxNo, orgId, startTime, endTime, "1");
            }
        }
        catch (Exception e) {
            logger.error("\u8868\u5934\u4e0b\u8f7d\u5931\u8d25:" + taxNo, (Throwable)e);
            resultJson = ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u8868\u5934\u4e0b\u8f7d\u5931\u8d25", (String)"HeaderInvoiceDownServiceImpl_2", (String)"imc-rim-common", (Object[])new Object[0]));
            return resultJson;
        }
        return resultJson;
    }

    private void downAgricInvoice(String taxNo, Long orgId, Date startTime, Date endTime, String processingStatus) {
        QFilter qFilter = new QFilter("tax_no", "=", (Object)taxNo).and("createtime", ">=", (Object)DateUtils.trunc(new Date())).and("inout", "=", (Object)"9").and("invoice_startdate", "=", (Object)startTime).and("invoice_enddate", "=", (Object)endTime);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_down_log", (String)"json_tag", (QFilter[])qFilter.toArray());
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            for (DynamicObject dynamicObject : collection) {
                String jsonTag = dynamicObject.getString("json_tag");
                JSONObject object = JSON.parseObject((String)jsonTag);
                if (object == null) continue;
                String farmProductType = object.getString("farmProductType");
                String invoiceStatus = object.getString("invoiceStatus");
                String processingStatusOld = object.getString("processingStatus");
                if (!"-1".equals(farmProductType) || !"-1".equals(invoiceStatus) || !StringUtils.equals((CharSequence)processingStatusOld, (CharSequence)processingStatus)) continue;
                return;
            }
        }
        JSONObject param = new JSONObject();
        param.put("taxNo", (Object)taxNo);
        param.put("farmProductType", (Object)"-1");
        param.put("invoiceStatus", (Object)"-1");
        param.put("processingStatus", (Object)processingStatus);
        param.put("startDate", (Object)DateUtils.format(startTime));
        param.put("endDate", (Object)DateUtils.format(endTime));
        InvoiceHeaderDownService invoiceHeaderDownService = new InvoiceHeaderDownService(orgId);
        invoiceHeaderDownService.downAgricInvoice(taxNo, orgId, param);
    }

    private boolean notExist(String taxNo, Date startTime, Date endTime, String invoiceStatus) {
        QFilter qFilter = new QFilter("tax_no", "=", (Object)taxNo).and("createtime", ">=", (Object)DateUtils.trunc(new Date())).and("sync_type", "=", (Object)"8").and("invoice_type", "=", (Object)0L).and("inout", "=", (Object)"3").and("invoice_startdate", "=", (Object)startTime).and("invoice_enddate", "=", (Object)endTime);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_down_log", (String)"json_tag", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return true;
        }
        for (DynamicObject dynamicObject : collection) {
            JSONObject searchOpt;
            String jsonTag = dynamicObject.getString("json_tag");
            JSONObject object = JSON.parseObject((String)jsonTag);
            if (object == null || (searchOpt = object.getJSONObject("searchOpt")) == null) continue;
            String status = searchOpt.getString("invoiceStatus");
            String multInvoiceStatus = searchOpt.getString("multInvoiceStatus");
            if (!"-1".equals(status) && !StringUtils.equals((CharSequence)invoiceStatus, (CharSequence)status) && !StringUtils.equals((CharSequence)multInvoiceStatus, (CharSequence)invoiceStatus)) continue;
            return false;
        }
        return true;
    }
}

