/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.collector.InvoiceHeaderDownService;
import kd.imc.rim.common.invoice.deduction.impl.NewEtaxDeductService;
import kd.imc.rim.common.invoice.download.impl.HeaderInvoiceDownServiceImpl;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.LockUtils;
import kd.imc.rim.common.utils.UUID;

public class NewEtaxTaxperiodInvoiceDownServiceImpl
extends HeaderInvoiceDownServiceImpl {
    private static Log logger = LogFactory.getLog(NewEtaxTaxperiodInvoiceDownServiceImpl.class);

    public NewEtaxTaxperiodInvoiceDownServiceImpl() {
        this.dkType = "4";
    }

    @Override
    public JSONObject invoiceDown(DynamicObject downInit, RequestContext requestContext, Long orgId, String taxNo) {
        logger.info("\u5f00\u59cb\u4e0b\u8f7drpa\u5f53\u524d\u5c5e\u671f\u53d1\u7968{}", (Object)taxNo);
        String cacheKey = "newEleTax_taxperiod-" + taxNo;
        try (DLock lock = LockUtils.createDLockByMd5(cacheKey, "NewEtaxTaxperiodInvoiceDownServiceImpl.lock");){
            if (lock.tryLock()) {
                JSONObject jSONObject = this.down(taxNo, orgId, downInit.getDate("begin"), requestContext);
                return jSONObject;
            }
        }
        return ResultContant.createSuccessJSONObject();
    }

    @Override
    protected JSONObject down(String taxNo, Long orgId, Date startDate, RequestContext requestContext) {
        JSONObject param = new JSONObject();
        param.put("taxNo", (Object)taxNo);
        return this.downByParam(taxNo, orgId, startDate, requestContext, param);
    }

    public JSONObject downByParam(String taxNo, Long orgId, Date startDate, RequestContext requestContext, JSONObject param) {
        if (orgId == 0L) {
            orgId = requestContext.getOrgId();
        }
        JSONObject resultJson = ResultContant.createSuccessJSONObject();
        try {
            logger.info("\u4e0b\u8f7d\u589e\u503c\u7a0e\u8868\u5934{}", (Object)taxNo);
            NewEtaxDeductService deductService = new NewEtaxDeductService(orgId);
            String taxperiod = param.getString("taxPeriod");
            boolean downHisPeriod = StringUtils.isNotBlank((CharSequence)taxperiod);
            String invoiceType = Optional.ofNullable(param.getString("invoiceType")).orElse("");
            boolean rpaDownSync = NewEtaxTaxperiodInvoiceDownServiceImpl.isSyncDown(taxNo);
            Date taxperiodDate = null;
            if (StringUtils.isNotBlank((CharSequence)taxperiod)) {
                taxperiodDate = DateUtils.stringToDate(taxperiod, "yyyyMM");
            }
            long longType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceType);
            if (rpaDownSync) {
                if (StringUtils.isEmpty((CharSequence)(taxperiod = Optional.ofNullable(taxperiod).filter(StringUtils::isNotEmpty).orElseGet(() -> deductService.syncGetTaxperiod(taxNo))))) {
                    taxperiod = DeductionConstant.getSkssq(taxNo);
                }
                if (StringUtils.isEmpty((CharSequence)taxperiod)) {
                    return ResultContant.createJSONObject("0002", ResManager.loadKDString((String)"\u83b7\u53d6\u7a0e\u671f\u5931\u8d25", (String)"NewEtaxTaxperiodInvoiceDownServiceImpl_1", (String)"imc-rim-common", (Object[])new Object[0]));
                }
                if (this.existTask(taxNo, taxperiodDate, null, longType, "4", false)) {
                    return resultJson;
                }
                String batchNo = this.getDownBatchNo();
                DynamicObject downLog = this.getDownLogDynamicObject(batchNo, UUID.getBatchNoByTaxNo(taxNo), orgId, taxNo, 0, "4");
                downLog.set("gov_status", (Object)"6");
                if (longType > 0L) {
                    downLog.set("invoice_type", (Object)longType);
                    downLog.set("aws_invoice_type", (Object)invoiceType);
                } else {
                    downLog.set("invoice_type", (Object)0L);
                }
                downLog.set("invoice_startdate", (Object)taxperiodDate);
                downLog.set("invoice_enddate", (Object)taxperiodDate);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
            }
            if (!rpaDownSync) {
                Date endTime = null;
                if (taxperiodDate != null) {
                    endTime = DateUtils.getLastDateOfMonthZero(taxperiodDate);
                }
                NewEtaxDeductService newEtaxDeductService = new NewEtaxDeductService(orgId);
                JSONObject paramJson = new JSONObject();
                paramJson.put("taxNo", (Object)taxNo);
                ArrayList<String> billTypeList = new ArrayList<String>(1);
                if (StringUtils.isBlank((CharSequence)invoiceType)) {
                    billTypeList.add("0");
                    billTypeList.add("1");
                    billTypeList.add("2");
                } else if (InputInvoiceTypeEnum.HGJKS.getAwsType().equals(invoiceType)) {
                    billTypeList.add("1");
                } else if (InputInvoiceTypeEnum.WITHHOLDING.getAwsType().equals(invoiceType)) {
                    billTypeList.add("2");
                } else {
                    billTypeList.add("0");
                }
                InvoiceHeaderDownService invoiceHeaderDownService = new InvoiceHeaderDownService(orgId);
                String syncType = downHisPeriod ? "10" : "9";
                for (String billTypeParam : billTypeList) {
                    paramJson.put("billType", (Object)billTypeParam);
                    JSONObject searchOpt = new JSONObject();
                    if ("0".equals(billTypeParam)) {
                        longType = 0L;
                        if (StringUtils.isNotBlank((CharSequence)invoiceType) && !"-1".equals(invoiceType)) {
                            longType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceType);
                            searchOpt.put("invoiceType", (Object)invoiceType);
                        }
                    }
                    if ("1".equals(billTypeParam)) {
                        longType = InputInvoiceTypeEnum.HGJKS.getCode();
                        searchOpt.put("invoiceType", (Object)InputInvoiceTypeEnum.HGJKS.getAwsType());
                    }
                    if ("2".equals(billTypeParam)) {
                        if ("10".equals(syncType)) {
                            logger.info("\u65b0\u7535\u5b50\u7a0e\u52a1\u5e73\u53f0\u6682\u4e0d\u652f\u6301\u4ee3\u6263\u4ee3\u7f34\u5b8c\u7a0e\u51ed\u8bc1\u5df2\u62b5\u6263\u4e0b\u8f7d");
                            continue;
                        }
                        longType = InputInvoiceTypeEnum.WITHHOLDING.getCode();
                        searchOpt.put("invoiceType", (Object)InputInvoiceTypeEnum.WITHHOLDING.getAwsType());
                    }
                    if (this.existTask(taxNo, taxperiodDate, endTime, longType, syncType, true)) {
                        logger.info("rpa-\u5df2\u52fe\u9009\u6216\u5df2\u62b5\u6263\u8868\u5934\u4e0b\u8f7d\u4efb\u52a1\uff0c\u4e0d\u9700\u65b0\u5efa\u4e0b\u8f7d\u7533\u8bf7");
                        continue;
                    }
                    searchOpt.put("deductFlag", (Object)(downHisPeriod ? "2" : "1"));
                    searchOpt.put("deductionPurpose", (Object)"-1");
                    searchOpt.put("taxPeriod", (Object)taxperiod);
                    paramJson.put("searchOpt", (Object)searchOpt);
                    JSONObject resultObject = newEtaxDeductService.downInvoiceHeadApply(paramJson);
                    if (resultObject != null && ResultContant.isSuccess(resultObject).booleanValue()) {
                        JSONObject logParam = new JSONObject();
                        logParam.put("searchOpt", (Object)searchOpt);
                        logParam.put("rpadownAsyn", (Object)paramJson.getString("rpadownAsyn"));
                        logParam.put("billType", (Object)billTypeParam);
                        logParam.put("taxNo", (Object)taxNo);
                        logParam.put("taskNo", (Object)UUID.getBatchNo(""));
                        logParam.put("syncType", (Object)syncType);
                        invoiceHeaderDownService.insertDownLog(logParam, resultObject);
                        continue;
                    }
                    logger.info("rpa-\u5df2\u52fe\u9009\u6216\u5df2\u62b5\u6263\u5f02\u6b65\u8868\u5934\u4e0b\u8f7d\u7533\u8bf7\u5931\u8d25, \u7a0e\u53f7-{}, billType-{}, \u8fd4\u56de\u503c-{}", new Object[]{taxNo, billTypeParam, resultObject});
                }
                return resultJson;
            }
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u8868\u5934\u53d1\u7968\u5931\u8d25" + taxNo, (Throwable)e);
            resultJson = ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u8868\u5934\u53d1\u7968\u5931\u8d25", (String)"NewEtaxTaxperiodInvoiceDownServiceImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return resultJson;
    }

    public static boolean isSyncDown(String taxNo) {
        Map<String, String> dowSyncMap = ImcConfigUtil.getValue("rim_head_down_syn");
        if (ObjectUtils.isEmpty(dowSyncMap) || ObjectUtils.isEmpty((Object)taxNo)) {
            return false;
        }
        String allAsync = dowSyncMap.get("all_taxno");
        String taxNoAsync = dowSyncMap.get(taxNo);
        String batchTaxNos = dowSyncMap.get("taxnos");
        return StringUtils.contains((CharSequence)batchTaxNos, (CharSequence)taxNo) || "1".equals(allAsync) || "1".equals(taxNoAsync);
    }
}

