/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.impl.NewEtaxDeductService;
import kd.imc.rim.common.invoice.download.impl.NewEtaxTaxperiodInvoiceDownServiceImpl;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.UUID;

public class ShuipanNewTaxperiodInvoiceDownServiceImpl
extends NewEtaxTaxperiodInvoiceDownServiceImpl {
    private static Log logger = LogFactory.getLog(ShuipanNewTaxperiodInvoiceDownServiceImpl.class);

    public ShuipanNewTaxperiodInvoiceDownServiceImpl() {
        this.dkType = "1";
    }

    @Override
    protected JSONObject down(String taxNo, Long orgId, Date startDate, RequestContext requestContext) {
        JSONObject param = new JSONObject();
        param.put("taxNo", (Object)taxNo);
        return this.downByParam(taxNo, orgId, startDate, requestContext, param);
    }

    @Override
    public JSONObject downByParam(String taxNo, Long orgId, Date startDate, RequestContext requestContext, JSONObject param) {
        if (orgId == 0L) {
            orgId = requestContext.getOrgId();
        }
        JSONObject resultJson = ResultContant.createSuccessJSONObject();
        try {
            long longType;
            logger.info("\u7a0e\u76d8-\u4e0b\u8f7d\u589e\u503c\u7a0e\u8868\u5934{}", (Object)taxNo);
            NewEtaxDeductService deductService = new NewEtaxDeductService(orgId);
            String taxperiod = param.getString("taxPeriod");
            String invoiceType = Optional.ofNullable(param.getString("invoiceType")).orElse("");
            taxperiod = Optional.ofNullable(taxperiod).filter(StringUtils::isNotEmpty).orElseGet(() -> deductService.syncGetTaxperiod(taxNo));
            if (StringUtils.isEmpty((CharSequence)taxperiod)) {
                taxperiod = DeductionConstant.getSkssq(taxNo);
            }
            if (StringUtils.isEmpty((CharSequence)taxperiod)) {
                return ResultContant.createJSONObject("0002", ResManager.loadKDString((String)"\u83b7\u53d6\u7a0e\u671f\u5931\u8d25", (String)"NewEtaxTaxperiodInvoiceDownServiceImpl_1", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            Date taxperiodDate = DateUtils.stringToDate(taxperiod, "yyyyMM");
            if (this.existTask(taxNo, taxperiodDate, null, longType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceType).longValue(), "4", false)) {
                return resultJson;
            }
            String batchNo = this.getDownBatchNo();
            DynamicObject downLog = this.getDownLogDynamicObject(batchNo, UUID.getBatchNoByTaxNo(taxNo), orgId, taxNo, 0, "4");
            downLog.set("gov_status", (Object)"6");
            if (longType > 0L) {
                downLog.set("invoice_type", (Object)longType);
                downLog.set("aws_invoice_type", (Object)invoiceType);
            } else {
                downLog.set("invoice_type", (Object)0L);
            }
            downLog.set("invoice_startdate", (Object)taxperiodDate);
            downLog.set("invoice_enddate", (Object)taxperiodDate);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLog});
        }
        catch (Exception e) {
            logger.error("\u7a0e\u76d8-\u4e0b\u8f7d\u8868\u5934\u53d1\u7968\u5931\u8d25" + taxNo, (Throwable)e);
            resultJson = ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u8868\u5934\u53d1\u7968\u5931\u8d25", (String)"NewEtaxTaxperiodInvoiceDownServiceImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return resultJson;
    }
}

