/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.download.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.invoice.download.impl.HeaderInvoiceDownServiceImpl;
import kd.imc.rim.common.utils.DateUtils;

public class TaxperiodInvoiceDownServiceImpl
extends HeaderInvoiceDownServiceImpl {
    private static Log logger = LogFactory.getLog(TaxperiodInvoiceDownServiceImpl.class);

    @Override
    protected JSONObject down(String taxNo, Long orgId, Date startDate, RequestContext requestContext) {
        if (orgId == 0L) {
            orgId = requestContext.getOrgId();
        }
        JSONObject resultJson = ResultContant.createSuccessJSONObject();
        DeductService deductService = DeductServiceFactory.newInstanceForDeduct("2", orgId);
        try {
            String taxperiod = deductService.syncGetTaxperiod(taxNo);
            if (StringUtils.isEmpty((CharSequence)taxperiod)) {
                taxperiod = DeductionConstant.getSkssq(taxNo);
            }
            if (StringUtils.isNotEmpty((CharSequence)taxperiod)) {
                Date taxperiodDate = DateUtils.stringToDate(taxperiod, "yyyyMM");
                if (this.existTask(taxNo, taxperiodDate, null, 0L, "4", false)) {
                    return resultJson;
                }
                resultJson = deductService.queryHistoryStatistics(taxNo, DateUtils.format(taxperiodDate, "yyyy-MM"));
                if (resultJson != null && ResultContant.isSuccess(resultJson).booleanValue()) {
                    String batchNo = this.getDownBatchNo();
                    resultJson.put("taskNo", (Object)taxperiod);
                    this.insertHeaderSyncLog(orgId, taxNo, startDate, batchNo, "4", resultJson, taxperiodDate, taxperiodDate);
                }
            } else {
                resultJson = ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u7a0e\u671f\u5931\u8d25", (String)"TaxperiodInvoiceDownServiceImpl_0", (String)"imc-rim-common", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u7a0e\u671f\u53d1\u7968\u5931\u8d25" + taxNo, (Throwable)e);
            resultJson = ResultContant.createJSONObject(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u7a0e\u671f\u53d1\u7968\u5931\u8d25", (String)"TaxperiodInvoiceDownServiceImpl_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return resultJson;
    }
}

