/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.file;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.HttpUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.file.utils.FileConvertUtils;

public class FileConvertService {
    private static final Log logger = LogFactory.getLog(FileConvertService.class);
    private boolean isAws = "aws".equals(RimConfigUtils.getConfig("rim_fpzs", "converttype"));
    private static final int connectionTimeout = 3000;
    private static final int readTimeout = 60000;

    public String pdf2imageByte(byte[] byteArray, String imageUrl) {
        block7: {
            if (this.isAws()) {
                try {
                    HashMap bodyMap = Maps.newHashMap();
                    String file = UUID.randomUUIDZero() + ".pdf";
                    ByteArrayInputStream valueInputStream = new ByteArrayInputStream(byteArray);
                    AwsFpyService service = AwsFpyService.newInstance();
                    String token = service.getAccessToken(-1L);
                    String url = service.getUrl("msg_generate_snapshots", token);
                    String result = HttpUtil.postFormData(url, AwsFpyService.newInstance().getProxy(), null, valueInputStream, file, bodyMap, 3000, 60000);
                    if (!StringUtils.isNotEmpty((String)result)) break block7;
                    JSONObject json = JSONObject.parseObject((String)result);
                    String snapshotPreUrl = json.getString("snapshotPreUrl");
                    if (StringUtils.isNotEmpty((String)snapshotPreUrl)) {
                        String imageObject = FileUtils.downLoadAndUpload(snapshotPreUrl, UUID.randomUUIDZero());
                        if (imageObject instanceof JSONObject) {
                            return ((JSONObject)imageObject).getString("file_url");
                        }
                        if (imageObject != null) {
                            return imageObject.toString();
                        }
                        break block7;
                    }
                    logger.info("\u8fdc\u7a0b\u751f\u6210\u5feb\u7167:{}", (Object)result);
                }
                catch (Exception e) {
                    logger.error("\u8fdc\u7a0b\u751f\u6210\u5feb\u7167\u5931\u8d25", (Throwable)e);
                }
            } else {
                byte[] imageArray = FileConvertUtils.pdf2imageByte((byte[])byteArray, (String)"jpg");
                String imageResult = FileConvertUtils.upload((byte[])imageArray, null, (String)imageUrl);
                return imageResult;
            }
        }
        return null;
    }

    public boolean isAws() {
        return this.isAws;
    }
}

