/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.query;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DBUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.MD5;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.PermissionUtils;
import kd.imc.rim.common.utils.RimUserService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.tuple.Pair;

public class InvoiceQueryService {
    private static Log LOGGER = LogFactory.getLog(InvoiceQueryService.class);
    private static final String mainFields = "serial_no, invoice_type.id as invoice_type, saler_name, invoice_date, invoice_code, invoice_no, total_amount, total_tax_amount, expense_status";
    public static final String INVOICE_LIST_MOBILE_FIELDS = "id, serial_no, invoice_type.id as invoice_type, saler_name, buyer_name, invoice_date, total_amount, invoice_code, invoice_no, total_tax_amount, expense_status, check_status, original_state, authenticate_flag, invoice_info";

    public static DynamicObject[] loadBySerialNo(String entity, String tenantNo, String[] serialNos) {
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        QFilter serialFilter = new QFilter("serial_no", "in", (Object)serialNos);
        List idList = QueryServiceHelper.queryPrimaryKeys((String)entity, (QFilter[])new QFilter[]{tenantFilter, serialFilter}, null, (int)10000);
        if (!CollectionUtils.isEmpty((Collection)idList)) {
            return BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entity));
        }
        return null;
    }

    public static DynamicObject[] loadBySerialNo(String entity, String tenantNo, List<String> serialNos) {
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        QFilter serialFilter = new QFilter("serial_no", "in", serialNos);
        List idList = QueryServiceHelper.queryPrimaryKeys((String)entity, (QFilter[])new QFilter[]{tenantFilter, serialFilter}, null, (int)10000);
        if (!CollectionUtils.isEmpty((Collection)idList)) {
            return BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entity));
        }
        return null;
    }

    public static DynamicObject[] queryInvoiceHead(String entity, String tenantNo, List<String> serialNos) {
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        QFilter serialFilter = new QFilter("serial_no", "in", serialNos);
        String fields = MetadataUtil.getFields(entity);
        DynamicObject[] collect = BusinessDataServiceHelper.load((String)entity, (String)fields, (QFilter[])new QFilter[]{tenantFilter, serialFilter});
        return collect;
    }

    public static DynamicObject[] loadAllBySerialNo(String entity, String tenantNo, Collection<String> serialNos) {
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        QFilter serialFilter = new QFilter("serial_no", "in", serialNos);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entity, (String)"id", (QFilter[])new QFilter[]{tenantFilter, serialFilter});
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            Object[] idArray = collection.stream().map(s -> s.get("id")).toArray();
            return BusinessDataServiceHelper.load((Object[])idArray, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entity));
        }
        return null;
    }

    public static DynamicObject queryInvoiceFile(String tenantNo, String serialNo) {
        QFilter serialFilter = new QFilter("serial_no", "=", (Object)serialNo);
        DynamicObjectCollection fileCollection = QueryServiceHelper.query((String)"rim_invoice_file", (String)"serial_no,file_hash,original_type,pdf_url,ofd_url,image_url,snapshot_url,icon_url,rotation_angle,region,pixel", (QFilter[])new QFilter[]{serialFilter});
        if (!CollectionUtils.isEmpty((Collection)fileCollection)) {
            return (DynamicObject)fileCollection.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> queryPersonalSerialByCondition(JSONObject param) {
        QFilter invoiceDateEndFilter;
        int pageSize;
        int pageNo;
        if (param == null || param.isEmpty()) {
            return Lists.newArrayList();
        }
        String userType = param.getString("userType");
        String resource = param.getString("resource");
        Pair<String, String> userInfo = FpzsMainService.getUser(param.getString("userId"), userType);
        Long rimUser = 0L;
        String userId = null;
        if (userInfo == null) {
            String openId = MD5.md5Hex(RequestContext.get().getTenantId() + resource + param.getString("userId"));
            if (!StringUtils.isEmpty((CharSequence)param.getString("userId"))) {
                rimUser = RimUserService.createRimUser(param.getString("userId"), resource, "third", openId, "");
            }
        } else {
            userId = (String)userInfo.getLeft();
        }
        QFilter collectUserFilter = null;
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            collectUserFilter = new QFilter("collect_user_entry.collect_user", "=", (Object)Long.parseLong(userId));
        } else if (rimUser != 0L) {
            collectUserFilter = new QFilter("collect_user_entry.rim_user", "=", (Object)rimUser);
        }
        QFilter expenseStatusFilter = null;
        String expenseStatus = InvoiceQueryService.getJSONValue(param, String.class, "expenseStatus");
        if (expenseStatus != null && !StringUtils.isBlank((CharSequence)expenseStatus)) {
            if (expenseStatus.indexOf(44) >= 0) {
                String[] types = expenseStatus.split(",");
                expenseStatusFilter = new QFilter("expense_status", "in", (Object)types);
            } else {
                expenseStatusFilter = new QFilter("expense_status", "=", (Object)expenseStatus);
            }
        }
        if ((pageNo = BigDecimalUtil.transDecimal(param.get((Object)"pageNo")).intValue()) < 1) {
            pageNo = 1;
        }
        if ((pageSize = BigDecimalUtil.transDecimal(param.get((Object)"pageSize")).intValue()) < 1) {
            pageSize = 50;
        } else if (pageSize > 500) {
            pageSize = 500;
        }
        String orderBys = null;
        QFilter deleteFilter = new QFilter("delete", "=", (Object)"1");
        QFilter invoiceDateStartFilter = InvoiceQueryService.createDateStrictFilter(param, "invoiceDateStart", 0, "invoice_date", ">=");
        if (invoiceDateStartFilter == null) {
            invoiceDateStartFilter = InvoiceQueryService.createDateFilter(param, "startTime", 0, "invoice_date", ">=");
        }
        if ((invoiceDateEndFilter = InvoiceQueryService.createDateStrictFilter(param, "invoiceDateEnd", 1, "invoice_date", "<")) == null) {
            invoiceDateEndFilter = InvoiceQueryService.createDateFilter(param, "endTime", 1, "invoice_date", "<");
        }
        if (invoiceDateStartFilter != null || invoiceDateEndFilter != null) {
            orderBys = "invoice_date,id";
        }
        QFilter createTimeStartFilter = InvoiceQueryService.createDateStrictFilter(param, "createTimeStart", 0, "createtime", ">=");
        QFilter creatTimeEndFilter = InvoiceQueryService.createDateStrictFilter(param, "createTimeEnd", 1, "createtime", "<");
        if ((createTimeStartFilter != null || creatTimeEndFilter != null) && StringUtils.isEmpty((CharSequence)orderBys)) {
            orderBys = "createtime,id";
        }
        ORM orm = ORM.create();
        DataSet ds = null;
        if (StringUtils.isEmpty((CharSequence)orderBys)) {
            orderBys = "id";
        }
        try {
            int from = (pageNo - 1) * pageSize;
            ds = orm.queryDataSet("rim.common.InvoiceQueryService", "rim_invoice", "serial_no", new QFilter[]{deleteFilter, invoiceDateStartFilter, invoiceDateEndFilter, createTimeStartFilter, creatTimeEndFilter, expenseStatusFilter, collectUserFilter}, orderBys, from, pageSize);
            DynamicObjectCollection collection = ORMUtil.toDynamicObjectCollection((DataSet)ds, (String)"rim_invoice");
            if (collection != null) {
                LOGGER.info("\u672c\u6b21\u67e5\u8be2\u6570\u636e\u7ed3\u679c\u6570\u91cf\u4e3a\uff1a{}", (Object)collection.size());
                ArrayList<String> list = new ArrayList<String>(collection.size());
                for (DynamicObject obj : collection) {
                    String seralNo = obj.getString("serial_no");
                    if (StringUtils.isEmpty((CharSequence)seralNo)) continue;
                    list.add(seralNo);
                }
                LOGGER.info("\u672c\u6b21\u67e5\u8be2\u53d1\u7968\u6d41\u6c34\u53f7\u6570\u91cf\u4e3a\uff1a{}", (Object)list.size());
                ArrayList<String> arrayList = list;
                return arrayList;
            }
            List<String> list = null;
            return list;
        }
        finally {
            if (ds != null) {
                ds.close();
            }
        }
    }

    public List<Map<String, Object>> queryBySerialNos(List<Long> orgIds, String tenantNo, List<String> serialNos) {
        if (CollectionUtils.isEmpty(serialNos)) {
            return Collections.emptyList();
        }
        QFilter tenantNoFilter = null;
        QFilter orgIdFilter = null;
        if (StringUtils.isNotBlank((CharSequence)tenantNo)) {
            tenantNoFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        }
        if (CollectionUtils.isNotEmpty(orgIds)) {
            orgIdFilter = new QFilter("org_id", "in", orgIds);
        }
        QFilter serialNoFilter = new QFilter("serial_no", "in", serialNos);
        DynamicObjectCollection mainCollection = this.queryMainInvoiceData(new QFilter[]{tenantNoFilter, serialNoFilter, orgIdFilter});
        return DynamicObjectUtil.dynamicObjectColletction2ListMap(mainCollection);
    }

    public DynamicObjectCollection queryMainInvoiceData(QFilter[] qFilters) {
        return QueryServiceHelper.query((String)"rim_invoice", (String)mainFields, (QFilter[])qFilters);
    }

    public Map<String, Object> queryNoVatInvoiceData(Long invoiceTypeCode, String serialNo) {
        String entity = InputInvoiceTypeEnum.getEntity(invoiceTypeCode);
        QFilter serialNoFilter = new QFilter("serial_no", "=", (Object)serialNo);
        if ("rim_inv_air".equals(entity)) {
            DynamicObject noVatObject = QueryServiceHelper.queryOne((String)entity, (String)"customer_name", (QFilter[])new QFilter[]{serialNoFilter});
            return DynamicObjectUtil.dynamicObjectToMap(noVatObject);
        }
        DynamicObject noVatObject = QueryServiceHelper.queryOne((String)entity, (String)"passenger_name", (QFilter[])new QFilter[]{serialNoFilter});
        return DynamicObjectUtil.dynamicObjectToMap(noVatObject);
    }

    public List<Map<String, Object>> queryChildInvoiceData(Long invoiceTypeCode, List<String> serialNos, List<QFilter> qFilters) {
        if (invoiceTypeCode == null || CollectionUtils.isEmpty(serialNos) && CollectionUtils.isEmpty(qFilters)) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isNotEmpty(serialNos)) {
            qFilters.add(new QFilter("serial_no", "in", serialNos));
        }
        qFilters.add(new QFilter("invoice_type", "=", (Object)invoiceTypeCode));
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)InputInvoiceTypeEnum.getEntity(invoiceTypeCode), (String)"serial_no", (QFilter[])((QFilter[])qFilters.stream().toArray(QFilter[]::new)));
        return DynamicObjectUtil.dynamicObjectColletction2ListMap(dynamicObjectCollection);
    }

    public List<Map<String, Object>> queryBySerialNosAndFilter(List<Long> orgIds, Long invoiceTypeCode, String tenantNo, List<String> serialNos, List<QFilter> qFilters) {
        if (CollectionUtils.isEmpty(serialNos) && CollectionUtils.isEmpty(qFilters)) {
            return Collections.emptyList();
        }
        if (StringUtils.isNotBlank((CharSequence)tenantNo)) {
            qFilters.add(new QFilter("tenant_no", "=", (Object)tenantNo));
        }
        if (CollectionUtils.isNotEmpty(orgIds)) {
            qFilters.add(new QFilter("org_id", "in", orgIds));
        }
        if (StringUtils.isNotBlank((Object)invoiceTypeCode) && 1L != invoiceTypeCode) {
            qFilters.add(new QFilter("invoice_type", "=", (Object)invoiceTypeCode));
        }
        if (CollectionUtils.isNotEmpty(serialNos)) {
            qFilters.add(new QFilter("serial_no", "in", serialNos));
        }
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"rim_invoice", (String)mainFields, (QFilter[])((QFilter[])qFilters.stream().toArray(QFilter[]::new)));
        return DynamicObjectUtil.dynamicObjectColletction2ListMap(dynamicObjectCollection);
    }

    public DynamicObjectCollection queryByFilter(QFilter qFilter, String orderBys, int top) {
        return QueryServiceHelper.query((String)"rim_invoice", (String)INVOICE_LIST_MOBILE_FIELDS, (QFilter[])new QFilter[]{qFilter}, (String)orderBys, (int)top);
    }

    public DynamicObject loadMobOneByFilter(QFilter qFilter) {
        return QueryServiceHelper.queryOne((String)"rim_invoice", (String)INVOICE_LIST_MOBILE_FIELDS, (QFilter[])new QFilter[]{qFilter});
    }

    public DynamicObjectCollection queryByFilter(QFilter qFilter) {
        return QueryServiceHelper.query((String)"rim_invoice", (String)INVOICE_LIST_MOBILE_FIELDS, (QFilter[])new QFilter[]{qFilter});
    }

    public DynamicObjectCollection findByFilter(String mainFields, QFilter qFilter) {
        return QueryServiceHelper.query((String)"rim_invoice", (String)mainFields, (QFilter[])new QFilter[]{qFilter});
    }

    public DynamicObject queryOne(String mainFields, QFilter qFilter) {
        return QueryServiceHelper.queryOne((String)"rim_invoice", (String)mainFields, (QFilter[])new QFilter[]{qFilter});
    }

    public static Map<String, String> querySerialByCodeAndNo(JSONArray param) {
        List<Map<String, Object>> queryList;
        HashMap<String, String> result = new HashMap<String, String>(param.size());
        String selectSql = "select fserial_no,finvoice_code,finvoice_no,finvoice_type from t_rim_invoice where ";
        int i = 0;
        StringBuilder whereSql = new StringBuilder();
        whereSql.append(selectSql);
        for (int idx = 0; idx < param.size(); ++idx) {
            JSONObject map = param.getJSONObject(idx);
            if (++i % 50 == 0) {
                List<Map<String, Object>> queryList2 = DBUtils.query(whereSql.toString());
                if (queryList2 != null && !queryList2.isEmpty()) {
                    InvoiceQueryService.changeReuslt(result, queryList2);
                }
                whereSql = new StringBuilder();
                whereSql.append(selectSql);
                continue;
            }
            if (whereSql.length() > selectSql.length() + 1) {
                whereSql.append(" or ");
            }
            whereSql.append('(').append("finvoice_code='").append(map.getString("invoiceCode")).append('\'');
            whereSql.append(" and finvoice_no='").append(map.getString("invoiceNo")).append("')");
        }
        if (whereSql.length() - selectSql.length() > 0 && (queryList = DBUtils.query(whereSql.toString())) != null && !queryList.isEmpty()) {
            InvoiceQueryService.changeReuslt(result, queryList);
        }
        return result;
    }

    private static void changeReuslt(Map<String, String> result, List<Map<String, Object>> queryList) {
        if (queryList != null && !queryList.isEmpty()) {
            for (Map<String, Object> map : queryList) {
                result.put(String.valueOf(map.get("FINVOICE_CODE")) + '-' + String.valueOf(map.get("FINVOICE_NO")), String.valueOf(map.get("FSERIAL_NO")));
            }
        }
    }

    public static Map<String, String> querySerialNoByTypeCodeAndNo(JSONArray array, boolean isEle) {
        HashMap<String, String> result = new HashMap<String, String>(array.size());
        String select = "SELECT FSERIAL_NO,FINVOICE_CODE,FINVOICE_NO,FINVOICE_TYPE FROM T_RIM_INVOICE WHERE ";
        StringBuilder sb = new StringBuilder();
        sb.append(select);
        int batchSize = 50;
        for (int i = 0; i < array.size(); ++i) {
            if (sb.length() > select.length()) {
                sb.append(" or ");
            }
            JSONObject invoice = array.getJSONObject(i);
            sb.append("(");
            if (!isEle) {
                sb.append("FINVOICE_CODE=").append('\'').append(invoice.getString("invoiceCode")).append('\'');
                sb.append(" and ");
            }
            sb.append("FINVOICE_NO=").append('\'').append(invoice.getString("invoiceNo")).append('\'');
            sb.append(" and ");
            Long typeId = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoice.getString("invoiceType"));
            sb.append("FINVOICE_TYPE=").append('\'').append(typeId.toString()).append('\'');
            sb.append(")");
            if ((i + 1) % batchSize != 0) continue;
            List<Map<String, Object>> batch = DBUtils.query(sb.toString());
            InvoiceQueryService.appendData(result, batch, isEle);
            sb.setLength(0);
            sb.append(select);
        }
        if (sb.length() > select.length()) {
            List<Map<String, Object>> batch = DBUtils.query(sb.toString());
            InvoiceQueryService.appendData(result, batch, isEle);
            sb.setLength(0);
        }
        return result;
    }

    private static void appendData(Map<String, String> allMap, List<Map<String, Object>> subList, boolean isEle) {
        if (subList != null && !subList.isEmpty()) {
            for (Map<String, Object> map : subList) {
                String awsType = InputInvoiceTypeEnum.getAwsType(map.get("FINVOICE_TYPE"));
                String k = isEle ? awsType + '-' + map.get("FINVOICE_NO") : awsType + '-' + map.get("FINVOICE_NO") + '-' + map.get("FINVOICE_CODE");
                allMap.put(k, String.valueOf(map.get("FSERIAL_NO")));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> querySerialByCondition(JSONObject param) {
        String collectUserNo;
        Long collectUserId;
        String creatorNo;
        Long creatorId;
        QFilter invoiceTypeFilter;
        QFilter orgNumberFilter;
        QFilter updateTimeEndFilter;
        QFilter updateTimeFilter;
        QFilter creatTimeEndFilter;
        QFilter createTimeStartFilter;
        QFilter invoiceDateEndFilter;
        QFilter invoiceDateStartFilter;
        QFilter deleteFilter;
        String orderBys;
        int pageSize;
        int pageNo;
        block62: {
            String invoiceType;
            block64: {
                block63: {
                    HasPermOrgResult hasPermOrgResult;
                    JSONArray array = param.getJSONArray("serialNos");
                    if (array != null && !array.isEmpty()) {
                        ArrayList<String> list = new ArrayList<String>(array.size());
                        int i = 0;
                        while (i < array.size()) {
                            list.add(array.getString(i));
                            ++i;
                        }
                        return list;
                    }
                    String expenseId = param.getString("expenseId");
                    if (!StringUtils.isEmpty((CharSequence)expenseId)) {
                        String entityId = param.getString("entityId");
                        QFilter entityIdFilter = null;
                        if (!StringUtils.isEmpty((CharSequence)entityId)) {
                            entityIdFilter = new QFilter("entityid", "=", (Object)entityId);
                        }
                        QFilter filter = new QFilter("expense_id", "=", (Object)expenseId);
                        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"serial_no", (QFilter[])new QFilter[]{filter, entityIdFilter});
                        QFilter filter2 = new QFilter("expense_id", "=", (Object)(entityId + "_" + expenseId));
                        DynamicObjectCollection collection2 = QueryServiceHelper.query((String)"rim_expense_relation", (String)"serial_no", (QFilter[])new QFilter[]{filter2, entityIdFilter});
                        if (collection2.size() > 0) {
                            collection.addAll((Collection)collection2);
                        }
                        LOGGER.info("\u67e5\u8be2\u53d1\u7968\uff0c\u53c2\u6570\uff1a{}\uff0c{}\uff0c\u7ed3\u679c\uff1a{}", new Object[]{filter, entityIdFilter, collection});
                        ArrayList<String> serialList = new ArrayList<String>(collection.size());
                        collection.forEach(expense -> serialList.add(expense.getString("serial_no")));
                        return serialList;
                    }
                    pageNo = BigDecimalUtil.transDecimal(param.get((Object)"pageNo")).intValue();
                    if (pageNo < 1) {
                        pageNo = 1;
                    }
                    if ((pageSize = BigDecimalUtil.transDecimal(param.get((Object)"pageSize")).intValue()) < 1) {
                        pageSize = 50;
                    } else if (pageSize > 500) {
                        pageSize = 500;
                    }
                    orderBys = null;
                    deleteFilter = new QFilter("delete", "=", (Object)"1");
                    invoiceDateStartFilter = InvoiceQueryService.createDateFilter(param, "invoiceDateStart", 0, "invoice_date", ">=");
                    if (invoiceDateStartFilter == null) {
                        invoiceDateStartFilter = InvoiceQueryService.createDateFilter(param, "startTime", 0, "invoice_date", ">=");
                    }
                    if ((invoiceDateEndFilter = InvoiceQueryService.createDateFilter(param, "invoiceDateEnd", 1, "invoice_date", "<")) == null) {
                        invoiceDateEndFilter = InvoiceQueryService.createDateFilter(param, "endTime", 1, "invoice_date", "<");
                    }
                    if (invoiceDateStartFilter != null || invoiceDateEndFilter != null) {
                        orderBys = "invoice_date,id";
                    }
                    createTimeStartFilter = InvoiceQueryService.createDateFilter(param, "createTimeStart", 0, "createtime", ">=");
                    creatTimeEndFilter = InvoiceQueryService.createDateFilter(param, "creatTimeEnd", 1, "createtime", "<");
                    if ((createTimeStartFilter != null || creatTimeEndFilter != null) && StringUtils.isEmpty((CharSequence)orderBys)) {
                        orderBys = "createtime,id";
                    }
                    updateTimeFilter = null;
                    Date updateTime = InvoiceQueryService.getJSONValue(param, Date.class, "updateTime");
                    if (updateTime != null) {
                        orderBys = "modifytime,id";
                        updateTimeFilter = new QFilter("modifytime", ">=", (Object)updateTime);
                    }
                    updateTimeEndFilter = null;
                    Date updateTimeEnd = InvoiceQueryService.getJSONValue(param, Date.class, "updateTimeEnd");
                    if (updateTimeEnd != null) {
                        updateTimeEndFilter = new QFilter("modifytime", "<", (Object)updateTimeEnd);
                        if (StringUtils.isEmpty((CharSequence)orderBys)) {
                            orderBys = "modifytime,id";
                        }
                    }
                    orgNumberFilter = null;
                    JSONArray orgNumber = param.getJSONArray("orgNumber");
                    if (!CollectionUtils.isEmpty((Collection)orgNumber)) {
                        ArrayList<Long> pks = null;
                        if ("1".equals(param.getString("orgType"))) {
                            QFilter idFilter = new QFilter("third_org_no", "in", (Object)orgNumber);
                            DynamicObjectCollection thirdOrgObject = QueryServiceHelper.query((String)"bdm_third_org", (String)"id,third_org_no,org_no,orgid", (QFilter[])new QFilter[]{idFilter});
                            if (!CollectionUtils.isEmpty((Collection)thirdOrgObject)) {
                                pks = new ArrayList<Long>(thirdOrgObject.size());
                                for (DynamicObject org : thirdOrgObject) {
                                    pks.add(BigDecimalUtil.transDecimal(org.get("orgid")).longValue());
                                }
                            }
                        } else {
                            QFilter filter = new QFilter("number", "in", (Object)orgNumber);
                            pks = QueryServiceHelper.queryPrimaryKeys((String)"bos_org", (QFilter[])new QFilter[]{filter}, null, (int)1000);
                        }
                        if (CollectionUtils.isEmpty((Collection)pks)) {
                            LOGGER.info("\u7ec4\u7ec7\u7f16\u7801\u4e0d\u5b58\u5728:{}", (Object)orgNumber);
                            return null;
                        }
                        orgNumberFilter = new QFilter("org", "in", pks);
                    } else if ("1".equals(param.getString("checkAuth")) && !(hasPermOrgResult = PermissionUtils.getAllPermOrgs("rim", "rim_invoice", "47150e89000000ac")).hasAllOrgPerm()) {
                        if (CollectionUtils.isEmpty((Collection)hasPermOrgResult.getHasPermOrgs())) {
                            LOGGER.info("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5168\u7968\u6c60\u67e5\u8be2\u6743\u9650");
                            return null;
                        }
                        LOGGER.info("\u975e\u5168\u529f\u80fd\u7528\u6237\u67e5\u8be2\u6709\u6743\u9650\u7684\u7ec4\u7ec7");
                        orgNumberFilter = new QFilter("org", "in", (Object)hasPermOrgResult.getHasPermOrgs());
                    }
                    invoiceTypeFilter = null;
                    invoiceType = InvoiceQueryService.getJSONValue(param, String.class, "invoiceType");
                    if (invoiceType == null || "".equals(invoiceType)) break block62;
                    if (invoiceType.indexOf(44) < 0) break block63;
                    DynamicObject types = invoiceType.split(",");
                    if (types != null) {
                        ArrayList<Long> typeList = new ArrayList<Long>(((String[])types).length);
                        for (DynamicObject type : types) {
                            Long typeLong = InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)type);
                            if (typeLong <= 0L) continue;
                            typeList.add(typeLong);
                        }
                        if (!typeList.isEmpty()) {
                            invoiceTypeFilter = new QFilter("invoice_type", "in", typeList);
                        }
                    }
                    break block64;
                }
                Long typeLong = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceType);
                if (typeLong > 0L) {
                    invoiceTypeFilter = new QFilter("invoice_type", "=", (Object)typeLong);
                }
            }
            if (invoiceTypeFilter == null) {
                LOGGER.info("\u53d1\u7968\u7c7b\u578b\u9519\u8bef{}", (Object)invoiceType);
                return null;
            }
        }
        QFilter invoiceCodeFilter = InvoiceQueryService.createStringFilter(param, "invoiceCode", "invoice_code");
        QFilter invoiceNoFilter = InvoiceQueryService.createStringFilter(param, "invoiceNo", "invoice_no");
        QFilter invoiceStatusFilter = InvoiceQueryService.createListFilter(param, "invoiceStatus", "invoice_status");
        QFilter authenticateFlagFilter = InvoiceQueryService.createListFilter(param, "authenticateFlag", "authenticate_flag");
        QFilter transportFilter = InvoiceQueryService.createListFilter(param, "transportDeduction", "transport_deduction");
        QFilter salerTaxNoFilter = InvoiceQueryService.createListFilter(param, "salerTaxNo", "saler_tax_no");
        QFilter buyerTaxNoFilter = InvoiceQueryService.createListFilter(param, "buyerTaxNo", "buyer_tax_no");
        QFilter expenseStatusFilter = null;
        String expenseStatus = InvoiceQueryService.getJSONValue(param, String.class, "expenseStatus");
        if (expenseStatus != null && !StringUtils.isBlank((CharSequence)expenseStatus)) {
            if (expenseStatus.indexOf(44) >= 0) {
                String[] types = expenseStatus.split(",");
                expenseStatusFilter = new QFilter("expense_status", "in", (Object)types);
            } else {
                expenseStatusFilter = new QFilter("expense_status", "=", (Object)expenseStatus);
            }
        }
        QFilter selectTimeStartFilter = InvoiceQueryService.createDateFilter(param, "selectTimeStart", 0, "select_time", ">=");
        QFilter selectTimeEndFilter = InvoiceQueryService.createDateFilter(param, "selectTimeEnd", 1, "select_time", "<");
        String taxPeriod = param.getString("taxPeriod");
        QFilter taxPeriodStartFilter = null;
        QFilter taxPeriodEndFilter = null;
        if (!StringUtils.isEmpty((CharSequence)taxPeriod)) {
            taxPeriod = taxPeriod.replace("-", "");
            Date taxPeriodDate = null;
            if (taxPeriod.length() == 6) {
                taxPeriodDate = DateUtils.stringToDate(taxPeriod, "yyyyMM");
            } else if (taxPeriod.length() == 8) {
                taxPeriodDate = DateUtils.stringToDate(taxPeriod, "yyyyMMdd");
            }
            taxPeriodStartFilter = new QFilter("tax_period", ">=", (Object)DateUtils.getFirstDateOfMonth(taxPeriodDate));
            taxPeriodEndFilter = new QFilter("tax_period", "<", (Object)DateUtils.getLastDateOfMonth(taxPeriodDate));
        }
        if (transportFilter != null && invoiceTypeFilter == null) {
            Long[] transportTypes = InputInvoiceTypeEnum.getTransportTypes();
            ArrayList<Long> typeArray = new ArrayList<Long>(16);
            for (Long type : transportTypes) {
                typeArray.add(type);
            }
            invoiceTypeFilter = new QFilter("invoice_type", "in", typeArray);
        }
        if (selectTimeStartFilter != null || selectTimeEndFilter != null || taxPeriodStartFilter != null) {
            if (invoiceTypeFilter == null && (selectTimeStartFilter != null || selectTimeEndFilter != null)) {
                invoiceTypeFilter = new QFilter("invoice_type", "in", (Object)InputInvoiceTypeEnum.getDeductionTypes());
            } else if (invoiceTypeFilter == null && taxPeriodStartFilter != null) {
                ArrayList<Long> typeArray = new ArrayList<Long>(16);
                Long[] deductionTypes = InputInvoiceTypeEnum.getDeductionTypes();
                Long[] transportTypes = InputInvoiceTypeEnum.getTransportTypes();
                for (Long type : deductionTypes) {
                    typeArray.add(type);
                }
                for (Long type : transportTypes) {
                    typeArray.add(type);
                }
                invoiceTypeFilter = new QFilter("invoice_type", "in", typeArray);
            }
            if (StringUtils.isEmpty((CharSequence)orderBys)) {
                if (selectTimeStartFilter != null || selectTimeEndFilter != null) {
                    orderBys = "select_time,id";
                } else if (taxPeriodStartFilter != null) {
                    orderBys = "tax_period,id";
                }
            }
        }
        if ((creatorId = Long.valueOf(BigDecimalUtil.transDecimal(InvoiceQueryService.getJSONValue(param, String.class, "creatorId")).longValue())) <= 0L && !StringUtils.isEmpty((CharSequence)(creatorNo = InvoiceQueryService.getJSONValue(param, String.class, "creatorNo"))) && (creatorId = InvoiceQueryService.getUserIdByUserNo(creatorNo)) <= 0L) {
            LOGGER.info("\u7528\u6237\u7f16\u7801\u4e0d\u5b58\u5728{}", (Object)creatorNo);
            return null;
        }
        QFilter creatorFilter = null;
        if (creatorId > 0L) {
            creatorFilter = new QFilter("creator", "=", (Object)creatorId);
        }
        if ((collectUserId = Long.valueOf(BigDecimalUtil.transDecimal(InvoiceQueryService.getJSONValue(param, String.class, "collectUserId")).longValue())) <= 0L && !StringUtils.isEmpty((CharSequence)(collectUserNo = InvoiceQueryService.getJSONValue(param, String.class, "collectUserNo"))) && (collectUserId = InvoiceQueryService.getUserIdByUserNo(collectUserNo)) <= 0L) {
            LOGGER.info("\u7528\u6237\u7f16\u7801\u4e0d\u5b58\u5728{}", (Object)collectUserNo);
            return null;
        }
        QFilter collectUserFilter = null;
        if (collectUserId > 0L) {
            collectUserFilter = new QFilter("collect_user_entry.collect_user", "=", (Object)collectUserId);
        }
        ORM orm = ORM.create();
        DataSet ds = null;
        if (StringUtils.isEmpty((CharSequence)orderBys)) {
            orderBys = "id";
        }
        try {
            int from = (pageNo - 1) * pageSize;
            ds = orm.queryDataSet("rim.common.InvoiceQueryService", "rim_invoice", "serial_no", new QFilter[]{deleteFilter, invoiceDateStartFilter, invoiceDateEndFilter, createTimeStartFilter, creatTimeEndFilter, updateTimeFilter, updateTimeEndFilter, orgNumberFilter, invoiceTypeFilter, salerTaxNoFilter, buyerTaxNoFilter, invoiceCodeFilter, invoiceNoFilter, invoiceStatusFilter, authenticateFlagFilter, expenseStatusFilter, selectTimeStartFilter, selectTimeEndFilter, taxPeriodStartFilter, taxPeriodEndFilter, creatorFilter, collectUserFilter}, orderBys, from, pageSize);
            DynamicObjectCollection collection = ORMUtil.toDynamicObjectCollection((DataSet)ds, (String)"rim_invoice");
            if (collection != null) {
                ArrayList<String> list = new ArrayList<String>(collection.size());
                Object object = collection.iterator();
                while (true) {
                    if (!object.hasNext()) {
                        object = list;
                        return object;
                    }
                    DynamicObject obj = (DynamicObject)object.next();
                    String seralNo = obj.getString("serial_no");
                    if (StringUtils.isEmpty((CharSequence)seralNo)) continue;
                    list.add(seralNo);
                }
            }
            List<String> list = null;
            return list;
        }
        finally {
            if (ds != null) {
                ds.close();
            }
        }
    }

    private static Long getUserIdByUserNo(String userNo) {
        QFilter filter = new QFilter("number", "=", (Object)userNo);
        DynamicObject receiverObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"id,name", (QFilter[])filter.toArray());
        if (receiverObj != null) {
            return receiverObj.getLong("id");
        }
        return 0L;
    }

    private static <T> T getJSONValue(JSONObject invoiceJson, Class<T> clazz, String key) {
        try {
            Object value = invoiceJson.getObject(key, clazz);
            return (T)value;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static <T> T getStrictJSONValue(JSONObject invoiceJson, Class<T> clazz, String key) {
        try {
            Object value = invoiceJson.getObject(key, clazz);
            return (T)value;
        }
        catch (Exception e) {
            throw new MsgException(key + ": format error");
        }
    }

    private static QFilter createStringFilter(JSONObject param, String paramKey, String property) {
        if (param == null) {
            return null;
        }
        String date = InvoiceQueryService.getJSONValue(param, String.class, paramKey);
        if (date == null) {
            return null;
        }
        return new QFilter(property, "=", (Object)date);
    }

    private static QFilter createListFilter(JSONObject param, String paramKey, String property) {
        if (param == null) {
            return null;
        }
        String string = InvoiceQueryService.getJSONValue(param, String.class, paramKey);
        if (string == null || StringUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (string.indexOf(44) >= 0) {
            String[] types = string.split(",");
            if (types != null) {
                ArrayList<String> typeList = new ArrayList<String>(types.length);
                for (String type : types) {
                    if (StringUtils.isEmpty((CharSequence)type)) continue;
                    typeList.add(type);
                }
                if (!typeList.isEmpty()) {
                    return new QFilter(property, "in", typeList);
                }
            }
        } else {
            return new QFilter(property, "=", (Object)string);
        }
        return null;
    }

    private static QFilter createDateFilter(JSONObject param, String paramKey, int addDay, String property, String cp) {
        if (param == null) {
            return null;
        }
        Date date = InvoiceQueryService.getJSONValue(param, Date.class, paramKey);
        Date newDate = InvoiceQueryService.convertData(date, addDay);
        if (newDate != null) {
            return new QFilter(property, cp, (Object)newDate);
        }
        return null;
    }

    private static QFilter createDateStrictFilter(JSONObject param, String paramKey, int addDay, String property, String cp) {
        if (param == null) {
            return null;
        }
        Date date = InvoiceQueryService.getStrictJSONValue(param, Date.class, paramKey);
        Date newDate = InvoiceQueryService.convertData(date, addDay);
        if (newDate != null) {
            return new QFilter(property, cp, (Object)newDate);
        }
        return null;
    }

    private static Date convertData(Date date, int addDay) {
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(5, addDay);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return calendar.getTime();
        }
        return null;
    }

    public static List<String> getSerialNoListByIds(List<Long> mainIds) {
        QFilter qFilter = new QFilter("id", "in", mainIds);
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"rim_invoice", (String)"serial_no", (QFilter[])qFilter.toArray());
        List<Object> serialNos = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)objects)) {
            serialNos = objects.stream().map(s -> s.getString("serial_no")).collect(Collectors.toList());
        }
        return serialNos;
    }
}

