/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.recognition;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.invoice.recognition.impl.RecognitionCheckRemoteTask;
import kd.imc.rim.common.invoice.recognition.impl.RecognitionCheckTask;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.MD5;
import org.apache.commons.lang3.tuple.Pair;

public abstract class RecognitionCheckParentTask
implements Callable<JSONObject> {
    protected static final Log logger = LogFactory.getLog(RecognitionCheckParentTask.class);
    protected static final int cache_time_out = 1800;
    protected JSONObject businessParam;
    protected Map<String, Object> customParam;
    protected String url;
    protected String fileName;
    protected String pageId;
    protected String source;
    protected RequestContext ctx;
    public static final String waiting = "waiting";
    public static final String success = "success";
    public static final String fail = "fail";
    protected static final List<String> telGoodNames = new ArrayList<String>(12){
        protected static final long serialVersionUID = 2608083843312492007L;
        {
            this.add("\u7535\u4fe1\u670d\u52a1");
            this.add("\u57fa\u7840\u7535\u4fe1\u670d\u52a1");
            this.add("\u8bed\u97f3\u901a\u8bdd\u670d\u52a1");
            this.add("\u51fa\u79df\u6216\u51fa\u552e\u7f51\u7edc\u5143\u7d20");
            this.add("\u589e\u503c\u7535\u4fe1\u670d\u52a1");
            this.add("\u77ed\u4fe1\u548c\u5f69\u4fe1\u670d\u52a1");
            this.add("\u7535\u5b50\u6570\u636e\u548c\u4fe1\u606f\u7684\u4f20\u8f93\u53ca\u5e94\u7528\u670d\u52a1");
            this.add("\u4e92\u8054\u7f51\u63a5\u5165\u670d\u52a1");
            this.add("\u5e7f\u64ad\u7535\u89c6\u4fe1\u53f7\u4f20\u8f93\u670d\u52a1");
            this.add("\u536b\u661f\u7535\u89c6\u4fe1\u53f7\u843d\u5730\u8f6c\u63a5\u670d\u52a1");
            this.add("\u5176\u4ed6\u589e\u503c\u7535\u4fe1\u670d\u52a1");
        }
    };

    public RecognitionCheckParentTask(RequestContext ctx, String source, String pageId, JSONObject businessParam, Map<String, Object> customParam, String url, String fileName) {
        this.businessParam = businessParam;
        this.customParam = customParam;
        this.url = url;
        this.fileName = fileName;
        this.pageId = pageId;
        this.source = source;
        this.ctx = ctx;
    }

    public RecognitionCheckParentTask newInstance(boolean isMultiTenant) {
        if (isMultiTenant) {
            return new RecognitionCheckRemoteTask(this.ctx, this.source, this.pageId, this.businessParam, this.customParam, this.url, this.fileName);
        }
        return new RecognitionCheckTask(this.ctx, this.source, this.pageId, this.businessParam, this.customParam, this.url, this.fileName);
    }

    public abstract JSONObject execute();

    public void dealSuccess(JSONObject invoiceResult, String pageId) {
        if (ResultContant.isSuccess(invoiceResult).booleanValue()) {
            JSONArray invoiceArray = invoiceResult.getJSONArray("data");
            RecognitionCheckParentTask.classOfInvoice(invoiceArray);
            JSONArray failInvoiceArray = invoiceResult.getJSONArray("failData");
            JSONArray attachArray = invoiceResult.getJSONArray("attach");
            if (!CollectionUtils.isEmpty((Collection)failInvoiceArray)) {
                CacheHelper.put(pageId + "failResult", failInvoiceArray.toJSONString(), 1800);
            }
            if (invoiceArray != null || attachArray != null) {
                CacheHelper.put(pageId + "refresh", "1", 1800);
                if ("fpzs".equals(this.source)) {
                    Pair<JSONObject, Boolean> cachePair = FpzsMainService.cacheInvoiceList(pageId, this.customParam, invoiceArray, attachArray);
                    if (((Boolean)cachePair.getRight()).booleanValue()) {
                        CacheHelper.put(pageId + "scannerProcessRepeat", cachePair.getRight() + "", 1800);
                    }
                } else {
                    RecognitionCheckParentTask.saveCacheFileResult(this.url, invoiceArray);
                }
                RecognitionCheckParentTask.saveCacheFile(pageId, this.url, success);
            } else {
                RecognitionCheckParentTask.saveCacheFile(pageId, this.url, fail);
            }
        } else {
            RecognitionCheckParentTask.saveCacheFile(pageId, this.url, fail);
            this.saveCacheCause(pageId, this.url, fail, invoiceResult.getString("description"));
        }
    }

    public static void classOfInvoice(JSONArray invoiceArray) {
        if (invoiceArray == null) {
            return;
        }
        for (int i = 0; i < invoiceArray.size(); ++i) {
            JSONObject invoice = invoiceArray.getJSONObject(i);
            Long invoiceType = invoice.getLong("invoiceType");
            if (!InputInvoiceTypeEnum.needClassOfInvoice(invoiceType)) continue;
            boolean telFlag = RecognitionCheckParentTask.telType(invoice);
            boolean childFlag = RecognitionCheckParentTask.childType(invoice);
            if (telFlag && childFlag) {
                RecognitionCheckParentTask.setInvoiceClass(invoice, "11", "9");
                continue;
            }
            if (telFlag) {
                RecognitionCheckParentTask.setInvoiceClass(invoice, "9");
                continue;
            }
            if (!childFlag) continue;
            RecognitionCheckParentTask.setInvoiceClass(invoice, "11");
        }
    }

    protected static boolean childType(JSONObject invoice) {
        boolean flag;
        block4: {
            Long invoiceType;
            block3: {
                flag = false;
                invoiceType = invoice.getLong("invoiceType");
                if (!InputInvoiceTypeEnum.FINANCIAL_INVOICE.getCode().equals(invoiceType)) break block3;
                String invoicingPartyName = invoice.getString("invoicingPartyName");
                if (!StringUtils.isNotEmpty((CharSequence)invoicingPartyName) || !invoicingPartyName.contains("\u5e7c\u513f\u56ed")) break block4;
                flag = true;
                break block4;
            }
            if (InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ORDINARY_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.GENERAL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType)) {
                JSONArray items = invoice.getJSONArray("items");
                if (items == null) {
                    return false;
                }
                for (int i = 0; i < items.size(); ++i) {
                    JSONObject item = items.getJSONObject(i);
                    String goodName = item.getString("goodsName");
                    if (!StringUtils.isNotEmpty((CharSequence)goodName) || !goodName.contains("\u4fdd\u6559\u8d39")) continue;
                    flag = true;
                    break;
                }
            }
        }
        return flag;
    }

    protected static boolean telType(JSONObject invoice) {
        Long invoiceType = invoice.getLong("invoiceType");
        boolean telFlag = false;
        if (InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ORDINARY_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoiceType) || InputInvoiceTypeEnum.GENERAL_ELECTRON.getCode().equals(invoiceType)) {
            JSONArray items = invoice.getJSONArray("items");
            if (items == null) {
                return false;
            }
            boolean flag = false;
            for (int i = 0; i < items.size(); ++i) {
                JSONObject item = items.getJSONObject(i);
                String goodName = item.getString("goodsName");
                if (StringUtils.isEmpty((CharSequence)goodName)) continue;
                for (String s : telGoodNames) {
                    if (!goodName.contains(s)) continue;
                    telFlag = true;
                    flag = true;
                    break;
                }
                if (flag) break;
            }
        }
        return telFlag;
    }

    protected static void setInvoiceClass(JSONObject invoice, String ... classType) {
        Long mainId = invoice.getLong("mainId");
        DynamicObject invoices = BusinessDataServiceHelper.loadSingle((String)"rim_invoice", (String)"id, mul_class, ext_info", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)mainId)});
        if (invoices != null) {
            String mulClassStr = String.join((CharSequence)",", classType);
            String extInfo = invoices.getString("ext_info");
            JSONObject extObject = new JSONObject();
            if (StringUtils.isNotEmpty((CharSequence)extInfo)) {
                try {
                    extObject = JSONObject.parseObject((String)extInfo);
                }
                catch (Exception e) {
                    extObject = new JSONObject();
                }
            }
            extObject.put("sys_mulclass", (Object)mulClassStr);
            invoices.set("ext_info", (Object)extObject.toString());
            DynamicObjectCollection mul_class = invoices.getDynamicObjectCollection("mul_class");
            if (CollectionUtils.isEmpty((Collection)mul_class)) {
                for (String typeStr : classType) {
                    DynamicObject classInfo = mul_class.addNew();
                    classInfo.set("fbasedataid_id", (Object)typeStr);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoices});
                }
            }
        }
    }

    public JSONObject getBusinessParam() {
        return this.businessParam;
    }

    public void setBusinessParam(JSONObject businessParam) {
        this.businessParam = businessParam;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public static void saveCacheFileResult(String url, JSONArray result) {
        if (result != null) {
            CacheHelper.put(MD5.md5Hex(url), result.toJSONString(), 1800);
        } else {
            CacheHelper.remove(MD5.md5Hex(url));
        }
    }

    public static JSONArray queryCacheFileResult(String url) {
        String result = CacheHelper.get(MD5.md5Hex(url));
        if (result != null) {
            return JSONArray.parseArray((String)result);
        }
        return new JSONArray();
    }

    public static void saveCacheFile(String pageId, String url, String operate) {
        RecognitionCheckParentTask.cacheFile(pageId, url, operate);
    }

    public void saveCacheCause(String pageId, String url, String operate, String cause) {
        RecognitionCheckParentTask.cacheCause(pageId, url, operate, cause);
    }

    public static JSONObject queryCacheFile(String pageId) {
        return RecognitionCheckParentTask.cacheFile(pageId, null, "query");
    }

    public static JSONObject queryCacheCause(String pageId) {
        return RecognitionCheckParentTask.cacheCause(pageId, null, "query", null);
    }

    public static void clearCacheFile(String pageId) {
        RecognitionCheckParentTask.cacheFile(pageId, null, "remove");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static JSONObject cacheCause(String pageId, String url, String operate, String cause) {
        logger.info(pageId + url + operate + cause);
        if (StringUtils.isEmpty((CharSequence)pageId)) {
            return null;
        }
        String cacheKey = "scaner_cause_" + pageId;
        Throwable throwable = null;
        try (DLock lock = DLock.create((String)("lock_" + cacheKey), (String)ResManager.loadKDString((String)"\u5237\u65b0\u5361\u7247\u9501", (String)"RecognitionCheckTask_1", (String)"imc-rim-common", (Object[])new Object[0]));){
            for (int times = 0; times < 10; ++times) {
                JSONObject jSONObject;
                JSONObject obj;
                block29: {
                    block28: {
                        if (!lock.tryLock(100L)) continue;
                        times = 100;
                        if (!"remove".equals(operate)) break block28;
                        CacheHelper.remove(cacheKey);
                        JSONObject jSONObject2 = null;
                        lock.unlock();
                        return jSONObject2;
                    }
                    String cache = CacheHelper.get(cacheKey);
                    obj = null;
                    obj = StringUtils.isEmpty((CharSequence)cache) ? new JSONObject() : JSON.parseObject((String)cache);
                    if (!"query".equals(operate)) break block29;
                    JSONObject jSONObject3 = obj;
                    lock.unlock();
                    return jSONObject3;
                }
                try {
                    if (StringUtils.isNotEmpty((CharSequence)url) && StringUtils.isNotEmpty((CharSequence)operate) && StringUtils.isNotEmpty((CharSequence)cause)) {
                        obj.put(url, (Object)cause);
                        CacheHelper.put(cacheKey, obj.toJSONString(), 1800);
                    }
                    jSONObject = obj;
                }
                catch (Throwable throwable2) {
                    try {
                        lock.unlock();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throw throwable4;
                        return null;
                    }
                }
                lock.unlock();
                return jSONObject;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static JSONObject cacheFile(String pageId, String url, String operate) {
        logger.info(pageId + url + operate);
        if (StringUtils.isEmpty((CharSequence)pageId)) {
            return null;
        }
        String cacheKey = "scaner_" + pageId;
        Throwable throwable = null;
        try (DLock lock = DLock.create((String)("lock_" + cacheKey), (String)ResManager.loadKDString((String)"\u5237\u65b0\u5361\u7247\u9501", (String)"RecognitionCheckTask_1", (String)"imc-rim-common", (Object[])new Object[0]));){
            for (int times = 0; times < 10; ++times) {
                JSONObject jSONObject;
                JSONObject obj;
                block29: {
                    block28: {
                        if (!lock.tryLock(100L)) continue;
                        times = 100;
                        if (!"remove".equals(operate)) break block28;
                        CacheHelper.remove(cacheKey);
                        JSONObject jSONObject2 = null;
                        lock.unlock();
                        return jSONObject2;
                    }
                    String cache = CacheHelper.get(cacheKey);
                    obj = null;
                    obj = StringUtils.isEmpty((CharSequence)cache) ? new JSONObject() : JSON.parseObject((String)cache);
                    if (!"query".equals(operate)) break block29;
                    JSONObject jSONObject3 = obj;
                    lock.unlock();
                    return jSONObject3;
                }
                try {
                    if (StringUtils.isNotEmpty((CharSequence)url) && StringUtils.isNotEmpty((CharSequence)operate)) {
                        obj.put(url, (Object)operate);
                        CacheHelper.put(cacheKey, obj.toJSONString(), 1800);
                    }
                    jSONObject = obj;
                }
                catch (Throwable throwable2) {
                    try {
                        lock.unlock();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throw throwable4;
                        return null;
                    }
                }
                lock.unlock();
                return jSONObject;
            }
        }
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Map<String, Object> getCustomParam() {
        return this.customParam;
    }

    public void setCustomParam(Map<String, Object> customParam) {
        this.customParam = customParam;
    }

    @Override
    public JSONObject call() throws Exception {
        return this.execute();
    }
}

