/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.recognition.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.imc.rim.common.invoice.recognition.RecognitionCheckParentTask;
import kd.imc.rim.common.invoice.recognitionnew.task.handle.impl.FileHandleMultiTenantDownService;
import kd.imc.rim.common.multitenant.service.MultiTenantService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.UUID;

public class RecognitionCheckRemoteTask
extends RecognitionCheckParentTask {
    public RecognitionCheckRemoteTask(RequestContext ctx, String source, String pageId, JSONObject businessParam, Map<String, Object> customParam, String url, String fileName) {
        super(ctx, source, pageId, businessParam, customParam, url, fileName);
        RecognitionCheckRemoteTask.saveCacheFile(pageId, url, "waiting");
    }

    @Override
    public JSONObject execute() {
        logger.info("begin remote RecognitionCheckTask :{},{}", (Object)this.url, (Object)this.fileName);
        try {
            RequestContext.copyAndSet((RequestContext)this.ctx);
            if (StringUtils.isEmpty((CharSequence)this.url)) {
                return null;
            }
            JSONObject invoiceResult = this.getRemoteInvoiceResult();
            logger.info("\u53d1\u7968\u52a9\u624bremote\u6700\u7ec8\u6570\u636e\u8fd4\u56de\uff1a{}-{}", (Object)this.pageId, (Object)invoiceResult);
            Object noDealFlag = this.businessParam.get((Object)"noDealFlag");
            if (noDealFlag == null) {
                this.dealSuccess(invoiceResult, this.pageId);
            }
            return invoiceResult;
        }
        catch (Throwable t) {
            logger.info("RecognitionCheckTask throwable:{}", (Object)t);
            RecognitionCheckRemoteTask.saveCacheFile(this.pageId, this.url, "fail");
            String errorMsg = String.format(ResManager.loadKDString((String)"\u7a0b\u5e8f\u9519\u8bef\uff1a[%s]", (String)"RecognitionCheckTask_0", (String)"imc-rim-common", (Object[])new Object[0]), this.ctx.getTraceId());
            if (t instanceof KDBizException) {
                errorMsg = ((KDBizException)t).getMessage();
            }
            this.saveCacheCause(this.pageId, this.url, "fail", errorMsg);
            return new JSONObject();
        }
    }

    private JSONObject getRemoteInvoiceResult() {
        String fileUrl = "";
        MultiTenantService service = new MultiTenantService();
        if (service.isMultiTenant()) {
            fileUrl = service.getRemoteUrl(this.url, UUID.randomUUID() + "." + FileUtils.getFileType(this.fileName));
        }
        HashMap param = Maps.newHashMap();
        param.put("fileUrl", fileUrl);
        param.put("fileName", this.fileName);
        param.put("source", this.source);
        param.put("pageId", this.pageId);
        param.put("businessParam", this.businessParam);
        param.put("customParam", this.customParam);
        long orgId = RequestContext.get().getOrgId();
        if (this.customParam != null) {
            try {
                long org = BigDecimalUtil.transDecimal(this.customParam.get("orgId")).longValue();
                if (org > 0L) {
                    orgId = org;
                }
            }
            catch (Exception org) {
                // empty catch block
            }
        }
        Long userId = RequestContext.get().getCurrUserId();
        MultiTenantService multiTenantService = new MultiTenantService();
        Object data = multiTenantService.doPost("RecognitionCheckRemoteApiImpl", null, param, orgId, userId);
        logger.info("RecognitionCheckRemoteTask result : {}", data);
        JSONObject invoiceResult = (JSONObject)data;
        this.convertUrl(invoiceResult.getJSONArray("data"));
        return invoiceResult;
    }

    private void convertUrl(JSONArray data) {
        try {
            FileHandleMultiTenantDownService downservice = new FileHandleMultiTenantDownService();
            downservice.insert(data);
        }
        catch (Exception e) {
            logger.info("\u5f02\u6b65\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25:", (Object)e);
        }
    }
}

