/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.recognition.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.imc.rim.common.invoice.recognition.RecognitionCheckParentTask;
import kd.imc.rim.common.service.EInvoiceZipXmlDealService;
import kd.imc.rim.common.service.ElectAccVoucherService;
import kd.imc.rim.common.service.ExcelInvoiceUploadService;
import kd.imc.rim.common.service.RecognitionCheckService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.FileUtils;

public class RecognitionCheckTask
extends RecognitionCheckParentTask {
    public RecognitionCheckTask(RequestContext ctx, String source, String pageId, JSONObject businessParam, Map<String, Object> customParam, String url, String fileName) {
        super(ctx, source, pageId, businessParam, customParam, url, fileName);
        RecognitionCheckTask.saveCacheFile(pageId, url, "waiting");
    }

    @Override
    public JSONObject execute() {
        logger.info("begin local RecognitionCheckTask :{},{}", (Object)this.url, (Object)this.fileName);
        try {
            RequestContext.copyAndSet((RequestContext)this.ctx);
            if (StringUtils.isEmpty((CharSequence)this.url)) {
                return null;
            }
            JSONObject invoiceResult = this.getLocalInvoiceResult();
            logger.info("\u53d1\u7968\u52a9\u624b\u672c\u5730\u4e0a\u4f20\u6700\u7ec8\u6570\u636e\u8fd4\u56de\uff1a{}-{}", (Object)this.pageId, (Object)invoiceResult);
            Object noDealFlag = this.businessParam.get((Object)"noDealFlag");
            if (noDealFlag == null) {
                this.dealSuccess(invoiceResult, this.pageId);
            }
            return invoiceResult;
        }
        catch (Throwable t) {
            logger.info("RecognitionCheckTask throwable:{}", (Object)t);
            RecognitionCheckTask.saveCacheFile(this.pageId, this.url, "fail");
            this.saveCacheCause(this.pageId, this.url, "fail", String.format(ResManager.loadKDString((String)"\u7a0b\u5e8f\u9519\u8bef\uff1a[%s]", (String)"RecognitionCheckTask_0", (String)"imc-rim-common", (Object[])new Object[0]), this.ctx.getTraceId()));
            return new JSONObject();
        }
    }

    private JSONObject getLocalInvoiceResult() throws Exception {
        String xbrlErrCode;
        boolean isZipXmlEI;
        boolean isNeedDeal;
        long rim_user;
        JSONObject invoiceResult = new JSONObject();
        Long orgId = RequestContext.get().getOrgId();
        if (this.customParam != null) {
            try {
                long org = BigDecimalUtil.transDecimal(this.customParam.get("orgId")).longValue();
                if (org > 0L) {
                    orgId = org;
                }
            }
            catch (Exception org) {
                // empty catch block
            }
        }
        if (this.businessParam != null && (rim_user = BigDecimalUtil.transDecimal(this.businessParam.get((Object)"rim_user")).longValue()) < 1L) {
            this.businessParam.put("rim_user", (Object)RequestContext.get().getCurrUserId());
        }
        if (isNeedDeal = FileUtils.checkFileType(this.fileName, "zip", "ofd", "pdf")) {
            ElectAccVoucherService electAccVoucherService = new ElectAccVoucherService();
            invoiceResult = electAccVoucherService.dealVoucher(this.url, this.fileName, orgId, this.businessParam, null);
        }
        if ((isZipXmlEI = FileUtils.checkFileType(this.fileName, "zip", "xml")) && !"0000".equals(invoiceResult.getString("errcode"))) {
            invoiceResult = EInvoiceZipXmlDealService.analysisAndCheckSave(this.url, this.fileName, orgId, this.businessParam, null);
        }
        boolean dealResult = StringUtils.isEmpty((CharSequence)(xbrlErrCode = invoiceResult.getString("errcode"))) || !xbrlErrCode.equals("0000");
        boolean isZip = FileUtils.checkFileType(this.fileName, "zip");
        if (dealResult && !isZip) {
            if (FileUtils.isExcel(this.fileName)) {
                invoiceResult = ExcelInvoiceUploadService.getInstance().uploadExcelInvoice(this.url, this.fileName, null, this.businessParam);
            } else {
                logger.info("RecognitionCheckTask\u8bc6\u522burl:{}{}", (Object)this.fileName, (Object)this.url);
                invoiceResult = RecognitionCheckService.getInstance().recognitionCheckInvoice(this.url, this.fileName, null, this.businessParam);
            }
        }
        return invoiceResult;
    }
}

