/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.recognitionnew;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.invoice.recognitionnew.RecognitionService;
import kd.imc.rim.common.invoice.recognitionnew.impl.AwsRecognitionService;
import kd.imc.rim.common.invoice.recognitionnew.impl.SaleListRecognitionService;
import kd.imc.rim.common.message.exception.MsgException;

public class RecognitionFactory {
    public static RecognitionService getDefaultRecognitionService() {
        return new AwsRecognitionService();
    }

    public static RecognitionService getSaleListRecognitionService() {
        return new SaleListRecognitionService();
    }

    public static RecognitionService getRecognitionService(String recognitionImplStr) {
        if (StringUtils.isEmpty((String)recognitionImplStr)) {
            return new AwsRecognitionService();
        }
        try {
            return (RecognitionService)Class.forName(recognitionImplStr).newInstance();
        }
        catch (Exception e) {
            throw new MsgException(e, ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u8bc6\u522b\u65b9\u5f0f\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u8fdb\u9879\u914d\u7f6e-\u6536\u7968\u7ba1\u7406\u914d\u7f6e-\u8bc6\u522b\u67e5\u9a8c\u65b9\u5f0f\u914d\u7f6e\u3002", (String)"RecognitionFactory_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
    }
}

