/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.recognitionnew.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.invoice.model.ConvertFieldUtil;
import kd.imc.rim.common.invoice.model.type.SaleList;
import kd.imc.rim.common.invoice.recognitionnew.RecognitionService;
import kd.imc.rim.common.invoice.recognitionnew.model.RecognitionParam;
import kd.imc.rim.common.invoice.recognitionnew.model.RecognitionResult;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.HttpUtil;
import kd.imc.rim.common.utils.MD5;
import kd.imc.rim.common.utils.RimConfigUtils;
import org.apache.commons.compress.utils.Lists;

public class SaleListRecognitionService
implements RecognitionService {
    private static Log logger = LogFactory.getLog(SaleListRecognitionService.class);
    private static final int connectionTimeout = 8000;
    private static final int readTimeout = 20000;

    @Override
    public RecognitionResult recognitionInvoice(RecognitionParam recognitionParam) throws Exception {
        RecognitionResult recognitionResult = new RecognitionResult();
        Map<String, String> configMap = recognitionParam.getRecogConfigMap();
        String postUrl = configMap.get("salelistposturl");
        if (StringUtils.isEmpty((CharSequence)postUrl)) {
            return null;
        }
        ArrayList entityList = Lists.newArrayList();
        ByteArrayInputStream valueInputStream = recognitionParam.getFileByteArrayInputStream();
        byte[] streamByte = FileUtils.getByte(valueInputStream);
        ByteArrayInputStream copyInputStream = new ByteArrayInputStream(streamByte);
        String fileBase64Str = FileUtils.encodeBase64File(copyInputStream);
        Map<String, Object> map = this.getPostMap(fileBase64Str);
        String valueFileName = recognitionParam.getFileName();
        long startTime = System.currentTimeMillis();
        String resultData = null;
        int reqTimes = 0;
        try {
            ++reqTimes;
            resultData = HttpUtil.postFormData(postUrl, null, null, null, valueFileName, map, 8000, 20000);
        }
        catch (MsgException e) {
            if ("1022".equals(e.getErrorCode())) {
                ++reqTimes;
                resultData = HttpUtil.postFormData(postUrl, null, null, null, valueFileName, map, 5000, 20000);
            }
            throw e;
        }
        logger.info("\u9500\u8d27\u6e05\u5355\u8bc6\u522b\u8017\u65f6\uff1a{},\u8bf7\u6c42\u6b21\u6570{}", (Object)(System.currentTimeMillis() - startTime), (Object)reqTimes);
        logger.info("\u9500\u8d27\u6e05\u5355\u8bc6\u522b\u8fd4\u56de\u7ed3\u679c{}\uff1a{}", (Object)reqTimes, (Object)resultData);
        JSONObject recognitionJson = JSONObject.parseObject((String)resultData);
        JSONObject response = recognitionJson.getJSONObject("response");
        if (response != null) {
            JSONObject recognitionData = response.getJSONObject("data");
            recognitionResult.setErrcode("0000");
            recognitionResult.setDescription(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"SaleListRecognitionService_0", (String)"imc-rim-common", (Object[])new Object[0]));
            if (recognitionData == null) {
                return recognitionResult;
            }
            JSONArray recognitionArray = recognitionData.getJSONArray("identify_results");
            for (int i = 0; i < recognitionArray.size(); ++i) {
                JSONObject saleList = recognitionArray.getJSONObject(i).getJSONObject("details");
                JSONObject saleListConvert = ConvertFieldUtil.convert(SaleList.class, saleList, "1");
                entityList.add(saleListConvert);
            }
        } else {
            recognitionResult.setErrcode(recognitionJson.getString("error"));
            recognitionResult.setDescription(recognitionJson.getString("message"));
        }
        recognitionResult.setData(entityList);
        return recognitionResult;
    }

    private Map<String, Object> getPostMap(String fileBase64Str) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        String appKey = RimConfigUtils.getConfig("rim_recog_check", "salelistappkey");
        String appSecret = RimConfigUtils.getConfig("rim_recog_check", "salelistappsecret");
        long timeStampSec = System.currentTimeMillis() / 1000L;
        String timestamp = String.format("%010d", timeStampSec);
        String token = MD5.md5Hex(appKey + "+" + timestamp + "+" + appSecret);
        map.put("app_key", appKey);
        map.put("token", token);
        map.put("timestamp", timestamp);
        map.put("image_data", fileBase64Str);
        return map;
    }

    @Override
    public String getServiceType(RecognitionParam recognitionParam) {
        return "saleList";
    }
}

