/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.recognitionnew.task.handle.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.invoice.recognitionnew.task.handle.FileHandleService;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.MD5;

public class FileHandleCoverDownService
extends FileHandleService {
    @Override
    public void insert(String fileId, JSONObject object) {
        QFilter filter = new QFilter("id", "=", (Object)fileId);
        DynamicObject obj = QueryServiceHelper.queryOne((String)"rim_invoice_file_aws", (String)"id", (QFilter[])new QFilter[]{filter});
        if (obj == null) {
            obj = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice_file_aws");
            obj.set("id", (Object)fileId);
            obj.set("download_url", (Object)object.getString("localUrl"));
            obj.set("snapshot_url", (Object)object.getString("snapshotUrl"));
            obj.set("original_file_name", (Object)object.getString("coverNo"));
            obj.set("ofd_url", (Object)object.getString("expenseId"));
            obj.set("file_type", (Object)object.getString("fileType"));
            obj.set("serial_no", (Object)fileId);
            obj.set("deal_times", (Object)0);
            obj.set("update_time", (Object)new Date());
            obj.set("status", (Object)"0");
            obj.set("create_time", (Object)new Date());
            obj.set("down_type", (Object)DOWN_TYPE_COV);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        }
    }

    @Override
    public boolean doBusiness(DynamicObject object) {
        String localUrl = object.getString("download_url");
        String snapshotUrl = object.getString("snapshot_url");
        if (!StringUtils.isEmpty((CharSequence)localUrl) || !StringUtils.isEmpty((CharSequence)snapshotUrl)) {
            String expenseId = object.getString("ofd_url");
            QFilter coverFilter = new QFilter("expense_id", "=", (Object)expenseId);
            DynamicObjectCollection coverRelationObjs = QueryServiceHelper.query((String)"rim_cover_relation", (String)"cover_id", (QFilter[])coverFilter.toArray());
            if (coverRelationObjs != null && !coverRelationObjs.isEmpty()) {
                return true;
            }
            localUrl = FileUtils.downLoadAndUpload(localUrl, MD5.md5Hex(localUrl));
            snapshotUrl = FileUtils.downLoadAndUpload(snapshotUrl, MD5.md5Hex(snapshotUrl));
            if (StringUtils.isEmpty((CharSequence)localUrl) && StringUtils.isEmpty((CharSequence)snapshotUrl)) {
                return false;
            }
            DynamicObject needSaveCover = BusinessDataServiceHelper.newDynamicObject((String)"rim_cover");
            needSaveCover.set("cover_no", (Object)object.getString("original_file_name"));
            needSaveCover.set("cover_type", (Object)object.getString("file_type"));
            needSaveCover.set("cover_url", (Object)(StringUtils.isNotEmpty((CharSequence)localUrl) ? localUrl : snapshotUrl));
            needSaveCover.set("snapshot_url", (Object)snapshotUrl);
            needSaveCover.set("create_time", (Object)new Date());
            needSaveCover.set("update_time", (Object)new Date());
            needSaveCover.set("snapshot_url", (Object)snapshotUrl);
            needSaveCover.set("resource", (Object)"4");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{needSaveCover});
            DynamicObject needSaveCoverRelation = BusinessDataServiceHelper.newDynamicObject((String)"rim_cover_relation");
            needSaveCoverRelation.set("cover_id", needSaveCover.getPkValue());
            needSaveCoverRelation.set("expense_id", (Object)expenseId);
            needSaveCoverRelation.set("resource", (Object)"4");
            needSaveCoverRelation.set("create_time", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{needSaveCoverRelation});
        }
        return true;
    }
}

