/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.save;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ExpenseConstant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.ek.EkServiceFactory;
import kd.imc.rim.common.ek.service.InvoiceSaveEkService;
import kd.imc.rim.common.invoice.query.convert.InvoiceConvertService;
import kd.imc.rim.common.invoice.recognitionnew.task.FileSaveTask;
import kd.imc.rim.common.invoice.save.InvoiceSaveResult;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.service.InvoiceLog;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.InvoiceCheckUtils;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.lang3.StringUtils;

public class ExcelInvoiceSaveService {
    private static Log logger = LogFactory.getLog(ExcelInvoiceSaveService.class);
    protected Long invoiceType;
    private static final String[] invoiceFields = new String[]{"invoice_code", "invoice_no", "invoice_date", "check_code", "invoice_amount", "invoice_status", "total_tax_amount", "saler_name", "saler_tax_no", "buyer_name", "buyer_tax_no", "total_amount", "check_status"};
    private static final String[] deductionFields = new String[]{"deduction_flag", "deduction_purpose", "authenticate_flag", "select_time", "authenticate_time", "tax_period", "transport_deduction", "effective_tax_amount"};

    public ExcelInvoiceSaveService(Long invoiceType) {
        this.invoiceType = invoiceType;
    }

    public JSONObject save(JSONObject invoiceJson) {
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            long start = System.currentTimeMillis();
            InvoiceConvertUtils.removeEleInvoiceCode(this.invoiceType, invoiceJson);
            DynamicObject invoiceObject = this.getInvoiceDynamicObject(invoiceJson);
            this.setInvoiceExcelFieldValue(invoiceJson, invoiceObject, Boolean.FALSE);
            this.setDeductionFieldValue(this.invoiceType, invoiceObject, invoiceJson);
            DynamicObject mainObject = this.getExcelMainDynamicObject(invoiceObject, invoiceJson);
            Boolean newFlag = this.checkIdIsNull(mainObject.getPkValue());
            this.setExcelMainFieldValue(invoiceJson, mainObject);
            DeductionConstant.searchBlacklist(mainObject.getString("saler_tax_no"));
            this.setDeductionFieldValue(this.invoiceType, mainObject, invoiceJson);
            JSONObject convertJson = new JSONObject();
            if (InputInvoiceTypeEnum.canDeduction(this.invoiceType).booleanValue() || InputInvoiceTypeEnum.canTransportDeduction(this.invoiceType).booleanValue()) {
                Map<String, Object> mainMap = DynamicObjectUtil.dynamicObjectToMap(mainObject);
                Map<String, Object> bodyMap = DynamicObjectUtil.dynamicObjectToMap(invoiceObject);
                InvoiceConvertService.putAll(mainMap, bodyMap);
                InvoiceConvertService convertService = InvoiceConvertService.newInstance(this.invoiceType);
                convertJson = convertService.convert(mainMap);
            }
            this.setDeductionFlag(invoiceJson, invoiceObject, convertJson);
            this.setDeductionFlag(invoiceJson, mainObject, convertJson);
            this.setMainInvoiceInfo(mainObject);
            InvoiceSaveService.setExtInfo(mainObject, InvoiceSaveConstant.EXT_DEDUCTION_FLAG, mainObject.getString(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG));
            this.setCusFieldsValue(invoiceJson, mainObject, invoiceObject);
            InvoiceSaveEkService ekService = EkServiceFactory.getInvoiceSaveEkService();
            InvoiceCheckUtils.enIDNum(invoiceObject);
            InvoiceSaveService service = InvoiceSaveService.newInstance(invoiceJson.getString("invoiceType"));
            if (service != null) {
                service.setAutoSignEleInvoice(invoiceJson, mainObject);
            }
            DeductionConstant.setSmallScaleTaxpayerDeductionFlag(invoiceJson, mainObject, invoiceObject);
            InvoiceSaveService.setExtInfo(mainObject, InvoiceSaveConstant.EXT_DEDUCTION_FLAG, mainObject.getString(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG));
            ekService.beforeSave(mainObject, invoiceObject, invoiceJson);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoiceObject});
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainObject});
            this.saveInvoiceFile(invoiceJson, invoiceObject.getString("serial_no"));
            invoiceJson.put("newFlag", (Object)newFlag);
            invoiceJson.put("serialNo", (Object)invoiceObject.getString("serial_no"));
            invoiceJson.put("serial_no", (Object)invoiceObject.getString("serial_no"));
            invoiceJson.put("invoiceId", invoiceObject.get("id"));
            invoiceJson.put("mainId", mainObject.get("id"));
            invoiceJson.put("tenantNo", (Object)invoiceObject.getString("tenant_no"));
            invoiceJson.put("invoice_info", (Object)mainObject.getString("invoice_info"));
            String serialNo = invoiceObject.getString("serial_no");
            JSONObject logInfo = new JSONObject();
            logInfo.put("mainId", mainObject.get("id"));
            logInfo.put("invId", invoiceObject.get("id"));
            logInfo.put("trace", (Object)RequestContext.get().getTraceId());
            Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(mainObject.get("org"));
            String resource = invoiceJson.getString("resource");
            InvoiceLog.insert("save", serialNo, logInfo.toJSONString(), orgId, resource, invoiceJson.getString("collect_type"));
            logger.info(invoiceJson.getString("fileName") + "\u7b2c" + invoiceJson.getString("fileIndex") + "\u9875\uff0cInvoiceSaveService.save\u7edf\u8ba1\u4fe1\u606f:" + invoiceObject.getString("serial_no") + ",\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            InvoiceSaveResult result = new InvoiceSaveResult();
            result.setNewFlag(newFlag);
            result.setInvoiceEntity(invoiceObject.getDynamicObjectType().getName());
            result.setInvoiceType(this.invoiceType);
            result.setSerialNo(serialNo);
            result.setInvoiceId(invoiceObject.get("id"));
            result.setMainId(mainObject.get("id"));
            result.setTenantNo(invoiceObject.getString("tenant_no"));
            result.setInvoiceInfo(mainObject.getString("invoice_info"));
            ekService.afterSave(result);
            JSONObject jSONObject = invoiceJson;
            return jSONObject;
        }
        catch (Throwable e) {
            try {
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private void setCusFieldsValue(JSONObject invoiceJson, DynamicObject mainObject, DynamicObject invoiceObject) {
        JSONObject customFieldValue = invoiceJson.getJSONObject("CustomFieldValue");
        if (customFieldValue != null) {
            HashMap<String, Object> cacheMap = new HashMap<String, Object>(8);
            MainEntityType mainEntityType1 = EntityMetadataCache.getDataEntityType((String)mainObject.getDynamicObjectType().getName());
            this.setCusFieldField(mainObject, (Map<String, Object>)customFieldValue, mainEntityType1, cacheMap);
            MainEntityType mainEntityType2 = EntityMetadataCache.getDataEntityType((String)invoiceObject.getDynamicObjectType().getName());
            this.setCusFieldField(invoiceObject, (Map<String, Object>)customFieldValue, mainEntityType2, cacheMap);
        }
    }

    private void setCusFieldField(DynamicObject object, Map<String, Object> excelvalMap, MainEntityType mainEntityType, Map<String, Object> valCache) {
        if (excelvalMap != null && !excelvalMap.isEmpty()) {
            for (Map.Entry<String, Object> excel : excelvalMap.entrySet()) {
                Object excelVal = excel.getValue();
                if (excelVal == null) continue;
                String fieldCode = excel.getKey();
                int index = fieldCode.indexOf(46);
                String filterField = null;
                if (index > 0) {
                    filterField = fieldCode.substring(index + 1);
                    fieldCode = fieldCode.substring(0, index);
                }
                DynamicProperty property = mainEntityType.getProperty(fieldCode);
                Object exitsVal = valCache.get(excel.getKey() + excelVal);
                if (property != null && exitsVal != null) {
                    object.set(fieldCode, exitsVal);
                    continue;
                }
                if (property instanceof BasedataProp) {
                    DynamicObject baseobject;
                    BasedataProp basedataProp = (BasedataProp)property;
                    String baseentity = basedataProp.getBaseEntityId();
                    Object filterVal = excelVal.toString();
                    if (filterField == null) {
                        filterField = "id";
                        filterVal = BigDecimalUtil.transDecimal(excelVal);
                    }
                    if ((baseobject = BusinessDataServiceHelper.loadSingleFromCache((String)baseentity, (QFilter[])new QFilter(filterField, "=", filterVal).toArray())) == null) continue;
                    object.set(fieldCode, baseobject.getPkValue());
                    valCache.put(excel.getKey() + excelVal, baseobject.getPkValue());
                    continue;
                }
                if (property instanceof BooleanProp) {
                    if ("true".equals(excelVal.toString())) {
                        object.set(fieldCode, (Object)Boolean.TRUE);
                        continue;
                    }
                    object.set(fieldCode, (Object)Boolean.FALSE);
                    continue;
                }
                if (property instanceof DateTimeProp) {
                    object.set(fieldCode, (Object)TypeUtils.castToDate((Object)excelVal.toString()));
                    continue;
                }
                if (property instanceof DecimalProp) {
                    object.set(fieldCode, (Object)BigDecimalUtil.transDecimal(excelVal));
                    continue;
                }
                if (property == null) continue;
                object.set(fieldCode, (Object)excelVal.toString());
            }
        }
    }

    private void saveInvoiceFile(JSONObject invoiceJson, String serialNo) {
        String original_type = invoiceJson.getString("original_type");
        if (StringUtils.isNotEmpty((CharSequence)original_type)) {
            QFilter filter = new QFilter("serial_no", "=", (Object)serialNo);
            DynamicObject fileIdDynamicObject = QueryServiceHelper.queryOne((String)"rim_invoice_file", (String)"id,original_state,snapshot_url", (QFilter[])new QFilter[]{filter});
            if (fileIdDynamicObject == null) {
                fileIdDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice_file");
                fileIdDynamicObject.set("serial_no", (Object)serialNo);
                fileIdDynamicObject.set("original_state", (Object)"3");
                fileIdDynamicObject.set("original_type", (Object)invoiceJson.getString("original_type"));
                fileIdDynamicObject.set("rotation_angle", (Object)invoiceJson.getBigDecimal("rotation_angle"));
                fileIdDynamicObject.set("region", (Object)invoiceJson.getString("region"));
                fileIdDynamicObject.set("pdf_url", (Object)invoiceJson.getString("pdf_url"));
                fileIdDynamicObject.set("ofd_url", (Object)invoiceJson.getString("ofd_url"));
                fileIdDynamicObject.set("image_url", (Object)invoiceJson.getString("image_url"));
                fileIdDynamicObject.set("snapshot_url", (Object)invoiceJson.getString("snapshot_url"));
                fileIdDynamicObject.set("pixel", (Object)invoiceJson.getString("pixel"));
                fileIdDynamicObject.set("original_filename", (Object)invoiceJson.getString("original_filename"));
                fileIdDynamicObject.set("update_time", (Object)new Date());
                fileIdDynamicObject.set("create_time", (Object)new Date());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fileIdDynamicObject});
            } else {
                String original_state = fileIdDynamicObject.getString("original_state");
                if ("2".equals(original_state) || "3".equals(original_state)) {
                    fileIdDynamicObject = BusinessDataServiceHelper.loadSingle((Object)fileIdDynamicObject.get("id"), (String)"rim_invoice_file");
                    Map<String, Object> oldMap = DynamicObjectUtil.dynamicObject2Map(fileIdDynamicObject);
                    fileIdDynamicObject.set("original_state", (Object)"3");
                    fileIdDynamicObject.set("original_type", (Object)invoiceJson.getString("original_type"));
                    fileIdDynamicObject.set("rotation_angle", (Object)invoiceJson.getBigDecimal("rotation_angle"));
                    fileIdDynamicObject.set("region", (Object)invoiceJson.getString("region"));
                    fileIdDynamicObject.set("pdf_url", (Object)invoiceJson.getString("pdf_url"));
                    fileIdDynamicObject.set("ofd_url", (Object)invoiceJson.getString("ofd_url"));
                    fileIdDynamicObject.set("image_url", (Object)invoiceJson.getString("image_url"));
                    fileIdDynamicObject.set("snapshot_url", (Object)invoiceJson.getString("snapshot_url"));
                    fileIdDynamicObject.set("pixel", (Object)invoiceJson.getString("pixel"));
                    fileIdDynamicObject.set("original_filename", (Object)invoiceJson.getString("original_filename"));
                    fileIdDynamicObject.set("update_time", (Object)new Date());
                    Map<String, Object> newMap = DynamicObjectUtil.dynamicObject2Map(fileIdDynamicObject);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fileIdDynamicObject});
                    FileSaveTask.saveHis(oldMap, newMap);
                }
            }
        }
    }

    public DynamicObject getInvoiceDynamicObject(JSONObject invoiceJson) {
        DynamicObject savedObject = this.checkInvoiceExist(invoiceJson);
        String tenantNo = TenantUtils.getTenantNo();
        String entityId = InputInvoiceTypeEnum.getEntity(this.invoiceType);
        DynamicObject invoiceDynamicObject = null;
        String userDelete = invoiceJson.getString("delete");
        if (StringUtils.isEmpty((CharSequence)userDelete)) {
            userDelete = "1";
        }
        if (ObjectUtils.isEmpty((Object)savedObject)) {
            invoiceDynamicObject = this.newDefaultDynamicObject(entityId, tenantNo, userDelete);
        } else {
            DynamicObject idObject = QueryServiceHelper.queryOne((String)entityId, (String)"id", (QFilter[])new QFilter[]{new QFilter("serial_no", "=", savedObject.get("serial_no"))});
            if (idObject == null || idObject.get("id") == null) {
                invoiceDynamicObject = this.newDefaultDynamicObject(entityId, tenantNo, userDelete);
            } else {
                invoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)entityId);
                invoiceDynamicObject.set("delete", (Object)userDelete);
            }
        }
        return invoiceDynamicObject;
    }

    private DynamicObject newDefaultDynamicObject(String entityId, String tenantNo, String userDelete) {
        DynamicObject invoiceDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityId);
        invoiceDynamicObject.set("tenant_no", (Object)tenantNo);
        invoiceDynamicObject.set("serial_no", (Object)UUID.randomUUIDZero());
        if (StringUtils.isEmpty((CharSequence)userDelete)) {
            invoiceDynamicObject.set("delete", (Object)"1");
        } else {
            invoiceDynamicObject.set("delete", (Object)userDelete);
        }
        invoiceDynamicObject.set("expense_status", (Object)"1");
        invoiceDynamicObject.set("original_state", (Object)"0");
        invoiceDynamicObject.set("createtime", (Object)new Date());
        return invoiceDynamicObject;
    }

    public JSONObject fillDefaultInvoice(JSONObject invoice) {
        BigDecimal totalAmount;
        BigDecimal otherFee;
        BigDecimal constructionFee;
        BigDecimal fuelAmount;
        Date startDate = DateUtils.stringToDate("2019-03-31 23:59:59", "yyyy-MM-dd HH:mm:ss");
        Date invoiceDate = invoice.getDate("invoice_date");
        BigDecimal invoiceAmount = invoice.getBigDecimal("invoice_amount");
        if (ObjectUtils.isEmpty((Object)invoiceAmount)) {
            invoiceAmount = BigDecimal.ZERO;
        }
        if (ObjectUtils.isEmpty((Object)(fuelAmount = invoice.getBigDecimal("fuel_surcharge")))) {
            fuelAmount = BigDecimal.ZERO;
        }
        if (ObjectUtils.isEmpty((Object)(constructionFee = invoice.getBigDecimal("airport_construction_fee")))) {
            constructionFee = BigDecimal.ZERO;
        }
        if (ObjectUtils.isEmpty((Object)(otherFee = invoice.getBigDecimal("other_amount")))) {
            otherFee = BigDecimal.ZERO;
        }
        if (ObjectUtils.isEmpty((Object)(totalAmount = invoice.getBigDecimal("total_amount")))) {
            totalAmount = BigDecimal.ZERO;
        }
        String customerName = invoice.getString("customer_name");
        BigDecimal taxRate = DeductionUtils.taxRateByInvoiceDate(invoiceDate, InputInvoiceTypeEnum.AIR_INVOICE.getCode(), new Object[0]);
        invoice.put("tax_rate", (Object)taxRate);
        BigDecimal totalTaxAmount = DeductionUtils.airTaxAmountByInvoiceDate(invoiceDate, invoiceAmount, fuelAmount, customerName, otherFee, totalAmount, constructionFee, invoice.getString("place_of_departure"), invoice.getString("destination"));
        invoice.put("total_tax_amount", (Object)totalTaxAmount);
        return invoice;
    }

    public DynamicObject checkInvoiceExist(JSONObject invoiceJson) {
        String entityId = InputInvoiceTypeEnum.getEntity(this.invoiceType);
        String tenantNo = TenantUtils.getTenantNo();
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        String invoiceCode = invoiceJson.getString("invoice_code");
        String invoiceNo = invoiceJson.getString("invoice_no");
        QFilter invoiceTypeFilter = new QFilter("invoice_type", "=", (Object)this.invoiceType);
        QFilter invoiceCodeFilter = new QFilter("invoice_code", "=", (Object)invoiceCode);
        QFilter invoiceNoFilter = new QFilter("invoice_no", "=", (Object)invoiceNo);
        Object invoiceObject = null;
        DynamicObject serialObject = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"id, serial_no, expense_status", (QFilter[])new QFilter[]{tenantFilter, invoiceCodeFilter, invoiceNoFilter, invoiceTypeFilter});
        if (serialObject != null) {
            return serialObject;
        }
        QFilter noFilter = null;
        QFilter codeFilter = null;
        if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(this.invoiceType)) {
            codeFilter = new QFilter("eticket_no", "=", (Object)invoiceJson.getString("eticket_no"));
            noFilter = new QFilter("print_num", "=", (Object)invoiceJson.getString("print_num"));
        }
        if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(this.invoiceType)) {
            codeFilter = new QFilter("train_num", "=", (Object)invoiceJson.getString("train_num"));
            noFilter = new QFilter("sequence_no", "=", (Object)invoiceJson.getString("sequence_no"));
        }
        if (InputInvoiceTypeEnum.TAX_PROOF.getCode().equals(this.invoiceType)) {
            noFilter = new QFilter("tax_paid_proof_no", "=", (Object)invoiceJson.getString("tax_paid_proof_no"));
        }
        if (InputInvoiceTypeEnum.TRAIN_REFUND.getCode().equals(this.invoiceType)) {
            noFilter = new QFilter("number", "=", (Object)invoiceJson.getString("number"));
        }
        if (InputInvoiceTypeEnum.HGJKS.getCode().equals(this.invoiceType)) {
            noFilter = new QFilter("custom_declaration_no", "=", (Object)invoiceJson.getString("custom_declaration_no"));
        }
        if (InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(this.invoiceType) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(this.invoiceType) || InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(this.invoiceType) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(this.invoiceType)) {
            noFilter = new QFilter("invoice_no", "=", (Object)invoiceNo);
        }
        if (InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(this.invoiceType)) {
            Map<String, String> configMap = ImcConfigUtil.getValue("rim_recog_check");
            String otherMust = ImcConfigUtil.getValue(configMap, "other_must", "0");
            if ("1".equals(otherMust) && !StringUtils.isEmpty((CharSequence)invoiceNo)) {
                noFilter = new QFilter("invoice_no", "=", (Object)invoiceNo);
            } else if ("2".equals(otherMust) && !StringUtils.isEmpty((CharSequence)invoiceNo)) {
                codeFilter = new QFilter("invoice_code", "=", (Object)invoiceCode);
                noFilter = new QFilter("invoice_no", "=", (Object)invoiceNo);
            } else {
                return null;
            }
        }
        if (codeFilter != null && noFilter != null) {
            serialObject = QueryServiceHelper.queryOne((String)entityId, (String)"serial_no", (QFilter[])new QFilter[]{tenantFilter, codeFilter, noFilter});
        } else if (noFilter != null) {
            serialObject = QueryServiceHelper.queryOne((String)entityId, (String)"serial_no", (QFilter[])new QFilter[]{tenantFilter, noFilter});
        }
        DynamicObject mainObject = null;
        if (serialObject != null && StringUtils.isNotBlank((CharSequence)serialObject.getString("serial_no"))) {
            mainObject = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"id, expense_status, serial_no", (QFilter[])new QFilter[]{new QFilter("serial_no", "=", (Object)serialObject.getString("serial_no"))});
        }
        return mainObject;
    }

    public void setInvoiceExcelFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject, Boolean isMain) {
        JSONArray items;
        Set jsonKeys = invoiceJson.keySet();
        if (CollectionUtils.isEmpty((Collection)jsonKeys)) {
            return;
        }
        if (InputInvoiceTypeEnum.isVatType(this.invoiceType) && StringUtils.isBlank((CharSequence)dynamicObject.getString("tax_recorded_status"))) {
            dynamicObject.set("tax_recorded_status", (Object)"01");
        }
        dynamicObject.set("invoice_type", (Object)this.invoiceType);
        if (ObjectUtils.isEmpty((Object)dynamicObject.get("creator"))) {
            dynamicObject.set("creator", (Object)RequestContext.get().getUserId());
        }
        dynamicObject.set("billstatus", (Object)"C");
        dynamicObject.set("modifytime", (Object)new Date());
        dynamicObject.set("billno", (Object)InvoiceCheckUtils.getBillNo(invoiceJson));
        dynamicObject.set("aws_serial_no", (Object)invoiceJson.getString("serial_no"));
        if (dynamicObject.get("createtime") == null) {
            dynamicObject.set("createtime", (Object)new Date());
        }
        this.setTableField(invoiceJson, dynamicObject, isMain);
        if (StringUtils.equals((CharSequence)"1", (CharSequence)invoiceJson.getString("resoureseAPI")) && (items = invoiceJson.getJSONArray("items")) != null && !items.isEmpty()) {
            boolean needClear = true;
            for (int i = 0; i < items.size(); ++i) {
                JSONObject item = items.getJSONObject(i);
                item.put("needClear", (Object)needClear);
                this.setTableField(item, dynamicObject, isMain);
                needClear = false;
            }
        }
        Long orgId = this.getOrgId(invoiceJson);
        Object taxOrg = invoiceJson.get((Object)"tax_org");
        if (this.overrideOrg(dynamicObject).booleanValue()) {
            dynamicObject.set("org", (Object)orgId);
        }
        if (taxOrg != null) {
            dynamicObject.set("tax_org", taxOrg);
        } else if (InputInvoiceTypeEnum.needCheck(this.invoiceType).booleanValue()) {
            dynamicObject.set("tax_org", (Object)TenantUtils.getTaxOrgId(null, invoiceJson.getString("buyer_tax_no")));
        } else {
            dynamicObject.set("tax_org", (Object)TenantUtils.getTaxOrgId(orgId));
        }
    }

    private Boolean isAllowEdit(DynamicObject dynamicObject, JSONObject invoiceJson) {
        String tenantNo = TenantUtils.getTenantNo();
        String serialNo = dynamicObject.getString("serial_no");
        QFilter invoiceFilter = new QFilter("serial_no", "=", (Object)serialNo).and("tenant_no", "=", (Object)tenantNo);
        DynamicObject checkObj = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"invoice_type, check_status, expense_status", (QFilter[])invoiceFilter.toArray());
        if (checkObj != null) {
            Long type = checkObj.getLong("invoice_type");
            String expenseStatus = checkObj.getString("expense_status");
            String inputResource = invoiceJson.getString("inputResource");
            if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(type) && "fpzs".equals(inputResource) && ("1".equals(expenseStatus) || "30".equals(expenseStatus))) {
                return Boolean.TRUE;
            }
            if (StringUtils.isNotEmpty((CharSequence)expenseStatus) && !"1".equals(expenseStatus)) {
                return Boolean.FALSE;
            }
            String checkStatus = checkObj.getString("check_status");
            if (InputInvoiceTypeEnum.needCheck(type).booleanValue() && "1".equals(checkStatus)) {
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    private void setTableField(JSONObject invoiceJson, DynamicObject dynamicObject, Boolean isMain) {
        Iterator jsonKeyIterator;
        Set jsonKeys = invoiceJson.keySet();
        if (CollectionUtils.isEmpty((Collection)jsonKeys)) {
            return;
        }
        Boolean allowEdit = this.isAllowEdit(dynamicObject, invoiceJson);
        String entityid = null;
        entityid = isMain != false ? "rim_invoice" : InputInvoiceTypeEnum.getEntity(this.invoiceType);
        JSONObject fieldFormatMap = MetadataUtil.getFeildFormatMap(entityid);
        DynamicObject dynamicItem = null;
        JSONObject itemsFormatObject = null;
        if (fieldFormatMap.containsKey((Object)"items") && fieldFormatMap.getJSONObject("items") != null && allowEdit.booleanValue()) {
            itemsFormatObject = fieldFormatMap.getJSONObject("items");
            DynamicObjectCollection items = dynamicObject.getDynamicObjectCollection("items");
            if (invoiceJson.getBoolean("needClear") != null && invoiceJson.getBoolean("needClear").booleanValue()) {
                items.clear();
            }
            dynamicItem = items.addNew();
        }
        if (!ObjectUtils.isEmpty(jsonKeyIterator = jsonKeys.iterator())) {
            while (jsonKeyIterator.hasNext()) {
                List<String> deductionFieldList;
                String jsonKey = (String)jsonKeyIterator.next();
                if (StringUtils.isEmpty((CharSequence)jsonKey) || "org".equals(jsonKey) || "tax_org".equals(jsonKey) || (deductionFieldList = Arrays.asList(deductionFields)).contains(jsonKey)) continue;
                List<String> invoiceFieldList = Arrays.asList(invoiceFields);
                if (!allowEdit.booleanValue() && invoiceFieldList.contains(jsonKey)) continue;
                try {
                    String format;
                    if (allowEdit.booleanValue() && itemsFormatObject != null && fieldFormatMap.containsKey((Object)"items") && StringUtils.isNotEmpty((CharSequence)(format = itemsFormatObject.getString(jsonKey)))) {
                        switch (format) {
                            case "date": {
                                if (dynamicItem == null || ObjectUtils.isEmpty((Object)invoiceJson.getDate(jsonKey))) break;
                                dynamicItem.set(jsonKey, (Object)invoiceJson.getDate(jsonKey));
                                break;
                            }
                            case "decimal": {
                                if (dynamicItem == null) break;
                                dynamicItem.set(jsonKey, (Object)invoiceJson.getBigDecimal(jsonKey));
                                break;
                            }
                            case "combo": 
                            case "string": {
                                if (dynamicItem == null) break;
                                dynamicItem.set(jsonKey, (Object)invoiceJson.getString(jsonKey));
                            }
                        }
                    }
                    if (!fieldFormatMap.containsKey((Object)jsonKey)) continue;
                    switch (fieldFormatMap.getString(jsonKey)) {
                        case "date": {
                            String val = invoiceJson.getString(jsonKey);
                            if (ObjectUtils.isEmpty((Object)val)) break;
                            Date date = "account_date".equals(jsonKey) || "tax_period".equals(jsonKey) ? DateUtils.stringToDate(val, "yyyyMM") : ("original_time".equals(jsonKey) ? DateUtils.stringToDate(val, "yyyy-MM-dd HH:mm:ss") : DateUtils.stringToDate(val.replace("-", ""), "yyyyMMdd"));
                            dynamicObject.set(jsonKey, (Object)date);
                            break;
                        }
                        case "decimal": {
                            dynamicObject.set(jsonKey, (Object)invoiceJson.getBigDecimal(jsonKey));
                            break;
                        }
                        case "combo": 
                        case "string": {
                            if (!StringUtils.isNotBlank((CharSequence)invoiceJson.getString(jsonKey))) break;
                            dynamicObject.set(jsonKey, (Object)invoiceJson.getString(jsonKey));
                        }
                    }
                }
                catch (Throwable e) {
                    logger.error("\u6570\u636e\u683c\u5f0f\u8f6c\u5316\u5931\u8d25", e);
                    throw new MsgException(e, ResManager.loadKDString((String)"\u683c\u5f0f\u8f6c\u5316\u51fa\u9519", (String)"ExcelInvoiceSaveService_0", (String)"imc-rim-common", (Object[])new Object[0]));
                }
            }
        }
    }

    public Long getOrgId(JSONObject invoiceJson) {
        String orgId = CommonUtils.getJsonValue((Map<String, Object>)invoiceJson, String.class, "org", "org_id");
        if (StringUtils.isEmpty((CharSequence)orgId)) {
            return RequestContext.get().getOrgId();
        }
        if (StringUtils.isNumeric((CharSequence)orgId)) {
            return Long.parseLong(orgId);
        }
        return 0L;
    }

    public DynamicObject getExcelMainDynamicObject(DynamicObject invoiceObject, JSONObject invoiceJson) {
        String userId = RequestContext.get().getUserId();
        String orgId = invoiceJson.getString("org_id");
        if (orgId == null) {
            orgId = RequestContext.get().getOrgId() + "";
        }
        String tenantNo = invoiceObject.getString("tenant_no");
        String serialNo = invoiceObject.getString("serial_no");
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        QFilter serialFilter = new QFilter("serial_no", "=", (Object)serialNo);
        List idList = QueryServiceHelper.queryPrimaryKeys((String)"rim_invoice", (QFilter[])new QFilter[]{tenantFilter, serialFilter}, null, (int)100);
        DynamicObject mainDynamicObject = null;
        String userDelete = invoiceJson.getString("delete");
        if (StringUtils.isEmpty((CharSequence)userDelete)) {
            userDelete = "1";
        }
        if (CollectionUtils.isEmpty((Collection)idList)) {
            mainDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice");
            mainDynamicObject.set("tenant_no", (Object)tenantNo);
            mainDynamicObject.set("org", (Object)orgId);
            mainDynamicObject.set("serial_no", (Object)serialNo);
            mainDynamicObject.set("billstatus", (Object)"C");
            mainDynamicObject.set("invoice_type", (Object)this.invoiceType);
            mainDynamicObject.set("expense_status", (Object)"1");
            if ("1".equals(invoiceJson.getString("check_status"))) {
                mainDynamicObject.set("check_status", (Object)invoiceJson.getString("check_status"));
            } else {
                mainDynamicObject.set("check_status", (Object)"4");
            }
            if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("resource"))) {
                mainDynamicObject.set("resource", invoiceJson.get((Object)"resource"));
            }
            mainDynamicObject.set("audit_result", (Object)"0");
            mainDynamicObject.set("original_state", (Object)"0");
            mainDynamicObject.set("createtime", (Object)new Date());
            mainDynamicObject.set("delete", (Object)userDelete);
            invoiceJson.put("isNewInvoice", (Object)Boolean.TRUE);
        } else {
            mainDynamicObject = BusinessDataServiceHelper.loadSingle(idList.get(0), (String)"rim_invoice");
            invoiceJson.put("isNewInvoice", (Object)Boolean.FALSE);
            mainDynamicObject.set("delete", (Object)userDelete);
        }
        mainDynamicObject.set("is_revise", (Object)"0");
        if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(this.invoiceType) || InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(this.invoiceType) || InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode().equals(this.invoiceType) || InputInvoiceTypeEnum.BOAT_INVOICE.getCode().equals(this.invoiceType)) {
            String deduction_flag = DeductionConstant.canBeDeductionForTransport(invoiceJson, Long.valueOf(orgId));
            mainDynamicObject.set("deduction_flag", (Object)deduction_flag);
            if (!"1".equals(mainDynamicObject.getString("transport_deduction"))) {
                mainDynamicObject.set("transport_deduction", (Object)"0");
            }
        }
        this.setUserAndOrg(userId, orgId, mainDynamicObject);
        mainDynamicObject.set("modifytime", (Object)new Date());
        return mainDynamicObject;
    }

    public void setMainInvoiceInfo(DynamicObject invoiceObject) {
        String is_revise;
        String awsType;
        if ("-".equals(invoiceObject.getString("electronic_no"))) {
            invoiceObject.set("electronic_no", (Object)"");
        }
        String deductionFlag = invoiceObject.getString("deduction_flag");
        String invoiceStatus = invoiceObject.getString("invoice_status");
        String expenseStatus = invoiceObject.getString("expense_status");
        String checkStatus = invoiceObject.getString("check_status");
        String originalState = invoiceObject.getString("original_state");
        if (!"1".equals(originalState)) {
            originalState = "0";
            invoiceObject.set("original_state", (Object)"0");
            invoiceObject.set("original_time", null);
            invoiceObject.set("receiver", (Object)0);
        } else if (invoiceObject.get("original_time") == null) {
            invoiceObject.set("original_time", (Object)new Date());
        }
        String authenticateFlag = invoiceObject.getString("authenticate_flag");
        StringBuilder infoString = new StringBuilder();
        if (this.invoiceType == null) {
            this.invoiceType = invoiceObject.getDynamicObject("invoice_type").getLong("id");
        }
        if (StringUtils.isNotEmpty((CharSequence)(awsType = InputInvoiceTypeEnum.getAwsType(this.invoiceType)))) {
            infoString.append("ty_").append(awsType).append(',');
        }
        if (StringUtils.isNotEmpty((CharSequence)invoiceStatus)) {
            infoString.append("st_").append(invoiceStatus).append(',');
        }
        if (StringUtils.isNotEmpty((CharSequence)expenseStatus)) {
            infoString.append("ex_").append(expenseStatus).append(',');
        } else {
            infoString.append("ex_").append('1').append(',');
        }
        if (InputInvoiceTypeEnum.needCheck(this.invoiceType).booleanValue()) {
            if (StringUtils.isNotEmpty((CharSequence)checkStatus)) {
                infoString.append("ch_").append(checkStatus).append(',');
            }
        } else {
            invoiceObject.set("check_status", (Object)"1");
        }
        if (StringUtils.isNotEmpty((CharSequence)originalState)) {
            infoString.append("or_").append(originalState).append(',');
        }
        if (StringUtils.isNotEmpty((CharSequence)authenticateFlag)) {
            infoString.append("au_").append(authenticateFlag).append(',');
        }
        if ("1".equals(is_revise = invoiceObject.getString("is_revise"))) {
            infoString.append("mo_1").append(',');
        } else {
            invoiceObject.set("is_revise", (Object)"0");
        }
        invoiceObject.set("invoice_info", (Object)infoString.toString());
        String deductionFlag2 = invoiceObject.getString("deduction_flag");
    }

    private void setDeductionFlag(JSONObject invoiceJson, DynamicObject mainDynamicObject, JSONObject convertJson) {
        String deduction_flag;
        if (convertJson == null) {
            convertJson = new JSONObject();
        }
        convertJson.put("allowDeduction", (Object)"1");
        convertJson.put("deductionFlag", invoiceJson.get((Object)"deduction_flag"));
        convertJson.put("invoiceStatus", invoiceJson.get((Object)"invoice_status"));
        convertJson.put("totalTaxAmount", invoiceJson.get((Object)"total_tax_amount"));
        convertJson.put("invoiceAmount", invoiceJson.get((Object)"invoice_amount"));
        convertJson.put("totalAmount", invoiceJson.get((Object)"total_amount"));
        convertJson.put("invoiceType", (Object)this.invoiceType);
        convertJson.put("taxAmount", invoiceJson.get((Object)"tax_amount"));
        if (!ObjectUtils.isEmpty((Object)invoiceJson.getDate("invoice_date"))) {
            convertJson.put("invoiceDate", (Object)DateUtils.format(invoiceJson.getDate("invoice_date"), "yyyy-MM-dd"));
        }
        Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(mainDynamicObject.get("org"));
        if (InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(this.invoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(this.invoiceType)) {
            deduction_flag = DeductionConstant.canBeDeductionForOrdinary(convertJson, orgId);
            mainDynamicObject.set("deduction_flag", (Object)deduction_flag);
            if (StringUtils.isEmpty((CharSequence)mainDynamicObject.getString("transport_deduction"))) {
                mainDynamicObject.set("transport_deduction", (Object)"0");
            }
            this.setEffectiveTaxAmount(mainDynamicObject, deduction_flag, mainDynamicObject.getString("transport_deduction"), invoiceJson);
        } else if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(this.invoiceType) || InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(this.invoiceType) || InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode().equals(this.invoiceType) || InputInvoiceTypeEnum.BOAT_INVOICE.getCode().equals(this.invoiceType)) {
            deduction_flag = DeductionConstant.canBeDeductionForTransport(convertJson, orgId);
            mainDynamicObject.set("deduction_flag", (Object)deduction_flag);
            if (StringUtils.isEmpty((CharSequence)mainDynamicObject.getString("transport_deduction"))) {
                mainDynamicObject.set("transport_deduction", (Object)"0");
            }
            this.setEffectiveTaxAmount(mainDynamicObject, deduction_flag, mainDynamicObject.getString("transport_deduction"), invoiceJson);
        }
        if (InputInvoiceTypeEnum.canDeduction(this.invoiceType).booleanValue()) {
            String authenticateFlag;
            deduction_flag = DeductionConstant.canBeDeductionForTaxInvoice(convertJson);
            String deductionFlag = mainDynamicObject.getString("deduction_flag");
            if (!StringUtils.isEmpty((CharSequence)deduction_flag)) {
                mainDynamicObject.set("deduction_flag", (Object)deduction_flag);
            }
            if (StringUtils.isEmpty((CharSequence)(authenticateFlag = mainDynamicObject.getString("authenticate_flag")))) {
                mainDynamicObject.set("authenticate_flag", (Object)"0");
            }
            this.setEffectiveTaxAmount(mainDynamicObject, DeductionConstant.canBeDeductionForTaxInvoiceByInv(convertJson), mainDynamicObject.getString("authenticate_flag"), invoiceJson);
        }
    }

    private void setEffectiveTaxAmount(DynamicObject dynamicObject, String deductionFlag, String deductValue, JSONObject invoiceJson) {
        Map<String, Object> map = DynamicObjectUtil.dynamicObjectToMap(dynamicObject);
        if ("1".equals(deductionFlag)) {
            if (StringUtils.isEmpty((CharSequence)invoiceJson.getString("effective_tax_amount")) && ("0".equals(deductValue) || StringUtils.isEmpty((CharSequence)deductValue))) {
                dynamicObject.set("effective_tax_amount", (Object)CommonUtils.getJsonValue(map, BigDecimal.class, "total_tax_amount", "tax_amount"));
            }
        } else {
            dynamicObject.set("effective_tax_amount", (Object)BigDecimal.ZERO);
        }
    }

    public void setDeductionFieldValue(Long invoiceType, DynamicObject dynamicObject, JSONObject invoiceJson) {
        if (InputInvoiceTypeEnum.canDeduction(invoiceType).booleanValue()) {
            Date authenticateTime;
            String authenticateFlag = invoiceJson.getString("authenticate_flag");
            if (StringUtils.isEmpty((CharSequence)authenticateFlag)) {
                if (StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("authenticate_flag"))) {
                    return;
                }
                authenticateFlag = "0";
            }
            if ((authenticateTime = invoiceJson.getDate("authenticate_time")) == null) {
                if ("2".equals(authenticateFlag)) {
                    authenticateTime = invoiceJson.getDate("select_authenticate_time");
                } else if ("3".equals(authenticateFlag)) {
                    authenticateTime = invoiceJson.getDate("scan_authenticate_time");
                }
            }
            dynamicObject.set("authenticate_flag", (Object)authenticateFlag);
            if (!"0".equals(authenticateFlag)) {
                dynamicObject.set("authenticate_time", (Object)authenticateTime);
                dynamicObject.set("select_time", (Object)invoiceJson.getDate("select_time"));
                if (!StringUtils.isEmpty((CharSequence)invoiceJson.getString("tax_period"))) {
                    dynamicObject.set("tax_period", (Object)DateUtils.stringToDate(invoiceJson.getString("tax_period"), "yyyyMM"));
                }
                dynamicObject.set("deduction_purpose", (Object)invoiceJson.getString("deduction_purpose"));
            } else if ("0".equals(authenticateFlag)) {
                dynamicObject.set("authenticate_time", null);
                dynamicObject.set("select_time", null);
                dynamicObject.set("tax_period", null);
                dynamicObject.set("deduction_purpose", (Object)"");
            }
            if (invoiceJson.getBigDecimal("effective_tax_amount") != null) {
                dynamicObject.set("effective_tax_amount", (Object)invoiceJson.getBigDecimal("effective_tax_amount"));
            }
        }
        if (InputInvoiceTypeEnum.canTransportDeduction(invoiceType).booleanValue()) {
            String transportDeduction = invoiceJson.getString("transport_deduction");
            if (StringUtils.isEmpty((CharSequence)transportDeduction)) {
                if (StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("transport_deduction"))) {
                    return;
                }
                transportDeduction = "0";
            }
            dynamicObject.set("transport_deduction", (Object)transportDeduction);
            if (!"0".equals(transportDeduction)) {
                dynamicObject.set("authenticate_time", (Object)invoiceJson.getDate("authenticate_time"));
                if (!StringUtils.isEmpty((CharSequence)invoiceJson.getString("tax_period"))) {
                    dynamicObject.set("tax_period", (Object)DateUtils.stringToDate(invoiceJson.getString("tax_period"), "yyyyMM"));
                }
            } else {
                dynamicObject.set("authenticate_time", null);
                dynamicObject.set("tax_period", null);
            }
            if (invoiceJson.getBigDecimal("effective_tax_amount") != null) {
                dynamicObject.set("effective_tax_amount", (Object)invoiceJson.getBigDecimal("effective_tax_amount"));
            }
        }
    }

    public void setExcelMainFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        Object receiverObject = dynamicObject.get("receiver");
        long preReceiver = 0L;
        if (receiverObject instanceof DynamicObject) {
            preReceiver = ((DynamicObject)receiverObject).getLong("id");
        } else if (receiverObject instanceof Long) {
            preReceiver = (Long)receiverObject;
        }
        if (InputInvoiceTypeEnum.isVatType(this.invoiceType) && StringUtils.isBlank((CharSequence)dynamicObject.getString("tax_recorded_status"))) {
            dynamicObject.set("tax_recorded_status", (Object)"01");
        }
        this.setInvoiceExcelFieldValue(invoiceJson, dynamicObject, Boolean.TRUE);
        this.replenishReceiver(invoiceJson, dynamicObject, preReceiver);
        if (this.isAllowEdit(dynamicObject, invoiceJson).booleanValue()) {
            JSONArray items;
            if (!StringUtils.isEmpty((CharSequence)invoiceJson.getString("eticket_no"))) {
                dynamicObject.set("invoice_no", (Object)invoiceJson.getString("eticket_no"));
            }
            if (!CollectionUtils.isEmpty((Collection)(items = invoiceJson.getJSONArray("items")))) {
                JSONObject itemJson = items.getJSONObject(0);
                dynamicObject.set("main_goods_name", (Object)itemJson.getString("goods_name"));
            }
            if (StringUtils.isNotBlank((CharSequence)invoiceJson.getString("tax_paid_proof_no"))) {
                dynamicObject.set("invoice_no", (Object)invoiceJson.getString("tax_paid_proof_no"));
            }
            if (StringUtils.isNotBlank((CharSequence)invoiceJson.getString("train_num"))) {
                dynamicObject.set("invoice_code", (Object)invoiceJson.getString("train_num"));
            }
            if (StringUtils.isNotBlank((CharSequence)invoiceJson.getString("sequence_no"))) {
                dynamicObject.set("invoice_no", (Object)invoiceJson.getString("sequence_no"));
            }
            if (StringUtils.isNotBlank((CharSequence)invoiceJson.getString("number"))) {
                dynamicObject.set("invoice_no", (Object)invoiceJson.getString("number"));
            }
            if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("custom_declaration_no"))) {
                dynamicObject.set("invoice_no", (Object)invoiceJson.getString("custom_declaration_no"));
            }
            if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("invoice_amount"))) {
                dynamicObject.set("invoice_amount", (Object)invoiceJson.getBigDecimal("invoice_amount"));
            } else {
                dynamicObject.set("invoice_amount", (Object)invoiceJson.getBigDecimal("amount"));
            }
            if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("total_tax_amount"))) {
                dynamicObject.set("total_tax_amount", (Object)invoiceJson.getBigDecimal("total_tax_amount"));
            }
            if (StringUtils.isEmpty((CharSequence)dynamicObject.getString("is_revise"))) {
                dynamicObject.set("is_revise", (Object)"0");
            }
            if ("65".equals(invoiceJson.get((Object)"expense_status")) && ObjectUtils.isEmpty((Object)invoiceJson.get((Object)"account_time"))) {
                dynamicObject.set("account_time", (Object)new Date());
            }
            if ("0".equals(invoiceJson.getString("company_seal"))) {
                dynamicObject.set("company_seal", (Object)"0");
            } else {
                dynamicObject.set("company_seal", (Object)"1");
            }
            if ("1".equals(invoiceJson.getString("continuous_no"))) {
                dynamicObject.set("continuous_no", (Object)"1");
            } else {
                dynamicObject.set("continuous_no", (Object)"0");
            }
            String originalState = dynamicObject.getString("original_state");
            if ("1".equals(originalState) && dynamicObject.get("original_time") == null) {
                dynamicObject.set("original_time", (Object)new Date());
            }
            String invoiceSource = invoiceJson.getString("invoice_source");
            String invoiceRiskLevel = invoiceJson.getString("invoice_risk_level");
            if (StringUtils.isNotEmpty((CharSequence)invoiceSource)) {
                dynamicObject.set("invoice_source", (Object)DeductionUtils.convertInvoiceSource(invoiceSource));
            }
            if (StringUtils.isNotEmpty((CharSequence)invoiceRiskLevel)) {
                dynamicObject.set("invoice_risk_level", (Object)DeductionUtils.convertInvoiceRiskLevel(invoiceRiskLevel));
            }
        }
    }

    private void replenishReceiver(JSONObject invoiceJson, DynamicObject dynamicObject, long preReceiver) {
        if (invoiceJson.containsKey((Object)"original_state") && "1".equals(invoiceJson.getString("original_state")) && invoiceJson.containsKey((Object)"receiver")) {
            boolean updateFlag = this.getUpdateFlag(dynamicObject);
            if (updateFlag) {
                String receiver = invoiceJson.getString("receiver");
                Long receiverId = 0L;
                if (!StringUtils.isBlank((CharSequence)receiver)) {
                    receiverId = TenantUtils.getUserId(receiver);
                }
                dynamicObject.set("receiver", (Object)receiverId);
            } else {
                dynamicObject.set("receiver", (Object)preReceiver);
            }
        }
    }

    private boolean getUpdateFlag(DynamicObject dynamicObject) {
        String tenantNo = TenantUtils.getTenantNo();
        String serialNo = dynamicObject.getString("serial_no");
        QFilter invoiceFilter = new QFilter("serial_no", "=", (Object)serialNo).and("tenant_no", "=", (Object)tenantNo);
        DynamicObject checkObj = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"expense_status", (QFilter[])invoiceFilter.toArray());
        if (checkObj != null) {
            String expenseStatus = checkObj.getString("expense_status");
            return "1".equals(expenseStatus) || "30".equals(expenseStatus);
        }
        return true;
    }

    private void setUserAndOrg(String userId, String orgId, DynamicObject mainDynamicObject) {
        DynamicObjectCollection orgEntry = mainDynamicObject.getDynamicObjectCollection("collect_org_entry");
        Boolean curOrgFlag = Boolean.FALSE;
        if (!CollectionUtils.isEmpty((Collection)orgEntry)) {
            for (DynamicObject orgObj : orgEntry) {
                String pk;
                DynamicObject org = orgObj.getDynamicObject("collect_org");
                if (org == null || !(pk = org.getPkValue() + "").equals(orgId)) continue;
                orgObj.set("collect_org_user", (Object)userId);
                curOrgFlag = Boolean.TRUE;
                break;
            }
        }
        if (!curOrgFlag.booleanValue()) {
            DynamicObject item = orgEntry.addNew();
            item.set("collect_org_user", (Object)userId);
            item.set("collect_org", (Object)orgId);
        }
    }

    private Boolean checkIdIsNull(Object id) {
        if (id == null) {
            return Boolean.TRUE;
        }
        try {
            return Integer.parseInt(id.toString()) == 0;
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    private Boolean overrideOrg(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return Boolean.TRUE;
        }
        Object expense_status = DynamicObjectUtil.getValue(dynamicObject, "expense_status");
        Boolean isUsed = ExpenseConstant.isUsed(expense_status);
        Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(dynamicObject.get("org"));
        logger.info("orgId:{},isUsed:{}", (Object)orgId, (Object)isUsed);
        if (orgId > 0L && isUsed.booleanValue()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Long getInvoiceType() {
        return this.invoiceType;
    }

    public void setInvoiceType(Long invoiceType) {
        this.invoiceType = invoiceType;
    }
}

