/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.save.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.collector.InvoiceCollectService;
import kd.imc.rim.common.invoice.download.excel.TaxInvoiceConvertUtil;
import kd.imc.rim.common.invoice.query.convert.impl.AirConvertService;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.TenantUtils;

public class AirEleSaveService
extends InvoiceSaveService {
    @Override
    public void setInvoiceFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        String sellerName;
        String gradeName;
        super.setInvoiceFieldValue(invoiceJson, dynamicObject);
        String invoiceStatus = invoiceJson.getString("invoiceStatus");
        String invoiceStateByCN = TaxInvoiceConvertUtil.getInvoiceStateByCN(invoiceStatus);
        if (kd.imc.rim.common.utils.StringUtils.isNotEmpty((CharSequence)invoiceStateByCN)) {
            invoiceStatus = invoiceStateByCN;
        }
        dynamicObject.set("invoice_status", (Object)invoiceStatus);
        dynamicObject.set("international_flag", (Object)invoiceJson.getString("internationalFlag"));
        dynamicObject.set("gp_order_no", (Object)invoiceJson.getString("gpOrderNo"));
        dynamicObject.set("invoice_no", (Object)invoiceJson.getString("invoiceNo"));
        dynamicObject.set("issuing_status", (Object)invoiceJson.getString("issuingStatus"));
        dynamicObject.set("customer_name", (Object)invoiceJson.getString("customerName"));
        dynamicObject.set("customer_identity_num", (Object)invoiceJson.getString("customerIdentityNum"));
        dynamicObject.set("endorsement", (Object)invoiceJson.getString("endorsement"));
        dynamicObject.set("place_of_departure", (Object)invoiceJson.getString("placeOfDeparture"));
        dynamicObject.set("destination", (Object)invoiceJson.getString("destination"));
        dynamicObject.set("issuing_status", (Object)invoiceJson.getString("invoiceStatus"));
        dynamicObject.set("carrier", (Object)invoiceJson.getString("carrier"));
        dynamicObject.set("flight_num", (Object)invoiceJson.getString("flightNum"));
        if (InvoiceConvertUtils.canUpdateData(invoiceJson.getString("prev_check_status"), invoiceJson.getString("seatGrade"))) {
            dynamicObject.set("seat_grade", (Object)invoiceJson.getString("seatGrade"));
        }
        if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)(gradeName = invoiceJson.getString("seatGradeName")))) {
            gradeName = AirConvertService.convertSeatName(DynamicObjectUtil.fieldToString(invoiceJson.getString("seatGrade")));
        }
        boolean reviseFlag = false;
        String isRevise = invoiceJson.getString("isReviseFlag");
        boolean bl = reviseFlag = kd.imc.rim.common.utils.StringUtils.isNotEmpty((CharSequence)isRevise) && "1".equals(isRevise);
        if (InvoiceConvertUtils.canUpdateData(invoiceJson.getString("prev_check_status"), gradeName) && !reviseFlag) {
            dynamicObject.set("seat_grade_name", (Object)gradeName);
        }
        dynamicObject.set("carrier_date", (Object)invoiceJson.getDate("carrierDate"));
        dynamicObject.set("air_time", (Object)invoiceJson.getString("airTime"));
        dynamicObject.set("fare_basis", (Object)invoiceJson.getString("fareBasis"));
        dynamicObject.set("free_bag_allowance", (Object)invoiceJson.getString("freeBaggageAllowance"));
        Date invoiceDate = invoiceJson.getDate("invoiceDate");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        boolean dateFlag = false;
        try {
            Date date = sdf.parse("2025-07-28 00:00:00");
            if (invoiceDate.compareTo(date) >= 0) {
                dateFlag = true;
            }
        }
        catch (ParseException date) {
            // empty catch block
        }
        BigDecimal invoiceAmount = this.getObject(invoiceJson, "invoiceAmount", BigDecimal.class);
        String ticketPrice = invoiceJson.getString("ticketPrice");
        String fuelSurcharge = invoiceJson.getString("fuelSurcharge");
        BigDecimal taxAmount = this.getJSONValue(invoiceJson, BigDecimal.class, "totalTaxAmount", "taxAmount");
        if (!dateFlag || BigDecimal.ZERO.compareTo(BigDecimalUtil.transDecimal(invoiceJson.get((Object)"totalTaxInclAmount"))) != 0) {
            if (InvoiceConvertUtils.canUpdateData(invoiceJson.getString("prev_check_status"), invoiceJson.getString("ticketPrice"))) {
                dynamicObject.set("ticket_price", (Object)ticketPrice);
            }
            dynamicObject.set("invoice_amount", (Object)invoiceAmount);
            dynamicObject.set("total_tax_incl_amount", (Object)BigDecimalUtil.transDecimal(invoiceJson.get((Object)"totalTaxInclAmount")));
        } else {
            this.setTotalTaxInclAmount(dynamicObject, invoiceJson, ticketPrice, fuelSurcharge, taxAmount, invoiceAmount);
        }
        if (InvoiceConvertUtils.canUpdateData(invoiceJson.getString("prev_check_status"), invoiceJson.getString("fuelSurcharge"))) {
            dynamicObject.set("fuel_surcharge", (Object)this.getObject(invoiceJson, "fuelSurcharge", BigDecimal.class));
        }
        if (InvoiceConvertUtils.canUpdateData(invoiceJson.getString("prev_check_status"), invoiceJson.getString("taxRate"))) {
            dynamicObject.set("tax_rate", (Object)this.getObject(invoiceJson, "taxRate", BigDecimal.class));
        }
        dynamicObject.set("tax_amount", (Object)this.getJSONValue(invoiceJson, BigDecimal.class, "totalTaxAmount", "taxAmount"));
        if (InvoiceConvertUtils.canUpdateData(invoiceJson.getString("prev_check_status"), invoiceJson.getString("airportConstructionFee"))) {
            dynamicObject.set("airport_construction_fee", (Object)this.getObject(invoiceJson, "airportConstructionFee", BigDecimal.class));
        }
        if (InvoiceConvertUtils.canUpdateData(invoiceJson.getString("prev_check_status"), this.getJSONValue(invoiceJson, String.class, "otherTaxAmount", "otherTotalTaxAmount"))) {
            dynamicObject.set("other_total_tax_amount", (Object)this.getJSONValue(invoiceJson, BigDecimal.class, "otherTaxAmount", "otherTotalTaxAmount"));
        }
        BigDecimal totalAmount = dynamicObject.getBigDecimal("total_amount");
        String prevCheckStatus = invoiceJson.getString("prev_check_status");
        if (!"1".equals(prevCheckStatus) || totalAmount.compareTo(BigDecimal.ZERO) == 0 || !"totalExcel".equals(invoiceJson.getString("importType"))) {
            dynamicObject.set("total_amount", (Object)this.getObject(invoiceJson, "totalAmount", BigDecimal.class));
        }
        if (InvoiceConvertUtils.canUpdateData(invoiceJson.getString("prev_check_status"), invoiceJson.getString("electronicTicketNum"))) {
            dynamicObject.set("electronic_ticket_num", (Object)invoiceJson.getString("electronicTicketNum"));
        }
        dynamicObject.set("verification_code", (Object)invoiceJson.getString("verificationCode"));
        dynamicObject.set("purchaser_name", (Object)this.getJSONValue(invoiceJson, String.class, "purchaserName", "buyerName"));
        String purchaserUnifiedSocialCreditCode = invoiceJson.getString("purchaserUnifiedSocialCreditCode");
        if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)purchaserUnifiedSocialCreditCode)) {
            purchaserUnifiedSocialCreditCode = invoiceJson.getString("buyerTaxNo");
        }
        dynamicObject.set("pur_unified_cre_code", (Object)purchaserUnifiedSocialCreditCode);
        String salesUnitCode = invoiceJson.getString("salesUnitCode");
        if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)salesUnitCode)) {
            salesUnitCode = invoiceJson.getString("salerTaxNo");
        }
        if (InvoiceConvertUtils.canUpdateData(invoiceJson.getString("prev_check_status"), salesUnitCode)) {
            dynamicObject.set("sales_unit_code", (Object)salesUnitCode);
        }
        Date tkrq = this.getIssueDate(invoiceJson);
        this.setInvoiceDate(tkrq, dynamicObject, "issue_date");
        this.setInvoiceDate(tkrq, dynamicObject, "invoice_date");
        dynamicObject.set("promptinformation", (Object)invoiceJson.getString("promptInformation"));
        dynamicObject.set("promptinformation", (Object)invoiceJson.getString("promptInformation"));
        if (InvoiceConvertUtils.canUpdateData(invoiceJson.getString("prev_check_status"), invoiceJson.getString("insurancePremium"))) {
            dynamicObject.set("insurance_premium", (Object)this.getObject(invoiceJson, "insurancePremium", BigDecimal.class));
        }
        if (InvoiceConvertUtils.canUpdateData(invoiceJson.getString("prev_check_status"), invoiceJson.getString("fillingUnit"))) {
            dynamicObject.set("filling_unit", (Object)invoiceJson.getString("fillingUnit"));
        }
        if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)(sellerName = invoiceJson.getString("sellerName")))) {
            sellerName = invoiceJson.getString("salerName");
        }
        if (InvoiceConvertUtils.canUpdateData(invoiceJson.getString("prev_check_status"), sellerName)) {
            dynamicObject.set("seller_name", (Object)sellerName);
        }
        this.setInvoiceItemsValue(invoiceJson, dynamicObject);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dynamicObject.getString("tax_recorded_status"))) {
            dynamicObject.set("tax_recorded_status", (Object)"01");
        }
        dynamicObject.set("remark", (Object)StringUtils.substring((String)invoiceJson.getString("remark"), (int)0, (int)300));
        dynamicObject.set("flight_segment", (Object)invoiceJson.getString("flightSegment"));
        dynamicObject.set("effective_date", (Object)invoiceJson.getDate("effectiveDate"));
        dynamicObject.set("expiration_date", (Object)invoiceJson.getDate("expirationDate"));
        dynamicObject.set("drawer", (Object)invoiceJson.getString("drawer"));
        dynamicObject.set("remitter", (Object)invoiceJson.getString("remitter"));
        dynamicObject.set("payee", (Object)invoiceJson.getString("payee"));
    }

    private void setTotalTaxInclAmount(DynamicObject dynamicObject, JSONObject invoiceJson, String ticketPrice, String fuelSurcharge, BigDecimal taxAmount, BigDecimal invoiceAmount) {
        BigDecimal totalTaxInclAmount = BigDecimalUtil.transDecimal(dynamicObject.get("total_tax_incl_amount"));
        if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)ticketPrice) || kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)fuelSurcharge)) {
            BigDecimal ticketPriceDb = BigDecimalUtil.transDecimal(dynamicObject.get("ticket_price"));
            BigDecimal fuelSurchargeDb = BigDecimalUtil.transDecimal(dynamicObject.get("fuel_surcharge"));
            if (BigDecimal.ZERO.compareTo(ticketPriceDb) != 0 && BigDecimal.ZERO.compareTo(totalTaxInclAmount) == 0) {
                totalTaxInclAmount = ticketPriceDb.add(fuelSurchargeDb).add(taxAmount);
                dynamicObject.set("total_tax_incl_amount", (Object)totalTaxInclAmount);
                invoiceAmount = ticketPriceDb.add(fuelSurchargeDb);
                dynamicObject.set("invoice_amount", (Object)invoiceAmount);
            }
        } else {
            BigDecimal ticketPriceDecimal = BigDecimalUtil.transDecimal(ticketPrice);
            BigDecimal fuelSurchargeDecimal = BigDecimalUtil.transDecimal(fuelSurcharge);
            if (InvoiceConvertUtils.canUpdateData(invoiceJson.getString("prev_check_status"), invoiceJson.getString("ticketPrice"))) {
                dynamicObject.set("ticket_price", (Object)ticketPriceDecimal);
                if (BigDecimal.ZERO.compareTo(totalTaxInclAmount) == 0) {
                    totalTaxInclAmount = ticketPriceDecimal.add(fuelSurchargeDecimal).add(taxAmount);
                    dynamicObject.set("total_tax_incl_amount", (Object)totalTaxInclAmount);
                    invoiceAmount = ticketPriceDecimal.add(fuelSurchargeDecimal);
                }
            }
            dynamicObject.set("invoice_amount", (Object)invoiceAmount);
        }
    }

    private Date getIssueDate(JSONObject invoiceJson) {
        return this.getJSONValue(invoiceJson, Date.class, "issueDate", "invoiceDate");
    }

    @Override
    public void setInvoiceItemsValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        JSONArray items = invoiceJson.getJSONArray("items");
        if (items != null) {
            DynamicObjectCollection collection = (DynamicObjectCollection)dynamicObject.get("items");
            collection.clear();
            for (int i = 0; i < items.size(); ++i) {
                JSONObject itemJson = items.getJSONObject(i);
                DynamicObject itemObject = collection.addNew();
                itemObject.set("seq", (Object)i);
                itemObject.set("entry_place_of_departure", (Object)itemJson.getString("placeOfDeparture"));
                itemObject.set("entry_destination", (Object)itemJson.getString("destination"));
                itemObject.set("entry_carrier", (Object)itemJson.getString("carrier"));
                itemObject.set("entry_flight_num", (Object)itemJson.getString("flightNum"));
                if (InvoiceConvertUtils.canUpdateData(invoiceJson.getString("prev_check_status"), invoiceJson.getString("seatGrade"))) {
                    itemObject.set("entry_seat_grade", (Object)itemJson.getString("seatGrade"));
                }
                itemObject.set("entry_carrier_date", (Object)itemJson.getDate("carrierDate"));
                itemObject.set("entry_air_time", (Object)itemJson.getString("airTime"));
                itemObject.set("entry_flight_segment", (Object)itemJson.getString("flightSegment"));
                itemObject.set("entry_fare_basis", (Object)itemJson.getString("fareBasis"));
                itemObject.set("entry_effective_date", (Object)itemJson.getDate("effectiveDate"));
                itemObject.set("entry_expiration_date", (Object)itemJson.getDate("expirationDate"));
                String freeBaggageAllowance = itemJson.getString("freeBaggageAllowance");
                if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)freeBaggageAllowance)) {
                    freeBaggageAllowance = invoiceJson.getString("freeBaggageAllowance");
                }
                itemObject.set("entry_free_bag_allowance", (Object)freeBaggageAllowance);
            }
        }
    }

    @Override
    public DynamicObject getInvoiceDynamicObject(JSONObject invoiceJson) {
        DynamicObject invDynObj;
        String entityId = InputInvoiceTypeEnum.getEntity(this.invoiceType);
        String tenantNo = TenantUtils.getTenantNo();
        String invoiceNo = invoiceJson.getString("invoiceNo");
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        QFilter invoiceNoFilter = new QFilter("invoice_no", "=", (Object)invoiceNo);
        DynamicObject idObject = QueryServiceHelper.queryOne((String)entityId, (String)"id", (QFilter[])new QFilter[]{tenantFilter, invoiceNoFilter});
        if (null == idObject) {
            invDynObj = BusinessDataServiceHelper.newDynamicObject((String)entityId);
            invDynObj.set("tenant_no", (Object)tenantNo);
            this.setSerialNo(invoiceJson, invDynObj);
        } else {
            invDynObj = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)entityId);
        }
        return invDynObj;
    }

    @Override
    public void setMainFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        String salesUnitCode;
        String recognitionImplStr = RimConfigUtils.getConfig("rim_recog_check", "rimpl");
        boolean isAwsRecognition = kd.bos.util.StringUtils.isEmpty((String)recognitionImplStr) || "kd.imc.rim.common.invoice.recognitionnew.impl.AwsRecognitionService".equals(recognitionImplStr);
        boolean isConvertPlace = "1".equals(RimConfigUtils.getConfig("rim_recog_check", "convertplace"));
        if (isAwsRecognition && isConvertPlace) {
            InvoiceCollectService collectService = new InvoiceCollectService();
            collectService.convertPlace(invoiceJson);
        }
        super.setMainFieldValue(invoiceJson, dynamicObject);
        Date tkrq = this.getIssueDate(invoiceJson);
        this.setInvoiceDate(tkrq, dynamicObject, "invoice_date");
        dynamicObject.set("total_tax_amount", (Object)this.getJSONValue(invoiceJson, BigDecimal.class, "totalTaxAmount", "taxAmount"));
        String invoiceStatus = invoiceJson.getString("invoiceStatus");
        String invoiceStateByCN = TaxInvoiceConvertUtil.getInvoiceStateByCN(invoiceStatus);
        if (kd.imc.rim.common.utils.StringUtils.isNotEmpty((CharSequence)invoiceStateByCN)) {
            invoiceStatus = invoiceStateByCN;
        }
        dynamicObject.set("invoice_status", (Object)invoiceStatus);
        dynamicObject.set("buyer_name", (Object)this.getJSONValue(invoiceJson, String.class, "purchaserName", "buyerName"));
        String purchaserUnifiedSocialCreditCode = invoiceJson.getString("purchaserUnifiedSocialCreditCode");
        if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)purchaserUnifiedSocialCreditCode)) {
            purchaserUnifiedSocialCreditCode = invoiceJson.getString("buyerTaxNo");
        }
        dynamicObject.set("buyer_tax_no", (Object)purchaserUnifiedSocialCreditCode);
        String sellerName = invoiceJson.getString("sellerName");
        if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)sellerName)) {
            sellerName = invoiceJson.getString("salerName");
        }
        if (InvoiceConvertUtils.canUpdateData(invoiceJson.getString("prev_check_status"), sellerName)) {
            dynamicObject.set("saler_name", (Object)sellerName);
        }
        if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)(salesUnitCode = invoiceJson.getString("salesUnitCode")))) {
            salesUnitCode = invoiceJson.getString("salerTaxNo");
        }
        if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)salesUnitCode)) {
            salesUnitCode = invoiceJson.getString("salerIdNo");
        }
        if (InvoiceConvertUtils.canUpdateData(invoiceJson.getString("prev_check_status"), salesUnitCode)) {
            dynamicObject.set("saler_tax_no", (Object)salesUnitCode);
        }
    }
}

