/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.save.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.query.convert.impl.AirConvertService;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.utils.TenantUtils;

public class AirSaveService
extends InvoiceSaveService {
    @Override
    public void setInvoiceFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        super.setInvoiceFieldValue(invoiceJson, dynamicObject);
        dynamicObject.set("agent_code", (Object)invoiceJson.getString("agentCode"));
        dynamicObject.set("air_num", (Object)invoiceJson.getString("airNum"));
        dynamicObject.set("air_time", (Object)invoiceJson.getString("airTime"));
        dynamicObject.set("airport_construction_fee", (Object)invoiceJson.getBigDecimal("airportConstructionFee"));
        dynamicObject.set("carrier", (Object)invoiceJson.getString("carrier"));
        String customerIdNo = invoiceJson.getString("customerIdNo");
        String customerIdentityNum = invoiceJson.getString("customerIdentityNum");
        String customer_id_no = StringUtils.isEmpty((CharSequence)customerIdNo) ? customerIdentityNum : customerIdNo;
        dynamicObject.set("customer_id_no", (Object)customer_id_no);
        dynamicObject.set("customer_name", (Object)invoiceJson.getString("customerName"));
        dynamicObject.set("destination", (Object)invoiceJson.getString("destination"));
        dynamicObject.set("endorsement", (Object)invoiceJson.getString("endorsement"));
        String eticketNo = invoiceJson.getString("eticketNo");
        String electronicTicketNum = invoiceJson.getString("electronicTicketNum");
        String eticket_no = StringUtils.isEmpty((CharSequence)eticketNo) ? electronicTicketNum : eticketNo;
        dynamicObject.set("eticket_no", (Object)eticket_no);
        String fillingUnit = invoiceJson.getString("fillingUnit");
        if (fillingUnit != null && fillingUnit.length() > 100) {
            dynamicObject.set("filling_unit", (Object)fillingUnit.substring(0, 100));
        } else {
            dynamicObject.set("filling_unit", (Object)fillingUnit);
        }
        dynamicObject.set("flight_num", (Object)invoiceJson.getString("flightNum"));
        dynamicObject.set("fuel_surcharge", (Object)invoiceJson.getBigDecimal("fuelSurcharge"));
        dynamicObject.set("insurance_premium", (Object)invoiceJson.getBigDecimal("insurancePremium"));
        dynamicObject.set("invoice_amount", (Object)invoiceJson.getBigDecimal("invoiceAmount"));
        dynamicObject.set("invoice_date", (Object)invoiceJson.getDate("invoiceDate"));
        dynamicObject.set("issue_date", (Object)invoiceJson.getDate("invoiceDate"));
        BigDecimal otherTotalTaxAmount = invoiceJson.getBigDecimal("otherTotalTaxAmount");
        BigDecimal otherAmount = invoiceJson.getBigDecimal("otherAmount");
        BigDecimal other_amount = otherAmount == null ? otherTotalTaxAmount : otherAmount;
        dynamicObject.set("other_amount", (Object)other_amount);
        dynamicObject.set("place_of_departure", (Object)invoiceJson.getString("placeOfDeparture"));
        dynamicObject.set("print_num", (Object)invoiceJson.getString("printNum"));
        dynamicObject.set("seat_grade", (Object)invoiceJson.getString("seatGrade"));
        String seatName = invoiceJson.getString("seatGradeName");
        if (StringUtils.isEmpty((CharSequence)seatName)) {
            dynamicObject.set("seatgrade_name", (Object)AirConvertService.convertSeatName(invoiceJson.getString("seatGrade")));
        } else {
            dynamicObject.set("seatgrade_name", (Object)seatName);
        }
        dynamicObject.set("tax_rate", (Object)invoiceJson.getBigDecimal("taxRate"));
        dynamicObject.set("total_amount", (Object)invoiceJson.getBigDecimal("totalAmount"));
        dynamicObject.set("total_tax_amount", (Object)invoiceJson.getBigDecimal("totalTaxAmount"));
        dynamicObject.set("international_flag", (Object)invoiceJson.getString("internationalFlag"));
        if (StringUtils.isEmpty((CharSequence)dynamicObject.getString("deduction_flag"))) {
            dynamicObject.set("deduction_flag", (Object)"1");
        }
        if (StringUtils.isEmpty((CharSequence)dynamicObject.getString("transport_deduction"))) {
            dynamicObject.set("transport_deduction", (Object)"0");
        }
        dynamicObject.set("ticket_changes", (Object)invoiceJson.getString("ticketChanges"));
        this.setInvoiceItemsValue(invoiceJson, dynamicObject);
    }

    @Override
    public void setInvoiceItemsValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        JSONArray items = invoiceJson.getJSONArray("items");
        if (items != null) {
            DynamicObjectCollection collection = (DynamicObjectCollection)dynamicObject.get("items");
            collection.clear();
            for (int i = 0; i < items.size(); ++i) {
                JSONObject itemJson = items.getJSONObject(i);
                DynamicObject itemObject = collection.addNew();
                itemObject.set("entry_flight_num", (Object)itemJson.getString("flightNum"));
                itemObject.set("entry_departure", (Object)itemJson.getString("placeOfDeparture"));
                itemObject.set("entry_destination", (Object)itemJson.getString("destination"));
                itemObject.set("entry_seat_grade", (Object)itemJson.getString("seatGrade"));
                itemObject.set("entry_carrier", (Object)itemJson.getString("carrier"));
                itemObject.set("entry_date", (Object)itemJson.getDate("invoiceDate"));
                itemObject.set("entry_time", (Object)itemJson.getString("takePlaneTime"));
            }
        }
    }

    @Override
    public void setMainFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        BigDecimal invoiceAmount;
        super.setMainFieldValue(invoiceJson, dynamicObject);
        String eticketNo = invoiceJson.getString("eticketNo");
        String electronicTicketNum = invoiceJson.getString("electronicTicketNum");
        String eticket_no = StringUtils.isEmpty((CharSequence)eticketNo) ? electronicTicketNum : eticketNo;
        dynamicObject.set("invoice_no", (Object)eticket_no);
        dynamicObject.set("invoice_code", (Object)"");
        dynamicObject.set("international_flag", (Object)invoiceJson.getString("internationalFlag"));
        String ticketChanges = invoiceJson.getString("ticketChanges");
        BigDecimal totalTaxAmount = invoiceJson.getBigDecimal("totalTaxAmount");
        BigDecimal bigDecimal = invoiceAmount = invoiceJson.getBigDecimal("invoiceAmount") == null ? BigDecimal.ZERO : invoiceJson.getBigDecimal("invoiceAmount");
        if ("2".equals(ticketChanges)) {
            BigDecimal totalAmount = invoiceJson.getBigDecimal("totalAmount") == null ? BigDecimal.ZERO : invoiceJson.getBigDecimal("totalAmount");
            BigDecimal otherAmount = invoiceJson.getBigDecimal("otherAmount") == null ? BigDecimal.ZERO : invoiceJson.getBigDecimal("otherAmount");
            BigDecimal subtract = totalAmount.subtract(otherAmount);
            dynamicObject.set("invoice_amount", (Object)(totalTaxAmount == null ? invoiceAmount : subtract.subtract(totalTaxAmount)));
        } else {
            BigDecimal fuelSurcharge = invoiceJson.getBigDecimal("fuelSurcharge") == null ? BigDecimal.ZERO : invoiceJson.getBigDecimal("fuelSurcharge");
            BigDecimal addNum = invoiceAmount.add(fuelSurcharge);
            dynamicObject.set("invoice_amount", (Object)(totalTaxAmount == null ? invoiceAmount : addNum.subtract(totalTaxAmount)));
        }
    }

    @Override
    public DynamicObject getInvoiceDynamicObject(JSONObject invoiceJson) {
        String entityId = InputInvoiceTypeEnum.getEntity(this.invoiceType);
        String tenantNo = TenantUtils.getTenantNo();
        String printNum = invoiceJson.getString("printNum");
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        String eticketNo = invoiceJson.getString("eticketNo");
        String electronicTicketNum = invoiceJson.getString("electronicTicketNum");
        String eticket_no = StringUtils.isEmpty((CharSequence)eticketNo) ? electronicTicketNum : eticketNo;
        QFilter filter1 = new QFilter("eticket_no", "=", (Object)eticket_no);
        QFilter filter2 = new QFilter("print_num", "=", (Object)(printNum == null ? "" : printNum));
        DynamicObject idObject = QueryServiceHelper.queryOne((String)entityId, (String)"id", (QFilter[])new QFilter[]{tenantFilter, filter1, filter2});
        DynamicObject invoiceDynamicObject = null;
        if (null == idObject) {
            invoiceDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityId);
            invoiceDynamicObject.set("tenant_no", (Object)tenantNo);
            this.setSerialNo(invoiceJson, invoiceDynamicObject);
        } else {
            invoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)entityId);
        }
        return invoiceDynamicObject;
    }

    @Override
    public String getLockKey(JSONObject invoiceJson) {
        return this.invoiceType + invoiceJson.getString("printNum") + this.getJSONValue(invoiceJson, String.class, "eticketNo", "electronicTicketNum");
    }

    @Override
    public String getBillNo(JSONObject invoiceJson) {
        return this.getJSONValue(invoiceJson, String.class, "eticketNo", "electronicTicketNum");
    }
}

