/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.save.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.TenantUtils;

public class CustomSaveService
extends InvoiceSaveService {
    @Override
    public void setInvoiceFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        super.setInvoiceFieldValue(invoiceJson, dynamicObject);
        dynamicObject.set("custom_declaration_no", (Object)this.getJSONValue(invoiceJson, String.class, "invoiceNo", "jkshm", "customDeclarationNo"));
        dynamicObject.set("invoice_date", (Object)this.getJSONValue(invoiceJson, Date.class, "invoiceDate", "tfrq"));
        dynamicObject.set("dept_name", (Object)this.getJSONValue(invoiceJson, String.class, "buyerName", "jkdwmc1", "deptName"));
        String deptTaxNo = this.getJSONValue(invoiceJson, String.class, "buyerTaxNo", "jkdwsh1", "deptTaxNo");
        if (StringUtils.isNotBlank((CharSequence)deptTaxNo)) {
            dynamicObject.set("dept_tax_no", (Object)deptTaxNo);
        }
        dynamicObject.set("total_tax_amount", (Object)this.getJSONValue(invoiceJson, BigDecimal.class, "totalTaxAmount", "skje", "totalAmount"));
        dynamicObject.set("second_dept_name", (Object)invoiceJson.getString("secondDeptName"));
        dynamicObject.set("second_dept_tax_no", (Object)invoiceJson.getString("secondDeptTaxNo"));
        dynamicObject.set("dept_account", (Object)invoiceJson.getString("deptAccount"));
        dynamicObject.set("dept_bank", (Object)invoiceJson.getString("deptBank"));
        dynamicObject.set("get_office", (Object)this.getJSONValue(invoiceJson, String.class, "srjg", "getOffice"));
        dynamicObject.set("apply_dept_no", (Object)this.getJSONValue(invoiceJson, String.class, "sqdwbm", "applyDeptNo"));
        dynamicObject.set("declare_no", (Object)this.getJSONValue(invoiceJson, String.class, "bgdbh", "declareNo"));
        dynamicObject.set("mode_trade", (Object)this.getJSONValue(invoiceJson, String.class, "myfs", "modeTrade"));
        dynamicObject.set("budget_account_code", (Object)this.getJSONValue(invoiceJson, String.class, "yskmdm", "budgetAccountCode"));
        dynamicObject.set("code_collection_treasury", (Object)this.getJSONValue(invoiceJson, String.class, "skgkdm", "codeCollectionTreasury"));
        dynamicObject.set("contract_no", (Object)this.getJSONValue(invoiceJson, String.class, "hth", "contractNo"));
        dynamicObject.set("trans_tool_no", (Object)this.getJSONValue(invoiceJson, String.class, "ysgj", "transToolNo"));
        dynamicObject.set("pay_limit_date", (Object)this.getJSONValue(invoiceJson, String.class, "jkqx", "payLimitDate"));
        dynamicObject.set("delivery_no", (Object)this.getJSONValue(invoiceJson, String.class, "tydh", "deliveryNo"));
        dynamicObject.set("deal_goods_no", (Object)invoiceJson.getString("dealGoodsNo"));
        dynamicObject.set("port_code", (Object)invoiceJson.getString("portCode"));
        dynamicObject.set("customs_name", (Object)invoiceJson.getString("customsName"));
        dynamicObject.set("data_source", (Object)this.getJSONValue(invoiceJson, String.class, "sjly", "dataSource"));
        String subject = invoiceJson.getString("subject");
        String subjectValue = "1";
        if (StringUtils.isNotEmpty((CharSequence)subject)) {
            switch (subject) {
                case "\u8fdb\u53e3\u5173\u7a0e": {
                    subjectValue = "2";
                    break;
                }
                case "\u8fdb\u53e3\u6d88\u8d39\u7a0e": {
                    subjectValue = "3";
                    break;
                }
                default: {
                    subjectValue = "1";
                }
            }
        }
        dynamicObject.set("subject", (Object)subjectValue);
        this.setInvoiceItemsValue(invoiceJson, dynamicObject);
    }

    @Override
    public void setInvoiceItemsValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        JSONArray items = invoiceJson.getJSONArray("items");
        if (items != null) {
            DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("items");
            collection.clear();
            for (int i = 0; i < items.size(); ++i) {
                JSONObject itemJson = items.getJSONObject(i);
                DynamicObject itemObject = collection.addNew();
                itemObject.set("seq", (Object)this.getJSONValue(itemJson, BigDecimal.class, "xh", "orderNumber"));
                itemObject.set("taxno_info", (Object)this.getJSONValue(itemJson, String.class, "shxx", "taxNumberInformation", "taxnoInfo"));
                itemObject.set("goods_name", (Object)this.getJSONValue(itemJson, String.class, "hwmc", "goodsName"));
                itemObject.set("unit_price", (Object)this.getJSONValue(itemJson, BigDecimal.class, "wsjg", "unitPrice", "detailAmount"));
                itemObject.set("num", (Object)this.getJSONValue(itemJson, BigDecimal.class, "sl", "num"));
                itemObject.set("unit", (Object)this.getJSONValue(itemJson, String.class, "dw", "unit"));
                itemObject.set("tax_rate", (Object)this.getJSONValue(itemJson, BigDecimal.class, "slv", "taxRate"));
                itemObject.set("tax_amount", (Object)this.getJSONValue(itemJson, BigDecimal.class, "skje", "taxAmount"));
                itemObject.set("item_source", (Object)itemJson.getString("dataSource"));
            }
        }
    }

    @Override
    public void setMainFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        super.setMainFieldValue(invoiceJson, dynamicObject);
        if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("invoiceNo"))) {
            dynamicObject.set("invoice_no", (Object)invoiceJson.getString("invoiceNo"));
        } else if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("jkshm"))) {
            dynamicObject.set("invoice_no", (Object)invoiceJson.getString("jkshm"));
        } else {
            dynamicObject.set("invoice_no", (Object)invoiceJson.getString("customDeclarationNo"));
        }
        if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("invoiceDate"))) {
            this.setInvoiceDate(invoiceJson.getDate("invoiceDate"), dynamicObject);
        } else {
            this.setInvoiceDate(invoiceJson.getDate("tfrq"), dynamicObject);
        }
        if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("buyerName"))) {
            dynamicObject.set("buyer_name", (Object)invoiceJson.getString("buyerName"));
        } else if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("jkdwmc1"))) {
            dynamicObject.set("buyer_name", (Object)invoiceJson.getString("jkdwmc1"));
        } else {
            dynamicObject.set("buyer_name", (Object)invoiceJson.getString("deptName"));
        }
        if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("buyerTaxNo"))) {
            dynamicObject.set("buyer_tax_no", (Object)invoiceJson.getString("buyerTaxNo"));
        } else if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("jkdwsh1"))) {
            dynamicObject.set("buyer_tax_no", (Object)invoiceJson.getString("jkdwsh1"));
        } else if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("deptTaxNo"))) {
            dynamicObject.set("buyer_tax_no", (Object)invoiceJson.getString("deptTaxNo"));
        }
        if (BigDecimal.ZERO.compareTo(BigDecimalUtil.transDecimal(dynamicObject.get("total_tax_amount"))) == 0) {
            dynamicObject.set("total_tax_amount", (Object)invoiceJson.getString("skje"));
        }
        if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("totalAmount"))) {
            dynamicObject.set("total_tax_amount", (Object)invoiceJson.getString("totalAmount"));
        } else {
            dynamicObject.set("total_amount", dynamicObject.get("total_tax_amount"));
        }
    }

    @Override
    public DynamicObject getInvoiceDynamicObject(JSONObject invoiceJson) {
        String entityId = InputInvoiceTypeEnum.getEntity(this.invoiceType);
        String tenantNo = TenantUtils.getTenantNo();
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        QFilter invoiceCodeFilter = new QFilter("custom_declaration_no", "=", (Object)this.getJSONValue(invoiceJson, String.class, "invoiceNo", "jkshm", "customDeclarationNo"));
        DynamicObject idObject = QueryServiceHelper.queryOne((String)entityId, (String)"id", (QFilter[])new QFilter[]{tenantFilter, invoiceCodeFilter});
        DynamicObject invoiceDynamicObject = null;
        if (null == idObject) {
            invoiceDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityId);
            invoiceDynamicObject.set("tenant_no", (Object)tenantNo);
            this.setSerialNo(invoiceJson, invoiceDynamicObject);
        } else {
            invoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)entityId);
        }
        return invoiceDynamicObject;
    }

    @Override
    public String getLockKey(JSONObject invoiceJson) {
        return this.invoiceType + this.getJSONValue(invoiceJson, String.class, "invoiceNo", "jkshm", "customDeclarationNo");
    }

    @Override
    public String getBillNo(JSONObject invoiceJson) {
        return CommonUtils.getJsonValue((Map<String, Object>)invoiceJson, String.class, true, "invoiceNo", "customDeclarationNo", "jkshm");
    }
}

