/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.save.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.TenantUtils;

public class FinancialSaveService
extends InvoiceSaveService {
    @Override
    public void setInvoiceFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        super.setInvoiceFieldValue(invoiceJson, dynamicObject);
        dynamicObject.set("invoice_name", (Object)invoiceJson.getString("invoiceName"));
        dynamicObject.set("invoice_code", (Object)invoiceJson.getString("invoiceCode"));
        dynamicObject.set("invoice_no", (Object)invoiceJson.getString("invoiceNo"));
        dynamicObject.set("check_code", (Object)invoiceJson.getString("checkCode"));
        dynamicObject.set("invoice_date", (Object)invoiceJson.getDate("invoiceDate"));
        dynamicObject.set("invoice_time", (Object)invoiceJson.getDate("invoiceTime"));
        dynamicObject.set("total_amount", (Object)invoiceJson.getBigDecimal("totalAmount"));
        dynamicObject.set("invoicing_party_code", (Object)invoiceJson.getString("invoicingPartyCode"));
        dynamicObject.set("invoicing_party_name", (Object)invoiceJson.getString("invoicingPartyName"));
        dynamicObject.set("payer_party_type", (Object)invoiceJson.getString("payerPartyType"));
        dynamicObject.set("biz_code", (Object)invoiceJson.getString("bizCode"));
        dynamicObject.set("remark", (Object)invoiceJson.getString("remark"));
        dynamicObject.set("payer_party_code", (Object)invoiceJson.getString("payerPartyCode"));
        dynamicObject.set("payer_party_name", (Object)invoiceJson.getString("payerPartyName"));
        dynamicObject.set("pay_mode", (Object)invoiceJson.getString("payMode"));
        dynamicObject.set("checker", (Object)FinancialSaveService.subString(invoiceJson.getString("checker"), 20));
        dynamicObject.set("handling_person", (Object)invoiceJson.getString("handlingPerson"));
        dynamicObject.set("related_invoice_code", (Object)invoiceJson.getString("relatedInvoiceCode"));
        dynamicObject.set("related_invoice_no", (Object)invoiceJson.getString("relatedInvoiceNo"));
        this.setInvoiceItemsValue(invoiceJson, dynamicObject);
    }

    @Override
    public void setInvoiceItemsValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        JSONArray items = invoiceJson.getJSONArray("items");
        if (items != null) {
            DynamicObjectCollection collection = (DynamicObjectCollection)dynamicObject.get("items");
            collection.clear();
            for (int i = 0; i < items.size(); ++i) {
                JSONObject itemJson = items.getJSONObject(i);
                DynamicObject itemObject = collection.addNew();
                itemObject.set("item_code", (Object)itemJson.getString("itemCode"));
                itemObject.set("item_name", (Object)itemJson.getString("itemName"));
                itemObject.set("item_quantity", (Object)BigDecimalUtil.transDecimal(itemJson.getString("itemQuantity")));
                itemObject.set("item_unit", (Object)itemJson.getString("itemUnit"));
                itemObject.set("item_std", (Object)BigDecimalUtil.transDecimal(itemJson.getString("itemStd")));
                itemObject.set("item_amount", (Object)BigDecimalUtil.transDecimal(itemJson.getString("itemAmount")));
                itemObject.set("item_remark", (Object)itemJson.getString("itemRemark"));
                JSONArray auxiliaryItems = itemJson.getJSONArray("auxiliaryItems");
                if (auxiliaryItems == null || auxiliaryItems.size() <= 0) continue;
                DynamicObjectCollection collection1 = (DynamicObjectCollection)dynamicObject.get("auxiliaryItems");
                collection1.clear();
                for (int j = 0; j < auxiliaryItems.size(); ++j) {
                    JSONObject itemJson1 = auxiliaryItems.getJSONObject(j);
                    DynamicObject itemObject1 = collection1.addNew();
                    itemObject1.set("aux_item_related_code", (Object)itemJson1.getString("auxItemRelatedCode"));
                    itemObject1.set("aux_item_related_name", (Object)itemJson1.getString("auxItemRelatedName"));
                    itemObject1.set("aux_item_code", (Object)itemJson1.getString("auxItemCode"));
                    itemObject1.set("aux_item_name", (Object)itemJson1.getString("auxItemName"));
                    itemObject1.set("aux_item_quantity", (Object)BigDecimalUtil.transDecimal(itemJson1.getString("auxItemQuantity")));
                    itemObject1.set("aux_item_unit", (Object)itemJson1.getString("auxItemUnit"));
                    itemObject1.set("aux_item_std", (Object)itemJson1.getString("auxItemStd"));
                    itemObject1.set("aux_item_amount", (Object)BigDecimalUtil.transDecimal(itemJson1.getString("auxItemAmount")));
                    itemObject1.set("aux_item_remark", (Object)itemJson1.getString("auxItemRemark"));
                }
            }
        }
    }

    @Override
    public void setMainFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        super.setMainFieldValue(invoiceJson, dynamicObject);
        dynamicObject.set("invoice_code", (Object)invoiceJson.getString("invoiceCode"));
        dynamicObject.set("invoice_no", (Object)invoiceJson.getString("invoiceNo"));
        dynamicObject.set("invoice_date", (Object)invoiceJson.getDate("invoiceDate"));
    }

    @Override
    public DynamicObject getInvoiceDynamicObject(JSONObject invoiceJson) {
        String entityId = InputInvoiceTypeEnum.getEntity(this.invoiceType);
        String tenantNo = TenantUtils.getTenantNo();
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        QFilter invoiceCodeFilter = new QFilter("invoice_code", "=", (Object)invoiceJson.getString("invoiceCode"));
        QFilter invoiceNoFilter = new QFilter("invoice_no", "=", (Object)invoiceJson.getString("invoiceNo"));
        DynamicObject idObject = QueryServiceHelper.queryOne((String)entityId, (String)"id", (QFilter[])new QFilter[]{tenantFilter, invoiceCodeFilter, invoiceNoFilter});
        DynamicObject invoiceDynamicObject = null;
        if (null == idObject) {
            invoiceDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityId);
            invoiceDynamicObject.set("tenant_no", (Object)tenantNo);
            this.setSerialNo(invoiceJson, invoiceDynamicObject);
        } else {
            invoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)entityId);
        }
        return invoiceDynamicObject;
    }
}

