/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.save.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.TenantUtils;

public class OtherSaveService
extends InvoiceSaveService {
    @Override
    public void setInvoiceFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        super.setInvoiceFieldValue(invoiceJson, dynamicObject);
        dynamicObject.set("remark", (Object)invoiceJson.getString("remark"));
        dynamicObject.set("total_amount", (Object)invoiceJson.getBigDecimal("totalAmount"));
        dynamicObject.set("invoice_code", (Object)invoiceJson.getString("invoiceCode"));
        dynamicObject.set("invoice_date", (Object)this.getObject(invoiceJson, "invoiceDate", Date.class));
        dynamicObject.set("invoice_no", (Object)invoiceJson.getString("invoiceNo"));
        dynamicObject.set("title", (Object)invoiceJson.getString("title"));
    }

    @Override
    public void setMainFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        super.setMainFieldValue(invoiceJson, dynamicObject);
        dynamicObject.set("remark", (Object)invoiceJson.getString("remark"));
        dynamicObject.set("invoice_code", (Object)invoiceJson.getString("invoiceCode"));
        dynamicObject.set("invoice_date", (Object)this.getObject(invoiceJson, "invoiceDate", Date.class));
        dynamicObject.set("invoice_no", (Object)invoiceJson.getString("invoiceNo"));
    }

    @Override
    public String getLockKey(JSONObject invoiceJson) {
        return null;
    }

    @Override
    public DynamicObject getInvoiceDynamicObject(JSONObject invoiceJson) {
        String entityId = InputInvoiceTypeEnum.getEntity(this.invoiceType);
        Map<String, String> configMap = ImcConfigUtil.getValue("rim_recog_check");
        String otherMust = ImcConfigUtil.getValue(configMap, "other_must", "0");
        String tenantNo = TenantUtils.getTenantNo();
        String invoiceNo = invoiceJson.getString("invoiceNo");
        DynamicObject idObject = null;
        DynamicObject invoiceDynamicObject = null;
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        if ("1".equals(otherMust) && !StringUtils.isEmpty((CharSequence)invoiceNo)) {
            QFilter noFilter = new QFilter("invoice_no", "=", (Object)invoiceNo);
            idObject = QueryServiceHelper.queryOne((String)entityId, (String)"id", (QFilter[])new QFilter[]{tenantFilter, noFilter});
        } else if ("2".equals(otherMust) && !StringUtils.isEmpty((CharSequence)invoiceNo)) {
            String invoiceCode = invoiceJson.getString("invoiceCode");
            QFilter codeFilter = new QFilter("invoice_code", "=", (Object)invoiceCode);
            QFilter noFilter = new QFilter("invoice_no", "=", (Object)invoiceNo);
            idObject = QueryServiceHelper.queryOne((String)entityId, (String)"id", (QFilter[])new QFilter[]{tenantFilter, noFilter, codeFilter});
        }
        if (idObject != null) {
            invoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)entityId);
        } else {
            QFilter serialFilter;
            List idObjectList;
            String serialNo = invoiceJson.getString("serialNo");
            if (StringUtils.isNotEmpty((CharSequence)serialNo) && (idObjectList = QueryServiceHelper.queryPrimaryKeys((String)entityId, (QFilter[])new QFilter[]{serialFilter = new QFilter("serial_no", "=", (Object)serialNo)}, null, (int)1)) != null && !idObjectList.isEmpty()) {
                invoiceDynamicObject = BusinessDataServiceHelper.loadSingle(idObjectList.get(0), (String)entityId);
            }
            if (invoiceDynamicObject == null) {
                invoiceDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityId);
                invoiceDynamicObject.set("tenant_no", (Object)tenantNo);
                this.setSerialNo(invoiceJson, invoiceDynamicObject);
            }
        }
        return invoiceDynamicObject;
    }
}

