/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.save.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.TenantUtils;

public class OverseaReceiptSaveService
extends InvoiceSaveService {
    @Override
    public void setInvoiceFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        super.setInvoiceFieldValue(invoiceJson, dynamicObject);
        dynamicObject.set("invoice_title", (Object)invoiceJson.getString("invoiceTitle"));
        dynamicObject.set("saler_city", (Object)invoiceJson.getString("salerCity"));
        dynamicObject.set("saler_telephone", (Object)invoiceJson.getString("salerTelephone"));
        dynamicObject.set("saler_state", (Object)invoiceJson.getString("salerState"));
        dynamicObject.set("invoice_no", (Object)invoiceJson.getString("invoiceNo"));
        dynamicObject.set("total_amount", (Object)this.getObject(invoiceJson, "totalAmount", BigDecimal.class));
        dynamicObject.set("total_tax_amount", (Object)this.getObject(invoiceJson, "totalTaxAmount", BigDecimal.class));
        dynamicObject.set("invoice_amount", (Object)this.getObject(invoiceJson, "invoiceAmount", BigDecimal.class));
        dynamicObject.set("buyer_address", (Object)OverseaReceiptSaveService.subStringByLength(invoiceJson.getString("buyerAddress"), 300));
        dynamicObject.set("buyer_account", (Object)OverseaReceiptSaveService.subStringByLength(invoiceJson.getString("buyerAccount"), 250));
        dynamicObject.set("buyer_tax_no", (Object)invoiceJson.getString("buyerTaxNo"));
        dynamicObject.set("saler_address", (Object)OverseaReceiptSaveService.subStringByLength(invoiceJson.getString("salerAddress"), 300));
        dynamicObject.set("saler_account", (Object)OverseaReceiptSaveService.subStringByLength(invoiceJson.getString("salerAccount"), 250));
        dynamicObject.set("country", (Object)OverseaReceiptSaveService.subStringByLength(invoiceJson.getString("country"), 500));
        dynamicObject.set("purchase_order_number", (Object)invoiceJson.getString("purchaseOrderNumber"));
        dynamicObject.set("delivery_date", (Object)invoiceJson.getDate("deliveryDate"));
        dynamicObject.set("deliver_note_number", (Object)invoiceJson.getString("deliverNoteNumber"));
        dynamicObject.set("invoice_date", (Object)invoiceJson.getDate("invoiceDate"));
        dynamicObject.set("due_date", (Object)invoiceJson.getDate("dueDate"));
        dynamicObject.set("buyer_name", (Object)OverseaReceiptSaveService.subStringByLength(invoiceJson.getString("buyerName"), 150));
        dynamicObject.set("saler_name", (Object)OverseaReceiptSaveService.subStringByLength(invoiceJson.getString("salerName"), 150));
        dynamicObject.set("remark", (Object)invoiceJson.getString("remark"));
        dynamicObject.set("saler_tax_no", (Object)invoiceJson.getString("salerTaxNo"));
        dynamicObject.set("payment_type", (Object)invoiceJson.getString("paymentType"));
        dynamicObject.set("tax_type1", (Object)invoiceJson.getString("taxType1"));
        dynamicObject.set("tax_rate1", (Object)invoiceJson.getString("taxRate1"));
        dynamicObject.set("tax_amount1", (Object)invoiceJson.getString("taxAmount1"));
        dynamicObject.set("invoice_amount1", (Object)this.getObject(invoiceJson, "invoiceAmount1", BigDecimal.class));
        dynamicObject.set("tax_type2", (Object)invoiceJson.getString("taxType2"));
        dynamicObject.set("tax_rate2", (Object)invoiceJson.getString("taxRate2"));
        dynamicObject.set("tax_amount2", (Object)invoiceJson.getString("taxAmount2"));
        dynamicObject.set("invoice_amount2", (Object)this.getObject(invoiceJson, "invoiceAmount2", BigDecimal.class));
        dynamicObject.set("tax_type3", (Object)invoiceJson.getString("taxType3"));
        dynamicObject.set("tax_rate3", (Object)invoiceJson.getString("taxRate3"));
        dynamicObject.set("tax_amount3", (Object)invoiceJson.getString("taxAmount3"));
        dynamicObject.set("invoice_amount3", (Object)this.getObject(invoiceJson, "invoiceAmount3", BigDecimal.class));
        dynamicObject.set("tax_type4", (Object)invoiceJson.getString("taxType4"));
        dynamicObject.set("tax_rate4", (Object)invoiceJson.getString("taxRate4"));
        dynamicObject.set("tax_amount4", (Object)invoiceJson.getString("taxAmount4"));
        dynamicObject.set("invoice_amount4", (Object)this.getObject(invoiceJson, "invoiceAmount4", BigDecimal.class));
        dynamicObject.set("tax_type5", (Object)invoiceJson.getString("taxType5"));
        dynamicObject.set("tax_rate5", (Object)invoiceJson.getString("taxRate5"));
        dynamicObject.set("tax_amount5", (Object)invoiceJson.getString("taxAmount5"));
        dynamicObject.set("invoice_amount5", (Object)this.getObject(invoiceJson, "invoiceAmount5", BigDecimal.class));
        Long currencyId = BigDecimalUtil.transDecimal(invoiceJson.getString("currencyId")).longValue();
        if (currencyId > 0L) {
            dynamicObject.set("currencyid", (Object)currencyId);
            DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency");
            dynamicObject.set("currency_name", currency.get("name"));
        } else if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("currencyName"))) {
            QFilter filter = new QFilter("number", "=", (Object)invoiceJson.getString("currencyName")).or("name", "=", (Object)invoiceJson.getString("currencyName"));
            DynamicObject obj = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id,name", (QFilter[])new QFilter[]{filter});
            if (obj != null) {
                invoiceJson.put("currencyid", obj.get("id"));
                dynamicObject.set("currencyid", obj.get("id"));
                dynamicObject.set("currency_name", obj.get("name"));
            }
        }
        this.setInvoiceItemsValue(invoiceJson, dynamicObject);
    }

    @Override
    public void setMainFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        super.setMainFieldValue(invoiceJson, dynamicObject);
        dynamicObject.set("total_amount", (Object)this.getObject(invoiceJson, "totalAmount", BigDecimal.class));
        dynamicObject.set("total_tax_amount", (Object)this.getObject(invoiceJson, "totalTaxAmount", BigDecimal.class));
        dynamicObject.set("invoice_no", (Object)invoiceJson.getString("invoiceNo"));
        dynamicObject.set("invoice_code", (Object)"");
        dynamicObject.set("invoice_date", (Object)invoiceJson.getDate("invoiceDate"));
        dynamicObject.set("invoice_amount", (Object)this.getObject(invoiceJson, "invoiceAmount", BigDecimal.class));
        Long currencyId = BigDecimalUtil.transDecimal(invoiceJson.getString("currencyId")).longValue();
        if (currencyId > 0L) {
            dynamicObject.set("currencyid", (Object)currencyId);
        }
    }

    @Override
    public DynamicObject getInvoiceDynamicObject(JSONObject invoiceJson) {
        String entityId = InputInvoiceTypeEnum.getEntity(this.invoiceType);
        String tenantNo = TenantUtils.getTenantNo();
        String serialNo = invoiceJson.getString("serialNo");
        DynamicObject invoiceDynamicObject = null;
        if (StringUtils.isNotEmpty((CharSequence)serialNo)) {
            QFilter serialFilter = new QFilter("serial_no", "=", (Object)serialNo);
            List idObjectList = QueryServiceHelper.queryPrimaryKeys((String)entityId, (QFilter[])new QFilter[]{serialFilter}, null, (int)1);
            if (!idObjectList.isEmpty()) {
                invoiceDynamicObject = BusinessDataServiceHelper.loadSingle(idObjectList.get(0), (String)entityId);
            }
        }
        if (invoiceDynamicObject == null) {
            invoiceDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityId);
            invoiceDynamicObject.set("tenant_no", (Object)tenantNo);
            this.setSerialNo(invoiceJson, invoiceDynamicObject);
        }
        return invoiceDynamicObject;
    }

    @Override
    public void setInvoiceItemsValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        JSONArray items = invoiceJson.getJSONArray("items");
        if (items != null) {
            DynamicObjectCollection collection = (DynamicObjectCollection)dynamicObject.get("items");
            collection.clear();
            for (int i = 0; i < items.size(); ++i) {
                JSONObject itemJson = items.getJSONObject(i);
                DynamicObject itemObject = collection.addNew();
                itemObject.set("line", (Object)itemJson.getString("line"));
                itemObject.set("goods_name", (Object)itemJson.getString("goodsName"));
                itemObject.set("unit", (Object)itemJson.getString("unit"));
                itemObject.set("num", (Object)this.getObject(itemJson, "num", BigDecimal.class));
                itemObject.set("unit_price", (Object)this.getObject(itemJson, "unitPrice", BigDecimal.class));
                itemObject.set("net_price", (Object)this.getObject(itemJson, "netPrice", BigDecimal.class));
                itemObject.set("detail_amount", (Object)this.getObject(itemJson, "detailAmount", BigDecimal.class));
                itemObject.set("tax_rate", (Object)itemJson.getString("taxRate"));
                itemObject.set("tax_amount", (Object)this.getObject(itemJson, "taxAmount", BigDecimal.class));
            }
        }
    }

    @Override
    public String getLockKey(JSONObject invoiceJson) {
        return null;
    }

    @Override
    public String getBillNo(JSONObject invoiceJson) {
        String invoiceNo = invoiceJson.getString("invoiceNo");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)invoiceNo) && invoiceNo.length() > 20) {
            invoiceNo = invoiceNo.substring(0, 20);
        }
        return "30-" + invoiceNo;
    }
}

