/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.save.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;

public class SpecialSaveService
extends InvoiceSaveService {
    @Override
    public void setInvoiceFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        super.setInvoiceFieldValue(invoiceJson, dynamicObject);
        super.setSpecialTypeMark(dynamicObject, invoiceJson);
        dynamicObject.set("buyer_account", (Object)invoiceJson.getString("buyerAccount"));
        dynamicObject.set("buyer_address_phone", (Object)invoiceJson.getString("buyerAddressPhone"));
        dynamicObject.set("buyer_name", (Object)invoiceJson.getString("buyerName"));
        dynamicObject.set("buyer_tax_no", (Object)invoiceJson.getString("buyerTaxNo"));
        dynamicObject.set("check_code", (Object)invoiceJson.getString("checkCode"));
        dynamicObject.set("drawer", (Object)invoiceJson.getString("drawer"));
        dynamicObject.set("invalid_date", (Object)this.getObject(invoiceJson, "invalidDate", Date.class));
        if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("invoiceAmount"))) {
            dynamicObject.set("invoice_amount", (Object)this.getObject(invoiceJson, "invoiceAmount", BigDecimal.class));
        } else {
            dynamicObject.set("invoice_amount", (Object)this.getObject(invoiceJson, "invoiceMoney", BigDecimal.class));
        }
        dynamicObject.set("invoice_code", (Object)invoiceJson.getString("invoiceCode"));
        this.setInvoiceDate(invoiceJson.getDate("invoiceDate"), dynamicObject);
        dynamicObject.set("invoice_no", (Object)invoiceJson.getString("invoiceNo"));
        dynamicObject.set("invoice_status", (Object)invoiceJson.getString("invoiceStatus"));
        dynamicObject.set("machine_no", (Object)invoiceJson.getString("machineNo"));
        dynamicObject.set("original_invoice_code", (Object)invoiceJson.getString("originalInvoiceCode"));
        dynamicObject.set("original_invoice_no", (Object)invoiceJson.getString("originalInvoiceNo"));
        dynamicObject.set("payee", (Object)invoiceJson.getString("payee"));
        dynamicObject.set("proxy_mark", (Object)invoiceJson.getString("proxyMark"));
        dynamicObject.set("proxy_saler_name", (Object)invoiceJson.getString("proxySalerName"));
        dynamicObject.set("proxy_saler_tax_no", (Object)invoiceJson.getString("proxySalerTaxNo"));
        dynamicObject.set("remark", (Object)invoiceJson.getString("remark"));
        dynamicObject.set("reviewer", (Object)invoiceJson.getString("reviewer"));
        this.setSalerType(dynamicObject, invoiceJson);
        dynamicObject.set("saler_account", (Object)invoiceJson.getString("salerAccount"));
        dynamicObject.set("saler_address_phone", (Object)invoiceJson.getString("salerAddressPhone"));
        dynamicObject.set("saler_name", (Object)invoiceJson.getString("salerName"));
        dynamicObject.set("saler_tax_no", (Object)invoiceJson.getString("salerTaxNo"));
        dynamicObject.set("total_amount", (Object)invoiceJson.getString("totalAmount"));
        if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("totalTaxAmount"))) {
            dynamicObject.set("total_tax_amount", (Object)invoiceJson.getBigDecimal("totalTaxAmount"));
        } else {
            dynamicObject.set("total_tax_amount", (Object)invoiceJson.getBigDecimal("taxAmount"));
        }
        dynamicObject.set("type", (Object)invoiceJson.getString("type"));
        BigDecimal total = dynamicObject.getBigDecimal("total_amount");
        if (total != null && total.compareTo(BigDecimal.ZERO) >= 0) {
            dynamicObject.set("type", (Object)"0");
        } else {
            dynamicObject.set("type", (Object)"1");
        }
        this.setInvoiceItemsValue(invoiceJson, dynamicObject);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dynamicObject.getString("tax_recorded_status"))) {
            dynamicObject.set("tax_recorded_status", (Object)"01");
        }
    }

    @Override
    public void setInvoiceItemsValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        JSONArray items = invoiceJson.getJSONArray("items");
        if (items != null) {
            DynamicObjectCollection collection = (DynamicObjectCollection)dynamicObject.get("items");
            Map<String, String> nameMap = this.getGoodsCodeMap(collection);
            collection.clear();
            for (int i = 0; i < items.size(); ++i) {
                JSONObject itemJson = items.getJSONObject(i);
                boolean ignoreFlag = SpecialSaveService.ignoreGoodsName(itemJson.getString("goodsName"), this.getObject(itemJson, "num", BigDecimal.class), itemJson.getString("unit"), this.getObject(itemJson, "unitPrice", BigDecimal.class));
                if (ignoreFlag && items.size() > 1) continue;
                if (i == 0) {
                    dynamicObject.set("main_goods_name", (Object)itemJson.getString("goodsName"));
                }
                DynamicObject itemObject = collection.addNew();
                itemObject.set("detail_amount", (Object)this.getObject(itemJson, "detailAmount", BigDecimal.class));
                itemObject.set("seq", (Object)i);
                itemObject.set("discount_type", (Object)itemJson.getString("discountType"));
                this.setGoodsCode(itemObject, nameMap, itemJson);
                itemObject.set("goods_name", (Object)itemJson.getString("goodsName"));
                itemObject.set("num", (Object)this.getObject(itemJson, "num", BigDecimal.class));
                itemObject.set("preferential_policy", (Object)itemJson.getString("preferentialPolicy"));
                itemObject.set("spec_model", (Object)itemJson.getString("specModel"));
                itemObject.set("tax_amount", (Object)this.getObject(itemJson, "taxAmount", BigDecimal.class));
                itemObject.set("tax_rate", (Object)this.getObject(itemJson, "taxRate", BigDecimal.class));
                itemObject.set("unit", (Object)itemJson.getString("unit"));
                itemObject.set("unit_price", (Object)this.getObject(itemJson, "unitPrice", BigDecimal.class));
                itemObject.set("zerotaxrate_flag", (Object)itemJson.getString("zeroTaxRateFlag"));
                itemObject.set("version_no", (Object)itemJson.getString("versionNo"));
            }
        }
    }

    @Override
    public void setMainFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        super.setMainFieldValue(invoiceJson, dynamicObject);
        JSONArray items = invoiceJson.getJSONArray("items");
        if (!CollectionUtils.isEmpty((Collection)items)) {
            JSONObject itemJson = items.getJSONObject(0);
            dynamicObject.set("main_goods_name", (Object)itemJson.getString("goodsName"));
        }
        dynamicObject.set("remark", (Object)invoiceJson.getString("remark"));
    }
}

