/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.save.impl;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.utils.TenantUtils;

public class TrainRefundSaveService
extends InvoiceSaveService {
    @Override
    public void setInvoiceFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        super.setInvoiceFieldValue(invoiceJson, dynamicObject);
        dynamicObject.set("invoice_date", (Object)invoiceJson.getDate("invoiceDate"));
        dynamicObject.set("number", (Object)invoiceJson.getString("number"));
        dynamicObject.set("total_amount", (Object)invoiceJson.getBigDecimal("totalAmount"));
        dynamicObject.set("voucher_title", (Object)invoiceJson.getString("voucherTitle"));
    }

    @Override
    public void setMainFieldValue(JSONObject invoiceJson, DynamicObject dynamicObject) {
        super.setMainFieldValue(invoiceJson, dynamicObject);
        dynamicObject.set("invoice_no", (Object)invoiceJson.getString("number"));
    }

    @Override
    public DynamicObject getInvoiceDynamicObject(JSONObject invoiceJson) {
        String entityId = InputInvoiceTypeEnum.getEntity(this.invoiceType);
        String tenantNo = TenantUtils.getTenantNo();
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        QFilter invoiceCodeFilter = new QFilter("number", "=", (Object)invoiceJson.getString("number"));
        DynamicObject idObject = QueryServiceHelper.queryOne((String)entityId, (String)"id", (QFilter[])new QFilter[]{tenantFilter, invoiceCodeFilter});
        DynamicObject invoiceDynamicObject = null;
        if (null == idObject) {
            invoiceDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityId);
            invoiceDynamicObject.set("tenant_no", (Object)tenantNo);
            this.setSerialNo(invoiceJson, invoiceDynamicObject);
        } else {
            invoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)entityId);
        }
        return invoiceDynamicObject;
    }

    @Override
    public String getLockKey(JSONObject invoiceJson) {
        return this.invoiceType + invoiceJson.getString("number");
    }

    @Override
    public String getBillNo(JSONObject invoiceJson) {
        return invoiceJson.getString("number");
    }
}

