/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.sign;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.expense.domain.ExpenseDTO;
import kd.imc.rim.common.expense.service.ExpenseService;
import kd.imc.rim.common.invoice.fpzs.FpzsService;
import kd.imc.rim.common.invoice.query.InvoiceQueryService;
import kd.imc.rim.common.utils.FileUploadUtils;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;
import kd.imc.rim.file.utils.FileConvertUtils;
import org.apache.commons.lang3.StringUtils;

public class InvoiceSignService {
    private static final Log LOGGER = LogFactory.getLog(InvoiceSignService.class);
    private static final String BILL_SIGN_THREAD_POOL_NAME = "InvoiceSignService_THREAD_POOL_NAME";
    private static final ExecutorService executorService = ThreadPools.newCachedExecutorService((String)"InvoiceSignService_THREAD_POOL_NAME", (int)1, (int)4);

    public Map<String, Object> updateSignStatus(JSONObject jsonObj) {
        String billId = jsonObj.getString("billId");
        String resource = jsonObj.getString("resource");
        String billType = jsonObj.getString("billType");
        String bizSysCode = jsonObj.getString("bussinSysCode");
        String signType = jsonObj.getString("signType");
        boolean isSign = StringUtils.equals((CharSequence)signType, (CharSequence)"01");
        JSONArray invoiceData = jsonObj.getJSONArray("invoiceData");
        Set inputSerialNos = invoiceData.toJavaList(JSONObject.class).stream().map(e -> e.getString("serialNo")).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        FpzsService fpzsService = new FpzsService();
        Set<Object> serialNosToProcess = new HashSet(0);
        Set<Object> serialNosBind = new HashSet(0);
        Set<Object> serialNosNotInDb = new HashSet(0);
        HashMap<String, String> invoiceMapWithTypeCodeAndNo = new HashMap<String, String>(0);
        if (StringUtils.isNotBlank((CharSequence)billId)) {
            List<String> bindSerialNos = this.queryInvoiceSerialNos(billId, resource, bizSysCode, billType);
            Map<String, DynamicObject> invoiceMap = this.queryInvoiceData(bindSerialNos);
            serialNosBind = invoiceMap.keySet();
            LOGGER.info("serialNosBind: {}", serialNosBind);
        }
        if (!CollectionUtils.isEmpty(inputSerialNos)) {
            if (StringUtils.isBlank((CharSequence)billId)) {
                Map<String, DynamicObject> invoiceMap = this.queryInvoiceData(new ArrayList<String>(inputSerialNos));
                HashSet<String> serialNos = new HashSet<String>(invoiceMap.keySet());
                serialNosToProcess = serialNos;
                serialNosNotInDb = inputSerialNos.stream().filter(e -> !serialNos.contains(e)).collect(Collectors.toSet());
            } else {
                HashSet temp = serialNosBind;
                serialNosToProcess = inputSerialNos.stream().filter(e -> temp.contains(e)).collect(Collectors.toSet());
            }
        } else {
            String invoiceType = invoiceData.getJSONObject(0).getString("invoiceType");
            if (invoiceType == null || invoiceType.length() == 0) {
                return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), "invoiceType param invalid");
            }
            JSONArray eleArray = new JSONArray();
            JSONArray vatArray = new JSONArray();
            for (int i = 0; i < invoiceData.size(); ++i) {
                JSONObject invoice = invoiceData.getJSONObject(i);
                String type = invoice.getString("invoiceType");
                Long typeId = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(type);
                if (InputInvoiceTypeEnum.isEleInvoice(typeId).booleanValue()) {
                    eleArray.add((Object)invoice);
                    continue;
                }
                if (!InputInvoiceTypeEnum.isVatType(typeId)) continue;
                vatArray.add((Object)invoice);
            }
            if (eleArray.size() > 0) {
                invoiceMapWithTypeCodeAndNo.putAll(InvoiceQueryService.querySerialNoByTypeCodeAndNo(eleArray, true));
            }
            if (vatArray.size() > 0) {
                invoiceMapWithTypeCodeAndNo.putAll(InvoiceQueryService.querySerialNoByTypeCodeAndNo(vatArray, false));
            }
            Set serialNosDb = invoiceMapWithTypeCodeAndNo.values().stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            if (StringUtils.isBlank((CharSequence)billId)) {
                serialNosToProcess = serialNosDb;
            } else {
                Set<Object> temp = serialNosBind;
                serialNosToProcess = serialNosDb.stream().filter(e -> temp.contains(e)).collect(Collectors.toSet());
            }
        }
        HashMap<String, JSONObject> fileMap = new HashMap<String, JSONObject>(0);
        HashSet<String> failSet = new HashSet<String>(0);
        for (int i = 0; i < invoiceData.size(); ++i) {
            JSONObject invoice = invoiceData.getJSONObject(i);
            String serialNo = invoice.getString("serialNo");
            if (StringUtils.isEmpty((CharSequence)serialNo) && invoiceMapWithTypeCodeAndNo.size() > 0) {
                String k1 = invoice.getString("invoiceType") + '-' + invoice.getString("invoiceNo");
                String k2 = k1 + '-' + invoice.getString("invoiceCode");
                serialNo = invoiceMapWithTypeCodeAndNo.getOrDefault(k1, invoiceMapWithTypeCodeAndNo.getOrDefault(k2, ""));
            }
            invoice.put("serialNo", (Object)serialNo);
            String fileDownUrl = invoice.getString("fileDownUrl");
            String fileType = invoice.getString("fileType");
            if (!isSign || !serialNosToProcess.contains(serialNo) || !StringUtils.isNotBlank((CharSequence)fileDownUrl)) continue;
            if (StringUtils.isNotBlank((CharSequence)fileType)) {
                JSONObject fileInfo = new JSONObject();
                fileInfo.put("fileDownUrl", (Object)fileDownUrl);
                fileInfo.put("fileType", (Object)fileType);
                fileMap.put(serialNo, fileInfo);
                continue;
            }
            failSet.add(serialNo);
            LOGGER.info("Param fileType is empty");
        }
        failSet.addAll(this.handleFileReplace(fileMap));
        serialNosToProcess = serialNosToProcess.stream().filter(e -> !failSet.contains(e)).collect(Collectors.toSet());
        ArrayList<String> list = new ArrayList<String>(serialNosToProcess);
        LOGGER.info("failSet: {}, serialNosToProcess: {}", failSet, serialNosToProcess);
        Object result = !CollectionUtils.isEmpty(serialNosToProcess) ? (isSign ? fpzsService.signInvoice(list) : fpzsService.unSignInvoice(list)) : ResultContant.createSuccessJSONObject();
        boolean isSuccess = ResultContant.isSuccess(result);
        if (isSuccess) {
            for (int i = 0; i < invoiceData.size(); ++i) {
                JSONObject invoice = invoiceData.getJSONObject(i);
                String serialNo = invoice.getString("serialNo");
                invoice.put("signStatus", (Object)"1");
                if (StringUtils.isNotBlank((CharSequence)billId) && !serialNosBind.contains(serialNo)) {
                    invoice.put("signStatus", (Object)"0");
                    invoice.put("message", (Object)ResManager.loadKDString((String)"\u53d1\u7968\u4e0d\u5728\u5355\u636e\u4e0b\u3002", (String)"BillSignService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                }
                if (serialNosNotInDb.contains(serialNo) || StringUtils.isEmpty((CharSequence)serialNo)) {
                    invoice.put("signStatus", (Object)"0");
                    invoice.put("message", (Object)ResManager.loadKDString((String)"\u53d1\u7968\u4e0d\u5728\u5e93\u4e2d\u3002", (String)"BillSignService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                }
                if (!failSet.contains(serialNo)) continue;
                invoice.put("signStatus", (Object)"0");
                invoice.put("message", (Object)ResManager.loadKDString((String)"\u6587\u4ef6\u66f4\u65b0\u5931\u8d25\u3002", (String)"BillSignService_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
            JSONObject response = new JSONObject();
            response.put("invoiceData", (Object)invoiceData);
            if (StringUtils.isNotBlank((CharSequence)billId)) {
                response.put("billId", (Object)billId);
                String billSignStatus = isSign && serialNosBind.size() > 0 && serialNosBind.size() == serialNosToProcess.size() ? "14" : "13";
                response.put("bussinSysBillStatus", (Object)billSignStatus);
            }
            return ResultContant.createSuccessJSONObject(response);
        }
        return result;
    }

    private Set<String> handleFileReplace(Map<String, JSONObject> fileMap) {
        RequestContext ctx = RequestContext.get();
        List futures = fileMap.entrySet().stream().map(entry -> CompletableFuture.supplyAsync(() -> {
            String filePath;
            RequestContext.copyAndSet((RequestContext)ctx);
            String serialNo = (String)entry.getKey();
            JSONObject filePram = (JSONObject)entry.getValue();
            String downloadUrl = filePram.getString("fileDownUrl");
            JSONObject fileInfo = FileUtils.downLoadAndUploadWithFileType(downloadUrl, null);
            String fileType = filePram.getString("fileType");
            String newType = fileInfo.getString("file_type");
            if (StringUtils.isBlank((CharSequence)fileType) && StringUtils.isNotBlank((CharSequence)newType)) {
                fileType = "ofd".equals(newType) ? "4" : ("pdf".equals(newType) ? "1" : ("xml".equals(newType) ? "9" : "2"));
            }
            if (StringUtils.isEmpty((CharSequence)(filePath = fileInfo.getString("file_url")))) {
                LOGGER.info("\u9500\u9879\u53d1\u7968\u6587\u4ef6\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25{}-{}", (Object)serialNo, (Object)filePath);
            } else {
                byte[] fileContent = this.getContent(filePath);
                if (StringUtils.isEmpty((CharSequence)fileType)) {
                    fileType = FileUtils.getFileType(filePath);
                }
                String path = FileUploadUtils.getSnapshotPathByUploadUrl(downloadUrl);
                LOGGER.info("handleFileReplace>>> fileType: {}, path: {}", (Object)fileType, (Object)path);
                try {
                    String ofdUrl = "";
                    String imageUrl = "";
                    String pdfUrl = "";
                    String xmlUrl = "";
                    if ("1".equalsIgnoreCase(fileType)) {
                        imageUrl = FileConvertUtils.pdf2imageAndUpload((byte[])fileContent, (String)(serialNo + ".jpg"), (String)(path + ".jpg"));
                        pdfUrl = filePath;
                    } else if ("4".equalsIgnoreCase(fileType)) {
                        imageUrl = FileConvertUtils.ofd2image((byte[])fileContent, (int)0, (String)(serialNo + ".jpg"), (String)(path + ".jpg"));
                        pdfUrl = FileConvertUtils.ofd2pdf((byte[])fileContent, (String)(serialNo + ".pdf"), (String)(path + ".pdf"));
                        ofdUrl = filePath;
                    } else if ("2".equals(fileType)) {
                        imageUrl = filePath;
                    } else if ("9".equals(fileType)) {
                        xmlUrl = filePath;
                    }
                    LOGGER.info("handleFileReplace>>> ofdUrl: {}, imageUrl: {}, pdfUrl: {}", new Object[]{ofdUrl, imageUrl, pdfUrl});
                    String tenantNo = TenantUtils.getTenantNo();
                    QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
                    QFilter serialFilter = new QFilter("serial_no", "=", (Object)serialNo);
                    DynamicObject fileDynamicObject = QueryServiceHelper.queryOne((String)"rim_invoice_file", (String)"id", (QFilter[])new QFilter[]{tenantFilter, serialFilter});
                    if (fileDynamicObject != null) {
                        fileDynamicObject = BusinessDataServiceHelper.loadSingle((Object)fileDynamicObject.get("id"), (String)"rim_invoice_file");
                        fileDynamicObject.set("update_time", (Object)new Date());
                        fileDynamicObject.set("original_type", (Object)fileType);
                        this.setValueIfNotBlank(fileDynamicObject, "pdf_url", pdfUrl);
                        this.setValueIfNotBlank(fileDynamicObject, "ofd_url", ofdUrl);
                        this.setValueIfNotBlank(fileDynamicObject, "xml_url", xmlUrl);
                        this.setValueIfNotBlank(fileDynamicObject, "snapshot_url", imageUrl);
                        this.setValueIfNotBlank(fileDynamicObject, "image_url", imageUrl);
                        try {
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fileDynamicObject});
                            return serialNo;
                        }
                        catch (Throwable e) {
                            LOGGER.error("\u4fdd\u5b58\u53d1\u7968\u6587\u4ef6\u62a5\u9519", e);
                        }
                    }
                }
                catch (Throwable t) {
                    LOGGER.info("handleFileReplace>>> Throwable: {}", (Object)t);
                }
            }
            return null;
        }, executorService)).collect(Collectors.toList());
        HashSet<String> failedList = new HashSet<String>(fileMap.keySet());
        for (CompletableFuture future : futures) {
            try {
                String serialNo = (String)future.join();
                failedList.remove(serialNo);
            }
            catch (CompletionException e) {
                LOGGER.error("handleFileReplace>>> future join error:", (Throwable)e);
            }
        }
        return failedList;
    }

    private void setValueIfNotBlank(DynamicObject dynamicObject, String property, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            dynamicObject.set(property, (Object)value);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getContent(String filePath) {
        try (InputStream fileInputStream = UrlServiceUtils.getAttachmentDecodedStream(FileServiceFactory.getAttachmentFileService().getInputStream(filePath));){
            byte[] fileContent;
            byte[] byArray = fileContent = FileUtils.getByte(fileInputStream);
            return byArray;
        }
        catch (IOException e) {
            LOGGER.info("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25{}", (Object)filePath);
            return null;
        }
    }

    private List<String> queryInvoiceSerialNos(String expenseId, String resource, String bussinSysCode, String entityId) {
        DynamicObjectCollection serialCollection = new DynamicObjectCollection();
        if (StringUtils.isNotEmpty((CharSequence)expenseId)) {
            resource = StringUtils.isNotBlank((CharSequence)bussinSysCode) ? bussinSysCode : resource;
            ExpenseService expenseService = new ExpenseService();
            ExpenseDTO expenseDTO = new ExpenseDTO();
            expenseDTO.setExpenseId(expenseId);
            expenseDTO.setEntityId(entityId);
            expenseDTO.setResource(resource);
            QFilter idFilter = expenseService.getExpenseRelationQFilter(expenseDTO, "expense_id", "entityid", "resource");
            serialCollection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"serial_no", (QFilter[])new QFilter[]{idFilter});
            QFilter historyDataFilter = null;
            QFilter entityIdFilter = null;
            QFilter resourceFilter = null;
            if (StringUtils.isNotEmpty((CharSequence)resource)) {
                resourceFilter = new QFilter("resource", "=", (Object)resource);
            }
            if (StringUtils.isNotEmpty((CharSequence)entityId)) {
                entityIdFilter = new QFilter("entityid", "=", (Object)entityId);
                if (!expenseId.startsWith(entityId)) {
                    historyDataFilter = new QFilter("expense_id", "=", (Object)(entityId + '_' + expenseId));
                }
            }
            if (CollectionUtils.isEmpty((Collection)serialCollection) && historyDataFilter != null) {
                serialCollection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"serial_no,create_time", (QFilter[])new QFilter[]{historyDataFilter, resourceFilter, entityIdFilter});
            }
        }
        return serialCollection.stream().map(e -> e.getString("serial_no")).collect(Collectors.toList());
    }

    private Map<String, DynamicObject> queryInvoiceData(List<String> serialNos) {
        String tenantNo = TenantUtils.getTenantNo();
        DynamicObject[] data = InvoiceQueryService.loadBySerialNo("rim_invoice", tenantNo, serialNos);
        if (data == null) {
            return new HashMap<String, DynamicObject>(0);
        }
        return Arrays.stream(data).collect(Collectors.toMap(e -> e.getString("serial_no"), e -> e));
    }
}

