/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.verify;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.ek.EkServiceFactory;
import kd.imc.rim.common.ek.service.InvoiceSaveEkService;
import kd.imc.rim.common.invoice.query.InvoiceQueryService;
import kd.imc.rim.common.invoice.query.convert.InvoiceConvertService;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.invoice.verify.VerifyService;
import kd.imc.rim.common.invoice.verify.dto.VerifyItem;
import kd.imc.rim.common.invoice.verify.dto.VerifyQFilter;
import kd.imc.rim.common.invoice.verify.dto.VerifyResultDto;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.CurrencyUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.sdk.annotation.SdkDeprecated;
import org.apache.commons.compress.utils.Lists;

public class VerifyUtil {
    private static Log logger = LogFactory.getLog(VerifyUtil.class);
    public static final Pattern ANY_POSITION = Pattern.compile(".*(\u516c\u53f8|\u4e2d\u5fc3|\u5730\u8d28\u5c40|\u4e8b\u52a1\u6240|\u534f\u4f1a|\u6709\u9650\u5408\u4f19|\u533b\u9662|\u516c\u5b89\u5c40|\u96c6\u56e2|\u8d85\u5e02|\u5382\uff08|\u5382\\(|\u4f01\u4e1a\uff08|\u4f01\u4e1a\\(|\uff08\u6709\u9650|\\(\u6709\u9650).*");
    public static final Pattern END_WITH = Pattern.compile(".*(\u6d77\u9c9c\u57ce|\u5bbe\u9986|\u673a\u573a|\u7ecf\u9500\u5904|\u652f\u961f|\u5c0f\u5b66|\u4e2d\u5b66|\u5927\u5b66|\u4ee3\u7406|\u7ec4\u7ec7|\u673a\u5173|\u5e7c\u513f\u56ed|\u529e\u4e8b\u5904|\u5b66\u6821|\u529e\u516c\u5ba4|\u5bb6\u5177\u57ce|\u517b\u6b96\u573a|\u5546\u573a|\u897f\u997c\u5c4b|\u836f\u623f|\u5de5\u4f5c\u5ba4|\u7403\u9986|\u516c\u56ed|\u519b\u4e8b\u4ee3\u8868\u5ba4|\u90e8\u961f|\u6d77\u5173|\u9910\u5385|\u9762\u9986|\u5305\u5b50\u94fa|\u8bd5\u9a8c\u5ba4|\u62a5\u793e)$");
    public static final Pattern END_WITH_LESS_5 = Pattern.compile(".*(\u5382|\u5e97|\u90e8|\u5c40|\u4f1a|\u6240|\u9662|\u884c|\u7ad9|\u793e)$");
    private static final Pattern PHONE_PATTERN = Pattern.compile("^1([358][0-9]|4[579]|66|7[0135678]|9[89])[0-9]{8}$");
    private static final Pattern IDENTITY_NO_PATTERN = Pattern.compile("(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}[0-9Xx]$)");

    public static JSONArray verifyByMainIds(Map<String, Object> param, List<Long> idList, List<Long> uncheckIdList, boolean convertFlag) {
        List<Map<String, DynamicObject>> dataList = VerifyUtil.queryInvoiceDynamicObjectByMainIds(idList, uncheckIdList);
        return VerifyUtil.verify(param, dataList, convertFlag);
    }

    public static JSONArray verifyByMainIds(Map<String, Object> param, List<Long> idList, boolean convertFlag) {
        List<Map<String, DynamicObject>> dataList = VerifyUtil.queryInvoiceDynamicObjectByMainIds(idList);
        return VerifyUtil.verify(param, dataList, convertFlag);
    }

    public static JSONArray verifyBySerialNos(Map<String, Object> param, List<String> serialList, boolean convertFlag) {
        List<Map<String, DynamicObject>> dataList = VerifyUtil.queryInvoiceDynamicObjectBySerialNos(serialList);
        JSONArray result = VerifyUtil.verify(param, dataList, convertFlag);
        return VerifyService.verifySequenceNo(param, result);
    }

    private static JSONArray verify(Map<String, Object> param, List<Map<String, DynamicObject>> dataList, boolean convertFlag) {
        JSONArray resultArray = new JSONArray();
        if (dataList == null || dataList.isEmpty()) {
            return resultArray;
        }
        JSONObject config = VerifyService.getVerfifyConfig(param);
        String resource = String.valueOf(param.get("resource"));
        Map<String, Map<String, Object>> expenseInfoMap = VerifyUtil.queryExpenseInfo(param, dataList);
        if (param.get("buyer_name") instanceof JSONArray) {
            param.put("originalBuyerName", (JSONArray)((JSONArray)param.get("buyer_name")).clone());
        }
        if (param.get("buyer_name") instanceof List) {
            param.put("originalBuyerName", new JSONArray(new ArrayList((List)param.get("buyer_name"))));
        }
        for (Map<String, DynamicObject> map : dataList) {
            Long invoiceType;
            DynamicObject mainObj = map.get("main");
            String serialNo = mainObj.getString("serial_no");
            try {
                DynamicObject invoiceTypeObj = mainObj.getDynamicObject("invoice_type");
                invoiceType = invoiceTypeObj.getLong("id");
            }
            catch (Exception e2) {
                invoiceType = mainObj.getLong("invoice_type");
            }
            Map<String, Object> mainMap = DynamicObjectUtil.dynamicObjectToMap(mainObj);
            Map<String, Object> fileMap = DynamicObjectUtil.dynamicObjectToMap(map.get("file"));
            Map<String, Object> bodyMap = DynamicObjectUtil.dynamicObjectToMap(map.get("detail"));
            Map<String, Object> xbrlMap = DynamicObjectUtil.dynamicObjectToMap(map.get("xbrl"));
            InvoiceConvertService.putAll(mainMap, fileMap);
            InvoiceConvertService.putAll(mainMap, bodyMap);
            InvoiceConvertService.putAll(mainMap, xbrlMap);
            InvoiceConvertService.updateAirInvocieAmount(invoiceType, mainMap, bodyMap);
            mainMap.put("personFlag", VerifyUtil.isPersonInvoice(mainMap));
            mainMap.put("tax_blacklist", VerifyUtil.isTaxBlackListInvoice(mainMap));
            mainMap.put("id", mainObj.getLong("id"));
            List<VerifyItem> list = VerifyService.getVerifyItem(config, param, mainMap);
            JSONObject result = null;
            if (convertFlag) {
                InvoiceConvertService convertService = InvoiceConvertService.newInstance(invoiceType, resource);
                result = convertService.convert(mainMap);
                result.put("mainId", (Object)mainObj.getLong("id"));
            } else {
                result = new JSONObject();
                result.putAll(mainMap);
            }
            Map<String, Object> expenseInfo = expenseInfoMap.get(serialNo);
            mainMap.put("availableAmount", expenseInfo.get("availableAmount"));
            mainMap.put("expenseBillList", expenseInfo.get("expenseBillList"));
            result.put("availableAmount", (Object)DynamicObjectUtil.fieldToString(expenseInfo.get("availableAmount")));
            ArrayList<VerifyResultDto> resultList = new ArrayList<VerifyResultDto>(8);
            String level = "3";
            for (VerifyItem item : list) {
                VerifyResultDto dto;
                if ("custom_config".equals(item.getConfigType())) {
                    List<VerifyQFilter> filterList = item.getFilterList();
                    List collect = filterList.stream().filter(f -> !"invoice_type".equals(f.getProperty())).filter(e -> !StringUtils.isEmpty((CharSequence)e.getProperty())).collect(Collectors.toList());
                    if (collect.isEmpty()) continue;
                    item.setFilterList(filterList);
                }
                if ((dto = VerifyService.compare(item, param, mainMap)) == null) continue;
                resultList.add(dto);
                if (Integer.parseInt(dto.getConfig()) >= Integer.parseInt(level)) continue;
                level = dto.getConfig();
            }
            result.put("errorLevel", (Object)level);
            result.put("validateMessage", (Object)VerifyService.getResultMsg(resultList));
            result.put("verifyResult", resultList);
            result.put("validateMessage_html", (Object)VerifyService.getResultMsgHtml(resultList));
            result.put("invoice_info", mainMap.get("invoice_info"));
            resultArray.add((Object)result);
        }
        return resultArray;
    }

    private static Map<String, Map<String, Object>> queryExpenseInfo(Map<String, Object> param, List<Map<String, DynamicObject>> dataList) {
        ArrayList<String> serialNoList = new ArrayList<String>(dataList.size());
        HashMap<String, BigDecimal> invoiceTotalMap = new HashMap<String, BigDecimal>(dataList.size());
        dataList.forEach(map -> {
            DynamicObject mainObj = (DynamicObject)map.get("main");
            serialNoList.add(mainObj.getString("serial_no"));
            invoiceTotalMap.put(mainObj.getString("serial_no"), mainObj.getBigDecimal("total_amount"));
            Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(mainObj.get("invoice_type"));
            if (InputInvoiceTypeEnum.containCurrencyId(invoiceType)) {
                Object currencyIdObj = null;
                try {
                    currencyIdObj = mainObj.get("currencyid");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                long currencyId = DynamicObjectUtil.getDynamicObjectLongValue(currencyIdObj);
                int precision = CurrencyUtils.getAmtPrecision(currencyId);
                String format = CurrencyUtils.getFormatByPrecision(precision);
                String totalAmountStr = DynamicObjectUtil.fieldToString(mainObj.getBigDecimal("total_amount"), format);
                invoiceTotalMap.put(mainObj.getString("serial_no"), BigDecimalUtil.transDecimal(totalAmountStr));
            }
        });
        return VerifyService.queryExpenseInfo(serialNoList, invoiceTotalMap, param);
    }

    public static List<Map<String, DynamicObject>> queryInvoiceDynamicObjectBySerialNos(List<String> idList, boolean fileCache) {
        QFilter serialFilter = new QFilter("serial_no", "in", idList);
        String mainFields = MetadataUtil.getFields("rim_invoice");
        DynamicObject[] mainCollection = BusinessDataServiceHelper.load((String)"rim_invoice", (String)mainFields, (QFilter[])new QFilter[]{serialFilter});
        List<Map<String, DynamicObject>> invoiceList = VerifyUtil.queryDetail(idList, serialFilter, mainCollection, fileCache);
        return invoiceList;
    }

    @SdkDeprecated
    public static List<Map<String, DynamicObject>> queryInvoiceDynamicObjectBySerialNos(List<String> idList) {
        return VerifyUtil.queryInvoiceDynamicObjectBySerialNos(idList, true);
    }

    public static Map<String, Object> noVerify(List<Long> mainIdList, List<Long> uncheckIdList, String resource) {
        List<Map<String, DynamicObject>> list = VerifyUtil.queryInvoiceDynamicObjectByMainIds(mainIdList, uncheckIdList);
        logger.info("openservice noVerify list:{}", list);
        JSONArray data = new JSONArray();
        for (Map<String, DynamicObject> map : list) {
            Long invoiceType;
            DynamicObject mainObj = map.get("main");
            try {
                DynamicObject invoiceTypeObj = mainObj.getDynamicObject("invoice_type");
                invoiceType = invoiceTypeObj.getLong("id");
            }
            catch (Exception e) {
                invoiceType = mainObj.getLong("invoice_type");
            }
            InvoiceConvertService convertService = InvoiceConvertService.newInstance(invoiceType);
            convertService.setResource(resource);
            Map<String, Object> mainMap = DynamicObjectUtil.dynamicObjectToMap(mainObj);
            Map<String, Object> fileMap = DynamicObjectUtil.dynamicObjectToMap(map.get("file"));
            Map<String, Object> bodyMap = DynamicObjectUtil.dynamicObjectToMap(map.get("detail"));
            Map<String, Object> xbrlMap = DynamicObjectUtil.dynamicObjectToMap(map.get("xbrl"));
            InvoiceConvertService.putAll(mainMap, fileMap);
            InvoiceConvertService.putAll(mainMap, bodyMap);
            InvoiceConvertService.putAll(mainMap, xbrlMap);
            JSONObject json = convertService.convert(mainMap);
            data.add((Object)json);
        }
        JSONObject result = ResultContant.createSuccessJSONObject();
        result.put("data", data);
        return result;
    }

    public static Map<String, DynamicObject> queryInvoiceDynamicObjectBySerialNo(String serialNo) {
        QFilter serialFilter = new QFilter("serial_no", "=", (Object)serialNo);
        String mainFields = MetadataUtil.getFields("rim_invoice");
        DynamicObject mainInvoice = QueryServiceHelper.queryOne((String)"rim_invoice", (String)mainFields, (QFilter[])new QFilter[]{serialFilter});
        HashMap<String, DynamicObject> mainDetailMap = new HashMap<String, DynamicObject>(2);
        if (mainInvoice == null) {
            return mainDetailMap;
        }
        Long invoiceType = mainInvoice.getLong("invoice_type");
        String entity = InputInvoiceTypeEnum.getEntity(invoiceType);
        String tenantNo = TenantUtils.getTenantNo();
        DynamicObject[] detail = InvoiceQueryService.loadBySerialNo(entity, tenantNo, new String[]{serialNo});
        DynamicObject detailInvoice = null;
        if (detail != null && detail.length > 0) {
            detailInvoice = detail[0];
        }
        mainDetailMap.put("main", mainInvoice);
        mainDetailMap.put("detail", detailInvoice);
        DynamicObjectCollection fileCollection = QueryServiceHelper.query((String)"rim_invoice_file", (String)"serial_no,file_hash,original_type,original_filename,pdf_url,ofd_url,image_url,snapshot_url,icon_url,rotation_angle,region,pixel", (QFilter[])new QFilter[]{serialFilter});
        if (!CollectionUtils.isEmpty((Collection)fileCollection)) {
            mainDetailMap.put("file", (DynamicObject)fileCollection.get(0));
        }
        return mainDetailMap;
    }

    public static List<Map<String, DynamicObject>> queryInvoiceDynamicObjectByMainIds(List<Long> idList, List<Long> uncheckIdList) {
        DynamicObject[] mainCollection;
        QFilter idFilter;
        List<Map<String, DynamicObject>> invoiceList = null;
        if (!CollectionUtils.isEmpty(idList)) {
            idFilter = new QFilter("id", "in", idList);
            String mainFields = MetadataUtil.getFields("rim_invoice");
            mainCollection = BusinessDataServiceHelper.load((String)"rim_invoice", (String)mainFields, (QFilter[])new QFilter[]{idFilter});
            List<String> serialNoList = Arrays.asList(mainCollection).stream().map(s -> s.getString("serial_no")).collect(Collectors.toList());
            QFilter serialFilter = new QFilter("serial_no", "in", serialNoList);
            invoiceList = VerifyUtil.queryDetail(serialNoList, serialFilter, mainCollection, true);
        }
        if (!CollectionUtils.isEmpty(uncheckIdList)) {
            idFilter = new QFilter("id", "in", uncheckIdList);
            String uncheckMainFields = MetadataUtil.getFields("rim_invoice_uncheck");
            mainCollection = BusinessDataServiceHelper.load((String)"rim_invoice_uncheck", (String)uncheckMainFields, (QFilter[])new QFilter[]{idFilter});
            List<Map<String, DynamicObject>> uncheckinvoiceList = VerifyUtil.queryUncheckDetail(mainCollection);
            if (invoiceList == null) {
                return uncheckinvoiceList;
            }
            invoiceList.addAll(uncheckinvoiceList);
        }
        return invoiceList;
    }

    private static List<Map<String, DynamicObject>> queryUncheckDetail(DynamicObject[] mainCollection) {
        ArrayList<Map<String, DynamicObject>> invoiceList = new ArrayList<Map<String, DynamicObject>>(mainCollection.length);
        for (DynamicObject object : mainCollection) {
            invoiceList.add(VerifyUtil.getUncheckDetail(object));
        }
        return invoiceList;
    }

    public static Map<String, DynamicObject> getUncheckDetail(DynamicObject object) {
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(4);
        map.put("main", object);
        try {
            String detalJson = object.getString("invoice_detail_tag");
            Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(object.get("invoice_type"));
            if (StringUtils.isNotEmpty((CharSequence)detalJson)) {
                String entity = InputInvoiceTypeEnum.getEntity(invoiceType);
                JSONObject detailFile = JSONObject.parseObject((String)detalJson);
                JSONObject invoiceDetailJson = detailFile.getJSONObject("detail");
                JSONObject fileObjectJson = detailFile.getJSONObject("file");
                DynamicObject invoiceObject = BusinessDataServiceHelper.newDynamicObject((String)entity);
                DynamicObject fileObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice_file");
                map.put("detail", DynamicObjectUtil.jsonToDynamicObject(invoiceDetailJson, invoiceObject));
                map.put("file", DynamicObjectUtil.jsonToDynamicObject(fileObjectJson, fileObject));
            }
        }
        catch (Exception e) {
            logger.info("\u672a\u67e5\u9a8c\u53d1\u7968\u660e\u7ec6test" + e);
        }
        return map;
    }

    public static List<Map<String, DynamicObject>> queryInvoiceDynamicObjectByMainIds(List<Long> idList) {
        QFilter idFilter = new QFilter("id", "in", idList);
        String mainFields = MetadataUtil.getFields("rim_invoice");
        DynamicObject[] mainCollection = BusinessDataServiceHelper.load((String)"rim_invoice", (String)mainFields, (QFilter[])new QFilter[]{idFilter});
        List<String> serialNoList = Arrays.asList(mainCollection).stream().map(s -> s.getString("serial_no")).collect(Collectors.toList());
        QFilter serialFilter = new QFilter("serial_no", "in", serialNoList);
        List<Map<String, DynamicObject>> invoiceList = VerifyUtil.queryDetail(serialNoList, serialFilter, mainCollection, true);
        return invoiceList;
    }

    private static List<Map<String, DynamicObject>> queryDetail(List<String> serialNoList, QFilter serialFilter, DynamicObject[] mainCollection, boolean fileCache) {
        String serialNo;
        ArrayList<Map<String, DynamicObject>> invoiceList = new ArrayList<Map<String, DynamicObject>>(mainCollection.length);
        HashMap typeSerialMap = Maps.newHashMapWithExpectedSize((int)mainCollection.length);
        ArrayList<String> unchekNoList = new ArrayList<String>(8);
        ArrayList mainSerialNos = Lists.newArrayList();
        for (DynamicObject obj : mainCollection) {
            DynamicObject invoiceTypeObj = obj.getDynamicObject("invoice_type");
            DynamicObject[] entity = InputInvoiceTypeEnum.getEntity(invoiceTypeObj.getLong("id"));
            ArrayList<String> list = (ArrayList<String>)typeSerialMap.get(entity);
            if (list == null) {
                list = new ArrayList<String>(8);
            }
            String checkStatus = obj.getString("check_status");
            serialNo = obj.getString("serial_no");
            mainSerialNos.add(serialNo);
            if (InputInvoiceTypeEnum.needCheck(invoiceTypeObj.getLong("id")).booleanValue() && !"1".equals(checkStatus)) {
                unchekNoList.add(serialNo);
            }
            list.add(obj.getString("serial_no"));
            typeSerialMap.put(entity, list);
        }
        String tenantNo = TenantUtils.getTenantNo();
        HashMap<String, DynamicObject> bodyMap = new HashMap<String, DynamicObject>(16);
        for (Map.Entry entry : typeSerialMap.entrySet()) {
            DynamicObject[] dynamics = InvoiceQueryService.loadBySerialNo((String)entry.getKey(), tenantNo, ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]));
            if (dynamics == null) continue;
            for (DynamicObject obj : dynamics) {
                bodyMap.put(obj.getString("serial_no"), obj);
            }
        }
        if (!unchekNoList.isEmpty()) {
            QFilter filter = new QFilter("serial_no", "in", unchekNoList);
            String uncheckFields = MetadataUtil.getFields("rim_invoice_uncheck");
            DynamicObject[] uncheckCollection = BusinessDataServiceHelper.load((String)"rim_invoice_uncheck", (String)uncheckFields, (QFilter[])new QFilter[]{filter});
            if (uncheckCollection != null) {
                for (DynamicObject obj : uncheckCollection) {
                    Map<String, DynamicObject> uncheckDetail = VerifyUtil.getUncheckDetail(obj);
                    if (uncheckDetail == null || uncheckDetail.get("detail") == null) continue;
                    bodyMap.put(obj.getString("serial_no"), uncheckDetail.get("detail"));
                }
            }
        }
        DynamicObjectCollection fileCollection = QueryServiceHelper.query((String)"rim_invoice_file", (String)"serial_no,file_hash,original_type,original_filename,pdf_url,ofd_url,image_url,snapshot_url,xml_url,icon_url,rotation_angle,region,pixel,tax_pdf_url,tax_ofd_url,tax_xml_url", (QFilter[])new QFilter[]{serialFilter});
        HashMap<String, DynamicObject> fileMap = new HashMap<String, DynamicObject>(fileCollection.size());
        if (serialNoList != null && fileCache) {
            for (String serialNo2 : serialNoList) {
                String str = CacheHelper.get("FileCache:" + serialNo2);
                if (!StringUtils.isNotEmpty((CharSequence)str)) continue;
                JSONObject json = JSONObject.parseObject((String)str);
                DynamicObject fileObj = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice_file");
                fileObj.set("serial_no", (Object)serialNo2);
                fileObj.set("original_type", (Object)json.getString("original_type"));
                fileObj.set("original_filename", (Object)json.getString("original_filename"));
                fileObj.set("pdf_url", (Object)json.getString("pdf_url"));
                fileObj.set("ofd_url", (Object)json.getString("ofd_url"));
                fileObj.set("image_url", (Object)json.getString("image_url"));
                fileObj.set("snapshot_url", (Object)json.getString("snapshot_url"));
                fileObj.set("xml_url", (Object)json.getString("xml_url"));
                fileObj.set("icon_url", (Object)json.getString("icon_url"));
                fileObj.set("rotation_angle", (Object)json.getString("rotation_angle"));
                fileObj.set("region", (Object)json.getString("region"));
                fileObj.set("pixel", (Object)json.getString("pixel"));
                fileObj.set("tax_pdf_url", (Object)json.getString("tax_pdf_url"));
                fileObj.set("tax_ofd_url", (Object)json.getString("tax_ofd_url"));
                fileObj.set("tax_xml_url", (Object)json.getString("tax_xml_url"));
                fileMap.put(serialNo2, fileObj);
            }
        }
        HashMap<String, DynamicObject> xbrlMaps = new HashMap<String, DynamicObject>(fileCollection.size());
        if (mainSerialNos.size() > 0) {
            DynamicObjectCollection voucherObjects = QueryServiceHelper.query((String)"rim_invoice_voucher", (String)"xbrl_name, xbrl_url, xbrl_type, serial_no", (QFilter[])new QFilter[]{new QFilter("serial_no", "in", (Object)mainSerialNos)});
            for (DynamicObject voucher : voucherObjects) {
                serialNo = voucher.getString("serial_no");
                if (xbrlMaps.containsKey(serialNo)) continue;
                xbrlMaps.put(serialNo, voucher);
            }
        }
        for (DynamicObject object : fileCollection) {
            String serialNo3 = object.getString("serial_no");
            if (fileMap.containsKey(serialNo3)) continue;
            fileMap.put(serialNo3, object);
        }
        for (DynamicObject object : mainCollection) {
            String serialNo4 = object.getString("serial_no");
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            map.put("main", object);
            map.put("detail", bodyMap.get(serialNo4));
            map.put("file", fileMap.get(serialNo4));
            map.put("xbrl", xbrlMaps.get(serialNo4));
            invoiceList.add(map);
        }
        return invoiceList;
    }

    public static boolean isPersonInvoice(Map<String, Object> invoiceMap) {
        Long invoiceType = BigDecimalUtil.transDecimal(invoiceMap.get("invoice_type")).longValue();
        String buyerTaxNo = (String)invoiceMap.get("buyer_tax_no");
        String buyerName = (String)invoiceMap.get("buyer_name");
        return VerifyUtil.isPersonInvoice(invoiceType, buyerTaxNo, buyerName);
    }

    public static boolean isPersonInvoice(Long invoiceType, String buyerTaxNo, String buyerName) {
        boolean result0 = false;
        boolean result1 = true;
        if (InputInvoiceTypeEnum.needCheck(invoiceType).booleanValue() && !InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(invoiceType)) {
            if (StringUtils.isNotBlank((CharSequence)buyerTaxNo) && !IDENTITY_NO_PATTERN.matcher(buyerTaxNo).matches() && !PHONE_PATTERN.matcher(buyerTaxNo).matches()) {
                return result0;
            }
            if (StringUtils.isNotBlank((CharSequence)buyerName) && (ANY_POSITION.matcher(buyerName).matches() || END_WITH.matcher(buyerName).matches() || buyerName.length() > 5 && END_WITH_LESS_5.matcher(buyerName).matches())) {
                return result0;
            }
            return result1;
        }
        return result0;
    }

    public static boolean isComapnyTaxNo(String buyerTaxNo) {
        if (StringUtils.isBlank((CharSequence)buyerTaxNo) || buyerTaxNo.length() < 15 || buyerTaxNo.length() > 20) {
            return false;
        }
        return StringUtils.isNotBlank((CharSequence)buyerTaxNo) && !PHONE_PATTERN.matcher(buyerTaxNo).matches();
    }

    public static String isTaxBlackListInvoice(Map<String, Object> invoiceMap) {
        String salerTaxNo = (String)invoiceMap.get("saler_tax_no");
        if (StringUtils.isEmpty((CharSequence)salerTaxNo) && StringUtils.isEmpty((CharSequence)(salerTaxNo = (String)invoiceMap.get("saler_id_no")))) {
            return null;
        }
        QFilter blackListFilter = new QFilter("tax_payer_no", "=", (Object)salerTaxNo);
        QFilter blacklistTypeFilter = new QFilter("black_list_type", "!=", (Object)"4");
        DynamicObject blackListData = QueryServiceHelper.queryOne((String)"rim_black_list_data", (String)"case_detail, case_nature", (QFilter[])new QFilter[]{blackListFilter, blacklistTypeFilter});
        if (!ObjectUtils.isEmpty((Object)blackListData)) {
            return VerifyUtil.getFormatInfo(blackListData);
        }
        return null;
    }

    private static String getFormatInfo(DynamicObject blackListData) {
        String caseDetail = blackListData.getString("case_detail");
        String caseNature = blackListData.getString("case_nature");
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)caseNature)) {
            String msg = String.format(ResManager.loadKDString((String)"\u9500\u65b9\u4e3a\u7a0e\u5c40\u516c\u793a\u7684\u6d89[%1$s]\u8fdd\u6cd5\u5931\u4fe1\u7eb3\u7a0e\u4eba:%2$s", (String)"VerifyUtil_0", (String)"imc-rim-common", (Object[])new Object[0]), caseNature, StringUtils.trimToEmpty((String)caseDetail));
            sb.append(msg);
            return sb.toString();
        }
        String title = StringUtils.substringBefore((String)caseDetail, (String)ResManager.loadKDString((String)"\u7ecf\u56fd\u5bb6", (String)"VerifyUtil_1", (String)"imc-rim-common", (Object[])new Object[0]));
        String content = StringUtils.substringAfterLast((String)caseDetail, (String)ResManager.loadKDString((String)"\u4e3b\u8981\u5b58\u5728\u4ee5\u4e0b\u95ee\u9898:", (String)"VerifyUtil_2", (String)"imc-rim-common", (Object[])new Object[0]));
        if (StringUtils.isNotBlank((CharSequence)title)) {
            String msg = String.format(ResManager.loadKDString((String)"\u9500\u65b9\u4e3a\u7a0e\u5c40\u516c\u793a\u7684\u6d89[%1$s]\u8fdd\u6cd5\u5931\u4fe1\u7eb3\u7a0e\u4eba:%2$s", (String)"VerifyUtil_0", (String)"imc-rim-common", (Object[])new Object[0]), title, content);
            sb.append(msg);
        } else {
            sb.append(ResManager.loadKDString((String)"\u9500\u65b9\u4e3a\u7a0e\u5c40\u516c\u793a\u7684\u6d89\u8fdd\u6cd5\u5931\u4fe1\u7eb3\u7a0e\u4eba", (String)"VerifyUtil_3", (String)"imc-rim-common", (Object[])new Object[0]));
            if (StringUtils.isNotBlank((CharSequence)content)) {
                sb.append('\uff1a').append(content);
            }
        }
        return sb.toString();
    }

    public static void updateDataStatus(String errorLevel, String serialNo, Long invoiceType, Boolean flag, boolean needUserRelation) {
        VerifyUtil.updateDataStatus(errorLevel, serialNo, invoiceType, flag, 0L, needUserRelation, 0L);
    }

    public static void updateDataStatus(String errorLevel, String serialNo, Long invoiceType, Boolean flag, Long rimUser, boolean needUserRelation) {
        VerifyUtil.updateDataStatus(errorLevel, serialNo, invoiceType, flag, rimUser, needUserRelation, 0L);
    }

    public static void updateDataStatus(String errorLevel, String serialNo, Long invoiceType, Boolean flag, Long rimUser, boolean needUserRelation, Long userId) {
        boolean checkFlag;
        logger.info("updateDataStatus serialNo:{}, boolean flag:{},errorLevel:{}", new Object[]{serialNo, flag, errorLevel});
        if (StringUtils.isEmpty((CharSequence)serialNo) || invoiceType == null || !flag.booleanValue()) {
            return;
        }
        String verifySaveFlag = RimConfigUtils.getConfig("verify_save");
        boolean bl = checkFlag = "0".equals(verifySaveFlag) && "0".equals(errorLevel);
        if (!checkFlag) {
            VerifyUtil.updateInvoiceDelStatus(serialNo, InputInvoiceTypeEnum.getEntity(invoiceType), rimUser, needUserRelation, userId);
            VerifyUtil.updateInvoiceDelStatus(serialNo, "rim_invoice", rimUser, needUserRelation, userId);
            VerifyUtil.updateInvoiceDelStatus(serialNo, "rim_invoice_uncheck", rimUser, needUserRelation, userId);
        }
    }

    public static void updateInvoiceDelStatus(String serialNo, String entityName, boolean needUserRelation) {
        VerifyUtil.updateInvoiceDelStatus(serialNo, entityName, 0L, needUserRelation, 0L);
    }

    public static void updateInvoiceDelStatus(String serialNo, String entityName, Long rimUser, boolean needUserRelation) {
        ArrayList serialList = Lists.newArrayList();
        serialList.add(serialNo);
        VerifyUtil.updateBatchInvoiceDelStatus(serialList, entityName, rimUser, needUserRelation, 0L);
    }

    public static void updateInvoiceDelStatus(String serialNo, String entityName, Long rimUser, boolean needUserRelation, Long userId) {
        ArrayList serialList = Lists.newArrayList();
        serialList.add(serialNo);
        VerifyUtil.updateBatchInvoiceDelStatus(serialList, entityName, rimUser, needUserRelation, userId);
    }

    public static void updateBatchDataStatus(Map<String, StringBuilder> verifyMap, JSONObject orderedDataJson, boolean needUserRelation) {
        if (verifyMap == null) {
            return;
        }
        for (Map.Entry<String, StringBuilder> entry : verifyMap.entrySet()) {
            String invoiceType = entry.getKey();
            Long invoiceTypeByAwsType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceType);
            StringBuilder serialBuilder = entry.getValue();
            List<String> serialList = Arrays.asList(serialBuilder.toString().split(","));
            VerifyUtil.updateBatchInvoiceDelStatus(serialList, InputInvoiceTypeEnum.getEntity(invoiceTypeByAwsType), 0L, needUserRelation, 0L);
            VerifyUtil.updateBatchInvoiceDelStatus(serialList, "rim_invoice", 0L, needUserRelation, 0L);
            VerifyUtil.updateBatchInvoiceDelStatus(serialList, "rim_invoice_uncheck", 0L, needUserRelation, 0L);
            DynamicObjectCollection updateResult = QueryServiceHelper.query((String)"rim_invoice", (String)"serial_no, delete, original_state, invoice_info", (QFilter[])new QFilter[]{new QFilter("serial_no", "in", serialList)});
            for (DynamicObject invoice : updateResult) {
                String serialNo = invoice.getString("serial_no");
                JSONObject orderInfo = orderedDataJson.getJSONObject(serialNo);
                orderInfo.put("originalState", (Object)invoice.getString("original_state"));
                orderInfo.put("delete", (Object)invoice.getString("delete"));
                orderInfo.put("invoiceInfo", (Object)invoice.getString("invoice_info"));
                orderInfo.put("invoice_info", (Object)invoice.getString("invoice_info"));
            }
        }
    }

    private static void updateBatchInvoiceDelStatus(List<String> serialList, String entity, Long rimUser, boolean needUserRelation, Long userId) {
        Object[] invoiceCollection;
        QFilter filter = new QFilter("serial_no", "in", serialList);
        if ("rim_invoice".equals(entity)) {
            DynamicObjectCollection collection = QueryServiceHelper.query((String)entity, (String)"id", (QFilter[])new QFilter[]{filter});
            if (ObjectUtils.isEmpty((Object)collection)) {
                return;
            }
            Object[] ids = collection.stream().map(s -> s.get("id")).toArray();
            invoiceCollection = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entity));
        } else {
            invoiceCollection = BusinessDataServiceHelper.load((String)entity, (String)"id,delete", (QFilter[])filter.toArray());
        }
        if (ObjectUtils.isEmpty((Object[])invoiceCollection)) {
            return;
        }
        for (Object invoiceObj : invoiceCollection) {
            String delete = invoiceObj.getString("delete");
            if ("3".equals(delete)) continue;
            if ("rim_invoice".equals(entity)) {
                String extInfo = invoiceObj.getString("ext_info");
                try {
                    JSONObject info = JSONObject.parseObject((String)(extInfo + ""));
                    if ("1".equals(info.getString("prevOriginalState"))) {
                        DynamicObject fileObj;
                        Long receiver = info.getLong("prevReceiver");
                        invoiceObj.set("original_state", (Object)"1");
                        invoiceObj.set("original_time", (Object)new Date());
                        invoiceObj.set("receiver", (Object)receiver);
                        try {
                            DynamicObject invoiceTypeObj = invoiceObj.getDynamicObject("invoice_type");
                            Long invoiceType = invoiceTypeObj.getLong("id");
                            if (InputInvoiceTypeEnum.isCheckOriginalFile(invoiceType)) {
                                DynamicObject object = CommonUtils.loadSingle(InputInvoiceTypeEnum.getEntity(invoiceType), new QFilter[]{new QFilter("serial_no", "=", (Object)invoiceObj.getString("serial_no"))});
                                object.set("original_state", (Object)"1");
                                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
                            }
                        }
                        catch (Exception invoiceTypeObj) {
                            // empty catch block
                        }
                        String invoiceInfo = invoiceObj.getString("invoice_info");
                        if (StringUtils.isNotEmpty((CharSequence)invoiceInfo)) {
                            String replace = invoiceInfo.replace("or_0", "or_1");
                            invoiceObj.set("invoice_info", (Object)replace);
                        }
                        if ("true".equals(info.getString("isOriginal")) && (fileObj = CommonUtils.loadSingle("rim_invoice_file", new QFilter[]{new QFilter("serial_no", "in", (Object)invoiceObj.getString("serial_no"))})) != null) {
                            fileObj.set("original_state", (Object)"1");
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fileObj});
                        }
                    }
                    info.remove((Object)"prevOriginalState");
                    info.remove((Object)"prevReceiver");
                    info.remove((Object)"isOriginal");
                    invoiceObj.set("ext_info", (Object)info.toJSONString());
                }
                catch (Exception e) {
                    logger.info("\u5408\u89c4\u6027\u4e25\u683c\u7ba1\u63a7\u4e0d\u5165\u5e93\u8fd8\u539f\u6570\u636e\u51fa\u9519\uff1a", (Object)e);
                }
                if (needUserRelation) {
                    InvoiceSaveService save = new InvoiceSaveService();
                    Long orgId = invoiceObj.getLong("org_id");
                    if (userId <= 0L) {
                        userId = Long.valueOf(RequestContext.get().getUserId());
                    }
                    save.setUserAndOrg(String.valueOf(userId), String.valueOf(orgId), rimUser, (DynamicObject)invoiceObj, true);
                    InvoiceSaveEkService ekService = EkServiceFactory.getInvoiceSaveEkService();
                    ekService.afterSetUserAndOrg((DynamicObject)invoiceObj);
                }
            }
            invoiceObj.set("delete", (Object)"1");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoiceObj});
        }
    }
}

