/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.multitenant.helper;

import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class RimInvoiceHelper {
    public static DynamicObject[] getRimInvoiceList(String entity, Map<String, Object> customParams) {
        Date start = null;
        Date end = null;
        if (customParams.get("start_date") != null) {
            Object startDate = customParams.get("start_date");
            if (startDate instanceof Long) {
                start = new Date((Long)customParams.get("start_date"));
            }
            if (startDate instanceof Date) {
                start = (Date)startDate;
            }
        }
        if (customParams.get("end_date") != null) {
            Object endDate = customParams.get("end_date");
            if (endDate instanceof Long) {
                end = new Date((Long)customParams.get("end_date"));
            }
            if (endDate instanceof Date) {
                end = (Date)endDate;
            }
        }
        String status = (String)customParams.get("status");
        String originalState = (String)customParams.get("original_state");
        String searchText = (String)customParams.get("search_text");
        QFilter filter = null;
        filter = new QFilter("delete", "=", (Object)"1");
        Long userId = BigDecimalUtil.transDecimal(customParams.get(InvoiceSaveConstant.OPERATE_USER_ID)).longValue();
        if (userId <= 0L) {
            userId = Long.valueOf(RequestContext.get().getUserId());
        }
        if ("operate_company_invoice".equals(customParams.get("listType"))) {
            long orgId = BigDecimalUtil.transDecimal(customParams.get("orgId")).longValue();
            if (orgId < 1L) {
                orgId = RequestContext.get().getOrgId();
            }
            filter = filter.and(new QFilter("collect_org_entry.collect_org", "=", (Object)orgId));
        } else {
            filter = filter.and(new QFilter("collect_user_entry.collect_user", "=", (Object)userId));
            Object rimUser = customParams.get("rim_user");
            if (rimUser != null) {
                filter = filter.and(new QFilter("collect_user_entry.rim_user", "=", rimUser));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)originalState)) {
            filter = filter.and(new QFilter("original_state", "=", (Object)originalState));
        }
        if ("0".equals(status)) {
            filter = filter.and(new QFilter("expense_status", "=", (Object)"1"));
        } else if (!StringUtils.isEmpty((CharSequence)status)) {
            filter = filter.and(new QFilter("expense_status", "!=", (Object)"1"));
        }
        if (start != null) {
            filter = filter.and(new QFilter("createtime", ">=", (Object)DateUtils.trunc(start)));
        }
        if (end != null) {
            filter = filter.and(new QFilter("createtime", "<=", (Object)DateUtils.trunc(DateUtils.addDay(end, 1))));
        }
        if (!StringUtils.isEmpty((CharSequence)searchText)) {
            filter = filter.and(new QFilter("saler_name", "like", (Object)("%" + searchText + "%")));
        }
        DynamicObject[] infoList = BusinessDataServiceHelper.load((String)entity, (String)"id, invoice_info,saler_name,invoice_no,total_amount,total_tax_amount,invoice_date", (QFilter[])new QFilter[]{filter}, (String)"createtime desc");
        return infoList;
    }
}

