/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.multitenant.openapi;

import java.io.Serializable;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiRequestBody;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.multitenant.model.FpzsServiceOpenApiRequest;
import kd.imc.rim.common.multitenant.openapi.FpzsOpenApiService;
import kd.imc.rim.common.multitenant.service.MultiTenantService;

@ApiController(value="imc", desc="\u6536\u7968\u52a9\u624b")
@ApiMapping(value="multitenant/fpzs")
public class FpzsOpenApiController
implements Serializable {
    private static final Log logger = LogFactory.getLog(FpzsOpenApiController.class);
    private static final long serialVersionUID = 1L;

    @ApiPostMapping(value="/service", desc="\u6536\u7968\u52a9\u624b")
    public CustomApiResult<@ApiResponseBody(value="\u8fd4\u56de\u53c2\u6570") Object> service(@ApiRequestBody(value="\u5165\u53c2") FpzsServiceOpenApiRequest request) {
        long start = System.currentTimeMillis();
        FpzsOpenApiService service = FpzsOpenApiService.newInstance(request);
        this.setOrgAndUser(request);
        if (service != null) {
            logger.info("\u53d1\u7968\u52a9\u624b\u591a\u79df\u6237\u8bf7\u6c42{},{},{}", new Object[]{request.getReqService(), request.getReqMethod(), request.getReqTraceId()});
            try {
                ApiResult apiResult = service.doBusiness(request);
                if (apiResult != null) {
                    CustomApiResult result = new CustomApiResult();
                    result.setErrorCode(apiResult.getErrorCode());
                    if (StringUtils.isEmpty((CharSequence)apiResult.getErrorCode())) {
                        if (apiResult.getSuccess()) {
                            result.setErrorCode("0000");
                        } else {
                            result.setErrorCode("0003");
                        }
                    } else if ("success".equals(apiResult.getErrorCode())) {
                        result.setErrorCode("0000");
                    }
                    result.setStatus(apiResult.getSuccess());
                    result.setMessage(apiResult.getMessage());
                    result.setData(apiResult.getData());
                    logger.info("\u53d1\u7968\u52a9\u624b\u591a\u79df\u6237\u8bf7\u6c422:{},\u8017\u65f6{}", (Object)request.getReqTraceId(), (Object)(System.currentTimeMillis() - start));
                    return result;
                }
            }
            catch (MsgException e) {
                return CustomApiResult.fail((String)e.getErrorCode(), (String)e.getMessage());
            }
            catch (KDException e) {
                ErrorCode error = e.getErrorCode();
                if (error != null) {
                    return CustomApiResult.fail((String)error.getCode(), (String)error.getMessage());
                }
            }
            catch (Exception e) {
                logger.error("\u53d1\u7968\u52a9\u624b\u591a\u79df\u6237\u8bf7\u6c42\u51fa\u9519", (Throwable)e);
            }
        }
        return CustomApiResult.fail((String)"0001", (String)"service error");
    }

    private void setOrgAndUser(FpzsServiceOpenApiRequest request) {
        MultiTenantService service = new MultiTenantService();
        request.setReqOrgId(service.getOrgId(request.getReqOrgNumber()));
        request.setReqUserId(service.getUserId(request.getReqUerNumber()));
    }
}

