/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.multitenant.openapi.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.invoice.query.convert.InvoiceConvertService;
import kd.imc.rim.common.invoice.verify.VerifyService;
import kd.imc.rim.common.invoice.verify.VerifyUtil;
import kd.imc.rim.common.multitenant.model.FpzsServiceOpenApiRequest;
import kd.imc.rim.common.multitenant.openapi.FpzsOpenApiService;
import kd.imc.rim.common.utils.DynamicObjectUtil;

public class VerifyRemoteApiImpl
extends FpzsOpenApiService {
    private static final Log logger = LogFactory.getLog(VerifyRemoteApiImpl.class);

    @Override
    public ApiResult doBusiness(FpzsServiceOpenApiRequest request) {
        String method = request.getReqMethod();
        try {
            switch (method) {
                case "verifyByMainIds": {
                    return this.verifyByMainIds(request);
                }
                case "verifySequenceNo": {
                    return this.verifySequenceNo(request);
                }
                case "queryAttachBySerialNos": {
                    return this.queryAttachBySerialNos(request);
                }
                case "queryInvoiceDynamicObjectByMainIds": {
                    return this.queryInvoiceDynamicObjectByMainIds(request);
                }
            }
        }
        catch (Exception e) {
            ApiResult apiResult = new ApiResult();
            apiResult.setErrorCode("0023");
            apiResult.setMessage(ResManager.loadKDString((String)"method\u53c2\u6570\u4e0d\u5408\u6cd5", (String)"VerifyRemoteApiImpl_1", (String)"imc-rim-common", (Object[])new Object[0]));
            apiResult.setSuccess(false);
            return apiResult;
        }
        return null;
    }

    private ApiResult queryAttachBySerialNos(FpzsServiceOpenApiRequest request) {
        Object reqParam = request.getReqParam();
        try {
            if (reqParam != null) {
                Map map = (Map)reqParam;
                List serialNos = (List)map.get("serialList");
                Map<String, List<Map<String, Object>>> stringListMap = FpzsMainService.queryAttachBySerialNos(serialNos);
                return ApiResult.success(stringListMap);
            }
        }
        catch (Exception e) {
            logger.info("VerifyRemoteApiImpl queryAttachBySerialNos exception:", (Object)e);
        }
        return ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25", (String)"RimInvoiceListServiceOpenApiImpl_3", (String)"imc-rim-common", (Object[])new Object[0]), (String)"9999");
    }

    private ApiResult verifySequenceNo(FpzsServiceOpenApiRequest request) {
        Object reqParam = request.getReqParam();
        try {
            if (reqParam != null) {
                Map map = (Map)reqParam;
                Map customParam = (Map)map.get("customParam");
                JSONObject dataJson = (JSONObject)map.get("dataJson");
                VerifyService.verifySequenceNo((Map<String, Object>)customParam, dataJson);
                return ApiResult.success((Object)dataJson);
            }
        }
        catch (Exception e) {
            logger.info("VerifyRemoteApiImpl verifySequenceNo exception:", (Object)e);
        }
        return ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25", (String)"RimInvoiceListServiceOpenApiImpl_3", (String)"imc-rim-common", (Object[])new Object[0]), (String)"9999");
    }

    private ApiResult verifyByMainIds(FpzsServiceOpenApiRequest request) {
        Object reqParam = request.getReqParam();
        try {
            Map map = (Map)reqParam;
            Map customParam = (Map)map.get("customParam");
            List invoiceIds = (List)map.get("invoiceIds");
            List uncheckInvoiceIds = (List)map.get("uncheckInvoiceIds");
            JSONArray jsonArray = VerifyUtil.verifyByMainIds(customParam, invoiceIds, uncheckInvoiceIds, true);
            return ApiResult.success((Object)jsonArray);
        }
        catch (Exception e) {
            logger.info("VerifyRemoteApiImpl verifyByMainIds exception:", (Object)e);
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25", (String)"RimInvoiceListServiceOpenApiImpl_3", (String)"imc-rim-common", (Object[])new Object[0]), (String)"9999");
        }
    }

    private ApiResult queryInvoiceDynamicObjectByMainIds(FpzsServiceOpenApiRequest request) {
        Object reqParam = request.getReqParam();
        try {
            Map reqParamMap = (Map)reqParam;
            List mainIds = (List)reqParamMap.get("mainIds");
            List<Map<String, DynamicObject>> dataList = VerifyUtil.queryInvoiceDynamicObjectByMainIds(mainIds);
            if (CollectionUtils.isEmpty(dataList)) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u8be5\u53d1\u7968\u5df2\u5220\u9664", (String)"VerifyRemoteApiImpl_0", (String)"imc-rim-common", (Object[])new Object[0]), (String)"9999");
            }
            Map<String, DynamicObject> map = dataList.get(0);
            DynamicObject mainObj = map.get("main");
            Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(mainObj.get("invoice_type"));
            InvoiceConvertService convertService = InvoiceConvertService.newInstance(invoiceType);
            Map<String, Object> mainMap = DynamicObjectUtil.dynamicObjectToMap(mainObj);
            Map<String, Object> fileMap = DynamicObjectUtil.dynamicObjectToMap(map.get("file"));
            Map<String, Object> bodyMap = DynamicObjectUtil.dynamicObjectToMap(map.get("detail"));
            Map<String, Object> xbrlMap = DynamicObjectUtil.dynamicObjectToMap(map.get("xbrl"));
            if (bodyMap != null) {
                Object uncheckTag = bodyMap.get("invoice_detail_tag");
                if (uncheckTag != null) {
                    JSONObject tagObject = JSONObject.parseObject((String)(uncheckTag + ""));
                    JSONObject detail = tagObject.getJSONObject("detail");
                    if (detail != null) {
                        InvoiceConvertService.putAll(mainMap, (Map<String, Object>)detail);
                    }
                } else {
                    InvoiceConvertService.putAll(mainMap, bodyMap);
                }
            }
            InvoiceConvertService.putAll(mainMap, fileMap);
            InvoiceConvertService.putAll(mainMap, xbrlMap);
            JSONObject result = convertService.convert(mainMap);
            return ApiResult.success((Object)result);
        }
        catch (Exception e) {
            logger.info("VerifyRemoteApiImpl queryInvoiceDynamicObjectByMainIds exception:", (Object)e);
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25", (String)"RimInvoiceListServiceOpenApiImpl_3", (String)"imc-rim-common", (Object[])new Object[0]), (String)"9999");
        }
    }
}

