/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.multitenant.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.multitenant.model.MultiTenantConfig;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.HttpUtil;

public class TokenService {
    private static final Log logger = LogFactory.getLog(TokenService.class);
    public static final String getAppTokenUrl = "/api/getAppToken.do";
    public static final String loginUrl = "/api/login.do";

    public String login(MultiTenantConfig tenantConfig) {
        try {
            String cacheKey = "token_" + tenantConfig.getAccountId() + tenantConfig.getUser();
            String cache = CacheHelper.get(cacheKey);
            if (StringUtils.isNotEmpty((String)cache)) {
                return cache;
            }
            String app_token = this.getAppToken(tenantConfig);
            JSONObject params = new JSONObject();
            params.put("user", (Object)tenantConfig.getUser());
            params.put("usertype", (Object)tenantConfig.getUsertype());
            params.put("apptoken", (Object)app_token);
            params.put("accountId", (Object)tenantConfig.getAccountId());
            String data = HttpUtil.doPostJson(tenantConfig.getBaseUrl() + loginUrl, tenantConfig.getProxy(), null, params.toJSONString());
            JSONObject json = JSONObject.parseObject((String)data);
            if ("success".equals(json.getString("state"))) {
                JSONObject respData = json.getJSONObject("data");
                String token = respData.getString("access_token");
                CacheHelper.put(cacheKey, token, 180);
                return token;
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6access_token\u5931\u8d25\uff1a%1$s", (String)"TokenService_0", (String)"imc-rim-common", (Object[])new Object[0]), json.getString("errorMsg")));
        }
        catch (KDBizException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6access_token\u5931\u8d25", (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6access_token\u5931\u8d25\uff1a%1$s", (String)"TokenService_0", (String)"imc-rim-common", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private String getAppToken(MultiTenantConfig tenantConfig) {
        JSONObject map = new JSONObject();
        map.put("appId", (Object)tenantConfig.getAppId());
        map.put("appSecuret", (Object)tenantConfig.getAppSecuret());
        map.put("accountId", (Object)tenantConfig.getAccountId());
        try {
            String data = HttpUtil.doPostJson(tenantConfig.getBaseUrl() + getAppTokenUrl, tenantConfig.getProxy(), null, map.toJSONString());
            if (StringUtils.isBlank((String)data)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6AppToken\u5931\u8d25\uff1a%1$s", (String)"TokenService_1", (String)"imc-rim-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a", (String)"TokenService_2", (String)"imc-rim-common", (Object[])new Object[0])));
            }
            JSONObject json = JSON.parseObject((String)data);
            if ("success".equals(json.getString("state"))) {
                JSONObject respData = json.getJSONObject("data");
                return respData.getString("app_token");
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6AppToken\u5931\u8d25\uff1a%1$s", (String)"TokenService_1", (String)"imc-rim-common", (Object[])new Object[0]), json.getString("errorMsg")));
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6AppToken\u5931\u8d25", (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6AppToken\u5931\u8d25\uff1a%1$s", (String)"TokenService_1", (String)"imc-rim-common", (Object[])new Object[0]), e.getMessage()));
        }
    }
}

