/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.multitenant.service.impl;

import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.multitenant.model.MultiTenantConfig;
import kd.imc.rim.common.multitenant.service.MultiApiService;
import kd.imc.rim.common.multitenant.service.TokenService;
import kd.imc.rim.common.utils.FileUploadUtils;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.HttpUtil;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;

public class FpyMultiApiService
extends MultiApiService {
    private static final Log logger = LogFactory.getLog(FpyMultiApiService.class);

    public FpyMultiApiService(Map<String, String> configMap) {
        this.multiTenantConfig = new MultiTenantConfig();
        if (configMap != null) {
            String baseUrl;
            if ("1".equals(configMap.get("enable"))) {
                this.multiTenantFlag = true;
            }
            if (StringUtils.isNotEmpty((CharSequence)(baseUrl = configMap.get("baseUrl"))) && !baseUrl.endsWith("/")) {
                baseUrl = baseUrl + "/";
            }
            this.multiTenantConfig.setBaseUrl(baseUrl);
            this.multiTenantConfig.setAccountId(configMap.get("accountId"));
            this.multiTenantConfig.setAppId(configMap.get("appId"));
            this.multiTenantConfig.setAppSecuret(configMap.get("appSecuret"));
            this.multiTenantConfig.setUser(configMap.get("user"));
            this.multiTenantConfig.setUsertype(configMap.get("usertype"));
        }
    }

    @Override
    public boolean isMultiTenant() {
        return this.multiTenantFlag;
    }

    @Override
    public Object doPost(String apiUrl, String apiNumber, JSONObject params) {
        long start = System.currentTimeMillis();
        TokenService tokenService = new TokenService();
        String token = tokenService.login(this.multiTenantConfig);
        RequestContext context = RequestContext.get();
        try {
            String result = HttpUtil.doPostJson(this.multiTenantConfig.getBaseUrl() + apiUrl + "?access_token=" + token, this.multiTenantConfig.getProxy(), null, params.toJSONString());
            logger.info("\u53d1\u7968\u52a9\u624b\u591a\u79df\u6237\u8bf7\u6c421:{},\u8017\u65f6{}", (Object)context.getTraceId(), (Object)(System.currentTimeMillis() - start));
            return result;
        }
        catch (KDBizException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("http\u8bf7\u6c42\u51fa\u9519", (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"http\u8bf7\u6c42\u51fa\u9519[%1$s],traceId:%2$s", (String)"FpyMultiApiService_0", (String)"imc-rim-common", (Object[])new Object[0]), e.getMessage(), context.getTraceId()));
        }
    }

    private String getEncodeParam(String params) {
        try {
            params = URLEncoder.encode(params, "utf-8");
        }
        catch (Exception e) {
            logger.info("\u53c2\u6570encode\u8f6c\u6362\u5931\u8d25");
        }
        return params;
    }

    @Override
    public String downloadFile(String remoteUrl, String fileId) {
        RequestContext context = RequestContext.get();
        TokenService tokenService = new TokenService();
        String token = tokenService.login(this.multiTenantConfig);
        String baseUrl = this.multiTenantConfig.getBaseUrl();
        String downloadUrl = baseUrl + "/attachment/download.do?path=" + this.getEncodeParam(remoteUrl) + "&access_token=" + token;
        CloseableHttpClient client = HttpUtil.getConnection(null, false);
        HttpGet get = HttpUtil.getHttpGet(HttpUtil.replaceUrl(downloadUrl));
        CloseableHttpResponse response = null;
        String fileName = "";
        try {
            response = (CloseableHttpResponse)client.execute((HttpUriRequest)get);
            int statusCode = response.getStatusLine().getStatusCode();
            if (200 == statusCode) {
                String content;
                Pair<String, byte[]> pair = FileUtils.getContentFromResonse(remoteUrl, response);
                if (pair == null || pair.getRight() == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25[%1$s],traceId:%2$s", (String)"FpyMultiApiService_1", (String)"imc-rim-common", (Object[])new Object[0]), "", context.getTraceId()));
                }
                if ("html".equals(pair.getLeft()) && (content = new String((byte[])pair.getRight())).indexOf("\u9644\u4ef6\u4e0d\u5b58\u5728") >= 0) {
                    logger.info("\u9644\u4ef6\u4e0d\u5b58\u5728{}", (Object)remoteUrl);
                    return null;
                }
                fileName = fileId + "." + (String)pair.getLeft();
                String storePath = FileUploadUtils.getInvoiceDir("multitenant") + fileName;
                String savepath = FileUploadUtils.uploadBytes(storePath, fileName, (byte[])pair.getRight());
                if (StringUtils.isNotEmpty((CharSequence)savepath)) {
                    String fileType = FileUtils.getFileType(fileName);
                    FileUtils.saveFilePath(remoteUrl, savepath, fileId, fileType);
                } else {
                    logger.info("\u53d1\u7968\u52a9\u624b\u591a\u79df\u6237\u4e0b\u8f7d\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:{},{}", (Object)fileId, (Object)remoteUrl);
                }
                return savepath;
            }
        }
        catch (Exception e) {
            logger.info("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25" + remoteUrl, (Object)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25[%1$s],traceId:%2$s", (String)"FpyMultiApiService_1", (String)"imc-rim-common", (Object[])new Object[0]), e.getMessage(), context.getTraceId()));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String uploadFile(String localUrl, String fileName) {
        try (InputStream fileInputStream = FileServiceFactory.getAttachmentFileService().getInputStream(localUrl);){
            TokenService tokenService = new TokenService();
            String token = tokenService.login(this.multiTenantConfig);
            String baseUrl = this.multiTenantConfig.getBaseUrl() + "/attachment/upload.do?access_token=" + token;
            String result = HttpUtil.postFormData(baseUrl, null, null, fileInputStream, UUID.randomUUID() + "." + FileUtils.getFileType(fileName), null, 3000, 60000);
            logger.info("\u4e0a\u4f20\u4e2d\u53f0\u6587\u4ef6\u670d\u52a1\u5668\u7ed3\u679c\uff1a{}", (Object)result);
            if (result == null) return null;
            JSONObject obj = JSONObject.parseObject((String)result);
            if (!"success".equals(obj.getString("status"))) return null;
            String string = obj.getString("url");
            return string;
        }
        catch (Exception e) {
            logger.info("\u4e0a\u4f20\u4e2d\u53f0\u6587\u4ef6\u670d\u52a1\u5668\u51fa\u9519\uff1a", (Object)e);
        }
        return null;
    }
}

