/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.multitenant.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.invoice.query.AttachQueryService;
import kd.imc.rim.common.invoice.recognitionnew.task.handle.impl.FileHandleMultiTenantDownService;
import kd.imc.rim.common.multitenant.service.AbstractFpzsPluginService;
import kd.imc.rim.common.multitenant.service.MultiTenantService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.FileUploadUtils;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.ListUtils;
import kd.imc.rim.common.utils.MD5;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class FpzsPluginRemoteService
extends AbstractFpzsPluginService {
    private static final Log logger = LogFactory.getLog(FpzsPluginRemoteService.class);
    public static final String SERVICE = "FpzsPluginOpenApiImpl";

    @Override
    public List<Long> dealWxPushInvoiceData(JSONArray invoiceData, JSONArray fids, JSONObject businessParam) {
        MultiTenantService service = new MultiTenantService();
        HashMap<String, Object> paramObject = new HashMap<String, Object>(4);
        paramObject.put("invoiceData", invoiceData);
        paramObject.put("fids", fids);
        paramObject.put("businessParam", businessParam);
        Long orgId = BigDecimalUtil.transDecimal(businessParam.get((Object)"org_id")).longValue();
        Long userId = BigDecimalUtil.transDecimal(businessParam.get((Object)InvoiceSaveConstant.OPERATE_USER_ID)).longValue();
        Object data = service.doPost(SERVICE, "dealWxPushInvoiceData", paramObject, orgId, userId);
        String json = SerializationUtils.toJsonString((Object)data);
        JSONArray array = JSONArray.parseArray((String)json);
        ArrayList<Long> invoiceIds = new ArrayList<Long>(array.size());
        for (int i = 0; i < array.size(); ++i) {
            invoiceIds.add(array.getLong(i));
        }
        return invoiceIds;
    }

    @Override
    public List<Long> saveAwsAttach(JSONArray attachmentDatas, Long rimUser) {
        MultiTenantService service = new MultiTenantService();
        HashMap<String, Object> paramObject = new HashMap<String, Object>(4);
        paramObject.put("attachmentDatas", attachmentDatas);
        paramObject.put("rimUser", rimUser);
        Object data = service.doPost(SERVICE, "saveAwsAttach", paramObject);
        String json = SerializationUtils.toJsonString((Object)data);
        JSONArray array = JSONArray.parseArray((String)json);
        ArrayList<Long> list = new ArrayList<Long>(8);
        if (array != null) {
            for (int i = 0; i < array.size(); ++i) {
                list.add(array.getLong(i));
            }
        }
        return list;
    }

    @Override
    public JSONObject getFpzsConfig(Long orgId) {
        MultiTenantService service = new MultiTenantService();
        Object data = service.doPost(SERVICE, "getFpzsConfig", orgId, orgId, 0L);
        byte[] message = Base64.decodeBase64((String)((String)data));
        return JSONObject.parseObject((String)new String(message));
    }

    @Override
    public JSONArray getFpzsAttachList(List<Long> attachIds, Set<String> invoiceSerialNos) {
        MultiTenantService service = new MultiTenantService();
        HashMap<String, Collection<Object>> paramObject = new HashMap<String, Collection<Object>>(4);
        paramObject.put("attachIds", attachIds);
        paramObject.put("invoiceSerialNos", invoiceSerialNos);
        Object data = service.doPost(SERVICE, "getFpzsAttachList", paramObject);
        String json = SerializationUtils.toJsonString((Object)data);
        JSONArray array = JSONArray.parseArray((String)json);
        return array;
    }

    @Override
    public JSONArray verifyByMainIds(Map<String, Object> customParam, List<Long> invoiceIds, List<Long> uncheckInvoiceIds) {
        MultiTenantService service = new MultiTenantService();
        HashMap param = Maps.newHashMap();
        param.put("customParam", customParam);
        param.put("invoiceIds", invoiceIds);
        param.put("uncheckInvoiceIds", uncheckInvoiceIds);
        Object data = service.doPost("VerifyRemoteApiImpl", "verifyByMainIds", param);
        logger.info("\u53d1\u7968\u52a9\u624b\u5408\u89c4\u6027\u6821\u9a8c\u7ed3\u679c:{}", data);
        if (data != null) {
            JSONArray result = (JSONArray)data;
            FileHandleMultiTenantDownService downservice = new FileHandleMultiTenantDownService();
            downservice.insert(result);
            return result;
        }
        return new JSONArray();
    }

    @Override
    public Map<String, List<Map<String, Object>>> queryAttachBySerialNosCondition(List<String> serialList) {
        MultiTenantService service = new MultiTenantService();
        HashMap param = Maps.newHashMap();
        param.put("serialList", serialList);
        Object data = service.doPost("VerifyRemoteApiImpl", "queryAttachBySerialNos", param);
        logger.info("\u53d1\u7968\u52a9\u624b\u67e5\u8be2\u53d1\u7968\u9644\u4ef6\u7ed3\u679c:{}", data);
        if (data != null) {
            return (Map)data;
        }
        return new HashMap<String, List<Map<String, Object>>>(0);
    }

    @Override
    public JSONObject verifySequenceNoCondition(Map<String, Object> customParam, JSONObject dataJson) {
        MultiTenantService service = new MultiTenantService();
        HashMap param = Maps.newHashMap();
        param.put("customParam", customParam);
        param.put("dataJson", dataJson);
        Object data = service.doPost("VerifyRemoteApiImpl", "verifySequenceNo", param);
        if (data != null) {
            dataJson = (JSONObject)data;
        }
        return dataJson;
    }

    @Override
    public JSONArray afterCloseAttachUpload(JSONArray uploadUrls, Map<String, Object> customParam, String serialNo) {
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        MultiTenantService service = new MultiTenantService();
        JSONArray newUrls = new JSONArray();
        for (int i = 0; i < uploadUrls.size(); ++i) {
            String remoteUrl;
            Map urlObj = (Map)uploadUrls.get(i);
            if (CollectionUtils.isEmpty((Map)urlObj)) continue;
            String strUrl = urlObj.get("url").toString();
            String originalName = urlObj.get("name").toString();
            String fileFormat = FileUtils.getFileType(originalName);
            String fileName = StringUtils.substring((String)originalName.substring(0, originalName.lastIndexOf(46)), (int)0, (int)80);
            if (StringUtils.isEmpty((CharSequence)fileName)) {
                throw new KDException(ResManager.loadKDString((String)"\u8bf7\u6ce8\u610f\uff0c\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"FpzsPluginLocalService_2", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            boolean isTempFile = false;
            try {
                isTempFile = strUrl.startsWith("http");
            }
            catch (Exception e) {
                logger.error("\u4e34\u65f6\u6587\u4ef6\u5224\u65ad\u5f02\u5e38:", (Throwable)e);
                isTempFile = false;
            }
            if (isTempFile) {
                InputStream inputStream = null;
                try {
                    inputStream = tempFileCache.getInputStream(strUrl);
                    strUrl = FileUploadUtils.upload(FileUploadUtils.getInvoiceDir("attach") + MD5.md5Hex(strUrl) + '.' + fileFormat, originalName, inputStream);
                    if (StringUtils.isEmpty((CharSequence)strUrl)) {
                        throw new KDException(String.format(ResManager.loadKDString((String)"%1$s\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5", (String)"FpzsPluginLocalService_5", (String)"imc-rim-common", (Object[])new Object[0]), originalName));
                    }
                }
                catch (Exception e) {
                    logger.error("\u4e34\u65f6\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38:", (Throwable)e);
                    throw new KDException(String.format(ResManager.loadKDString((String)"%1$s\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5", (String)"FpzsPluginLocalService_5", (String)"imc-rim-common", (Object[])new Object[0]), originalName));
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            logger.error("\u9644\u4ef6\u6587\u4ef6\u6d41\u5173\u95ed\u5931\u8d25:", (Throwable)e);
                        }
                    }
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(remoteUrl = service.getRemoteUrl(strUrl, originalName)))) {
                FileUtils.saveFilePath(remoteUrl, strUrl, FileUtils.getFileId(remoteUrl), FileUtils.getFileType(fileName));
            }
            JSONObject json = new JSONObject();
            json.put("url", (Object)remoteUrl);
            json.put("name", (Object)originalName);
            newUrls.add((Object)json);
        }
        HashMap param = Maps.newHashMap();
        param.put("uploadUrls", newUrls);
        param.put("customParam", customParam);
        param.put("serialNo", serialNo);
        Object data = service.doPost(SERVICE, "afterCloseAttachUpload", param);
        if (data != null) {
            return (JSONArray)data;
        }
        return null;
    }

    @Override
    public JSONObject loadAttachById(Long attachId) {
        String snapshot_url;
        MultiTenantService service = new MultiTenantService();
        HashMap param = Maps.newHashMap();
        param.put("attachId", attachId);
        JSONObject result = (JSONObject)service.doPost(SERVICE, "loadAttachById", param);
        String attach_url = result.getString("attach_url");
        if (!StringUtils.isEmpty((CharSequence)attach_url)) {
            result.put("attach_url", (Object)service.getLocalUrl(attach_url));
        }
        if (!StringUtils.isEmpty((CharSequence)(snapshot_url = result.getString("snapshot_url")))) {
            result.put("snapshot_url", (Object)service.getLocalUrl(snapshot_url));
        }
        return result;
    }

    @Override
    public JSONObject getBillInvoiceIdAndAttachId(Map<String, Object> param) {
        boolean isQueryDb;
        JSONObject result = new JSONObject();
        String billId = (String)param.get("billId");
        if (StringUtils.isEmpty((CharSequence)billId)) {
            return result;
        }
        String cachekey = FpzsMainService.getPushInvoiceKey(billId, (String)param.get("entityId"), (String)param.get("resource"));
        String incoiceCache = CacheHelper.get(cachekey);
        AttachQueryService attachQueryService = new AttachQueryService();
        JSONArray attachArray = attachQueryService.queryFpzsAttach(billId, (String)param.get("entityId"), (String)param.get("resource"), false);
        boolean bl = isQueryDb = StringUtils.isEmpty((CharSequence)incoiceCache) && CollectionUtils.isEmpty((Collection)attachArray);
        if (!isQueryDb) {
            if (StringUtils.isNotEmpty((CharSequence)incoiceCache)) {
                List serialNos = JSONArray.parseArray((String)incoiceCache, String.class);
                result.put("invoiceIds", this.getMainIdBySerialNo(serialNos));
            }
            if (!CollectionUtils.isEmpty((Collection)attachArray)) {
                ArrayList<Long> attachIds = new ArrayList<Long>(attachArray.size());
                for (int i = 0; i < attachArray.size(); ++i) {
                    attachIds.add(Long.parseLong(attachArray.getJSONObject(i).getString("attachId")));
                }
                result.put("attachIds", attachIds);
            }
            return result;
        }
        MultiTenantService service = new MultiTenantService();
        result = (JSONObject)service.doPost(SERVICE, "getBillInvoiceIdAndAttachId", param);
        if (result != null) {
            return result;
        }
        return new JSONObject();
    }

    @Override
    public List<Long> getMainIdBySerialNo(List<String> serialNos) {
        MultiTenantService service = new MultiTenantService();
        HashMap<String, List<String>> paramObject = new HashMap<String, List<String>>(4);
        paramObject.put("serialNos", serialNos);
        Object data = service.doPost(SERVICE, "getMainIdBySerialNo", paramObject);
        if (data == null) {
            return Lists.newArrayList();
        }
        String json = SerializationUtils.toJsonString((Object)data);
        JSONArray array = JSONArray.parseArray((String)json);
        return ListUtils.parseLongList(array);
    }
}

