/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.multitenant.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.expense.service.ExpenseService;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.invoice.query.AttachQueryService;
import kd.imc.rim.common.multitenant.service.AbstractFpzsService;
import kd.imc.rim.common.multitenant.service.MultiTenantService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.MD5;
import kd.imc.rim.common.utils.UUID;

public class FpzsRemoteService
extends AbstractFpzsService {
    private static final Log logger = LogFactory.getLog(FpzsRemoteService.class);
    public static final String SERVICE = "FpzsServiceOpenApiImpl";

    private JSONObject doPost(String method, Object param) {
        return this.doPost(method, param, 0L, 0L);
    }

    private JSONObject doPost(String method, Object param, Long orgId, Long userId) {
        try {
            MultiTenantService service = new MultiTenantService();
            Object data = service.doPost(SERVICE, method, param, orgId, userId);
            JSONObject result = ResultContant.createSuccessJSONObject();
            result.put("data", data);
            return result;
        }
        catch (KDBizException e) {
            return ResultContant.createJSONObject((KDException)((Object)e));
        }
    }

    private void setOrgNumber(Map<String, Object> param, String orgIdKey) {
        MultiTenantService service;
        String orgNumber;
        Long orgId;
        if (param != null && (orgId = Long.valueOf(BigDecimalUtil.transDecimal(param.get(orgIdKey)).longValue())) > 0L && (orgNumber = (service = new MultiTenantService()).getOrgNumber(orgId)) != null) {
            param.put("orgNumber", orgNumber);
        }
    }

    @Override
    public Map<String, Object> billCreate(Map<String, Object> param) {
        return null;
    }

    @Override
    public Map<String, Object> billUpdate(Map<String, Object> param) {
        return null;
    }

    @Override
    public Map<String, Object> statusUpdate(Map<String, Object> param) {
        return null;
    }

    @Override
    public Map<String, Object> save(Map<String, Object> param) {
        this.setOrgNumber(param, "orgId");
        String json = SerializationUtils.toJsonString(param);
        JSONObject jsonObj = JSONObject.parseObject((String)json);
        AttachQueryService attachQueryService = new AttachQueryService();
        JSONArray invoiceAttachObj = attachQueryService.queryFpzsAttach(jsonObj.getString("billId"), jsonObj.getString("entityId"), jsonObj.getString("resource"), false);
        if (invoiceAttachObj != null) {
            for (int i = 0; i < invoiceAttachObj.size(); ++i) {
                JSONObject obj = invoiceAttachObj.getJSONObject(i);
                this.setRemoteUrl(obj);
            }
            param.put("attachData", invoiceAttachObj);
        }
        ExpenseService service = new ExpenseService();
        List<Map<String, String>> botp = service.loadBillLinkBySubTenant(jsonObj.getString("entityId"), jsonObj.getString("billId"));
        param.put("botpBillList", botp);
        JSONObject result = this.doPost("save", param);
        if (result != null && "0000".equals(result.get("errcode"))) {
            attachQueryService.cacheFpzsAttach(jsonObj.getString("billId"), jsonObj.getString("entityId"), jsonObj.getString("resource"), null);
            FpzsMainService.cacheFpzsPushInvoices(jsonObj.getString("billId"), jsonObj.getString("entityId"), jsonObj.getString("resource"), null);
        }
        return result;
    }

    @Override
    public Map<String, Object> saveBatch(List<Map<String, Object>> param) {
        return this.doPost("saveBatch", param);
    }

    @Override
    public Map<String, Object> deleteBatch(List<Map<String, Object>> param) {
        return this.doPost("deleteBatch", param);
    }

    private void setRemoteUrl(JSONObject obj) {
        MultiTenantService service = new MultiTenantService();
        String attachNo = obj.getString("attachNo");
        if (StringUtils.isEmpty((CharSequence)attachNo)) {
            attachNo = UUID.randomUUIDZero();
        }
        String attachUrl = service.getRemoteUrl(obj.getString("attachUrl"), attachNo + "." + obj.getString("fileExtension"));
        String snapshotUrl = service.getRemoteUrl(obj.getString("snapshotUrl"), attachNo + ".jpg");
        if (StringUtils.isNotEmpty((CharSequence)attachUrl)) {
            obj.put("attachUrl", (Object)attachUrl);
        }
        if (StringUtils.isNotEmpty((CharSequence)snapshotUrl)) {
            obj.put("snapshotUrl", (Object)snapshotUrl);
        }
    }

    @Override
    public Map<String, Object> delete(Map<String, Object> param) {
        return this.doPost("delete", param);
    }

    @Override
    public Map<String, Object> deleteAttach(Map<String, Object> param) {
        return this.doPost("deleteAttach", param);
    }

    @Override
    public Map<String, Object> deleteInvoice(List<String> serialList) {
        return this.doPost("deleteInvoice", serialList);
    }

    @Override
    public Map<String, Object> query(List<String> param, String resource, String orgType) {
        HashMap<String, Object> paramObject = new HashMap<String, Object>(4);
        paramObject.put("param", param);
        paramObject.put("resource", resource);
        paramObject.put("orgType", orgType);
        return this.doPost("query", paramObject);
    }

    @Override
    public Map<String, Object> queryVerify(Map<String, Object> param) {
        return this.doPost("queryVerify", param);
    }

    @Override
    public Map<String, Object> check(Map<String, Object> param) {
        return this.doPost("check", param);
    }

    @Override
    public Map<String, Object> checkNew(Map<String, Object> param) {
        return this.doPost("checkNew", param);
    }

    @Override
    public Map<String, Object> saveVoucher(Map<String, Object> param) {
        return this.doPost("saveVoucher", param);
    }

    @Override
    public Map<String, Object> saveVoucherCover(Map<String, Object> param) {
        return this.doPost("saveVoucherCover", param);
    }

    @Override
    public Map<String, Object> queryInvoiceAndFile(Map<String, Object> param) {
        return this.doPost("queryInvoiceAndFile", param);
    }

    @Override
    public Map<String, Object> queryInvoice(Map<String, Object> param) {
        return this.doPost("queryInvoice", param);
    }

    @Override
    public Map<String, Object> queryAttach(Map<String, Object> param) {
        return this.doPost("queryAttach", param);
    }

    @Override
    public Map<String, Object> queryCover(Map<String, Object> param) {
        return this.doPost("queryCover", param);
    }

    @Override
    public Map<String, Object> deleteVoucher(Map<String, Object> param) {
        return this.doPost("deleteVoucher", param);
    }

    @Override
    public List<Map<String, String>> queryFile(List<String> serialList) {
        JSONObject reuslt = this.doPost("queryFile", serialList);
        JSONArray array = reuslt.getJSONArray("data");
        if (array != null) {
            ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(array.size());
            for (int i = 0; i < array.size(); ++i) {
                JSONObject obj = array.getJSONObject(i);
                HashMap map = new HashMap(obj.size());
                for (Map.Entry entry : obj.entrySet()) {
                    map.put(entry.getKey(), obj.getString((String)entry.getKey()));
                }
                list.add(map);
            }
            return list;
        }
        return null;
    }

    @Override
    public Map<String, Object> signInvoice(List<String> serialNos) {
        return this.doPost("signInvoice", serialNos);
    }

    @Override
    public Map<String, Object> unSignInvoice(List<String> serialNos) {
        return this.doPost("unSignInvoice", serialNos);
    }

    @Override
    public Map<String, Object> dapVoucherWriteBack(Map<String, Object> param) {
        return this.doPost("dapVoucherWriteBack", param);
    }

    @Override
    public Map<String, Object> recognitionCheck(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL);
        }
        String paramStr = SerializationUtils.toJsonString(param);
        logger.info("\u3010\u53d1\u7968\u52a9\u624b\u5fae\u670d\u52a1\u3011recognitionCheck-param:" + paramStr);
        JSONObject paramJson = JSONObject.parseObject((String)paramStr);
        String fileDownUrl = paramJson.getString("fileDownUrl");
        String fileType = paramJson.getString("fileType");
        MultiTenantService service = new MultiTenantService();
        if (StringUtils.isBlank((CharSequence)fileDownUrl)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ResManager.loadKDString((String)"\u6587\u4ef6\u5730\u5740\u4e3a\u7a7a", (String)"FpzsService_10", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)fileType)) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ResManager.loadKDString((String)"\u6587\u4ef6\u7c7b\u578b\u4e3a\u7a7a", (String)"FpzsService_11", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        Long orgId = paramJson.getLong("orgId");
        if (orgId == null || orgId == 0L) {
            return ResultContant.createJSONObject(ErrorType.PARAM_NULL.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u5f52\u5c5e\u7ec4\u7ec7\u4e3a\u7a7a", (String)"FpzsService_13", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String remoteUrl = service.getRemoteUrl(fileDownUrl, MD5.md5Hex(fileDownUrl) + "." + FileUtils.convertFileType(fileType));
        paramJson.put("fileDownUrl", (Object)remoteUrl);
        return this.doPost("recognitionCheck", param, orgId, 0L);
    }

    @Override
    public Map<String, Object> editInvoice(Map<String, Object> param) {
        return this.doPost("editInvoice", param);
    }

    @Override
    public Map<String, Object> outInvoiceApply(Map<String, Object> param) {
        return this.doPost("outInvoiceApply", param);
    }

    @Override
    public Map<String, Object> outInvoiceDownloadResult(Map<String, Object> param) {
        return this.doPost("outInvoiceDownloadResult", param);
    }

    @Override
    public Map<String, Object> stopInvoiceDownload(Map<String, Object> param) {
        return this.doPost("stopInvoiceDownload", param);
    }

    @Override
    public Map<String, Object> syncAwsHisBillData(Map<String, Object> param) {
        return this.doPost("syncAwsHisBillData", param);
    }
}

